package io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ProvisionStatusFluent<A extends ProvisionStatusFluent<A>> extends BaseFluent<A>{
  public ProvisionStatusFluent() {
  }
  
  public ProvisionStatusFluent(ProvisionStatus instance) {
    this.copyInstance(instance);
  }
  private String id;
  private String bootMode;
  private CustomDeployBuilder customDeploy;
  private FirmwareConfigBuilder firmware;
  private ImageBuilder image;
  private RAIDConfigBuilder raid;
  private RootDeviceHintsBuilder rootDeviceHints;
  private String state;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ProvisionStatus instance) {
    instance = (instance != null ? instance : new ProvisionStatus());
  
    if (instance != null) {
        this.withId(instance.getId());
        this.withBootMode(instance.getBootMode());
        this.withCustomDeploy(instance.getCustomDeploy());
        this.withFirmware(instance.getFirmware());
        this.withImage(instance.getImage());
        this.withRaid(instance.getRaid());
        this.withRootDeviceHints(instance.getRootDeviceHints());
        this.withState(instance.getState());
        this.withId(instance.getId());
        this.withBootMode(instance.getBootMode());
        this.withCustomDeploy(instance.getCustomDeploy());
        this.withFirmware(instance.getFirmware());
        this.withImage(instance.getImage());
        this.withRaid(instance.getRaid());
        this.withRootDeviceHints(instance.getRootDeviceHints());
        this.withState(instance.getState());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public String getId() {
    return this.id;
  }
  
  public A withId(String id) {
    this.id=id; return (A) this;
  }
  
  public boolean hasId() {
    return this.id != null;
  }
  
  public String getBootMode() {
    return this.bootMode;
  }
  
  public A withBootMode(String bootMode) {
    this.bootMode=bootMode; return (A) this;
  }
  
  public boolean hasBootMode() {
    return this.bootMode != null;
  }
  
  public CustomDeploy buildCustomDeploy() {
    return this.customDeploy!=null ?this.customDeploy.build():null;
  }
  
  public A withCustomDeploy(CustomDeploy customDeploy) {
    _visitables.get("customDeploy").remove(this.customDeploy);
    if (customDeploy!=null){ this.customDeploy= new CustomDeployBuilder(customDeploy); _visitables.get("customDeploy").add(this.customDeploy);} else { this.customDeploy = null; _visitables.get("customDeploy").remove(this.customDeploy); } return (A) this;
  }
  
  public boolean hasCustomDeploy() {
    return this.customDeploy != null;
  }
  
  public A withNewCustomDeploy(String method) {
    return (A)withCustomDeploy(new CustomDeploy(method));
  }
  
  public CustomDeployNested<A> withNewCustomDeploy() {
    return new CustomDeployNested(null);
  }
  
  public CustomDeployNested<A> withNewCustomDeployLike(CustomDeploy item) {
    return new CustomDeployNested(item);
  }
  
  public CustomDeployNested<A> editCustomDeploy() {
    return withNewCustomDeployLike(java.util.Optional.ofNullable(buildCustomDeploy()).orElse(null));
  }
  
  public CustomDeployNested<A> editOrNewCustomDeploy() {
    return withNewCustomDeployLike(java.util.Optional.ofNullable(buildCustomDeploy()).orElse(new CustomDeployBuilder().build()));
  }
  
  public CustomDeployNested<A> editOrNewCustomDeployLike(CustomDeploy item) {
    return withNewCustomDeployLike(java.util.Optional.ofNullable(buildCustomDeploy()).orElse(item));
  }
  
  public FirmwareConfig buildFirmware() {
    return this.firmware!=null ?this.firmware.build():null;
  }
  
  public A withFirmware(FirmwareConfig firmware) {
    _visitables.get("firmware").remove(this.firmware);
    if (firmware!=null){ this.firmware= new FirmwareConfigBuilder(firmware); _visitables.get("firmware").add(this.firmware);} else { this.firmware = null; _visitables.get("firmware").remove(this.firmware); } return (A) this;
  }
  
  public boolean hasFirmware() {
    return this.firmware != null;
  }
  
  public A withNewFirmware(Boolean simultaneousMultithreadingEnabled,Boolean sriovEnabled,Boolean virtualizationEnabled) {
    return (A)withFirmware(new FirmwareConfig(simultaneousMultithreadingEnabled, sriovEnabled, virtualizationEnabled));
  }
  
  public FirmwareNested<A> withNewFirmware() {
    return new FirmwareNested(null);
  }
  
  public FirmwareNested<A> withNewFirmwareLike(FirmwareConfig item) {
    return new FirmwareNested(item);
  }
  
  public FirmwareNested<A> editFirmware() {
    return withNewFirmwareLike(java.util.Optional.ofNullable(buildFirmware()).orElse(null));
  }
  
  public FirmwareNested<A> editOrNewFirmware() {
    return withNewFirmwareLike(java.util.Optional.ofNullable(buildFirmware()).orElse(new FirmwareConfigBuilder().build()));
  }
  
  public FirmwareNested<A> editOrNewFirmwareLike(FirmwareConfig item) {
    return withNewFirmwareLike(java.util.Optional.ofNullable(buildFirmware()).orElse(item));
  }
  
  public Image buildImage() {
    return this.image!=null ?this.image.build():null;
  }
  
  public A withImage(Image image) {
    _visitables.get("image").remove(this.image);
    if (image!=null){ this.image= new ImageBuilder(image); _visitables.get("image").add(this.image);} else { this.image = null; _visitables.get("image").remove(this.image); } return (A) this;
  }
  
  public boolean hasImage() {
    return this.image != null;
  }
  
  public A withNewImage(String checksum,String checksumType,String format,String url) {
    return (A)withImage(new Image(checksum, checksumType, format, url));
  }
  
  public ImageNested<A> withNewImage() {
    return new ImageNested(null);
  }
  
  public ImageNested<A> withNewImageLike(Image item) {
    return new ImageNested(item);
  }
  
  public ImageNested<A> editImage() {
    return withNewImageLike(java.util.Optional.ofNullable(buildImage()).orElse(null));
  }
  
  public ImageNested<A> editOrNewImage() {
    return withNewImageLike(java.util.Optional.ofNullable(buildImage()).orElse(new ImageBuilder().build()));
  }
  
  public ImageNested<A> editOrNewImageLike(Image item) {
    return withNewImageLike(java.util.Optional.ofNullable(buildImage()).orElse(item));
  }
  
  public RAIDConfig buildRaid() {
    return this.raid!=null ?this.raid.build():null;
  }
  
  public A withRaid(RAIDConfig raid) {
    _visitables.get("raid").remove(this.raid);
    if (raid!=null){ this.raid= new RAIDConfigBuilder(raid); _visitables.get("raid").add(this.raid);} else { this.raid = null; _visitables.get("raid").remove(this.raid); } return (A) this;
  }
  
  public boolean hasRaid() {
    return this.raid != null;
  }
  
  public RaidNested<A> withNewRaid() {
    return new RaidNested(null);
  }
  
  public RaidNested<A> withNewRaidLike(RAIDConfig item) {
    return new RaidNested(item);
  }
  
  public RaidNested<A> editRaid() {
    return withNewRaidLike(java.util.Optional.ofNullable(buildRaid()).orElse(null));
  }
  
  public RaidNested<A> editOrNewRaid() {
    return withNewRaidLike(java.util.Optional.ofNullable(buildRaid()).orElse(new RAIDConfigBuilder().build()));
  }
  
  public RaidNested<A> editOrNewRaidLike(RAIDConfig item) {
    return withNewRaidLike(java.util.Optional.ofNullable(buildRaid()).orElse(item));
  }
  
  public RootDeviceHints buildRootDeviceHints() {
    return this.rootDeviceHints!=null ?this.rootDeviceHints.build():null;
  }
  
  public A withRootDeviceHints(RootDeviceHints rootDeviceHints) {
    _visitables.get("rootDeviceHints").remove(this.rootDeviceHints);
    if (rootDeviceHints!=null){ this.rootDeviceHints= new RootDeviceHintsBuilder(rootDeviceHints); _visitables.get("rootDeviceHints").add(this.rootDeviceHints);} else { this.rootDeviceHints = null; _visitables.get("rootDeviceHints").remove(this.rootDeviceHints); } return (A) this;
  }
  
  public boolean hasRootDeviceHints() {
    return this.rootDeviceHints != null;
  }
  
  public RootDeviceHintsNested<A> withNewRootDeviceHints() {
    return new RootDeviceHintsNested(null);
  }
  
  public RootDeviceHintsNested<A> withNewRootDeviceHintsLike(RootDeviceHints item) {
    return new RootDeviceHintsNested(item);
  }
  
  public RootDeviceHintsNested<A> editRootDeviceHints() {
    return withNewRootDeviceHintsLike(java.util.Optional.ofNullable(buildRootDeviceHints()).orElse(null));
  }
  
  public RootDeviceHintsNested<A> editOrNewRootDeviceHints() {
    return withNewRootDeviceHintsLike(java.util.Optional.ofNullable(buildRootDeviceHints()).orElse(new RootDeviceHintsBuilder().build()));
  }
  
  public RootDeviceHintsNested<A> editOrNewRootDeviceHintsLike(RootDeviceHints item) {
    return withNewRootDeviceHintsLike(java.util.Optional.ofNullable(buildRootDeviceHints()).orElse(item));
  }
  
  public String getState() {
    return this.state;
  }
  
  public A withState(String state) {
    this.state=state; return (A) this;
  }
  
  public boolean hasState() {
    return this.state != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ProvisionStatusFluent that = (ProvisionStatusFluent) o;
    if (!java.util.Objects.equals(id, that.id)) return false;
  
    if (!java.util.Objects.equals(bootMode, that.bootMode)) return false;
  
    if (!java.util.Objects.equals(customDeploy, that.customDeploy)) return false;
  
    if (!java.util.Objects.equals(firmware, that.firmware)) return false;
  
    if (!java.util.Objects.equals(image, that.image)) return false;
  
    if (!java.util.Objects.equals(raid, that.raid)) return false;
  
    if (!java.util.Objects.equals(rootDeviceHints, that.rootDeviceHints)) return false;
  
    if (!java.util.Objects.equals(state, that.state)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(id,  bootMode,  customDeploy,  firmware,  image,  raid,  rootDeviceHints,  state,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (id != null) { sb.append("id:"); sb.append(id + ","); }
    if (bootMode != null) { sb.append("bootMode:"); sb.append(bootMode + ","); }
    if (customDeploy != null) { sb.append("customDeploy:"); sb.append(customDeploy + ","); }
    if (firmware != null) { sb.append("firmware:"); sb.append(firmware + ","); }
    if (image != null) { sb.append("image:"); sb.append(image + ","); }
    if (raid != null) { sb.append("raid:"); sb.append(raid + ","); }
    if (rootDeviceHints != null) { sb.append("rootDeviceHints:"); sb.append(rootDeviceHints + ","); }
    if (state != null) { sb.append("state:"); sb.append(state + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class CustomDeployNested<N> extends CustomDeployFluent<CustomDeployNested<N>> implements Nested<N>{
    CustomDeployNested(CustomDeploy item) {
      this.builder = new CustomDeployBuilder(this, item);
    }
    CustomDeployBuilder builder;
    
    public N and() {
      return (N) ProvisionStatusFluent.this.withCustomDeploy(builder.build());
    }
    
    public N endCustomDeploy() {
      return and();
    }
    
  
  }
  public class FirmwareNested<N> extends FirmwareConfigFluent<FirmwareNested<N>> implements Nested<N>{
    FirmwareNested(FirmwareConfig item) {
      this.builder = new FirmwareConfigBuilder(this, item);
    }
    FirmwareConfigBuilder builder;
    
    public N and() {
      return (N) ProvisionStatusFluent.this.withFirmware(builder.build());
    }
    
    public N endFirmware() {
      return and();
    }
    
  
  }
  public class ImageNested<N> extends ImageFluent<ImageNested<N>> implements Nested<N>{
    ImageNested(Image item) {
      this.builder = new ImageBuilder(this, item);
    }
    ImageBuilder builder;
    
    public N and() {
      return (N) ProvisionStatusFluent.this.withImage(builder.build());
    }
    
    public N endImage() {
      return and();
    }
    
  
  }
  public class RaidNested<N> extends RAIDConfigFluent<RaidNested<N>> implements Nested<N>{
    RaidNested(RAIDConfig item) {
      this.builder = new RAIDConfigBuilder(this, item);
    }
    RAIDConfigBuilder builder;
    
    public N and() {
      return (N) ProvisionStatusFluent.this.withRaid(builder.build());
    }
    
    public N endRaid() {
      return and();
    }
    
  
  }
  public class RootDeviceHintsNested<N> extends RootDeviceHintsFluent<RootDeviceHintsNested<N>> implements Nested<N>{
    RootDeviceHintsNested(RootDeviceHints item) {
      this.builder = new RootDeviceHintsBuilder(this, item);
    }
    RootDeviceHintsBuilder builder;
    
    public N and() {
      return (N) ProvisionStatusFluent.this.withRootDeviceHints(builder.build());
    }
    
    public N endRootDeviceHints() {
      return and();
    }
    
  
  }

}