package io.fabric8.openshift.api.model.miscellaneous.network.operator.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class EgressRouterInterfaceFluent<A extends EgressRouterInterfaceFluent<A>> extends BaseFluent<A>{
  public EgressRouterInterfaceFluent() {
  }
  
  public EgressRouterInterfaceFluent(EgressRouterInterface instance) {
    this.copyInstance(instance);
  }
  private MacvlanConfigBuilder macvlan;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(EgressRouterInterface instance) {
    instance = (instance != null ? instance : new EgressRouterInterface());
  
    if (instance != null) {
        this.withMacvlan(instance.getMacvlan());
        this.withMacvlan(instance.getMacvlan());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public MacvlanConfig buildMacvlan() {
    return this.macvlan!=null ?this.macvlan.build():null;
  }
  
  public A withMacvlan(MacvlanConfig macvlan) {
    _visitables.get("macvlan").remove(this.macvlan);
    if (macvlan!=null){ this.macvlan= new MacvlanConfigBuilder(macvlan); _visitables.get("macvlan").add(this.macvlan);} else { this.macvlan = null; _visitables.get("macvlan").remove(this.macvlan); } return (A) this;
  }
  
  public boolean hasMacvlan() {
    return this.macvlan != null;
  }
  
  public A withNewMacvlan(String master,String mode) {
    return (A)withMacvlan(new MacvlanConfig(master, mode));
  }
  
  public MacvlanNested<A> withNewMacvlan() {
    return new MacvlanNested(null);
  }
  
  public MacvlanNested<A> withNewMacvlanLike(MacvlanConfig item) {
    return new MacvlanNested(item);
  }
  
  public MacvlanNested<A> editMacvlan() {
    return withNewMacvlanLike(java.util.Optional.ofNullable(buildMacvlan()).orElse(null));
  }
  
  public MacvlanNested<A> editOrNewMacvlan() {
    return withNewMacvlanLike(java.util.Optional.ofNullable(buildMacvlan()).orElse(new MacvlanConfigBuilder().build()));
  }
  
  public MacvlanNested<A> editOrNewMacvlanLike(MacvlanConfig item) {
    return withNewMacvlanLike(java.util.Optional.ofNullable(buildMacvlan()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    EgressRouterInterfaceFluent that = (EgressRouterInterfaceFluent) o;
    if (!java.util.Objects.equals(macvlan, that.macvlan)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(macvlan,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (macvlan != null) { sb.append("macvlan:"); sb.append(macvlan + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class MacvlanNested<N> extends MacvlanConfigFluent<MacvlanNested<N>> implements Nested<N>{
    MacvlanNested(MacvlanConfig item) {
      this.builder = new MacvlanConfigBuilder(this, item);
    }
    MacvlanConfigBuilder builder;
    
    public N and() {
      return (N) EgressRouterInterfaceFluent.this.withMacvlan(builder.build());
    }
    
    public N endMacvlan() {
      return and();
    }
    
  
  }

}