package io.fabric8.openshift.api.model.miscellaneous.network.operator.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class OperatorPKISpecFluent<A extends OperatorPKISpecFluent<A>> extends BaseFluent<A>{
  public OperatorPKISpecFluent() {
  }
  
  public OperatorPKISpecFluent(OperatorPKISpec instance) {
    this.copyInstance(instance);
  }
  private CertSpecBuilder targetCert;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(OperatorPKISpec instance) {
    instance = (instance != null ? instance : new OperatorPKISpec());
  
    if (instance != null) {
        this.withTargetCert(instance.getTargetCert());
        this.withTargetCert(instance.getTargetCert());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public CertSpec buildTargetCert() {
    return this.targetCert!=null ?this.targetCert.build():null;
  }
  
  public A withTargetCert(CertSpec targetCert) {
    _visitables.get("targetCert").remove(this.targetCert);
    if (targetCert!=null){ this.targetCert= new CertSpecBuilder(targetCert); _visitables.get("targetCert").add(this.targetCert);} else { this.targetCert = null; _visitables.get("targetCert").remove(this.targetCert); } return (A) this;
  }
  
  public boolean hasTargetCert() {
    return this.targetCert != null;
  }
  
  public A withNewTargetCert(String commonName) {
    return (A)withTargetCert(new CertSpec(commonName));
  }
  
  public TargetCertNested<A> withNewTargetCert() {
    return new TargetCertNested(null);
  }
  
  public TargetCertNested<A> withNewTargetCertLike(CertSpec item) {
    return new TargetCertNested(item);
  }
  
  public TargetCertNested<A> editTargetCert() {
    return withNewTargetCertLike(java.util.Optional.ofNullable(buildTargetCert()).orElse(null));
  }
  
  public TargetCertNested<A> editOrNewTargetCert() {
    return withNewTargetCertLike(java.util.Optional.ofNullable(buildTargetCert()).orElse(new CertSpecBuilder().build()));
  }
  
  public TargetCertNested<A> editOrNewTargetCertLike(CertSpec item) {
    return withNewTargetCertLike(java.util.Optional.ofNullable(buildTargetCert()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    OperatorPKISpecFluent that = (OperatorPKISpecFluent) o;
    if (!java.util.Objects.equals(targetCert, that.targetCert)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(targetCert,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (targetCert != null) { sb.append("targetCert:"); sb.append(targetCert + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class TargetCertNested<N> extends CertSpecFluent<TargetCertNested<N>> implements Nested<N>{
    TargetCertNested(CertSpec item) {
      this.builder = new CertSpecBuilder(this, item);
    }
    CertSpecBuilder builder;
    
    public N and() {
      return (N) OperatorPKISpecFluent.this.withTargetCert(builder.build());
    }
    
    public N endTargetCert() {
      return and();
    }
    
  
  }

}