package io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1;

import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ImageRegistryConfigStorageFluent<A extends ImageRegistryConfigStorageFluent<A>> extends BaseFluent<A>{
  public ImageRegistryConfigStorageFluent() {
  }
  
  public ImageRegistryConfigStorageFluent(ImageRegistryConfigStorage instance) {
    this.copyInstance(instance);
  }
  private ImageRegistryConfigStorageAzureBuilder azure;
  private ImageRegistryConfigStorageEmptyDirBuilder emptyDir;
  private ImageRegistryConfigStorageGCSBuilder gcs;
  private ImageRegistryConfigStorageIBMCOSBuilder ibmcos;
  private String managementState;
  private ImageRegistryConfigStorageAlibabaOSSBuilder oss;
  private ImageRegistryConfigStoragePVCBuilder pvc;
  private ImageRegistryConfigStorageS3Builder s3;
  private ImageRegistryConfigStorageSwiftBuilder swift;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ImageRegistryConfigStorage instance) {
    instance = (instance != null ? instance : new ImageRegistryConfigStorage());
    if (instance != null) {
          this.withAzure(instance.getAzure());
          this.withEmptyDir(instance.getEmptyDir());
          this.withGcs(instance.getGcs());
          this.withIbmcos(instance.getIbmcos());
          this.withManagementState(instance.getManagementState());
          this.withOss(instance.getOss());
          this.withPvc(instance.getPvc());
          this.withS3(instance.getS3());
          this.withSwift(instance.getSwift());
          this.withAzure(instance.getAzure());
          this.withEmptyDir(instance.getEmptyDir());
          this.withGcs(instance.getGcs());
          this.withIbmcos(instance.getIbmcos());
          this.withManagementState(instance.getManagementState());
          this.withOss(instance.getOss());
          this.withPvc(instance.getPvc());
          this.withS3(instance.getS3());
          this.withSwift(instance.getSwift());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public ImageRegistryConfigStorageAzure buildAzure() {
    return this.azure != null ? this.azure.build() : null;
  }
  
  public A withAzure(ImageRegistryConfigStorageAzure azure) {
    this._visitables.remove(this.azure);
    if (azure != null) {
        this.azure = new ImageRegistryConfigStorageAzureBuilder(azure);
        this._visitables.get("azure").add(this.azure);
    } else {
        this.azure = null;
        this._visitables.get("azure").remove(this.azure);
    }
    return (A) this;
  }
  
  public boolean hasAzure() {
    return this.azure != null;
  }
  
  public A withNewAzure(String accountName,String cloudName,String container) {
    return (A)withAzure(new ImageRegistryConfigStorageAzure(accountName, cloudName, container));
  }
  
  public AzureNested<A> withNewAzure() {
    return new AzureNested(null);
  }
  
  public AzureNested<A> withNewAzureLike(ImageRegistryConfigStorageAzure item) {
    return new AzureNested(item);
  }
  
  public AzureNested<A> editAzure() {
    return withNewAzureLike(java.util.Optional.ofNullable(buildAzure()).orElse(null));
  }
  
  public AzureNested<A> editOrNewAzure() {
    return withNewAzureLike(java.util.Optional.ofNullable(buildAzure()).orElse(new ImageRegistryConfigStorageAzureBuilder().build()));
  }
  
  public AzureNested<A> editOrNewAzureLike(ImageRegistryConfigStorageAzure item) {
    return withNewAzureLike(java.util.Optional.ofNullable(buildAzure()).orElse(item));
  }
  
  public ImageRegistryConfigStorageEmptyDir buildEmptyDir() {
    return this.emptyDir != null ? this.emptyDir.build() : null;
  }
  
  public A withEmptyDir(ImageRegistryConfigStorageEmptyDir emptyDir) {
    this._visitables.remove(this.emptyDir);
    if (emptyDir != null) {
        this.emptyDir = new ImageRegistryConfigStorageEmptyDirBuilder(emptyDir);
        this._visitables.get("emptyDir").add(this.emptyDir);
    } else {
        this.emptyDir = null;
        this._visitables.get("emptyDir").remove(this.emptyDir);
    }
    return (A) this;
  }
  
  public boolean hasEmptyDir() {
    return this.emptyDir != null;
  }
  
  public EmptyDirNested<A> withNewEmptyDir() {
    return new EmptyDirNested(null);
  }
  
  public EmptyDirNested<A> withNewEmptyDirLike(ImageRegistryConfigStorageEmptyDir item) {
    return new EmptyDirNested(item);
  }
  
  public EmptyDirNested<A> editEmptyDir() {
    return withNewEmptyDirLike(java.util.Optional.ofNullable(buildEmptyDir()).orElse(null));
  }
  
  public EmptyDirNested<A> editOrNewEmptyDir() {
    return withNewEmptyDirLike(java.util.Optional.ofNullable(buildEmptyDir()).orElse(new ImageRegistryConfigStorageEmptyDirBuilder().build()));
  }
  
  public EmptyDirNested<A> editOrNewEmptyDirLike(ImageRegistryConfigStorageEmptyDir item) {
    return withNewEmptyDirLike(java.util.Optional.ofNullable(buildEmptyDir()).orElse(item));
  }
  
  public ImageRegistryConfigStorageGCS buildGcs() {
    return this.gcs != null ? this.gcs.build() : null;
  }
  
  public A withGcs(ImageRegistryConfigStorageGCS gcs) {
    this._visitables.remove(this.gcs);
    if (gcs != null) {
        this.gcs = new ImageRegistryConfigStorageGCSBuilder(gcs);
        this._visitables.get("gcs").add(this.gcs);
    } else {
        this.gcs = null;
        this._visitables.get("gcs").remove(this.gcs);
    }
    return (A) this;
  }
  
  public boolean hasGcs() {
    return this.gcs != null;
  }
  
  public A withNewGcs(String bucket,String keyID,String projectID,String region) {
    return (A)withGcs(new ImageRegistryConfigStorageGCS(bucket, keyID, projectID, region));
  }
  
  public GcsNested<A> withNewGcs() {
    return new GcsNested(null);
  }
  
  public GcsNested<A> withNewGcsLike(ImageRegistryConfigStorageGCS item) {
    return new GcsNested(item);
  }
  
  public GcsNested<A> editGcs() {
    return withNewGcsLike(java.util.Optional.ofNullable(buildGcs()).orElse(null));
  }
  
  public GcsNested<A> editOrNewGcs() {
    return withNewGcsLike(java.util.Optional.ofNullable(buildGcs()).orElse(new ImageRegistryConfigStorageGCSBuilder().build()));
  }
  
  public GcsNested<A> editOrNewGcsLike(ImageRegistryConfigStorageGCS item) {
    return withNewGcsLike(java.util.Optional.ofNullable(buildGcs()).orElse(item));
  }
  
  public ImageRegistryConfigStorageIBMCOS buildIbmcos() {
    return this.ibmcos != null ? this.ibmcos.build() : null;
  }
  
  public A withIbmcos(ImageRegistryConfigStorageIBMCOS ibmcos) {
    this._visitables.remove(this.ibmcos);
    if (ibmcos != null) {
        this.ibmcos = new ImageRegistryConfigStorageIBMCOSBuilder(ibmcos);
        this._visitables.get("ibmcos").add(this.ibmcos);
    } else {
        this.ibmcos = null;
        this._visitables.get("ibmcos").remove(this.ibmcos);
    }
    return (A) this;
  }
  
  public boolean hasIbmcos() {
    return this.ibmcos != null;
  }
  
  public A withNewIbmcos(String bucket,String location,String resourceGroupName,String resourceKeyCRN,String serviceInstanceCRN) {
    return (A)withIbmcos(new ImageRegistryConfigStorageIBMCOS(bucket, location, resourceGroupName, resourceKeyCRN, serviceInstanceCRN));
  }
  
  public IbmcosNested<A> withNewIbmcos() {
    return new IbmcosNested(null);
  }
  
  public IbmcosNested<A> withNewIbmcosLike(ImageRegistryConfigStorageIBMCOS item) {
    return new IbmcosNested(item);
  }
  
  public IbmcosNested<A> editIbmcos() {
    return withNewIbmcosLike(java.util.Optional.ofNullable(buildIbmcos()).orElse(null));
  }
  
  public IbmcosNested<A> editOrNewIbmcos() {
    return withNewIbmcosLike(java.util.Optional.ofNullable(buildIbmcos()).orElse(new ImageRegistryConfigStorageIBMCOSBuilder().build()));
  }
  
  public IbmcosNested<A> editOrNewIbmcosLike(ImageRegistryConfigStorageIBMCOS item) {
    return withNewIbmcosLike(java.util.Optional.ofNullable(buildIbmcos()).orElse(item));
  }
  
  public String getManagementState() {
    return this.managementState;
  }
  
  public A withManagementState(String managementState) {
    this.managementState = managementState;
    return (A) this;
  }
  
  public boolean hasManagementState() {
    return this.managementState != null;
  }
  
  public ImageRegistryConfigStorageAlibabaOSS buildOss() {
    return this.oss != null ? this.oss.build() : null;
  }
  
  public A withOss(ImageRegistryConfigStorageAlibabaOSS oss) {
    this._visitables.remove(this.oss);
    if (oss != null) {
        this.oss = new ImageRegistryConfigStorageAlibabaOSSBuilder(oss);
        this._visitables.get("oss").add(this.oss);
    } else {
        this.oss = null;
        this._visitables.get("oss").remove(this.oss);
    }
    return (A) this;
  }
  
  public boolean hasOss() {
    return this.oss != null;
  }
  
  public OssNested<A> withNewOss() {
    return new OssNested(null);
  }
  
  public OssNested<A> withNewOssLike(ImageRegistryConfigStorageAlibabaOSS item) {
    return new OssNested(item);
  }
  
  public OssNested<A> editOss() {
    return withNewOssLike(java.util.Optional.ofNullable(buildOss()).orElse(null));
  }
  
  public OssNested<A> editOrNewOss() {
    return withNewOssLike(java.util.Optional.ofNullable(buildOss()).orElse(new ImageRegistryConfigStorageAlibabaOSSBuilder().build()));
  }
  
  public OssNested<A> editOrNewOssLike(ImageRegistryConfigStorageAlibabaOSS item) {
    return withNewOssLike(java.util.Optional.ofNullable(buildOss()).orElse(item));
  }
  
  public ImageRegistryConfigStoragePVC buildPvc() {
    return this.pvc != null ? this.pvc.build() : null;
  }
  
  public A withPvc(ImageRegistryConfigStoragePVC pvc) {
    this._visitables.remove(this.pvc);
    if (pvc != null) {
        this.pvc = new ImageRegistryConfigStoragePVCBuilder(pvc);
        this._visitables.get("pvc").add(this.pvc);
    } else {
        this.pvc = null;
        this._visitables.get("pvc").remove(this.pvc);
    }
    return (A) this;
  }
  
  public boolean hasPvc() {
    return this.pvc != null;
  }
  
  public A withNewPvc(String claim) {
    return (A)withPvc(new ImageRegistryConfigStoragePVC(claim));
  }
  
  public PvcNested<A> withNewPvc() {
    return new PvcNested(null);
  }
  
  public PvcNested<A> withNewPvcLike(ImageRegistryConfigStoragePVC item) {
    return new PvcNested(item);
  }
  
  public PvcNested<A> editPvc() {
    return withNewPvcLike(java.util.Optional.ofNullable(buildPvc()).orElse(null));
  }
  
  public PvcNested<A> editOrNewPvc() {
    return withNewPvcLike(java.util.Optional.ofNullable(buildPvc()).orElse(new ImageRegistryConfigStoragePVCBuilder().build()));
  }
  
  public PvcNested<A> editOrNewPvcLike(ImageRegistryConfigStoragePVC item) {
    return withNewPvcLike(java.util.Optional.ofNullable(buildPvc()).orElse(item));
  }
  
  public ImageRegistryConfigStorageS3 buildS3() {
    return this.s3 != null ? this.s3.build() : null;
  }
  
  public A withS3(ImageRegistryConfigStorageS3 s3) {
    this._visitables.remove(this.s3);
    if (s3 != null) {
        this.s3 = new ImageRegistryConfigStorageS3Builder(s3);
        this._visitables.get("s3").add(this.s3);
    } else {
        this.s3 = null;
        this._visitables.get("s3").remove(this.s3);
    }
    return (A) this;
  }
  
  public boolean hasS3() {
    return this.s3 != null;
  }
  
  public S3Nested<A> withNewS3() {
    return new S3Nested(null);
  }
  
  public S3Nested<A> withNewS3Like(ImageRegistryConfigStorageS3 item) {
    return new S3Nested(item);
  }
  
  public S3Nested<A> editS3() {
    return withNewS3Like(java.util.Optional.ofNullable(buildS3()).orElse(null));
  }
  
  public S3Nested<A> editOrNewS3() {
    return withNewS3Like(java.util.Optional.ofNullable(buildS3()).orElse(new ImageRegistryConfigStorageS3Builder().build()));
  }
  
  public S3Nested<A> editOrNewS3Like(ImageRegistryConfigStorageS3 item) {
    return withNewS3Like(java.util.Optional.ofNullable(buildS3()).orElse(item));
  }
  
  public ImageRegistryConfigStorageSwift buildSwift() {
    return this.swift != null ? this.swift.build() : null;
  }
  
  public A withSwift(ImageRegistryConfigStorageSwift swift) {
    this._visitables.remove(this.swift);
    if (swift != null) {
        this.swift = new ImageRegistryConfigStorageSwiftBuilder(swift);
        this._visitables.get("swift").add(this.swift);
    } else {
        this.swift = null;
        this._visitables.get("swift").remove(this.swift);
    }
    return (A) this;
  }
  
  public boolean hasSwift() {
    return this.swift != null;
  }
  
  public SwiftNested<A> withNewSwift() {
    return new SwiftNested(null);
  }
  
  public SwiftNested<A> withNewSwiftLike(ImageRegistryConfigStorageSwift item) {
    return new SwiftNested(item);
  }
  
  public SwiftNested<A> editSwift() {
    return withNewSwiftLike(java.util.Optional.ofNullable(buildSwift()).orElse(null));
  }
  
  public SwiftNested<A> editOrNewSwift() {
    return withNewSwiftLike(java.util.Optional.ofNullable(buildSwift()).orElse(new ImageRegistryConfigStorageSwiftBuilder().build()));
  }
  
  public SwiftNested<A> editOrNewSwiftLike(ImageRegistryConfigStorageSwift item) {
    return withNewSwiftLike(java.util.Optional.ofNullable(buildSwift()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ImageRegistryConfigStorageFluent that = (ImageRegistryConfigStorageFluent) o;
    if (!java.util.Objects.equals(azure, that.azure)) return false;
    if (!java.util.Objects.equals(emptyDir, that.emptyDir)) return false;
    if (!java.util.Objects.equals(gcs, that.gcs)) return false;
    if (!java.util.Objects.equals(ibmcos, that.ibmcos)) return false;
    if (!java.util.Objects.equals(managementState, that.managementState)) return false;
    if (!java.util.Objects.equals(oss, that.oss)) return false;
    if (!java.util.Objects.equals(pvc, that.pvc)) return false;
    if (!java.util.Objects.equals(s3, that.s3)) return false;
    if (!java.util.Objects.equals(swift, that.swift)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(azure,  emptyDir,  gcs,  ibmcos,  managementState,  oss,  pvc,  s3,  swift,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (azure != null) { sb.append("azure:"); sb.append(azure + ","); }
    if (emptyDir != null) { sb.append("emptyDir:"); sb.append(emptyDir + ","); }
    if (gcs != null) { sb.append("gcs:"); sb.append(gcs + ","); }
    if (ibmcos != null) { sb.append("ibmcos:"); sb.append(ibmcos + ","); }
    if (managementState != null) { sb.append("managementState:"); sb.append(managementState + ","); }
    if (oss != null) { sb.append("oss:"); sb.append(oss + ","); }
    if (pvc != null) { sb.append("pvc:"); sb.append(pvc + ","); }
    if (s3 != null) { sb.append("s3:"); sb.append(s3 + ","); }
    if (swift != null) { sb.append("swift:"); sb.append(swift + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class AzureNested<N> extends ImageRegistryConfigStorageAzureFluent<AzureNested<N>> implements Nested<N>{
    AzureNested(ImageRegistryConfigStorageAzure item) {
      this.builder = new ImageRegistryConfigStorageAzureBuilder(this, item);
    }
    ImageRegistryConfigStorageAzureBuilder builder;
    
    public N and() {
      return (N) ImageRegistryConfigStorageFluent.this.withAzure(builder.build());
    }
    
    public N endAzure() {
      return and();
    }
    
  
  }
  public class EmptyDirNested<N> extends ImageRegistryConfigStorageEmptyDirFluent<EmptyDirNested<N>> implements Nested<N>{
    EmptyDirNested(ImageRegistryConfigStorageEmptyDir item) {
      this.builder = new ImageRegistryConfigStorageEmptyDirBuilder(this, item);
    }
    ImageRegistryConfigStorageEmptyDirBuilder builder;
    
    public N and() {
      return (N) ImageRegistryConfigStorageFluent.this.withEmptyDir(builder.build());
    }
    
    public N endEmptyDir() {
      return and();
    }
    
  
  }
  public class GcsNested<N> extends ImageRegistryConfigStorageGCSFluent<GcsNested<N>> implements Nested<N>{
    GcsNested(ImageRegistryConfigStorageGCS item) {
      this.builder = new ImageRegistryConfigStorageGCSBuilder(this, item);
    }
    ImageRegistryConfigStorageGCSBuilder builder;
    
    public N and() {
      return (N) ImageRegistryConfigStorageFluent.this.withGcs(builder.build());
    }
    
    public N endGcs() {
      return and();
    }
    
  
  }
  public class IbmcosNested<N> extends ImageRegistryConfigStorageIBMCOSFluent<IbmcosNested<N>> implements Nested<N>{
    IbmcosNested(ImageRegistryConfigStorageIBMCOS item) {
      this.builder = new ImageRegistryConfigStorageIBMCOSBuilder(this, item);
    }
    ImageRegistryConfigStorageIBMCOSBuilder builder;
    
    public N and() {
      return (N) ImageRegistryConfigStorageFluent.this.withIbmcos(builder.build());
    }
    
    public N endIbmcos() {
      return and();
    }
    
  
  }
  public class OssNested<N> extends ImageRegistryConfigStorageAlibabaOSSFluent<OssNested<N>> implements Nested<N>{
    OssNested(ImageRegistryConfigStorageAlibabaOSS item) {
      this.builder = new ImageRegistryConfigStorageAlibabaOSSBuilder(this, item);
    }
    ImageRegistryConfigStorageAlibabaOSSBuilder builder;
    
    public N and() {
      return (N) ImageRegistryConfigStorageFluent.this.withOss(builder.build());
    }
    
    public N endOss() {
      return and();
    }
    
  
  }
  public class PvcNested<N> extends ImageRegistryConfigStoragePVCFluent<PvcNested<N>> implements Nested<N>{
    PvcNested(ImageRegistryConfigStoragePVC item) {
      this.builder = new ImageRegistryConfigStoragePVCBuilder(this, item);
    }
    ImageRegistryConfigStoragePVCBuilder builder;
    
    public N and() {
      return (N) ImageRegistryConfigStorageFluent.this.withPvc(builder.build());
    }
    
    public N endPvc() {
      return and();
    }
    
  
  }
  public class S3Nested<N> extends ImageRegistryConfigStorageS3Fluent<S3Nested<N>> implements Nested<N>{
    S3Nested(ImageRegistryConfigStorageS3 item) {
      this.builder = new ImageRegistryConfigStorageS3Builder(this, item);
    }
    ImageRegistryConfigStorageS3Builder builder;
    
    public N and() {
      return (N) ImageRegistryConfigStorageFluent.this.withS3(builder.build());
    }
    
    public N endS3() {
      return and();
    }
    
  
  }
  public class SwiftNested<N> extends ImageRegistryConfigStorageSwiftFluent<SwiftNested<N>> implements Nested<N>{
    SwiftNested(ImageRegistryConfigStorageSwift item) {
      this.builder = new ImageRegistryConfigStorageSwiftBuilder(this, item);
    }
    ImageRegistryConfigStorageSwiftBuilder builder;
    
    public N and() {
      return (N) ImageRegistryConfigStorageFluent.this.withSwift(builder.build());
    }
    
    public N endSwift() {
      return and();
    }
    
  
  }

}