package io.fabric8.openshift.api.model.miscellaneous.network.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class EgressRouterSpecFluent<A extends EgressRouterSpecFluent<A>> extends BaseFluent<A>{
  public EgressRouterSpecFluent() {
  }
  
  public EgressRouterSpecFluent(EgressRouterSpec instance) {
    this.copyInstance(instance);
  }
  private ArrayList<EgressRouterAddressBuilder> addresses = new ArrayList<EgressRouterAddressBuilder>();
  private String mode;
  private EgressRouterInterfaceBuilder networkInterface;
  private RedirectConfigBuilder redirect;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(EgressRouterSpec instance) {
    instance = (instance != null ? instance : new EgressRouterSpec());
    if (instance != null) {
          this.withAddresses(instance.getAddresses());
          this.withMode(instance.getMode());
          this.withNetworkInterface(instance.getNetworkInterface());
          this.withRedirect(instance.getRedirect());
          this.withAddresses(instance.getAddresses());
          this.withMode(instance.getMode());
          this.withNetworkInterface(instance.getNetworkInterface());
          this.withRedirect(instance.getRedirect());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToAddresses(int index,EgressRouterAddress item) {
    if (this.addresses == null) {this.addresses = new ArrayList<EgressRouterAddressBuilder>();}
    EgressRouterAddressBuilder builder = new EgressRouterAddressBuilder(item);
    if (index < 0 || index >= addresses.size()) { _visitables.get("addresses").add(builder); addresses.add(builder); } else { _visitables.get("addresses").add(index, builder); addresses.add(index, builder);}
    return (A)this;
  }
  
  public A setToAddresses(int index,EgressRouterAddress item) {
    if (this.addresses == null) {this.addresses = new ArrayList<EgressRouterAddressBuilder>();}
    EgressRouterAddressBuilder builder = new EgressRouterAddressBuilder(item);
    if (index < 0 || index >= addresses.size()) { _visitables.get("addresses").add(builder); addresses.add(builder); } else { _visitables.get("addresses").set(index, builder); addresses.set(index, builder);}
    return (A)this;
  }
  
  public A addToAddresses(io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.EgressRouterAddress... items) {
    if (this.addresses == null) {this.addresses = new ArrayList<EgressRouterAddressBuilder>();}
    for (EgressRouterAddress item : items) {EgressRouterAddressBuilder builder = new EgressRouterAddressBuilder(item);_visitables.get("addresses").add(builder);this.addresses.add(builder);} return (A)this;
  }
  
  public A addAllToAddresses(Collection<EgressRouterAddress> items) {
    if (this.addresses == null) {this.addresses = new ArrayList<EgressRouterAddressBuilder>();}
    for (EgressRouterAddress item : items) {EgressRouterAddressBuilder builder = new EgressRouterAddressBuilder(item);_visitables.get("addresses").add(builder);this.addresses.add(builder);} return (A)this;
  }
  
  public A removeFromAddresses(io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.EgressRouterAddress... items) {
    if (this.addresses == null) return (A)this;
    for (EgressRouterAddress item : items) {EgressRouterAddressBuilder builder = new EgressRouterAddressBuilder(item);_visitables.get("addresses").remove(builder); this.addresses.remove(builder);} return (A)this;
  }
  
  public A removeAllFromAddresses(Collection<EgressRouterAddress> items) {
    if (this.addresses == null) return (A)this;
    for (EgressRouterAddress item : items) {EgressRouterAddressBuilder builder = new EgressRouterAddressBuilder(item);_visitables.get("addresses").remove(builder); this.addresses.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromAddresses(Predicate<EgressRouterAddressBuilder> predicate) {
    if (addresses == null) return (A) this;
    final Iterator<EgressRouterAddressBuilder> each = addresses.iterator();
    final List visitables = _visitables.get("addresses");
    while (each.hasNext()) {
      EgressRouterAddressBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<EgressRouterAddress> buildAddresses() {
    return this.addresses != null ? build(addresses) : null;
  }
  
  public EgressRouterAddress buildAddress(int index) {
    return this.addresses.get(index).build();
  }
  
  public EgressRouterAddress buildFirstAddress() {
    return this.addresses.get(0).build();
  }
  
  public EgressRouterAddress buildLastAddress() {
    return this.addresses.get(addresses.size() - 1).build();
  }
  
  public EgressRouterAddress buildMatchingAddress(Predicate<EgressRouterAddressBuilder> predicate) {
      for (EgressRouterAddressBuilder item : addresses) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingAddress(Predicate<EgressRouterAddressBuilder> predicate) {
      for (EgressRouterAddressBuilder item : addresses) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withAddresses(List<EgressRouterAddress> addresses) {
    if (this.addresses != null) {
      this._visitables.get("addresses").clear();
    }
    if (addresses != null) {
        this.addresses = new ArrayList();
        for (EgressRouterAddress item : addresses) {
          this.addToAddresses(item);
        }
    } else {
      this.addresses = null;
    }
    return (A) this;
  }
  
  public A withAddresses(io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.EgressRouterAddress... addresses) {
    if (this.addresses != null) {this.addresses.clear(); _visitables.remove("addresses"); }
    if (addresses != null) {for (EgressRouterAddress item :addresses){ this.addToAddresses(item);}} return (A) this;
  }
  
  public boolean hasAddresses() {
    return this.addresses != null && !this.addresses.isEmpty();
  }
  
  public A addNewAddress(String gateway,String ip) {
    return (A)addToAddresses(new EgressRouterAddress(gateway, ip));
  }
  
  public AddressesNested<A> addNewAddress() {
    return new AddressesNested(-1, null);
  }
  
  public AddressesNested<A> addNewAddressLike(EgressRouterAddress item) {
    return new AddressesNested(-1, item);
  }
  
  public AddressesNested<A> setNewAddressLike(int index,EgressRouterAddress item) {
    return new AddressesNested(index, item);
  }
  
  public AddressesNested<A> editAddress(int index) {
    if (addresses.size() <= index) throw new RuntimeException("Can't edit addresses. Index exceeds size.");
    return setNewAddressLike(index, buildAddress(index));
  }
  
  public AddressesNested<A> editFirstAddress() {
    if (addresses.size() == 0) throw new RuntimeException("Can't edit first addresses. The list is empty.");
    return setNewAddressLike(0, buildAddress(0));
  }
  
  public AddressesNested<A> editLastAddress() {
    int index = addresses.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last addresses. The list is empty.");
    return setNewAddressLike(index, buildAddress(index));
  }
  
  public AddressesNested<A> editMatchingAddress(Predicate<EgressRouterAddressBuilder> predicate) {
    int index = -1;
    for (int i=0;i<addresses.size();i++) { 
    if (predicate.test(addresses.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching addresses. No match found.");
    return setNewAddressLike(index, buildAddress(index));
  }
  
  public String getMode() {
    return this.mode;
  }
  
  public A withMode(String mode) {
    this.mode = mode;
    return (A) this;
  }
  
  public boolean hasMode() {
    return this.mode != null;
  }
  
  public EgressRouterInterface buildNetworkInterface() {
    return this.networkInterface != null ? this.networkInterface.build() : null;
  }
  
  public A withNetworkInterface(EgressRouterInterface networkInterface) {
    this._visitables.remove(this.networkInterface);
    if (networkInterface != null) {
        this.networkInterface = new EgressRouterInterfaceBuilder(networkInterface);
        this._visitables.get("networkInterface").add(this.networkInterface);
    } else {
        this.networkInterface = null;
        this._visitables.get("networkInterface").remove(this.networkInterface);
    }
    return (A) this;
  }
  
  public boolean hasNetworkInterface() {
    return this.networkInterface != null;
  }
  
  public NetworkInterfaceNested<A> withNewNetworkInterface() {
    return new NetworkInterfaceNested(null);
  }
  
  public NetworkInterfaceNested<A> withNewNetworkInterfaceLike(EgressRouterInterface item) {
    return new NetworkInterfaceNested(item);
  }
  
  public NetworkInterfaceNested<A> editNetworkInterface() {
    return withNewNetworkInterfaceLike(java.util.Optional.ofNullable(buildNetworkInterface()).orElse(null));
  }
  
  public NetworkInterfaceNested<A> editOrNewNetworkInterface() {
    return withNewNetworkInterfaceLike(java.util.Optional.ofNullable(buildNetworkInterface()).orElse(new EgressRouterInterfaceBuilder().build()));
  }
  
  public NetworkInterfaceNested<A> editOrNewNetworkInterfaceLike(EgressRouterInterface item) {
    return withNewNetworkInterfaceLike(java.util.Optional.ofNullable(buildNetworkInterface()).orElse(item));
  }
  
  public RedirectConfig buildRedirect() {
    return this.redirect != null ? this.redirect.build() : null;
  }
  
  public A withRedirect(RedirectConfig redirect) {
    this._visitables.remove(this.redirect);
    if (redirect != null) {
        this.redirect = new RedirectConfigBuilder(redirect);
        this._visitables.get("redirect").add(this.redirect);
    } else {
        this.redirect = null;
        this._visitables.get("redirect").remove(this.redirect);
    }
    return (A) this;
  }
  
  public boolean hasRedirect() {
    return this.redirect != null;
  }
  
  public RedirectNested<A> withNewRedirect() {
    return new RedirectNested(null);
  }
  
  public RedirectNested<A> withNewRedirectLike(RedirectConfig item) {
    return new RedirectNested(item);
  }
  
  public RedirectNested<A> editRedirect() {
    return withNewRedirectLike(java.util.Optional.ofNullable(buildRedirect()).orElse(null));
  }
  
  public RedirectNested<A> editOrNewRedirect() {
    return withNewRedirectLike(java.util.Optional.ofNullable(buildRedirect()).orElse(new RedirectConfigBuilder().build()));
  }
  
  public RedirectNested<A> editOrNewRedirectLike(RedirectConfig item) {
    return withNewRedirectLike(java.util.Optional.ofNullable(buildRedirect()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    EgressRouterSpecFluent that = (EgressRouterSpecFluent) o;
    if (!java.util.Objects.equals(addresses, that.addresses)) return false;
    if (!java.util.Objects.equals(mode, that.mode)) return false;
    if (!java.util.Objects.equals(networkInterface, that.networkInterface)) return false;
    if (!java.util.Objects.equals(redirect, that.redirect)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(addresses,  mode,  networkInterface,  redirect,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (addresses != null && !addresses.isEmpty()) { sb.append("addresses:"); sb.append(addresses + ","); }
    if (mode != null) { sb.append("mode:"); sb.append(mode + ","); }
    if (networkInterface != null) { sb.append("networkInterface:"); sb.append(networkInterface + ","); }
    if (redirect != null) { sb.append("redirect:"); sb.append(redirect + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class AddressesNested<N> extends EgressRouterAddressFluent<AddressesNested<N>> implements Nested<N>{
    AddressesNested(int index,EgressRouterAddress item) {
      this.index = index;
      this.builder = new EgressRouterAddressBuilder(this, item);
    }
    EgressRouterAddressBuilder builder;
    int index;
    
    public N and() {
      return (N) EgressRouterSpecFluent.this.setToAddresses(index,builder.build());
    }
    
    public N endAddress() {
      return and();
    }
    
  
  }
  public class NetworkInterfaceNested<N> extends EgressRouterInterfaceFluent<NetworkInterfaceNested<N>> implements Nested<N>{
    NetworkInterfaceNested(EgressRouterInterface item) {
      this.builder = new EgressRouterInterfaceBuilder(this, item);
    }
    EgressRouterInterfaceBuilder builder;
    
    public N and() {
      return (N) EgressRouterSpecFluent.this.withNetworkInterface(builder.build());
    }
    
    public N endNetworkInterface() {
      return and();
    }
    
  
  }
  public class RedirectNested<N> extends RedirectConfigFluent<RedirectNested<N>> implements Nested<N>{
    RedirectNested(RedirectConfig item) {
      this.builder = new RedirectConfigBuilder(this, item);
    }
    RedirectConfigBuilder builder;
    
    public N and() {
      return (N) EgressRouterSpecFluent.this.withRedirect(builder.build());
    }
    
    public N endRedirect() {
      return and();
    }
    
  
  }

}