/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkDataLinkBond;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkLinkEthernetMac;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkLinkEthernetMacBuilder;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkLinkEthernetMacFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class NetworkDataLinkBondFluent<A extends NetworkDataLinkBondFluent<A>>
extends BaseFluent<A> {
    private List<String> bondLinks = new ArrayList<String>();
    private String bondMode;
    private String bondXmitHashPolicy;
    private String id;
    private NetworkLinkEthernetMacBuilder macAddress;
    private Integer mtu;
    private Map<String, Object> additionalProperties;

    public NetworkDataLinkBondFluent() {
    }

    public NetworkDataLinkBondFluent(NetworkDataLinkBond instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(NetworkDataLinkBond instance) {
        NetworkDataLinkBond networkDataLinkBond = instance = instance != null ? instance : new NetworkDataLinkBond();
        if (instance != null) {
            this.withBondLinks(instance.getBondLinks());
            this.withBondMode(instance.getBondMode());
            this.withBondXmitHashPolicy(instance.getBondXmitHashPolicy());
            this.withId(instance.getId());
            this.withMacAddress(instance.getMacAddress());
            this.withMtu(instance.getMtu());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToBondLinks(int index, String item) {
        if (this.bondLinks == null) {
            this.bondLinks = new ArrayList<String>();
        }
        this.bondLinks.add(index, item);
        return (A)((Object)this);
    }

    public A setToBondLinks(int index, String item) {
        if (this.bondLinks == null) {
            this.bondLinks = new ArrayList<String>();
        }
        this.bondLinks.set(index, item);
        return (A)((Object)this);
    }

    public A addToBondLinks(String ... items) {
        if (this.bondLinks == null) {
            this.bondLinks = new ArrayList<String>();
        }
        for (String item : items) {
            this.bondLinks.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToBondLinks(Collection<String> items) {
        if (this.bondLinks == null) {
            this.bondLinks = new ArrayList<String>();
        }
        for (String item : items) {
            this.bondLinks.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromBondLinks(String ... items) {
        if (this.bondLinks == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.bondLinks.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromBondLinks(Collection<String> items) {
        if (this.bondLinks == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.bondLinks.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getBondLinks() {
        return this.bondLinks;
    }

    public String getBondLink(int index) {
        return this.bondLinks.get(index);
    }

    public String getFirstBondLink() {
        return this.bondLinks.get(0);
    }

    public String getLastBondLink() {
        return this.bondLinks.get(this.bondLinks.size() - 1);
    }

    public String getMatchingBondLink(Predicate<String> predicate) {
        for (String item : this.bondLinks) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingBondLink(Predicate<String> predicate) {
        for (String item : this.bondLinks) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withBondLinks(List<String> bondLinks) {
        if (bondLinks != null) {
            this.bondLinks = new ArrayList<String>();
            for (String item : bondLinks) {
                this.addToBondLinks(item);
            }
        } else {
            this.bondLinks = null;
        }
        return (A)((Object)this);
    }

    public A withBondLinks(String ... bondLinks) {
        if (this.bondLinks != null) {
            this.bondLinks.clear();
            this._visitables.remove((Object)"bondLinks");
        }
        if (bondLinks != null) {
            for (String item : bondLinks) {
                this.addToBondLinks(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasBondLinks() {
        return this.bondLinks != null && !this.bondLinks.isEmpty();
    }

    public String getBondMode() {
        return this.bondMode;
    }

    public A withBondMode(String bondMode) {
        this.bondMode = bondMode;
        return (A)((Object)this);
    }

    public boolean hasBondMode() {
        return this.bondMode != null;
    }

    public String getBondXmitHashPolicy() {
        return this.bondXmitHashPolicy;
    }

    public A withBondXmitHashPolicy(String bondXmitHashPolicy) {
        this.bondXmitHashPolicy = bondXmitHashPolicy;
        return (A)((Object)this);
    }

    public boolean hasBondXmitHashPolicy() {
        return this.bondXmitHashPolicy != null;
    }

    public String getId() {
        return this.id;
    }

    public A withId(String id) {
        this.id = id;
        return (A)((Object)this);
    }

    public boolean hasId() {
        return this.id != null;
    }

    public NetworkLinkEthernetMac buildMacAddress() {
        return this.macAddress != null ? this.macAddress.build() : null;
    }

    public A withMacAddress(NetworkLinkEthernetMac macAddress) {
        this._visitables.remove((Object)"macAddress");
        if (macAddress != null) {
            this.macAddress = new NetworkLinkEthernetMacBuilder(macAddress);
            this._visitables.get((Object)"macAddress").add(this.macAddress);
        } else {
            this.macAddress = null;
            this._visitables.get((Object)"macAddress").remove((Object)this.macAddress);
        }
        return (A)((Object)this);
    }

    public boolean hasMacAddress() {
        return this.macAddress != null;
    }

    public MacAddressNested<A> withNewMacAddress() {
        return new MacAddressNested(null);
    }

    public MacAddressNested<A> withNewMacAddressLike(NetworkLinkEthernetMac item) {
        return new MacAddressNested(item);
    }

    public MacAddressNested<A> editMacAddress() {
        return this.withNewMacAddressLike(Optional.ofNullable(this.buildMacAddress()).orElse(null));
    }

    public MacAddressNested<A> editOrNewMacAddress() {
        return this.withNewMacAddressLike(Optional.ofNullable(this.buildMacAddress()).orElse(new NetworkLinkEthernetMacBuilder().build()));
    }

    public MacAddressNested<A> editOrNewMacAddressLike(NetworkLinkEthernetMac item) {
        return this.withNewMacAddressLike(Optional.ofNullable(this.buildMacAddress()).orElse(item));
    }

    public Integer getMtu() {
        return this.mtu;
    }

    public A withMtu(Integer mtu) {
        this.mtu = mtu;
        return (A)((Object)this);
    }

    public boolean hasMtu() {
        return this.mtu != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkDataLinkBondFluent that = (NetworkDataLinkBondFluent)((Object)o);
        if (!Objects.equals(this.bondLinks, that.bondLinks)) {
            return false;
        }
        if (!Objects.equals(this.bondMode, that.bondMode)) {
            return false;
        }
        if (!Objects.equals(this.bondXmitHashPolicy, that.bondXmitHashPolicy)) {
            return false;
        }
        if (!Objects.equals(this.id, that.id)) {
            return false;
        }
        if (!Objects.equals((Object)this.macAddress, (Object)that.macAddress)) {
            return false;
        }
        if (!Objects.equals(this.mtu, that.mtu)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bondLinks, this.bondMode, this.bondXmitHashPolicy, this.id, this.macAddress, this.mtu, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bondLinks != null && !this.bondLinks.isEmpty()) {
            sb.append("bondLinks:");
            sb.append(this.bondLinks + ",");
        }
        if (this.bondMode != null) {
            sb.append("bondMode:");
            sb.append(this.bondMode + ",");
        }
        if (this.bondXmitHashPolicy != null) {
            sb.append("bondXmitHashPolicy:");
            sb.append(this.bondXmitHashPolicy + ",");
        }
        if (this.id != null) {
            sb.append("id:");
            sb.append(this.id + ",");
        }
        if (this.macAddress != null) {
            sb.append("macAddress:");
            sb.append(this.macAddress + ",");
        }
        if (this.mtu != null) {
            sb.append("mtu:");
            sb.append(this.mtu + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MacAddressNested<N>
    extends NetworkLinkEthernetMacFluent<MacAddressNested<N>>
    implements Nested<N> {
        NetworkLinkEthernetMacBuilder builder;

        MacAddressNested(NetworkLinkEthernetMac item) {
            this.builder = new NetworkLinkEthernetMacBuilder(this, item);
        }

        public N and() {
            return (N)NetworkDataLinkBondFluent.this.withMacAddress(this.builder.build());
        }

        public N endMacAddress() {
            return this.and();
        }
    }
}

