package io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class DataImageStatusFluent<A extends DataImageStatusFluent<A>> extends BaseFluent<A>{
  public DataImageStatusFluent() {
  }
  
  public DataImageStatusFluent(DataImageStatus instance) {
    this.copyInstance(instance);
  }
  private AttachedImageReferenceBuilder attachedImage;
  private DataImageErrorBuilder error;
  private String lastReconciled;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(DataImageStatus instance) {
    instance = (instance != null ? instance : new DataImageStatus());
    if (instance != null) {
          this.withAttachedImage(instance.getAttachedImage());
          this.withError(instance.getError());
          this.withLastReconciled(instance.getLastReconciled());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public AttachedImageReference buildAttachedImage() {
    return this.attachedImage != null ? this.attachedImage.build() : null;
  }
  
  public A withAttachedImage(AttachedImageReference attachedImage) {
    this._visitables.remove("attachedImage");
    if (attachedImage != null) {
        this.attachedImage = new AttachedImageReferenceBuilder(attachedImage);
        this._visitables.get("attachedImage").add(this.attachedImage);
    } else {
        this.attachedImage = null;
        this._visitables.get("attachedImage").remove(this.attachedImage);
    }
    return (A) this;
  }
  
  public boolean hasAttachedImage() {
    return this.attachedImage != null;
  }
  
  public A withNewAttachedImage(String url) {
    return (A)withAttachedImage(new AttachedImageReference(url));
  }
  
  public AttachedImageNested<A> withNewAttachedImage() {
    return new AttachedImageNested(null);
  }
  
  public AttachedImageNested<A> withNewAttachedImageLike(AttachedImageReference item) {
    return new AttachedImageNested(item);
  }
  
  public AttachedImageNested<A> editAttachedImage() {
    return withNewAttachedImageLike(java.util.Optional.ofNullable(buildAttachedImage()).orElse(null));
  }
  
  public AttachedImageNested<A> editOrNewAttachedImage() {
    return withNewAttachedImageLike(java.util.Optional.ofNullable(buildAttachedImage()).orElse(new AttachedImageReferenceBuilder().build()));
  }
  
  public AttachedImageNested<A> editOrNewAttachedImageLike(AttachedImageReference item) {
    return withNewAttachedImageLike(java.util.Optional.ofNullable(buildAttachedImage()).orElse(item));
  }
  
  public DataImageError buildError() {
    return this.error != null ? this.error.build() : null;
  }
  
  public A withError(DataImageError error) {
    this._visitables.remove("error");
    if (error != null) {
        this.error = new DataImageErrorBuilder(error);
        this._visitables.get("error").add(this.error);
    } else {
        this.error = null;
        this._visitables.get("error").remove(this.error);
    }
    return (A) this;
  }
  
  public boolean hasError() {
    return this.error != null;
  }
  
  public A withNewError(Integer count,String message) {
    return (A)withError(new DataImageError(count, message));
  }
  
  public ErrorNested<A> withNewError() {
    return new ErrorNested(null);
  }
  
  public ErrorNested<A> withNewErrorLike(DataImageError item) {
    return new ErrorNested(item);
  }
  
  public ErrorNested<A> editError() {
    return withNewErrorLike(java.util.Optional.ofNullable(buildError()).orElse(null));
  }
  
  public ErrorNested<A> editOrNewError() {
    return withNewErrorLike(java.util.Optional.ofNullable(buildError()).orElse(new DataImageErrorBuilder().build()));
  }
  
  public ErrorNested<A> editOrNewErrorLike(DataImageError item) {
    return withNewErrorLike(java.util.Optional.ofNullable(buildError()).orElse(item));
  }
  
  public String getLastReconciled() {
    return this.lastReconciled;
  }
  
  public A withLastReconciled(String lastReconciled) {
    this.lastReconciled = lastReconciled;
    return (A) this;
  }
  
  public boolean hasLastReconciled() {
    return this.lastReconciled != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DataImageStatusFluent that = (DataImageStatusFluent) o;
    if (!java.util.Objects.equals(attachedImage, that.attachedImage)) return false;
    if (!java.util.Objects.equals(error, that.error)) return false;
    if (!java.util.Objects.equals(lastReconciled, that.lastReconciled)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(attachedImage,  error,  lastReconciled,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (attachedImage != null) { sb.append("attachedImage:"); sb.append(attachedImage + ","); }
    if (error != null) { sb.append("error:"); sb.append(error + ","); }
    if (lastReconciled != null) { sb.append("lastReconciled:"); sb.append(lastReconciled + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class AttachedImageNested<N> extends AttachedImageReferenceFluent<AttachedImageNested<N>> implements Nested<N>{
    AttachedImageNested(AttachedImageReference item) {
      this.builder = new AttachedImageReferenceBuilder(this, item);
    }
    AttachedImageReferenceBuilder builder;
    
    public N and() {
      return (N) DataImageStatusFluent.this.withAttachedImage(builder.build());
    }
    
    public N endAttachedImage() {
      return and();
    }
    
  
  }
  public class ErrorNested<N> extends DataImageErrorFluent<ErrorNested<N>> implements Nested<N>{
    ErrorNested(DataImageError item) {
      this.builder = new DataImageErrorBuilder(this, item);
    }
    DataImageErrorBuilder builder;
    
    public N and() {
      return (N) DataImageStatusFluent.this.withError(builder.build());
    }
    
    public N endError() {
      return and();
    }
    
  
  }

}