package io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1;

import io.fabric8.kubernetes.api.model.clusterapi.v1beta1.Condition;
import io.fabric8.kubernetes.api.model.SecretReference;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.clusterapi.v1beta1.MachineAddress;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class Metal3MachineStatusFluent<A extends Metal3MachineStatusFluent<A>> extends BaseFluent<A>{
  public Metal3MachineStatusFluent() {
  }
  
  public Metal3MachineStatusFluent(Metal3MachineStatus instance) {
    this.copyInstance(instance);
  }
  private List<MachineAddress> addresses = new ArrayList<MachineAddress>();
  private List<Condition> conditions = new ArrayList<Condition>();
  private String failureMessage;
  private String failureReason;
  private String lastUpdated;
  private SecretReference metaData;
  private SecretReference networkData;
  private String phase;
  private Boolean ready;
  private ObjectReferenceBuilder renderedData;
  private SecretReference userData;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(Metal3MachineStatus instance) {
    instance = (instance != null ? instance : new Metal3MachineStatus());
    if (instance != null) {
          this.withAddresses(instance.getAddresses());
          this.withConditions(instance.getConditions());
          this.withFailureMessage(instance.getFailureMessage());
          this.withFailureReason(instance.getFailureReason());
          this.withLastUpdated(instance.getLastUpdated());
          this.withMetaData(instance.getMetaData());
          this.withNetworkData(instance.getNetworkData());
          this.withPhase(instance.getPhase());
          this.withReady(instance.getReady());
          this.withRenderedData(instance.getRenderedData());
          this.withUserData(instance.getUserData());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToAddresses(int index,MachineAddress item) {
    if (this.addresses == null) {this.addresses = new ArrayList<MachineAddress>();}
    this.addresses.add(index, item);
    return (A)this;
  }
  
  public A setToAddresses(int index,MachineAddress item) {
    if (this.addresses == null) {this.addresses = new ArrayList<MachineAddress>();}
    this.addresses.set(index, item); return (A)this;
  }
  
  public A addToAddresses(io.fabric8.kubernetes.api.model.clusterapi.v1beta1.MachineAddress... items) {
    if (this.addresses == null) {this.addresses = new ArrayList<MachineAddress>();}
    for (MachineAddress item : items) {this.addresses.add(item);} return (A)this;
  }
  
  public A addAllToAddresses(Collection<MachineAddress> items) {
    if (this.addresses == null) {this.addresses = new ArrayList<MachineAddress>();}
    for (MachineAddress item : items) {this.addresses.add(item);} return (A)this;
  }
  
  public A removeFromAddresses(io.fabric8.kubernetes.api.model.clusterapi.v1beta1.MachineAddress... items) {
    if (this.addresses == null) return (A)this;
    for (MachineAddress item : items) { this.addresses.remove(item);} return (A)this;
  }
  
  public A removeAllFromAddresses(Collection<MachineAddress> items) {
    if (this.addresses == null) return (A)this;
    for (MachineAddress item : items) { this.addresses.remove(item);} return (A)this;
  }
  
  public List<MachineAddress> getAddresses() {
    return this.addresses;
  }
  
  public MachineAddress getAddress(int index) {
    return this.addresses.get(index);
  }
  
  public MachineAddress getFirstAddress() {
    return this.addresses.get(0);
  }
  
  public MachineAddress getLastAddress() {
    return this.addresses.get(addresses.size() - 1);
  }
  
  public MachineAddress getMatchingAddress(Predicate<MachineAddress> predicate) {
      for (MachineAddress item : addresses) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingAddress(Predicate<MachineAddress> predicate) {
      for (MachineAddress item : addresses) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withAddresses(List<MachineAddress> addresses) {
    if (addresses != null) {
        this.addresses = new ArrayList();
        for (MachineAddress item : addresses) {
          this.addToAddresses(item);
        }
    } else {
      this.addresses = null;
    }
    return (A) this;
  }
  
  public A withAddresses(io.fabric8.kubernetes.api.model.clusterapi.v1beta1.MachineAddress... addresses) {
    if (this.addresses != null) {
        this.addresses.clear();
        _visitables.remove("addresses");
    }
    if (addresses != null) {
      for (MachineAddress item : addresses) {
        this.addToAddresses(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasAddresses() {
    return this.addresses != null && !this.addresses.isEmpty();
  }
  
  public A addNewAddress(String address,String type) {
    return (A)addToAddresses(new MachineAddress(address, type));
  }
  
  public A addToConditions(int index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    this.conditions.add(index, item);
    return (A)this;
  }
  
  public A setToConditions(int index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    this.conditions.set(index, item); return (A)this;
  }
  
  public A addToConditions(io.fabric8.kubernetes.api.model.clusterapi.v1beta1.Condition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    for (Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  
  public A addAllToConditions(Collection<Condition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    for (Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  
  public A removeFromConditions(io.fabric8.kubernetes.api.model.clusterapi.v1beta1.Condition... items) {
    if (this.conditions == null) return (A)this;
    for (Condition item : items) { this.conditions.remove(item);} return (A)this;
  }
  
  public A removeAllFromConditions(Collection<Condition> items) {
    if (this.conditions == null) return (A)this;
    for (Condition item : items) { this.conditions.remove(item);} return (A)this;
  }
  
  public List<Condition> getConditions() {
    return this.conditions;
  }
  
  public Condition getCondition(int index) {
    return this.conditions.get(index);
  }
  
  public Condition getFirstCondition() {
    return this.conditions.get(0);
  }
  
  public Condition getLastCondition() {
    return this.conditions.get(conditions.size() - 1);
  }
  
  public Condition getMatchingCondition(Predicate<Condition> predicate) {
      for (Condition item : conditions) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingCondition(Predicate<Condition> predicate) {
      for (Condition item : conditions) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withConditions(List<Condition> conditions) {
    if (conditions != null) {
        this.conditions = new ArrayList();
        for (Condition item : conditions) {
          this.addToConditions(item);
        }
    } else {
      this.conditions = null;
    }
    return (A) this;
  }
  
  public A withConditions(io.fabric8.kubernetes.api.model.clusterapi.v1beta1.Condition... conditions) {
    if (this.conditions != null) {
        this.conditions.clear();
        _visitables.remove("conditions");
    }
    if (conditions != null) {
      for (Condition item : conditions) {
        this.addToConditions(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasConditions() {
    return this.conditions != null && !this.conditions.isEmpty();
  }
  
  public String getFailureMessage() {
    return this.failureMessage;
  }
  
  public A withFailureMessage(String failureMessage) {
    this.failureMessage = failureMessage;
    return (A) this;
  }
  
  public boolean hasFailureMessage() {
    return this.failureMessage != null;
  }
  
  public String getFailureReason() {
    return this.failureReason;
  }
  
  public A withFailureReason(String failureReason) {
    this.failureReason = failureReason;
    return (A) this;
  }
  
  public boolean hasFailureReason() {
    return this.failureReason != null;
  }
  
  public String getLastUpdated() {
    return this.lastUpdated;
  }
  
  public A withLastUpdated(String lastUpdated) {
    this.lastUpdated = lastUpdated;
    return (A) this;
  }
  
  public boolean hasLastUpdated() {
    return this.lastUpdated != null;
  }
  
  public SecretReference getMetaData() {
    return this.metaData;
  }
  
  public A withMetaData(SecretReference metaData) {
    this.metaData = metaData;
    return (A) this;
  }
  
  public boolean hasMetaData() {
    return this.metaData != null;
  }
  
  public A withNewMetaData(String name,String namespace) {
    return (A)withMetaData(new SecretReference(name, namespace));
  }
  
  public SecretReference getNetworkData() {
    return this.networkData;
  }
  
  public A withNetworkData(SecretReference networkData) {
    this.networkData = networkData;
    return (A) this;
  }
  
  public boolean hasNetworkData() {
    return this.networkData != null;
  }
  
  public A withNewNetworkData(String name,String namespace) {
    return (A)withNetworkData(new SecretReference(name, namespace));
  }
  
  public String getPhase() {
    return this.phase;
  }
  
  public A withPhase(String phase) {
    this.phase = phase;
    return (A) this;
  }
  
  public boolean hasPhase() {
    return this.phase != null;
  }
  
  public Boolean getReady() {
    return this.ready;
  }
  
  public A withReady(Boolean ready) {
    this.ready = ready;
    return (A) this;
  }
  
  public boolean hasReady() {
    return this.ready != null;
  }
  
  public ObjectReference buildRenderedData() {
    return this.renderedData != null ? this.renderedData.build() : null;
  }
  
  public A withRenderedData(ObjectReference renderedData) {
    this._visitables.remove("renderedData");
    if (renderedData != null) {
        this.renderedData = new ObjectReferenceBuilder(renderedData);
        this._visitables.get("renderedData").add(this.renderedData);
    } else {
        this.renderedData = null;
        this._visitables.get("renderedData").remove(this.renderedData);
    }
    return (A) this;
  }
  
  public boolean hasRenderedData() {
    return this.renderedData != null;
  }
  
  public RenderedDataNested<A> withNewRenderedData() {
    return new RenderedDataNested(null);
  }
  
  public RenderedDataNested<A> withNewRenderedDataLike(ObjectReference item) {
    return new RenderedDataNested(item);
  }
  
  public RenderedDataNested<A> editRenderedData() {
    return withNewRenderedDataLike(java.util.Optional.ofNullable(buildRenderedData()).orElse(null));
  }
  
  public RenderedDataNested<A> editOrNewRenderedData() {
    return withNewRenderedDataLike(java.util.Optional.ofNullable(buildRenderedData()).orElse(new ObjectReferenceBuilder().build()));
  }
  
  public RenderedDataNested<A> editOrNewRenderedDataLike(ObjectReference item) {
    return withNewRenderedDataLike(java.util.Optional.ofNullable(buildRenderedData()).orElse(item));
  }
  
  public SecretReference getUserData() {
    return this.userData;
  }
  
  public A withUserData(SecretReference userData) {
    this.userData = userData;
    return (A) this;
  }
  
  public boolean hasUserData() {
    return this.userData != null;
  }
  
  public A withNewUserData(String name,String namespace) {
    return (A)withUserData(new SecretReference(name, namespace));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    Metal3MachineStatusFluent that = (Metal3MachineStatusFluent) o;
    if (!java.util.Objects.equals(addresses, that.addresses)) return false;
    if (!java.util.Objects.equals(conditions, that.conditions)) return false;
    if (!java.util.Objects.equals(failureMessage, that.failureMessage)) return false;
    if (!java.util.Objects.equals(failureReason, that.failureReason)) return false;
    if (!java.util.Objects.equals(lastUpdated, that.lastUpdated)) return false;
    if (!java.util.Objects.equals(metaData, that.metaData)) return false;
    if (!java.util.Objects.equals(networkData, that.networkData)) return false;
    if (!java.util.Objects.equals(phase, that.phase)) return false;
    if (!java.util.Objects.equals(ready, that.ready)) return false;
    if (!java.util.Objects.equals(renderedData, that.renderedData)) return false;
    if (!java.util.Objects.equals(userData, that.userData)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(addresses,  conditions,  failureMessage,  failureReason,  lastUpdated,  metaData,  networkData,  phase,  ready,  renderedData,  userData,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (addresses != null && !addresses.isEmpty()) { sb.append("addresses:"); sb.append(addresses + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (failureMessage != null) { sb.append("failureMessage:"); sb.append(failureMessage + ","); }
    if (failureReason != null) { sb.append("failureReason:"); sb.append(failureReason + ","); }
    if (lastUpdated != null) { sb.append("lastUpdated:"); sb.append(lastUpdated + ","); }
    if (metaData != null) { sb.append("metaData:"); sb.append(metaData + ","); }
    if (networkData != null) { sb.append("networkData:"); sb.append(networkData + ","); }
    if (phase != null) { sb.append("phase:"); sb.append(phase + ","); }
    if (ready != null) { sb.append("ready:"); sb.append(ready + ","); }
    if (renderedData != null) { sb.append("renderedData:"); sb.append(renderedData + ","); }
    if (userData != null) { sb.append("userData:"); sb.append(userData + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withReady() {
    return withReady(true);
  }
  public class RenderedDataNested<N> extends ObjectReferenceFluent<RenderedDataNested<N>> implements Nested<N>{
    RenderedDataNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    
    public N and() {
      return (N) Metal3MachineStatusFluent.this.withRenderedData(builder.build());
    }
    
    public N endRenderedData() {
      return and();
    }
    
  
  }

}