package io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class NetworkDataLinkVlanFluent<A extends NetworkDataLinkVlanFluent<A>> extends BaseFluent<A>{
  public NetworkDataLinkVlanFluent() {
  }
  
  public NetworkDataLinkVlanFluent(NetworkDataLinkVlan instance) {
    this.copyInstance(instance);
  }
  private String id;
  private NetworkLinkEthernetMacBuilder macAddress;
  private Integer mtu;
  private Integer vlanID;
  private String vlanLink;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(NetworkDataLinkVlan instance) {
    instance = (instance != null ? instance : new NetworkDataLinkVlan());
    if (instance != null) {
          this.withId(instance.getId());
          this.withMacAddress(instance.getMacAddress());
          this.withMtu(instance.getMtu());
          this.withVlanID(instance.getVlanID());
          this.withVlanLink(instance.getVlanLink());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getId() {
    return this.id;
  }
  
  public A withId(String id) {
    this.id = id;
    return (A) this;
  }
  
  public boolean hasId() {
    return this.id != null;
  }
  
  public NetworkLinkEthernetMac buildMacAddress() {
    return this.macAddress != null ? this.macAddress.build() : null;
  }
  
  public A withMacAddress(NetworkLinkEthernetMac macAddress) {
    this._visitables.remove("macAddress");
    if (macAddress != null) {
        this.macAddress = new NetworkLinkEthernetMacBuilder(macAddress);
        this._visitables.get("macAddress").add(this.macAddress);
    } else {
        this.macAddress = null;
        this._visitables.get("macAddress").remove(this.macAddress);
    }
    return (A) this;
  }
  
  public boolean hasMacAddress() {
    return this.macAddress != null;
  }
  
  public MacAddressNested<A> withNewMacAddress() {
    return new MacAddressNested(null);
  }
  
  public MacAddressNested<A> withNewMacAddressLike(NetworkLinkEthernetMac item) {
    return new MacAddressNested(item);
  }
  
  public MacAddressNested<A> editMacAddress() {
    return withNewMacAddressLike(java.util.Optional.ofNullable(buildMacAddress()).orElse(null));
  }
  
  public MacAddressNested<A> editOrNewMacAddress() {
    return withNewMacAddressLike(java.util.Optional.ofNullable(buildMacAddress()).orElse(new NetworkLinkEthernetMacBuilder().build()));
  }
  
  public MacAddressNested<A> editOrNewMacAddressLike(NetworkLinkEthernetMac item) {
    return withNewMacAddressLike(java.util.Optional.ofNullable(buildMacAddress()).orElse(item));
  }
  
  public Integer getMtu() {
    return this.mtu;
  }
  
  public A withMtu(Integer mtu) {
    this.mtu = mtu;
    return (A) this;
  }
  
  public boolean hasMtu() {
    return this.mtu != null;
  }
  
  public Integer getVlanID() {
    return this.vlanID;
  }
  
  public A withVlanID(Integer vlanID) {
    this.vlanID = vlanID;
    return (A) this;
  }
  
  public boolean hasVlanID() {
    return this.vlanID != null;
  }
  
  public String getVlanLink() {
    return this.vlanLink;
  }
  
  public A withVlanLink(String vlanLink) {
    this.vlanLink = vlanLink;
    return (A) this;
  }
  
  public boolean hasVlanLink() {
    return this.vlanLink != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NetworkDataLinkVlanFluent that = (NetworkDataLinkVlanFluent) o;
    if (!java.util.Objects.equals(id, that.id)) return false;
    if (!java.util.Objects.equals(macAddress, that.macAddress)) return false;
    if (!java.util.Objects.equals(mtu, that.mtu)) return false;
    if (!java.util.Objects.equals(vlanID, that.vlanID)) return false;
    if (!java.util.Objects.equals(vlanLink, that.vlanLink)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(id,  macAddress,  mtu,  vlanID,  vlanLink,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (id != null) { sb.append("id:"); sb.append(id + ","); }
    if (macAddress != null) { sb.append("macAddress:"); sb.append(macAddress + ","); }
    if (mtu != null) { sb.append("mtu:"); sb.append(mtu + ","); }
    if (vlanID != null) { sb.append("vlanID:"); sb.append(vlanID + ","); }
    if (vlanLink != null) { sb.append("vlanLink:"); sb.append(vlanLink + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class MacAddressNested<N> extends NetworkLinkEthernetMacFluent<MacAddressNested<N>> implements Nested<N>{
    MacAddressNested(NetworkLinkEthernetMac item) {
      this.builder = new NetworkLinkEthernetMacBuilder(this, item);
    }
    NetworkLinkEthernetMacBuilder builder;
    
    public N and() {
      return (N) NetworkDataLinkVlanFluent.this.withMacAddress(builder.build());
    }
    
    public N endMacAddress() {
      return and();
    }
    
  
  }

}