package io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class AzureProviderStatusFluent<A extends AzureProviderStatusFluent<A>> extends BaseFluent<A>{
  public AzureProviderStatusFluent() {
  }
  
  public AzureProviderStatusFluent(AzureProviderStatus instance) {
    this.copyInstance(instance);
  }
  private String apiVersion;
  private String appID;
  private String kind;
  private String name;
  private String secretLastResourceVersion;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(AzureProviderStatus instance) {
    instance = (instance != null ? instance : new AzureProviderStatus());
    if (instance != null) {
          this.withApiVersion(instance.getApiVersion());
          this.withAppID(instance.getAppID());
          this.withKind(instance.getKind());
          this.withName(instance.getName());
          this.withSecretLastResourceVersion(instance.getSecretLastResourceVersion());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getApiVersion() {
    return this.apiVersion;
  }
  
  public A withApiVersion(String apiVersion) {
    this.apiVersion = apiVersion;
    return (A) this;
  }
  
  public boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  public String getAppID() {
    return this.appID;
  }
  
  public A withAppID(String appID) {
    this.appID = appID;
    return (A) this;
  }
  
  public boolean hasAppID() {
    return this.appID != null;
  }
  
  public String getKind() {
    return this.kind;
  }
  
  public A withKind(String kind) {
    this.kind = kind;
    return (A) this;
  }
  
  public boolean hasKind() {
    return this.kind != null;
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public String getSecretLastResourceVersion() {
    return this.secretLastResourceVersion;
  }
  
  public A withSecretLastResourceVersion(String secretLastResourceVersion) {
    this.secretLastResourceVersion = secretLastResourceVersion;
    return (A) this;
  }
  
  public boolean hasSecretLastResourceVersion() {
    return this.secretLastResourceVersion != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AzureProviderStatusFluent that = (AzureProviderStatusFluent) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;
    if (!java.util.Objects.equals(appID, that.appID)) return false;
    if (!java.util.Objects.equals(kind, that.kind)) return false;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(secretLastResourceVersion, that.secretLastResourceVersion)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  appID,  kind,  name,  secretLastResourceVersion,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (appID != null) { sb.append("appID:"); sb.append(appID + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (secretLastResourceVersion != null) { sb.append("secretLastResourceVersion:"); sb.append(secretLastResourceVersion + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}