package io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;
import java.util.function.Predicate;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class NetworkDataServicev6Fluent<A extends NetworkDataServicev6Fluent<A>> extends BaseFluent<A>{
  public NetworkDataServicev6Fluent() {
  }
  
  public NetworkDataServicev6Fluent(NetworkDataServicev6 instance) {
    this.copyInstance(instance);
  }
  private List<String> dns = new ArrayList<String>();
  private String dnsFromIPPool;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(NetworkDataServicev6 instance) {
    instance = (instance != null ? instance : new NetworkDataServicev6());
    if (instance != null) {
          this.withDns(instance.getDns());
          this.withDnsFromIPPool(instance.getDnsFromIPPool());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToDns(int index,String item) {
    if (this.dns == null) {this.dns = new ArrayList<String>();}
    this.dns.add(index, item);
    return (A)this;
  }
  
  public A setToDns(int index,String item) {
    if (this.dns == null) {this.dns = new ArrayList<String>();}
    this.dns.set(index, item); return (A)this;
  }
  
  public A addToDns(java.lang.String... items) {
    if (this.dns == null) {this.dns = new ArrayList<String>();}
    for (String item : items) {this.dns.add(item);} return (A)this;
  }
  
  public A addAllToDns(Collection<String> items) {
    if (this.dns == null) {this.dns = new ArrayList<String>();}
    for (String item : items) {this.dns.add(item);} return (A)this;
  }
  
  public A removeFromDns(java.lang.String... items) {
    if (this.dns == null) return (A)this;
    for (String item : items) { this.dns.remove(item);} return (A)this;
  }
  
  public A removeAllFromDns(Collection<String> items) {
    if (this.dns == null) return (A)this;
    for (String item : items) { this.dns.remove(item);} return (A)this;
  }
  
  public List<String> getDns() {
    return this.dns;
  }
  
  public String getDn(int index) {
    return this.dns.get(index);
  }
  
  public String getFirstDn() {
    return this.dns.get(0);
  }
  
  public String getLastDn() {
    return this.dns.get(dns.size() - 1);
  }
  
  public String getMatchingDn(Predicate<String> predicate) {
      for (String item : dns) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingDn(Predicate<String> predicate) {
      for (String item : dns) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withDns(List<String> dns) {
    if (dns != null) {
        this.dns = new ArrayList();
        for (String item : dns) {
          this.addToDns(item);
        }
    } else {
      this.dns = null;
    }
    return (A) this;
  }
  
  public A withDns(java.lang.String... dns) {
    if (this.dns != null) {
        this.dns.clear();
        _visitables.remove("dns");
    }
    if (dns != null) {
      for (String item : dns) {
        this.addToDns(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasDns() {
    return this.dns != null && !this.dns.isEmpty();
  }
  
  public String getDnsFromIPPool() {
    return this.dnsFromIPPool;
  }
  
  public A withDnsFromIPPool(String dnsFromIPPool) {
    this.dnsFromIPPool = dnsFromIPPool;
    return (A) this;
  }
  
  public boolean hasDnsFromIPPool() {
    return this.dnsFromIPPool != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NetworkDataServicev6Fluent that = (NetworkDataServicev6Fluent) o;
    if (!java.util.Objects.equals(dns, that.dns)) return false;
    if (!java.util.Objects.equals(dnsFromIPPool, that.dnsFromIPPool)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(dns,  dnsFromIPPool,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (dns != null && !dns.isEmpty()) { sb.append("dns:"); sb.append(dns + ","); }
    if (dnsFromIPPool != null) { sb.append("dnsFromIPPool:"); sb.append(dnsFromIPPool + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}