/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.SecretReference;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.Metal3DataSpec;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class Metal3DataSpecFluent<A extends Metal3DataSpecFluent<A>>
extends BaseFluent<A> {
    private ObjectReferenceBuilder claim;
    private Integer index;
    private SecretReference metaData;
    private SecretReference networkData;
    private ObjectReferenceBuilder template;
    private String templateReference;
    private Map<String, Object> additionalProperties;

    public Metal3DataSpecFluent() {
    }

    public Metal3DataSpecFluent(Metal3DataSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Metal3DataSpec instance) {
        Metal3DataSpec metal3DataSpec = instance = instance != null ? instance : new Metal3DataSpec();
        if (instance != null) {
            this.withClaim(instance.getClaim());
            this.withIndex(instance.getIndex());
            this.withMetaData(instance.getMetaData());
            this.withNetworkData(instance.getNetworkData());
            this.withTemplate(instance.getTemplate());
            this.withTemplateReference(instance.getTemplateReference());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ObjectReference buildClaim() {
        return this.claim != null ? this.claim.build() : null;
    }

    public A withClaim(ObjectReference claim) {
        this._visitables.remove((Object)"claim");
        if (claim != null) {
            this.claim = new ObjectReferenceBuilder(claim);
            this._visitables.get((Object)"claim").add(this.claim);
        } else {
            this.claim = null;
            this._visitables.get((Object)"claim").remove(this.claim);
        }
        return (A)((Object)this);
    }

    public boolean hasClaim() {
        return this.claim != null;
    }

    public ClaimNested<A> withNewClaim() {
        return new ClaimNested(null);
    }

    public ClaimNested<A> withNewClaimLike(ObjectReference item) {
        return new ClaimNested(item);
    }

    public ClaimNested<A> editClaim() {
        return this.withNewClaimLike(Optional.ofNullable(this.buildClaim()).orElse(null));
    }

    public ClaimNested<A> editOrNewClaim() {
        return this.withNewClaimLike(Optional.ofNullable(this.buildClaim()).orElse(new ObjectReferenceBuilder().build()));
    }

    public ClaimNested<A> editOrNewClaimLike(ObjectReference item) {
        return this.withNewClaimLike(Optional.ofNullable(this.buildClaim()).orElse(item));
    }

    public Integer getIndex() {
        return this.index;
    }

    public A withIndex(Integer index) {
        this.index = index;
        return (A)((Object)this);
    }

    public boolean hasIndex() {
        return this.index != null;
    }

    public SecretReference getMetaData() {
        return this.metaData;
    }

    public A withMetaData(SecretReference metaData) {
        this.metaData = metaData;
        return (A)((Object)this);
    }

    public boolean hasMetaData() {
        return this.metaData != null;
    }

    public A withNewMetaData(String name, String namespace) {
        return this.withMetaData(new SecretReference(name, namespace));
    }

    public SecretReference getNetworkData() {
        return this.networkData;
    }

    public A withNetworkData(SecretReference networkData) {
        this.networkData = networkData;
        return (A)((Object)this);
    }

    public boolean hasNetworkData() {
        return this.networkData != null;
    }

    public A withNewNetworkData(String name, String namespace) {
        return this.withNetworkData(new SecretReference(name, namespace));
    }

    public ObjectReference buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    public A withTemplate(ObjectReference template) {
        this._visitables.remove((Object)"template");
        if (template != null) {
            this.template = new ObjectReferenceBuilder(template);
            this._visitables.get((Object)"template").add(this.template);
        } else {
            this.template = null;
            this._visitables.get((Object)"template").remove(this.template);
        }
        return (A)((Object)this);
    }

    public boolean hasTemplate() {
        return this.template != null;
    }

    public TemplateNested<A> withNewTemplate() {
        return new TemplateNested(null);
    }

    public TemplateNested<A> withNewTemplateLike(ObjectReference item) {
        return new TemplateNested(item);
    }

    public TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(null));
    }

    public TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(new ObjectReferenceBuilder().build()));
    }

    public TemplateNested<A> editOrNewTemplateLike(ObjectReference item) {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(item));
    }

    public String getTemplateReference() {
        return this.templateReference;
    }

    public A withTemplateReference(String templateReference) {
        this.templateReference = templateReference;
        return (A)((Object)this);
    }

    public boolean hasTemplateReference() {
        return this.templateReference != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Metal3DataSpecFluent that = (Metal3DataSpecFluent)((Object)o);
        if (!Objects.equals(this.claim, that.claim)) {
            return false;
        }
        if (!Objects.equals(this.index, that.index)) {
            return false;
        }
        if (!Objects.equals(this.metaData, that.metaData)) {
            return false;
        }
        if (!Objects.equals(this.networkData, that.networkData)) {
            return false;
        }
        if (!Objects.equals(this.template, that.template)) {
            return false;
        }
        if (!Objects.equals(this.templateReference, that.templateReference)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.claim, this.index, this.metaData, this.networkData, this.template, this.templateReference, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.claim != null) {
            sb.append("claim:");
            sb.append(String.valueOf(this.claim) + ",");
        }
        if (this.index != null) {
            sb.append("index:");
            sb.append(this.index + ",");
        }
        if (this.metaData != null) {
            sb.append("metaData:");
            sb.append(String.valueOf(this.metaData) + ",");
        }
        if (this.networkData != null) {
            sb.append("networkData:");
            sb.append(String.valueOf(this.networkData) + ",");
        }
        if (this.template != null) {
            sb.append("template:");
            sb.append(String.valueOf(this.template) + ",");
        }
        if (this.templateReference != null) {
            sb.append("templateReference:");
            sb.append(this.templateReference + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TemplateNested<N>
    extends ObjectReferenceFluent<TemplateNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        TemplateNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder((ObjectReferenceFluent)this, item);
        }

        public N and() {
            return (N)Metal3DataSpecFluent.this.withTemplate(this.builder.build());
        }

        public N endTemplate() {
            return this.and();
        }
    }

    public class ClaimNested<N>
    extends ObjectReferenceFluent<ClaimNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        ClaimNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder((ObjectReferenceFluent)this, item);
        }

        public N and() {
            return (N)Metal3DataSpecFluent.this.withClaim(this.builder.build());
        }

        public N endClaim() {
            return this.and();
        }
    }
}

