package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class QueueConfigBuilder extends io.fabric8.openshift.api.model.monitoring.v1.QueueConfigFluentImpl<io.fabric8.openshift.api.model.monitoring.v1.QueueConfigBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.monitoring.v1.QueueConfig,io.fabric8.openshift.api.model.monitoring.v1.QueueConfigBuilder>{
  public QueueConfigBuilder() {
    this(false);
  }
  public QueueConfigBuilder(java.lang.Boolean validationEnabled) {
    this(new QueueConfig(), validationEnabled);
  }
  public QueueConfigBuilder(io.fabric8.openshift.api.model.monitoring.v1.QueueConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public QueueConfigBuilder(io.fabric8.openshift.api.model.monitoring.v1.QueueConfigFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new QueueConfig(), validationEnabled);
  }
  public QueueConfigBuilder(io.fabric8.openshift.api.model.monitoring.v1.QueueConfigFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.QueueConfig instance) {
    this(fluent, instance, false);
  }
  public QueueConfigBuilder(io.fabric8.openshift.api.model.monitoring.v1.QueueConfigFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.QueueConfig instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withBatchSendDeadline(instance.getBatchSendDeadline()); 
    fluent.withCapacity(instance.getCapacity()); 
    fluent.withMaxBackoff(instance.getMaxBackoff()); 
    fluent.withMaxRetries(instance.getMaxRetries()); 
    fluent.withMaxSamplesPerSend(instance.getMaxSamplesPerSend()); 
    fluent.withMaxShards(instance.getMaxShards()); 
    fluent.withMinBackoff(instance.getMinBackoff()); 
    fluent.withMinShards(instance.getMinShards()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public QueueConfigBuilder(io.fabric8.openshift.api.model.monitoring.v1.QueueConfig instance) {
    this(instance,false);
  }
  public QueueConfigBuilder(io.fabric8.openshift.api.model.monitoring.v1.QueueConfig instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withBatchSendDeadline(instance.getBatchSendDeadline()); 
    this.withCapacity(instance.getCapacity()); 
    this.withMaxBackoff(instance.getMaxBackoff()); 
    this.withMaxRetries(instance.getMaxRetries()); 
    this.withMaxSamplesPerSend(instance.getMaxSamplesPerSend()); 
    this.withMaxShards(instance.getMaxShards()); 
    this.withMinBackoff(instance.getMinBackoff()); 
    this.withMinShards(instance.getMinShards()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.monitoring.v1.QueueConfigFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.monitoring.v1.QueueConfig build() {
    QueueConfig buildable = new QueueConfig(fluent.getBatchSendDeadline(),fluent.getCapacity(),fluent.getMaxBackoff(),fluent.getMaxRetries(),fluent.getMaxSamplesPerSend(),fluent.getMaxShards(),fluent.getMinBackoff(),fluent.getMinShards());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    QueueConfigBuilder that = (QueueConfigBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}