/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.StorageSpec;
import io.fabric8.openshift.api.model.monitoring.v1.StorageSpecFluent;
import io.fabric8.openshift.api.model.monitoring.v1.StorageSpecFluentImpl;
import java.util.Objects;

public class StorageSpecBuilder
extends StorageSpecFluentImpl<StorageSpecBuilder>
implements VisitableBuilder<StorageSpec, StorageSpecBuilder> {
    StorageSpecFluent<?> fluent;
    Boolean validationEnabled;

    public StorageSpecBuilder() {
        this(false);
    }

    public StorageSpecBuilder(Boolean validationEnabled) {
        this(new StorageSpec(), validationEnabled);
    }

    public StorageSpecBuilder(StorageSpecFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public StorageSpecBuilder(StorageSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new StorageSpec(), validationEnabled);
    }

    public StorageSpecBuilder(StorageSpecFluent<?> fluent, StorageSpec instance) {
        this(fluent, instance, false);
    }

    public StorageSpecBuilder(StorageSpecFluent<?> fluent, StorageSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withDisableMountSubPath(instance.getDisableMountSubPath());
        fluent.withEmptyDir(instance.getEmptyDir());
        fluent.withEphemeral(instance.getEphemeral());
        fluent.withVolumeClaimTemplate(instance.getVolumeClaimTemplate());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public StorageSpecBuilder(StorageSpec instance) {
        this(instance, (Boolean)false);
    }

    public StorageSpecBuilder(StorageSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withDisableMountSubPath(instance.getDisableMountSubPath());
        this.withEmptyDir(instance.getEmptyDir());
        this.withEphemeral(instance.getEphemeral());
        this.withVolumeClaimTemplate(instance.getVolumeClaimTemplate());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public StorageSpec build() {
        StorageSpec buildable = new StorageSpec(this.fluent.getDisableMountSubPath(), this.fluent.getEmptyDir(), this.fluent.getEphemeral(), this.fluent.getVolumeClaimTemplate());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StorageSpecBuilder that = (StorageSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

