/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.monitoring.v1.ProbeTargetStaticConfig;
import io.fabric8.openshift.api.model.monitoring.v1.ProbeTargetStaticConfigFluent;
import io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig;
import io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ProbeTargetStaticConfigFluentImpl<A extends ProbeTargetStaticConfigFluent<A>>
extends BaseFluent<A>
implements ProbeTargetStaticConfigFluent<A> {
    private Map<String, String> labels;
    private List<RelabelConfigBuilder> relabelingConfigs = new ArrayList<RelabelConfigBuilder>();
    private List<String> _static = new ArrayList<String>();

    public ProbeTargetStaticConfigFluentImpl() {
    }

    public ProbeTargetStaticConfigFluentImpl(ProbeTargetStaticConfig instance) {
        this.withLabels(instance.getLabels());
        this.withRelabelingConfigs(instance.getRelabelingConfigs());
        this.withStatic(instance.getStatic());
    }

    @Override
    public A addToLabels(String key, String value) {
        if (this.labels == null && key != null && value != null) {
            this.labels = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.labels.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToLabels(Map<String, String> map) {
        if (this.labels == null && map != null) {
            this.labels = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.labels.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromLabels(String key) {
        if (this.labels == null) {
            return (A)this;
        }
        if (key != null && this.labels != null) {
            this.labels.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromLabels(Map<String, String> map) {
        if (this.labels == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.labels == null) continue;
                this.labels.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getLabels() {
        return this.labels;
    }

    @Override
    public <K, V> A withLabels(Map<String, String> labels) {
        this.labels = labels == null ? null : new LinkedHashMap<String, String>(labels);
        return (A)this;
    }

    @Override
    public Boolean hasLabels() {
        return this.labels != null;
    }

    @Override
    public A addToRelabelingConfigs(Integer index, RelabelConfig item) {
        if (this.relabelingConfigs == null) {
            this.relabelingConfigs = new ArrayList<RelabelConfigBuilder>();
        }
        RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
        this._visitables.get((Object)"relabelingConfigs").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"relabelingConfigs").size(), builder);
        this.relabelingConfigs.add(index >= 0 ? index.intValue() : this.relabelingConfigs.size(), builder);
        return (A)this;
    }

    @Override
    public A setToRelabelingConfigs(Integer index, RelabelConfig item) {
        if (this.relabelingConfigs == null) {
            this.relabelingConfigs = new ArrayList<RelabelConfigBuilder>();
        }
        RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"relabelingConfigs").size()) {
            this._visitables.get((Object)"relabelingConfigs").add(builder);
        } else {
            this._visitables.get((Object)"relabelingConfigs").set(index, builder);
        }
        if (index < 0 || index >= this.relabelingConfigs.size()) {
            this.relabelingConfigs.add(builder);
        } else {
            this.relabelingConfigs.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToRelabelingConfigs(RelabelConfig ... items) {
        if (this.relabelingConfigs == null) {
            this.relabelingConfigs = new ArrayList<RelabelConfigBuilder>();
        }
        for (RelabelConfig item : items) {
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            this._visitables.get((Object)"relabelingConfigs").add(builder);
            this.relabelingConfigs.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToRelabelingConfigs(Collection<RelabelConfig> items) {
        if (this.relabelingConfigs == null) {
            this.relabelingConfigs = new ArrayList<RelabelConfigBuilder>();
        }
        for (RelabelConfig item : items) {
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            this._visitables.get((Object)"relabelingConfigs").add(builder);
            this.relabelingConfigs.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromRelabelingConfigs(RelabelConfig ... items) {
        for (RelabelConfig item : items) {
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            this._visitables.get((Object)"relabelingConfigs").remove(builder);
            if (this.relabelingConfigs == null) continue;
            this.relabelingConfigs.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRelabelingConfigs(Collection<RelabelConfig> items) {
        for (RelabelConfig item : items) {
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            this._visitables.get((Object)"relabelingConfigs").remove(builder);
            if (this.relabelingConfigs == null) continue;
            this.relabelingConfigs.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromRelabelingConfigs(Predicate<RelabelConfigBuilder> predicate) {
        if (this.relabelingConfigs == null) {
            return (A)this;
        }
        Iterator<RelabelConfigBuilder> each = this.relabelingConfigs.iterator();
        List visitables = this._visitables.get((Object)"relabelingConfigs");
        while (each.hasNext()) {
            RelabelConfigBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<RelabelConfig> getRelabelingConfigs() {
        return ProbeTargetStaticConfigFluentImpl.build(this.relabelingConfigs);
    }

    @Override
    public List<RelabelConfig> buildRelabelingConfigs() {
        return ProbeTargetStaticConfigFluentImpl.build(this.relabelingConfigs);
    }

    @Override
    public RelabelConfig buildRelabelingConfig(Integer index) {
        return this.relabelingConfigs.get(index).build();
    }

    @Override
    public RelabelConfig buildFirstRelabelingConfig() {
        return this.relabelingConfigs.get(0).build();
    }

    @Override
    public RelabelConfig buildLastRelabelingConfig() {
        return this.relabelingConfigs.get(this.relabelingConfigs.size() - 1).build();
    }

    @Override
    public RelabelConfig buildMatchingRelabelingConfig(Predicate<RelabelConfigBuilder> predicate) {
        for (RelabelConfigBuilder item : this.relabelingConfigs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingRelabelingConfig(Predicate<RelabelConfigBuilder> predicate) {
        for (RelabelConfigBuilder item : this.relabelingConfigs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withRelabelingConfigs(List<RelabelConfig> relabelingConfigs) {
        if (this.relabelingConfigs != null) {
            this._visitables.get((Object)"relabelingConfigs").removeAll(this.relabelingConfigs);
        }
        if (relabelingConfigs != null) {
            this.relabelingConfigs = new ArrayList<RelabelConfigBuilder>();
            for (RelabelConfig item : relabelingConfigs) {
                this.addToRelabelingConfigs(item);
            }
        } else {
            this.relabelingConfigs = null;
        }
        return (A)this;
    }

    @Override
    public A withRelabelingConfigs(RelabelConfig ... relabelingConfigs) {
        if (this.relabelingConfigs != null) {
            this.relabelingConfigs.clear();
        }
        if (relabelingConfigs != null) {
            for (RelabelConfig item : relabelingConfigs) {
                this.addToRelabelingConfigs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRelabelingConfigs() {
        return this.relabelingConfigs != null && !this.relabelingConfigs.isEmpty();
    }

    @Override
    public ProbeTargetStaticConfigFluent.RelabelingConfigsNested<A> addNewRelabelingConfig() {
        return new RelabelingConfigsNestedImpl();
    }

    @Override
    public ProbeTargetStaticConfigFluent.RelabelingConfigsNested<A> addNewRelabelingConfigLike(RelabelConfig item) {
        return new RelabelingConfigsNestedImpl(-1, item);
    }

    @Override
    public ProbeTargetStaticConfigFluent.RelabelingConfigsNested<A> setNewRelabelingConfigLike(Integer index, RelabelConfig item) {
        return new RelabelingConfigsNestedImpl(index, item);
    }

    @Override
    public ProbeTargetStaticConfigFluent.RelabelingConfigsNested<A> editRelabelingConfig(Integer index) {
        if (this.relabelingConfigs.size() <= index) {
            throw new RuntimeException("Can't edit relabelingConfigs. Index exceeds size.");
        }
        return this.setNewRelabelingConfigLike(index, this.buildRelabelingConfig(index));
    }

    @Override
    public ProbeTargetStaticConfigFluent.RelabelingConfigsNested<A> editFirstRelabelingConfig() {
        if (this.relabelingConfigs.size() == 0) {
            throw new RuntimeException("Can't edit first relabelingConfigs. The list is empty.");
        }
        return this.setNewRelabelingConfigLike(0, this.buildRelabelingConfig(0));
    }

    @Override
    public ProbeTargetStaticConfigFluent.RelabelingConfigsNested<A> editLastRelabelingConfig() {
        int index = this.relabelingConfigs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last relabelingConfigs. The list is empty.");
        }
        return this.setNewRelabelingConfigLike(index, this.buildRelabelingConfig(index));
    }

    @Override
    public ProbeTargetStaticConfigFluent.RelabelingConfigsNested<A> editMatchingRelabelingConfig(Predicate<RelabelConfigBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.relabelingConfigs.size(); ++i) {
            if (!predicate.test(this.relabelingConfigs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching relabelingConfigs. No match found.");
        }
        return this.setNewRelabelingConfigLike(index, this.buildRelabelingConfig(index));
    }

    @Override
    public A addToStatic(Integer index, String item) {
        if (this._static == null) {
            this._static = new ArrayList<String>();
        }
        this._static.add(index, item);
        return (A)this;
    }

    @Override
    public A setToStatic(Integer index, String item) {
        if (this._static == null) {
            this._static = new ArrayList<String>();
        }
        this._static.set(index, item);
        return (A)this;
    }

    @Override
    public A addToStatic(String ... items) {
        if (this._static == null) {
            this._static = new ArrayList<String>();
        }
        for (String item : items) {
            this._static.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToStatic(Collection<String> items) {
        if (this._static == null) {
            this._static = new ArrayList<String>();
        }
        for (String item : items) {
            this._static.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromStatic(String ... items) {
        for (String item : items) {
            if (this._static == null) continue;
            this._static.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromStatic(Collection<String> items) {
        for (String item : items) {
            if (this._static == null) continue;
            this._static.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getStatic() {
        return this._static;
    }

    @Override
    public String getStatic(Integer index) {
        return this._static.get(index);
    }

    @Override
    public String getFirstStatic() {
        return this._static.get(0);
    }

    @Override
    public String getLastStatic() {
        return this._static.get(this._static.size() - 1);
    }

    @Override
    public String getMatchingStatic(Predicate<String> predicate) {
        for (String item : this._static) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingStatic(Predicate<String> predicate) {
        for (String item : this._static) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withStatic(List<String> _static) {
        if (_static != null) {
            this._static = new ArrayList<String>();
            for (String item : _static) {
                this.addToStatic(item);
            }
        } else {
            this._static = null;
        }
        return (A)this;
    }

    @Override
    public A withStatic(String ... _static) {
        if (this._static != null) {
            this._static.clear();
        }
        if (_static != null) {
            for (String item : _static) {
                this.addToStatic(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasStatic() {
        return this._static != null && !this._static.isEmpty();
    }

    @Override
    public A addNewStatic(String arg0) {
        return this.addToStatic(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProbeTargetStaticConfigFluentImpl that = (ProbeTargetStaticConfigFluentImpl)o;
        if (this.labels != null ? !this.labels.equals(that.labels) : that.labels != null) {
            return false;
        }
        if (this.relabelingConfigs != null ? !this.relabelingConfigs.equals(that.relabelingConfigs) : that.relabelingConfigs != null) {
            return false;
        }
        return !(this._static != null ? !this._static.equals(that._static) : that._static != null);
    }

    public int hashCode() {
        return Objects.hash(this.labels, this.relabelingConfigs, this._static, super.hashCode());
    }

    public class RelabelingConfigsNestedImpl<N>
    extends RelabelConfigFluentImpl<ProbeTargetStaticConfigFluent.RelabelingConfigsNested<N>>
    implements ProbeTargetStaticConfigFluent.RelabelingConfigsNested<N>,
    Nested<N> {
        RelabelConfigBuilder builder;
        Integer index;

        RelabelingConfigsNestedImpl(Integer index, RelabelConfig item) {
            this.index = index;
            this.builder = new RelabelConfigBuilder(this, item);
        }

        RelabelingConfigsNestedImpl() {
            this.index = -1;
            this.builder = new RelabelConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)ProbeTargetStaticConfigFluentImpl.this.setToRelabelingConfigs(this.index, this.builder.build());
        }

        @Override
        public N endRelabelingConfig() {
            return this.and();
        }
    }
}

