/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMap;
import io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMapBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMapFluentImpl;
import io.fabric8.openshift.api.model.monitoring.v1.WebTLSConfig;
import io.fabric8.openshift.api.model.monitoring.v1.WebTLSConfigFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class WebTLSConfigFluentImpl<A extends WebTLSConfigFluent<A>>
extends BaseFluent<A>
implements WebTLSConfigFluent<A> {
    private SecretOrConfigMapBuilder cert;
    private List<String> cipherSuites = new ArrayList<String>();
    private String clientAuthType;
    private SecretOrConfigMapBuilder clientCa;
    private List<String> curvePreferences = new ArrayList<String>();
    private SecretKeySelector keySecret;
    private String maxVersion;
    private String minVersion;
    private Boolean preferServerCipherSuites;
    private Map<String, Object> additionalProperties;

    public WebTLSConfigFluentImpl() {
    }

    public WebTLSConfigFluentImpl(WebTLSConfig instance) {
        this.withCert(instance.getCert());
        this.withCipherSuites(instance.getCipherSuites());
        this.withClientAuthType(instance.getClientAuthType());
        this.withClientCa(instance.getClientCa());
        this.withCurvePreferences(instance.getCurvePreferences());
        this.withKeySecret(instance.getKeySecret());
        this.withMaxVersion(instance.getMaxVersion());
        this.withMinVersion(instance.getMinVersion());
        this.withPreferServerCipherSuites(instance.getPreferServerCipherSuites());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    @Deprecated
    public SecretOrConfigMap getCert() {
        return this.cert != null ? this.cert.build() : null;
    }

    @Override
    public SecretOrConfigMap buildCert() {
        return this.cert != null ? this.cert.build() : null;
    }

    @Override
    public A withCert(SecretOrConfigMap cert) {
        this._visitables.get((Object)"cert").remove(this.cert);
        if (cert != null) {
            this.cert = new SecretOrConfigMapBuilder(cert);
            this._visitables.get((Object)"cert").add(this.cert);
        }
        return (A)this;
    }

    @Override
    public Boolean hasCert() {
        return this.cert != null;
    }

    @Override
    public WebTLSConfigFluent.CertNested<A> withNewCert() {
        return new CertNestedImpl();
    }

    @Override
    public WebTLSConfigFluent.CertNested<A> withNewCertLike(SecretOrConfigMap item) {
        return new CertNestedImpl(item);
    }

    @Override
    public WebTLSConfigFluent.CertNested<A> editCert() {
        return this.withNewCertLike(this.getCert());
    }

    @Override
    public WebTLSConfigFluent.CertNested<A> editOrNewCert() {
        return this.withNewCertLike(this.getCert() != null ? this.getCert() : new SecretOrConfigMapBuilder().build());
    }

    @Override
    public WebTLSConfigFluent.CertNested<A> editOrNewCertLike(SecretOrConfigMap item) {
        return this.withNewCertLike(this.getCert() != null ? this.getCert() : item);
    }

    @Override
    public A addToCipherSuites(Integer index, String item) {
        if (this.cipherSuites == null) {
            this.cipherSuites = new ArrayList<String>();
        }
        this.cipherSuites.add(index, item);
        return (A)this;
    }

    @Override
    public A setToCipherSuites(Integer index, String item) {
        if (this.cipherSuites == null) {
            this.cipherSuites = new ArrayList<String>();
        }
        this.cipherSuites.set(index, item);
        return (A)this;
    }

    @Override
    public A addToCipherSuites(String ... items) {
        if (this.cipherSuites == null) {
            this.cipherSuites = new ArrayList<String>();
        }
        for (String item : items) {
            this.cipherSuites.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToCipherSuites(Collection<String> items) {
        if (this.cipherSuites == null) {
            this.cipherSuites = new ArrayList<String>();
        }
        for (String item : items) {
            this.cipherSuites.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromCipherSuites(String ... items) {
        for (String item : items) {
            if (this.cipherSuites == null) continue;
            this.cipherSuites.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCipherSuites(Collection<String> items) {
        for (String item : items) {
            if (this.cipherSuites == null) continue;
            this.cipherSuites.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getCipherSuites() {
        return this.cipherSuites;
    }

    @Override
    public String getCipherSuite(Integer index) {
        return this.cipherSuites.get(index);
    }

    @Override
    public String getFirstCipherSuite() {
        return this.cipherSuites.get(0);
    }

    @Override
    public String getLastCipherSuite() {
        return this.cipherSuites.get(this.cipherSuites.size() - 1);
    }

    @Override
    public String getMatchingCipherSuite(Predicate<String> predicate) {
        for (String item : this.cipherSuites) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCipherSuite(Predicate<String> predicate) {
        for (String item : this.cipherSuites) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withCipherSuites(List<String> cipherSuites) {
        if (cipherSuites != null) {
            this.cipherSuites = new ArrayList<String>();
            for (String item : cipherSuites) {
                this.addToCipherSuites(item);
            }
        } else {
            this.cipherSuites = null;
        }
        return (A)this;
    }

    @Override
    public A withCipherSuites(String ... cipherSuites) {
        if (this.cipherSuites != null) {
            this.cipherSuites.clear();
        }
        if (cipherSuites != null) {
            for (String item : cipherSuites) {
                this.addToCipherSuites(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasCipherSuites() {
        return this.cipherSuites != null && !this.cipherSuites.isEmpty();
    }

    @Override
    public String getClientAuthType() {
        return this.clientAuthType;
    }

    @Override
    public A withClientAuthType(String clientAuthType) {
        this.clientAuthType = clientAuthType;
        return (A)this;
    }

    @Override
    public Boolean hasClientAuthType() {
        return this.clientAuthType != null;
    }

    @Override
    @Deprecated
    public SecretOrConfigMap getClientCa() {
        return this.clientCa != null ? this.clientCa.build() : null;
    }

    @Override
    public SecretOrConfigMap buildClientCa() {
        return this.clientCa != null ? this.clientCa.build() : null;
    }

    @Override
    public A withClientCa(SecretOrConfigMap clientCa) {
        this._visitables.get((Object)"clientCa").remove(this.clientCa);
        if (clientCa != null) {
            this.clientCa = new SecretOrConfigMapBuilder(clientCa);
            this._visitables.get((Object)"clientCa").add(this.clientCa);
        }
        return (A)this;
    }

    @Override
    public Boolean hasClientCa() {
        return this.clientCa != null;
    }

    @Override
    public WebTLSConfigFluent.ClientCaNested<A> withNewClientCa() {
        return new ClientCaNestedImpl();
    }

    @Override
    public WebTLSConfigFluent.ClientCaNested<A> withNewClientCaLike(SecretOrConfigMap item) {
        return new ClientCaNestedImpl(item);
    }

    @Override
    public WebTLSConfigFluent.ClientCaNested<A> editClientCa() {
        return this.withNewClientCaLike(this.getClientCa());
    }

    @Override
    public WebTLSConfigFluent.ClientCaNested<A> editOrNewClientCa() {
        return this.withNewClientCaLike(this.getClientCa() != null ? this.getClientCa() : new SecretOrConfigMapBuilder().build());
    }

    @Override
    public WebTLSConfigFluent.ClientCaNested<A> editOrNewClientCaLike(SecretOrConfigMap item) {
        return this.withNewClientCaLike(this.getClientCa() != null ? this.getClientCa() : item);
    }

    @Override
    public A addToCurvePreferences(Integer index, String item) {
        if (this.curvePreferences == null) {
            this.curvePreferences = new ArrayList<String>();
        }
        this.curvePreferences.add(index, item);
        return (A)this;
    }

    @Override
    public A setToCurvePreferences(Integer index, String item) {
        if (this.curvePreferences == null) {
            this.curvePreferences = new ArrayList<String>();
        }
        this.curvePreferences.set(index, item);
        return (A)this;
    }

    @Override
    public A addToCurvePreferences(String ... items) {
        if (this.curvePreferences == null) {
            this.curvePreferences = new ArrayList<String>();
        }
        for (String item : items) {
            this.curvePreferences.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToCurvePreferences(Collection<String> items) {
        if (this.curvePreferences == null) {
            this.curvePreferences = new ArrayList<String>();
        }
        for (String item : items) {
            this.curvePreferences.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromCurvePreferences(String ... items) {
        for (String item : items) {
            if (this.curvePreferences == null) continue;
            this.curvePreferences.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCurvePreferences(Collection<String> items) {
        for (String item : items) {
            if (this.curvePreferences == null) continue;
            this.curvePreferences.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getCurvePreferences() {
        return this.curvePreferences;
    }

    @Override
    public String getCurvePreference(Integer index) {
        return this.curvePreferences.get(index);
    }

    @Override
    public String getFirstCurvePreference() {
        return this.curvePreferences.get(0);
    }

    @Override
    public String getLastCurvePreference() {
        return this.curvePreferences.get(this.curvePreferences.size() - 1);
    }

    @Override
    public String getMatchingCurvePreference(Predicate<String> predicate) {
        for (String item : this.curvePreferences) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCurvePreference(Predicate<String> predicate) {
        for (String item : this.curvePreferences) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withCurvePreferences(List<String> curvePreferences) {
        if (curvePreferences != null) {
            this.curvePreferences = new ArrayList<String>();
            for (String item : curvePreferences) {
                this.addToCurvePreferences(item);
            }
        } else {
            this.curvePreferences = null;
        }
        return (A)this;
    }

    @Override
    public A withCurvePreferences(String ... curvePreferences) {
        if (this.curvePreferences != null) {
            this.curvePreferences.clear();
        }
        if (curvePreferences != null) {
            for (String item : curvePreferences) {
                this.addToCurvePreferences(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasCurvePreferences() {
        return this.curvePreferences != null && !this.curvePreferences.isEmpty();
    }

    @Override
    public SecretKeySelector getKeySecret() {
        return this.keySecret;
    }

    @Override
    public A withKeySecret(SecretKeySelector keySecret) {
        this.keySecret = keySecret;
        return (A)this;
    }

    @Override
    public Boolean hasKeySecret() {
        return this.keySecret != null;
    }

    @Override
    public A withNewKeySecret(String key, String name, Boolean optional) {
        return this.withKeySecret(new SecretKeySelector(key, name, optional));
    }

    @Override
    public String getMaxVersion() {
        return this.maxVersion;
    }

    @Override
    public A withMaxVersion(String maxVersion) {
        this.maxVersion = maxVersion;
        return (A)this;
    }

    @Override
    public Boolean hasMaxVersion() {
        return this.maxVersion != null;
    }

    @Override
    public String getMinVersion() {
        return this.minVersion;
    }

    @Override
    public A withMinVersion(String minVersion) {
        this.minVersion = minVersion;
        return (A)this;
    }

    @Override
    public Boolean hasMinVersion() {
        return this.minVersion != null;
    }

    @Override
    public Boolean getPreferServerCipherSuites() {
        return this.preferServerCipherSuites;
    }

    @Override
    public A withPreferServerCipherSuites(Boolean preferServerCipherSuites) {
        this.preferServerCipherSuites = preferServerCipherSuites;
        return (A)this;
    }

    @Override
    public Boolean hasPreferServerCipherSuites() {
        return this.preferServerCipherSuites != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebTLSConfigFluentImpl that = (WebTLSConfigFluentImpl)o;
        if (this.cert != null ? !this.cert.equals(that.cert) : that.cert != null) {
            return false;
        }
        if (this.cipherSuites != null ? !this.cipherSuites.equals(that.cipherSuites) : that.cipherSuites != null) {
            return false;
        }
        if (this.clientAuthType != null ? !this.clientAuthType.equals(that.clientAuthType) : that.clientAuthType != null) {
            return false;
        }
        if (this.clientCa != null ? !this.clientCa.equals(that.clientCa) : that.clientCa != null) {
            return false;
        }
        if (this.curvePreferences != null ? !this.curvePreferences.equals(that.curvePreferences) : that.curvePreferences != null) {
            return false;
        }
        if (this.keySecret != null ? !this.keySecret.equals((Object)that.keySecret) : that.keySecret != null) {
            return false;
        }
        if (this.maxVersion != null ? !this.maxVersion.equals(that.maxVersion) : that.maxVersion != null) {
            return false;
        }
        if (this.minVersion != null ? !this.minVersion.equals(that.minVersion) : that.minVersion != null) {
            return false;
        }
        if (this.preferServerCipherSuites != null ? !this.preferServerCipherSuites.equals(that.preferServerCipherSuites) : that.preferServerCipherSuites != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.cert, this.cipherSuites, this.clientAuthType, this.clientCa, this.curvePreferences, this.keySecret, this.maxVersion, this.minVersion, this.preferServerCipherSuites, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.cert != null) {
            sb.append("cert:");
            sb.append(this.cert + ",");
        }
        if (this.cipherSuites != null && !this.cipherSuites.isEmpty()) {
            sb.append("cipherSuites:");
            sb.append(this.cipherSuites + ",");
        }
        if (this.clientAuthType != null) {
            sb.append("clientAuthType:");
            sb.append(this.clientAuthType + ",");
        }
        if (this.clientCa != null) {
            sb.append("clientCa:");
            sb.append(this.clientCa + ",");
        }
        if (this.curvePreferences != null && !this.curvePreferences.isEmpty()) {
            sb.append("curvePreferences:");
            sb.append(this.curvePreferences + ",");
        }
        if (this.keySecret != null) {
            sb.append("keySecret:");
            sb.append(this.keySecret + ",");
        }
        if (this.maxVersion != null) {
            sb.append("maxVersion:");
            sb.append(this.maxVersion + ",");
        }
        if (this.minVersion != null) {
            sb.append("minVersion:");
            sb.append(this.minVersion + ",");
        }
        if (this.preferServerCipherSuites != null) {
            sb.append("preferServerCipherSuites:");
            sb.append(this.preferServerCipherSuites + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withPreferServerCipherSuites() {
        return this.withPreferServerCipherSuites(true);
    }

    class ClientCaNestedImpl<N>
    extends SecretOrConfigMapFluentImpl<WebTLSConfigFluent.ClientCaNested<N>>
    implements WebTLSConfigFluent.ClientCaNested<N>,
    Nested<N> {
        SecretOrConfigMapBuilder builder;

        ClientCaNestedImpl(SecretOrConfigMap item) {
            this.builder = new SecretOrConfigMapBuilder(this, item);
        }

        ClientCaNestedImpl() {
            this.builder = new SecretOrConfigMapBuilder(this);
        }

        @Override
        public N and() {
            return (N)WebTLSConfigFluentImpl.this.withClientCa(this.builder.build());
        }

        @Override
        public N endClientCa() {
            return this.and();
        }
    }

    class CertNestedImpl<N>
    extends SecretOrConfigMapFluentImpl<WebTLSConfigFluent.CertNested<N>>
    implements WebTLSConfigFluent.CertNested<N>,
    Nested<N> {
        SecretOrConfigMapBuilder builder;

        CertNestedImpl(SecretOrConfigMap item) {
            this.builder = new SecretOrConfigMapBuilder(this, item);
        }

        CertNestedImpl() {
            this.builder = new SecretOrConfigMapBuilder(this);
        }

        @Override
        public N and() {
            return (N)WebTLSConfigFluentImpl.this.withCert(this.builder.build());
        }

        @Override
        public N endCert() {
            return this.and();
        }
    }
}

