package io.fabric8.openshift.api.model.monitoring.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class RemoteReadSpecFluent<A extends RemoteReadSpecFluent<A>> extends BaseFluent<A>{
  public RemoteReadSpecFluent() {
  }
  
  public RemoteReadSpecFluent(RemoteReadSpec instance) {
    this.copyInstance(instance);
  }
  private AuthorizationBuilder authorization;
  private BasicAuthBuilder basicAuth;
  private String bearerToken;
  private String bearerTokenFile;
  private Boolean filterExternalLabels;
  private Boolean followRedirects;
  private Map<String,String> headers;
  private String name;
  private OAuth2Builder oauth2;
  private String proxyUrl;
  private Boolean readRecent;
  private String remoteTimeout;
  private Map<String,String> requiredMatchers;
  private TLSConfigBuilder tlsConfig;
  private String url;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(RemoteReadSpec instance) {
    instance = (instance != null ? instance : new RemoteReadSpec());
    if (instance != null) {
          this.withAuthorization(instance.getAuthorization());
          this.withBasicAuth(instance.getBasicAuth());
          this.withBearerToken(instance.getBearerToken());
          this.withBearerTokenFile(instance.getBearerTokenFile());
          this.withFilterExternalLabels(instance.getFilterExternalLabels());
          this.withFollowRedirects(instance.getFollowRedirects());
          this.withHeaders(instance.getHeaders());
          this.withName(instance.getName());
          this.withOauth2(instance.getOauth2());
          this.withProxyUrl(instance.getProxyUrl());
          this.withReadRecent(instance.getReadRecent());
          this.withRemoteTimeout(instance.getRemoteTimeout());
          this.withRequiredMatchers(instance.getRequiredMatchers());
          this.withTlsConfig(instance.getTlsConfig());
          this.withUrl(instance.getUrl());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Authorization buildAuthorization() {
    return this.authorization != null ? this.authorization.build() : null;
  }
  
  public A withAuthorization(Authorization authorization) {
    this._visitables.remove("authorization");
    if (authorization != null) {
        this.authorization = new AuthorizationBuilder(authorization);
        this._visitables.get("authorization").add(this.authorization);
    } else {
        this.authorization = null;
        this._visitables.get("authorization").remove(this.authorization);
    }
    return (A) this;
  }
  
  public boolean hasAuthorization() {
    return this.authorization != null;
  }
  
  public AuthorizationNested<A> withNewAuthorization() {
    return new AuthorizationNested(null);
  }
  
  public AuthorizationNested<A> withNewAuthorizationLike(Authorization item) {
    return new AuthorizationNested(item);
  }
  
  public AuthorizationNested<A> editAuthorization() {
    return withNewAuthorizationLike(java.util.Optional.ofNullable(buildAuthorization()).orElse(null));
  }
  
  public AuthorizationNested<A> editOrNewAuthorization() {
    return withNewAuthorizationLike(java.util.Optional.ofNullable(buildAuthorization()).orElse(new AuthorizationBuilder().build()));
  }
  
  public AuthorizationNested<A> editOrNewAuthorizationLike(Authorization item) {
    return withNewAuthorizationLike(java.util.Optional.ofNullable(buildAuthorization()).orElse(item));
  }
  
  public BasicAuth buildBasicAuth() {
    return this.basicAuth != null ? this.basicAuth.build() : null;
  }
  
  public A withBasicAuth(BasicAuth basicAuth) {
    this._visitables.remove("basicAuth");
    if (basicAuth != null) {
        this.basicAuth = new BasicAuthBuilder(basicAuth);
        this._visitables.get("basicAuth").add(this.basicAuth);
    } else {
        this.basicAuth = null;
        this._visitables.get("basicAuth").remove(this.basicAuth);
    }
    return (A) this;
  }
  
  public boolean hasBasicAuth() {
    return this.basicAuth != null;
  }
  
  public BasicAuthNested<A> withNewBasicAuth() {
    return new BasicAuthNested(null);
  }
  
  public BasicAuthNested<A> withNewBasicAuthLike(BasicAuth item) {
    return new BasicAuthNested(item);
  }
  
  public BasicAuthNested<A> editBasicAuth() {
    return withNewBasicAuthLike(java.util.Optional.ofNullable(buildBasicAuth()).orElse(null));
  }
  
  public BasicAuthNested<A> editOrNewBasicAuth() {
    return withNewBasicAuthLike(java.util.Optional.ofNullable(buildBasicAuth()).orElse(new BasicAuthBuilder().build()));
  }
  
  public BasicAuthNested<A> editOrNewBasicAuthLike(BasicAuth item) {
    return withNewBasicAuthLike(java.util.Optional.ofNullable(buildBasicAuth()).orElse(item));
  }
  
  public String getBearerToken() {
    return this.bearerToken;
  }
  
  public A withBearerToken(String bearerToken) {
    this.bearerToken = bearerToken;
    return (A) this;
  }
  
  public boolean hasBearerToken() {
    return this.bearerToken != null;
  }
  
  public String getBearerTokenFile() {
    return this.bearerTokenFile;
  }
  
  public A withBearerTokenFile(String bearerTokenFile) {
    this.bearerTokenFile = bearerTokenFile;
    return (A) this;
  }
  
  public boolean hasBearerTokenFile() {
    return this.bearerTokenFile != null;
  }
  
  public Boolean getFilterExternalLabels() {
    return this.filterExternalLabels;
  }
  
  public A withFilterExternalLabels(Boolean filterExternalLabels) {
    this.filterExternalLabels = filterExternalLabels;
    return (A) this;
  }
  
  public boolean hasFilterExternalLabels() {
    return this.filterExternalLabels != null;
  }
  
  public Boolean getFollowRedirects() {
    return this.followRedirects;
  }
  
  public A withFollowRedirects(Boolean followRedirects) {
    this.followRedirects = followRedirects;
    return (A) this;
  }
  
  public boolean hasFollowRedirects() {
    return this.followRedirects != null;
  }
  
  public A addToHeaders(String key,String value) {
    if(this.headers == null && key != null && value != null) { this.headers = new LinkedHashMap(); }
    if(key != null && value != null) {this.headers.put(key, value);} return (A)this;
  }
  
  public A addToHeaders(Map<String,String> map) {
    if(this.headers == null && map != null) { this.headers = new LinkedHashMap(); }
    if(map != null) { this.headers.putAll(map);} return (A)this;
  }
  
  public A removeFromHeaders(String key) {
    if(this.headers == null) { return (A) this; }
    if(key != null && this.headers != null) {this.headers.remove(key);} return (A)this;
  }
  
  public A removeFromHeaders(Map<String,String> map) {
    if(this.headers == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.headers != null){this.headers.remove(key);}}} return (A)this;
  }
  
  public Map<String,String> getHeaders() {
    return this.headers;
  }
  
  public <K,V>A withHeaders(Map<String,String> headers) {
    if (headers == null) {
      this.headers = null;
    } else {
      this.headers = new LinkedHashMap(headers);
    }
    return (A) this;
  }
  
  public boolean hasHeaders() {
    return this.headers != null;
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public OAuth2 buildOauth2() {
    return this.oauth2 != null ? this.oauth2.build() : null;
  }
  
  public A withOauth2(OAuth2 oauth2) {
    this._visitables.remove("oauth2");
    if (oauth2 != null) {
        this.oauth2 = new OAuth2Builder(oauth2);
        this._visitables.get("oauth2").add(this.oauth2);
    } else {
        this.oauth2 = null;
        this._visitables.get("oauth2").remove(this.oauth2);
    }
    return (A) this;
  }
  
  public boolean hasOauth2() {
    return this.oauth2 != null;
  }
  
  public Oauth2Nested<A> withNewOauth2() {
    return new Oauth2Nested(null);
  }
  
  public Oauth2Nested<A> withNewOauth2Like(OAuth2 item) {
    return new Oauth2Nested(item);
  }
  
  public Oauth2Nested<A> editOauth2() {
    return withNewOauth2Like(java.util.Optional.ofNullable(buildOauth2()).orElse(null));
  }
  
  public Oauth2Nested<A> editOrNewOauth2() {
    return withNewOauth2Like(java.util.Optional.ofNullable(buildOauth2()).orElse(new OAuth2Builder().build()));
  }
  
  public Oauth2Nested<A> editOrNewOauth2Like(OAuth2 item) {
    return withNewOauth2Like(java.util.Optional.ofNullable(buildOauth2()).orElse(item));
  }
  
  public String getProxyUrl() {
    return this.proxyUrl;
  }
  
  public A withProxyUrl(String proxyUrl) {
    this.proxyUrl = proxyUrl;
    return (A) this;
  }
  
  public boolean hasProxyUrl() {
    return this.proxyUrl != null;
  }
  
  public Boolean getReadRecent() {
    return this.readRecent;
  }
  
  public A withReadRecent(Boolean readRecent) {
    this.readRecent = readRecent;
    return (A) this;
  }
  
  public boolean hasReadRecent() {
    return this.readRecent != null;
  }
  
  public String getRemoteTimeout() {
    return this.remoteTimeout;
  }
  
  public A withRemoteTimeout(String remoteTimeout) {
    this.remoteTimeout = remoteTimeout;
    return (A) this;
  }
  
  public boolean hasRemoteTimeout() {
    return this.remoteTimeout != null;
  }
  
  public A addToRequiredMatchers(String key,String value) {
    if(this.requiredMatchers == null && key != null && value != null) { this.requiredMatchers = new LinkedHashMap(); }
    if(key != null && value != null) {this.requiredMatchers.put(key, value);} return (A)this;
  }
  
  public A addToRequiredMatchers(Map<String,String> map) {
    if(this.requiredMatchers == null && map != null) { this.requiredMatchers = new LinkedHashMap(); }
    if(map != null) { this.requiredMatchers.putAll(map);} return (A)this;
  }
  
  public A removeFromRequiredMatchers(String key) {
    if(this.requiredMatchers == null) { return (A) this; }
    if(key != null && this.requiredMatchers != null) {this.requiredMatchers.remove(key);} return (A)this;
  }
  
  public A removeFromRequiredMatchers(Map<String,String> map) {
    if(this.requiredMatchers == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.requiredMatchers != null){this.requiredMatchers.remove(key);}}} return (A)this;
  }
  
  public Map<String,String> getRequiredMatchers() {
    return this.requiredMatchers;
  }
  
  public <K,V>A withRequiredMatchers(Map<String,String> requiredMatchers) {
    if (requiredMatchers == null) {
      this.requiredMatchers = null;
    } else {
      this.requiredMatchers = new LinkedHashMap(requiredMatchers);
    }
    return (A) this;
  }
  
  public boolean hasRequiredMatchers() {
    return this.requiredMatchers != null;
  }
  
  public TLSConfig buildTlsConfig() {
    return this.tlsConfig != null ? this.tlsConfig.build() : null;
  }
  
  public A withTlsConfig(TLSConfig tlsConfig) {
    this._visitables.remove("tlsConfig");
    if (tlsConfig != null) {
        this.tlsConfig = new TLSConfigBuilder(tlsConfig);
        this._visitables.get("tlsConfig").add(this.tlsConfig);
    } else {
        this.tlsConfig = null;
        this._visitables.get("tlsConfig").remove(this.tlsConfig);
    }
    return (A) this;
  }
  
  public boolean hasTlsConfig() {
    return this.tlsConfig != null;
  }
  
  public TlsConfigNested<A> withNewTlsConfig() {
    return new TlsConfigNested(null);
  }
  
  public TlsConfigNested<A> withNewTlsConfigLike(TLSConfig item) {
    return new TlsConfigNested(item);
  }
  
  public TlsConfigNested<A> editTlsConfig() {
    return withNewTlsConfigLike(java.util.Optional.ofNullable(buildTlsConfig()).orElse(null));
  }
  
  public TlsConfigNested<A> editOrNewTlsConfig() {
    return withNewTlsConfigLike(java.util.Optional.ofNullable(buildTlsConfig()).orElse(new TLSConfigBuilder().build()));
  }
  
  public TlsConfigNested<A> editOrNewTlsConfigLike(TLSConfig item) {
    return withNewTlsConfigLike(java.util.Optional.ofNullable(buildTlsConfig()).orElse(item));
  }
  
  public String getUrl() {
    return this.url;
  }
  
  public A withUrl(String url) {
    this.url = url;
    return (A) this;
  }
  
  public boolean hasUrl() {
    return this.url != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    RemoteReadSpecFluent that = (RemoteReadSpecFluent) o;
    if (!java.util.Objects.equals(authorization, that.authorization)) return false;
    if (!java.util.Objects.equals(basicAuth, that.basicAuth)) return false;
    if (!java.util.Objects.equals(bearerToken, that.bearerToken)) return false;
    if (!java.util.Objects.equals(bearerTokenFile, that.bearerTokenFile)) return false;
    if (!java.util.Objects.equals(filterExternalLabels, that.filterExternalLabels)) return false;
    if (!java.util.Objects.equals(followRedirects, that.followRedirects)) return false;
    if (!java.util.Objects.equals(headers, that.headers)) return false;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(oauth2, that.oauth2)) return false;
    if (!java.util.Objects.equals(proxyUrl, that.proxyUrl)) return false;
    if (!java.util.Objects.equals(readRecent, that.readRecent)) return false;
    if (!java.util.Objects.equals(remoteTimeout, that.remoteTimeout)) return false;
    if (!java.util.Objects.equals(requiredMatchers, that.requiredMatchers)) return false;
    if (!java.util.Objects.equals(tlsConfig, that.tlsConfig)) return false;
    if (!java.util.Objects.equals(url, that.url)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(authorization,  basicAuth,  bearerToken,  bearerTokenFile,  filterExternalLabels,  followRedirects,  headers,  name,  oauth2,  proxyUrl,  readRecent,  remoteTimeout,  requiredMatchers,  tlsConfig,  url,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (authorization != null) { sb.append("authorization:"); sb.append(authorization + ","); }
    if (basicAuth != null) { sb.append("basicAuth:"); sb.append(basicAuth + ","); }
    if (bearerToken != null) { sb.append("bearerToken:"); sb.append(bearerToken + ","); }
    if (bearerTokenFile != null) { sb.append("bearerTokenFile:"); sb.append(bearerTokenFile + ","); }
    if (filterExternalLabels != null) { sb.append("filterExternalLabels:"); sb.append(filterExternalLabels + ","); }
    if (followRedirects != null) { sb.append("followRedirects:"); sb.append(followRedirects + ","); }
    if (headers != null && !headers.isEmpty()) { sb.append("headers:"); sb.append(headers + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (oauth2 != null) { sb.append("oauth2:"); sb.append(oauth2 + ","); }
    if (proxyUrl != null) { sb.append("proxyUrl:"); sb.append(proxyUrl + ","); }
    if (readRecent != null) { sb.append("readRecent:"); sb.append(readRecent + ","); }
    if (remoteTimeout != null) { sb.append("remoteTimeout:"); sb.append(remoteTimeout + ","); }
    if (requiredMatchers != null && !requiredMatchers.isEmpty()) { sb.append("requiredMatchers:"); sb.append(requiredMatchers + ","); }
    if (tlsConfig != null) { sb.append("tlsConfig:"); sb.append(tlsConfig + ","); }
    if (url != null) { sb.append("url:"); sb.append(url + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withFilterExternalLabels() {
    return withFilterExternalLabels(true);
  }
  
  public A withFollowRedirects() {
    return withFollowRedirects(true);
  }
  
  public A withReadRecent() {
    return withReadRecent(true);
  }
  public class AuthorizationNested<N> extends AuthorizationFluent<AuthorizationNested<N>> implements Nested<N>{
    AuthorizationNested(Authorization item) {
      this.builder = new AuthorizationBuilder(this, item);
    }
    AuthorizationBuilder builder;
    
    public N and() {
      return (N) RemoteReadSpecFluent.this.withAuthorization(builder.build());
    }
    
    public N endAuthorization() {
      return and();
    }
    
  
  }
  public class BasicAuthNested<N> extends BasicAuthFluent<BasicAuthNested<N>> implements Nested<N>{
    BasicAuthNested(BasicAuth item) {
      this.builder = new BasicAuthBuilder(this, item);
    }
    BasicAuthBuilder builder;
    
    public N and() {
      return (N) RemoteReadSpecFluent.this.withBasicAuth(builder.build());
    }
    
    public N endBasicAuth() {
      return and();
    }
    
  
  }
  public class Oauth2Nested<N> extends OAuth2Fluent<Oauth2Nested<N>> implements Nested<N>{
    Oauth2Nested(OAuth2 item) {
      this.builder = new OAuth2Builder(this, item);
    }
    OAuth2Builder builder;
    
    public N and() {
      return (N) RemoteReadSpecFluent.this.withOauth2(builder.build());
    }
    
    public N endOauth2() {
      return and();
    }
    
  
  }
  public class TlsConfigNested<N> extends TLSConfigFluent<TlsConfigNested<N>> implements Nested<N>{
    TlsConfigNested(TLSConfig item) {
      this.builder = new TLSConfigBuilder(this, item);
    }
    TLSConfigBuilder builder;
    
    public N and() {
      return (N) RemoteReadSpecFluent.this.withTlsConfig(builder.build());
    }
    
    public N endTlsConfig() {
      return and();
    }
    
  
  }

}