package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class OpsGenieConfigFluent<A extends OpsGenieConfigFluent<A>> extends BaseFluent<A>{
  public OpsGenieConfigFluent() {
  }
  
  public OpsGenieConfigFluent(OpsGenieConfig instance) {
    this.copyInstance(instance);
  }
  private String actions;
  private SecretKeySelector apiKey;
  private String apiURL;
  private String description;
  private ArrayList<KeyValueBuilder> details = new ArrayList<KeyValueBuilder>();
  private String entity;
  private HTTPConfigBuilder httpConfig;
  private String message;
  private String note;
  private String priority;
  private ArrayList<OpsGenieConfigResponderBuilder> responders = new ArrayList<OpsGenieConfigResponderBuilder>();
  private Boolean sendResolved;
  private String source;
  private String tags;
  private Boolean updateAlerts;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(OpsGenieConfig instance) {
    instance = (instance != null ? instance : new OpsGenieConfig());
    if (instance != null) {
          this.withActions(instance.getActions());
          this.withApiKey(instance.getApiKey());
          this.withApiURL(instance.getApiURL());
          this.withDescription(instance.getDescription());
          this.withDetails(instance.getDetails());
          this.withEntity(instance.getEntity());
          this.withHttpConfig(instance.getHttpConfig());
          this.withMessage(instance.getMessage());
          this.withNote(instance.getNote());
          this.withPriority(instance.getPriority());
          this.withResponders(instance.getResponders());
          this.withSendResolved(instance.getSendResolved());
          this.withSource(instance.getSource());
          this.withTags(instance.getTags());
          this.withUpdateAlerts(instance.getUpdateAlerts());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getActions() {
    return this.actions;
  }
  
  public A withActions(String actions) {
    this.actions = actions;
    return (A) this;
  }
  
  public boolean hasActions() {
    return this.actions != null;
  }
  
  public SecretKeySelector getApiKey() {
    return this.apiKey;
  }
  
  public A withApiKey(SecretKeySelector apiKey) {
    this.apiKey = apiKey;
    return (A) this;
  }
  
  public boolean hasApiKey() {
    return this.apiKey != null;
  }
  
  public A withNewApiKey(String key,String name,Boolean optional) {
    return (A)withApiKey(new SecretKeySelector(key, name, optional));
  }
  
  public String getApiURL() {
    return this.apiURL;
  }
  
  public A withApiURL(String apiURL) {
    this.apiURL = apiURL;
    return (A) this;
  }
  
  public boolean hasApiURL() {
    return this.apiURL != null;
  }
  
  public String getDescription() {
    return this.description;
  }
  
  public A withDescription(String description) {
    this.description = description;
    return (A) this;
  }
  
  public boolean hasDescription() {
    return this.description != null;
  }
  
  public A addToDetails(int index,KeyValue item) {
    if (this.details == null) {this.details = new ArrayList<KeyValueBuilder>();}
    KeyValueBuilder builder = new KeyValueBuilder(item);
    if (index < 0 || index >= details.size()) { _visitables.get("details").add(builder); details.add(builder); } else { _visitables.get("details").add(index, builder); details.add(index, builder);}
    return (A)this;
  }
  
  public A setToDetails(int index,KeyValue item) {
    if (this.details == null) {this.details = new ArrayList<KeyValueBuilder>();}
    KeyValueBuilder builder = new KeyValueBuilder(item);
    if (index < 0 || index >= details.size()) { _visitables.get("details").add(builder); details.add(builder); } else { _visitables.get("details").set(index, builder); details.set(index, builder);}
    return (A)this;
  }
  
  public A addToDetails(io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue... items) {
    if (this.details == null) {this.details = new ArrayList<KeyValueBuilder>();}
    for (KeyValue item : items) {KeyValueBuilder builder = new KeyValueBuilder(item);_visitables.get("details").add(builder);this.details.add(builder);} return (A)this;
  }
  
  public A addAllToDetails(Collection<KeyValue> items) {
    if (this.details == null) {this.details = new ArrayList<KeyValueBuilder>();}
    for (KeyValue item : items) {KeyValueBuilder builder = new KeyValueBuilder(item);_visitables.get("details").add(builder);this.details.add(builder);} return (A)this;
  }
  
  public A removeFromDetails(io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue... items) {
    if (this.details == null) return (A)this;
    for (KeyValue item : items) {KeyValueBuilder builder = new KeyValueBuilder(item);_visitables.get("details").remove(builder); this.details.remove(builder);} return (A)this;
  }
  
  public A removeAllFromDetails(Collection<KeyValue> items) {
    if (this.details == null) return (A)this;
    for (KeyValue item : items) {KeyValueBuilder builder = new KeyValueBuilder(item);_visitables.get("details").remove(builder); this.details.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromDetails(Predicate<KeyValueBuilder> predicate) {
    if (details == null) return (A) this;
    final Iterator<KeyValueBuilder> each = details.iterator();
    final List visitables = _visitables.get("details");
    while (each.hasNext()) {
      KeyValueBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<KeyValue> buildDetails() {
    return this.details != null ? build(details) : null;
  }
  
  public KeyValue buildDetail(int index) {
    return this.details.get(index).build();
  }
  
  public KeyValue buildFirstDetail() {
    return this.details.get(0).build();
  }
  
  public KeyValue buildLastDetail() {
    return this.details.get(details.size() - 1).build();
  }
  
  public KeyValue buildMatchingDetail(Predicate<KeyValueBuilder> predicate) {
      for (KeyValueBuilder item : details) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingDetail(Predicate<KeyValueBuilder> predicate) {
      for (KeyValueBuilder item : details) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withDetails(List<KeyValue> details) {
    if (this.details != null) {
      this._visitables.get("details").clear();
    }
    if (details != null) {
        this.details = new ArrayList();
        for (KeyValue item : details) {
          this.addToDetails(item);
        }
    } else {
      this.details = null;
    }
    return (A) this;
  }
  
  public A withDetails(io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue... details) {
    if (this.details != null) {
        this.details.clear();
        _visitables.remove("details");
    }
    if (details != null) {
      for (KeyValue item : details) {
        this.addToDetails(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasDetails() {
    return this.details != null && !this.details.isEmpty();
  }
  
  public A addNewDetail(String key,String value) {
    return (A)addToDetails(new KeyValue(key, value));
  }
  
  public DetailsNested<A> addNewDetail() {
    return new DetailsNested(-1, null);
  }
  
  public DetailsNested<A> addNewDetailLike(KeyValue item) {
    return new DetailsNested(-1, item);
  }
  
  public DetailsNested<A> setNewDetailLike(int index,KeyValue item) {
    return new DetailsNested(index, item);
  }
  
  public DetailsNested<A> editDetail(int index) {
    if (details.size() <= index) throw new RuntimeException("Can't edit details. Index exceeds size.");
    return setNewDetailLike(index, buildDetail(index));
  }
  
  public DetailsNested<A> editFirstDetail() {
    if (details.size() == 0) throw new RuntimeException("Can't edit first details. The list is empty.");
    return setNewDetailLike(0, buildDetail(0));
  }
  
  public DetailsNested<A> editLastDetail() {
    int index = details.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last details. The list is empty.");
    return setNewDetailLike(index, buildDetail(index));
  }
  
  public DetailsNested<A> editMatchingDetail(Predicate<KeyValueBuilder> predicate) {
    int index = -1;
    for (int i=0;i<details.size();i++) { 
    if (predicate.test(details.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching details. No match found.");
    return setNewDetailLike(index, buildDetail(index));
  }
  
  public String getEntity() {
    return this.entity;
  }
  
  public A withEntity(String entity) {
    this.entity = entity;
    return (A) this;
  }
  
  public boolean hasEntity() {
    return this.entity != null;
  }
  
  public HTTPConfig buildHttpConfig() {
    return this.httpConfig != null ? this.httpConfig.build() : null;
  }
  
  public A withHttpConfig(HTTPConfig httpConfig) {
    this._visitables.remove("httpConfig");
    if (httpConfig != null) {
        this.httpConfig = new HTTPConfigBuilder(httpConfig);
        this._visitables.get("httpConfig").add(this.httpConfig);
    } else {
        this.httpConfig = null;
        this._visitables.get("httpConfig").remove(this.httpConfig);
    }
    return (A) this;
  }
  
  public boolean hasHttpConfig() {
    return this.httpConfig != null;
  }
  
  public HttpConfigNested<A> withNewHttpConfig() {
    return new HttpConfigNested(null);
  }
  
  public HttpConfigNested<A> withNewHttpConfigLike(HTTPConfig item) {
    return new HttpConfigNested(item);
  }
  
  public HttpConfigNested<A> editHttpConfig() {
    return withNewHttpConfigLike(java.util.Optional.ofNullable(buildHttpConfig()).orElse(null));
  }
  
  public HttpConfigNested<A> editOrNewHttpConfig() {
    return withNewHttpConfigLike(java.util.Optional.ofNullable(buildHttpConfig()).orElse(new HTTPConfigBuilder().build()));
  }
  
  public HttpConfigNested<A> editOrNewHttpConfigLike(HTTPConfig item) {
    return withNewHttpConfigLike(java.util.Optional.ofNullable(buildHttpConfig()).orElse(item));
  }
  
  public String getMessage() {
    return this.message;
  }
  
  public A withMessage(String message) {
    this.message = message;
    return (A) this;
  }
  
  public boolean hasMessage() {
    return this.message != null;
  }
  
  public String getNote() {
    return this.note;
  }
  
  public A withNote(String note) {
    this.note = note;
    return (A) this;
  }
  
  public boolean hasNote() {
    return this.note != null;
  }
  
  public String getPriority() {
    return this.priority;
  }
  
  public A withPriority(String priority) {
    this.priority = priority;
    return (A) this;
  }
  
  public boolean hasPriority() {
    return this.priority != null;
  }
  
  public A addToResponders(int index,OpsGenieConfigResponder item) {
    if (this.responders == null) {this.responders = new ArrayList<OpsGenieConfigResponderBuilder>();}
    OpsGenieConfigResponderBuilder builder = new OpsGenieConfigResponderBuilder(item);
    if (index < 0 || index >= responders.size()) { _visitables.get("responders").add(builder); responders.add(builder); } else { _visitables.get("responders").add(index, builder); responders.add(index, builder);}
    return (A)this;
  }
  
  public A setToResponders(int index,OpsGenieConfigResponder item) {
    if (this.responders == null) {this.responders = new ArrayList<OpsGenieConfigResponderBuilder>();}
    OpsGenieConfigResponderBuilder builder = new OpsGenieConfigResponderBuilder(item);
    if (index < 0 || index >= responders.size()) { _visitables.get("responders").add(builder); responders.add(builder); } else { _visitables.get("responders").set(index, builder); responders.set(index, builder);}
    return (A)this;
  }
  
  public A addToResponders(io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponder... items) {
    if (this.responders == null) {this.responders = new ArrayList<OpsGenieConfigResponderBuilder>();}
    for (OpsGenieConfigResponder item : items) {OpsGenieConfigResponderBuilder builder = new OpsGenieConfigResponderBuilder(item);_visitables.get("responders").add(builder);this.responders.add(builder);} return (A)this;
  }
  
  public A addAllToResponders(Collection<OpsGenieConfigResponder> items) {
    if (this.responders == null) {this.responders = new ArrayList<OpsGenieConfigResponderBuilder>();}
    for (OpsGenieConfigResponder item : items) {OpsGenieConfigResponderBuilder builder = new OpsGenieConfigResponderBuilder(item);_visitables.get("responders").add(builder);this.responders.add(builder);} return (A)this;
  }
  
  public A removeFromResponders(io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponder... items) {
    if (this.responders == null) return (A)this;
    for (OpsGenieConfigResponder item : items) {OpsGenieConfigResponderBuilder builder = new OpsGenieConfigResponderBuilder(item);_visitables.get("responders").remove(builder); this.responders.remove(builder);} return (A)this;
  }
  
  public A removeAllFromResponders(Collection<OpsGenieConfigResponder> items) {
    if (this.responders == null) return (A)this;
    for (OpsGenieConfigResponder item : items) {OpsGenieConfigResponderBuilder builder = new OpsGenieConfigResponderBuilder(item);_visitables.get("responders").remove(builder); this.responders.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromResponders(Predicate<OpsGenieConfigResponderBuilder> predicate) {
    if (responders == null) return (A) this;
    final Iterator<OpsGenieConfigResponderBuilder> each = responders.iterator();
    final List visitables = _visitables.get("responders");
    while (each.hasNext()) {
      OpsGenieConfigResponderBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<OpsGenieConfigResponder> buildResponders() {
    return this.responders != null ? build(responders) : null;
  }
  
  public OpsGenieConfigResponder buildResponder(int index) {
    return this.responders.get(index).build();
  }
  
  public OpsGenieConfigResponder buildFirstResponder() {
    return this.responders.get(0).build();
  }
  
  public OpsGenieConfigResponder buildLastResponder() {
    return this.responders.get(responders.size() - 1).build();
  }
  
  public OpsGenieConfigResponder buildMatchingResponder(Predicate<OpsGenieConfigResponderBuilder> predicate) {
      for (OpsGenieConfigResponderBuilder item : responders) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingResponder(Predicate<OpsGenieConfigResponderBuilder> predicate) {
      for (OpsGenieConfigResponderBuilder item : responders) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withResponders(List<OpsGenieConfigResponder> responders) {
    if (this.responders != null) {
      this._visitables.get("responders").clear();
    }
    if (responders != null) {
        this.responders = new ArrayList();
        for (OpsGenieConfigResponder item : responders) {
          this.addToResponders(item);
        }
    } else {
      this.responders = null;
    }
    return (A) this;
  }
  
  public A withResponders(io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponder... responders) {
    if (this.responders != null) {
        this.responders.clear();
        _visitables.remove("responders");
    }
    if (responders != null) {
      for (OpsGenieConfigResponder item : responders) {
        this.addToResponders(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasResponders() {
    return this.responders != null && !this.responders.isEmpty();
  }
  
  public A addNewResponder(String id,String name,String type,String username) {
    return (A)addToResponders(new OpsGenieConfigResponder(id, name, type, username));
  }
  
  public RespondersNested<A> addNewResponder() {
    return new RespondersNested(-1, null);
  }
  
  public RespondersNested<A> addNewResponderLike(OpsGenieConfigResponder item) {
    return new RespondersNested(-1, item);
  }
  
  public RespondersNested<A> setNewResponderLike(int index,OpsGenieConfigResponder item) {
    return new RespondersNested(index, item);
  }
  
  public RespondersNested<A> editResponder(int index) {
    if (responders.size() <= index) throw new RuntimeException("Can't edit responders. Index exceeds size.");
    return setNewResponderLike(index, buildResponder(index));
  }
  
  public RespondersNested<A> editFirstResponder() {
    if (responders.size() == 0) throw new RuntimeException("Can't edit first responders. The list is empty.");
    return setNewResponderLike(0, buildResponder(0));
  }
  
  public RespondersNested<A> editLastResponder() {
    int index = responders.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last responders. The list is empty.");
    return setNewResponderLike(index, buildResponder(index));
  }
  
  public RespondersNested<A> editMatchingResponder(Predicate<OpsGenieConfigResponderBuilder> predicate) {
    int index = -1;
    for (int i=0;i<responders.size();i++) { 
    if (predicate.test(responders.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching responders. No match found.");
    return setNewResponderLike(index, buildResponder(index));
  }
  
  public Boolean getSendResolved() {
    return this.sendResolved;
  }
  
  public A withSendResolved(Boolean sendResolved) {
    this.sendResolved = sendResolved;
    return (A) this;
  }
  
  public boolean hasSendResolved() {
    return this.sendResolved != null;
  }
  
  public String getSource() {
    return this.source;
  }
  
  public A withSource(String source) {
    this.source = source;
    return (A) this;
  }
  
  public boolean hasSource() {
    return this.source != null;
  }
  
  public String getTags() {
    return this.tags;
  }
  
  public A withTags(String tags) {
    this.tags = tags;
    return (A) this;
  }
  
  public boolean hasTags() {
    return this.tags != null;
  }
  
  public Boolean getUpdateAlerts() {
    return this.updateAlerts;
  }
  
  public A withUpdateAlerts(Boolean updateAlerts) {
    this.updateAlerts = updateAlerts;
    return (A) this;
  }
  
  public boolean hasUpdateAlerts() {
    return this.updateAlerts != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    OpsGenieConfigFluent that = (OpsGenieConfigFluent) o;
    if (!java.util.Objects.equals(actions, that.actions)) return false;
    if (!java.util.Objects.equals(apiKey, that.apiKey)) return false;
    if (!java.util.Objects.equals(apiURL, that.apiURL)) return false;
    if (!java.util.Objects.equals(description, that.description)) return false;
    if (!java.util.Objects.equals(details, that.details)) return false;
    if (!java.util.Objects.equals(entity, that.entity)) return false;
    if (!java.util.Objects.equals(httpConfig, that.httpConfig)) return false;
    if (!java.util.Objects.equals(message, that.message)) return false;
    if (!java.util.Objects.equals(note, that.note)) return false;
    if (!java.util.Objects.equals(priority, that.priority)) return false;
    if (!java.util.Objects.equals(responders, that.responders)) return false;
    if (!java.util.Objects.equals(sendResolved, that.sendResolved)) return false;
    if (!java.util.Objects.equals(source, that.source)) return false;
    if (!java.util.Objects.equals(tags, that.tags)) return false;
    if (!java.util.Objects.equals(updateAlerts, that.updateAlerts)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(actions,  apiKey,  apiURL,  description,  details,  entity,  httpConfig,  message,  note,  priority,  responders,  sendResolved,  source,  tags,  updateAlerts,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (actions != null) { sb.append("actions:"); sb.append(actions + ","); }
    if (apiKey != null) { sb.append("apiKey:"); sb.append(apiKey + ","); }
    if (apiURL != null) { sb.append("apiURL:"); sb.append(apiURL + ","); }
    if (description != null) { sb.append("description:"); sb.append(description + ","); }
    if (details != null && !details.isEmpty()) { sb.append("details:"); sb.append(details + ","); }
    if (entity != null) { sb.append("entity:"); sb.append(entity + ","); }
    if (httpConfig != null) { sb.append("httpConfig:"); sb.append(httpConfig + ","); }
    if (message != null) { sb.append("message:"); sb.append(message + ","); }
    if (note != null) { sb.append("note:"); sb.append(note + ","); }
    if (priority != null) { sb.append("priority:"); sb.append(priority + ","); }
    if (responders != null && !responders.isEmpty()) { sb.append("responders:"); sb.append(responders + ","); }
    if (sendResolved != null) { sb.append("sendResolved:"); sb.append(sendResolved + ","); }
    if (source != null) { sb.append("source:"); sb.append(source + ","); }
    if (tags != null) { sb.append("tags:"); sb.append(tags + ","); }
    if (updateAlerts != null) { sb.append("updateAlerts:"); sb.append(updateAlerts + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withSendResolved() {
    return withSendResolved(true);
  }
  
  public A withUpdateAlerts() {
    return withUpdateAlerts(true);
  }
  public class DetailsNested<N> extends KeyValueFluent<DetailsNested<N>> implements Nested<N>{
    DetailsNested(int index,KeyValue item) {
      this.index = index;
      this.builder = new KeyValueBuilder(this, item);
    }
    KeyValueBuilder builder;
    int index;
    
    public N and() {
      return (N) OpsGenieConfigFluent.this.setToDetails(index,builder.build());
    }
    
    public N endDetail() {
      return and();
    }
    
  
  }
  public class HttpConfigNested<N> extends HTTPConfigFluent<HttpConfigNested<N>> implements Nested<N>{
    HttpConfigNested(HTTPConfig item) {
      this.builder = new HTTPConfigBuilder(this, item);
    }
    HTTPConfigBuilder builder;
    
    public N and() {
      return (N) OpsGenieConfigFluent.this.withHttpConfig(builder.build());
    }
    
    public N endHttpConfig() {
      return and();
    }
    
  
  }
  public class RespondersNested<N> extends OpsGenieConfigResponderFluent<RespondersNested<N>> implements Nested<N>{
    RespondersNested(int index,OpsGenieConfigResponder item) {
      this.index = index;
      this.builder = new OpsGenieConfigResponderBuilder(this, item);
    }
    OpsGenieConfigResponderBuilder builder;
    int index;
    
    public N and() {
      return (N) OpsGenieConfigFluent.this.setToResponders(index,builder.build());
    }
    
    public N endResponder() {
      return and();
    }
    
  
  }

}