package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class EmbeddedObjectMetadataBuilder extends EmbeddedObjectMetadataFluent<EmbeddedObjectMetadataBuilder> implements VisitableBuilder<EmbeddedObjectMetadata,EmbeddedObjectMetadataBuilder>{
  public EmbeddedObjectMetadataBuilder() {
    this(new EmbeddedObjectMetadata());
  }
  
  public EmbeddedObjectMetadataBuilder(EmbeddedObjectMetadataFluent<?> fluent) {
    this(fluent, new EmbeddedObjectMetadata());
  }
  
  public EmbeddedObjectMetadataBuilder(EmbeddedObjectMetadataFluent<?> fluent,EmbeddedObjectMetadata instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public EmbeddedObjectMetadataBuilder(EmbeddedObjectMetadata instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  EmbeddedObjectMetadataFluent<?> fluent;
  
  public EmbeddedObjectMetadata build() {
    EmbeddedObjectMetadata buildable = new EmbeddedObjectMetadata(fluent.getAnnotations(),fluent.getLabels(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}