/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.TLSConfig;
import io.fabric8.openshift.api.model.monitoring.v1.TLSConfigFluent;
import io.fabric8.openshift.api.model.monitoring.v1.TLSConfigFluentImpl;

public class TLSConfigBuilder
extends TLSConfigFluentImpl<TLSConfigBuilder>
implements VisitableBuilder<TLSConfig, TLSConfigBuilder> {
    TLSConfigFluent<?> fluent;
    Boolean validationEnabled;

    public TLSConfigBuilder() {
        this(false);
    }

    public TLSConfigBuilder(Boolean validationEnabled) {
        this(new TLSConfig(), validationEnabled);
    }

    public TLSConfigBuilder(TLSConfigFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public TLSConfigBuilder(TLSConfigFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new TLSConfig(), validationEnabled);
    }

    public TLSConfigBuilder(TLSConfigFluent<?> fluent, TLSConfig instance) {
        this(fluent, instance, false);
    }

    public TLSConfigBuilder(TLSConfigFluent<?> fluent, TLSConfig instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCa(instance.getCa());
        fluent.withCaFile(instance.getCaFile());
        fluent.withCert(instance.getCert());
        fluent.withCertFile(instance.getCertFile());
        fluent.withInsecureSkipVerify(instance.getInsecureSkipVerify());
        fluent.withKeyFile(instance.getKeyFile());
        fluent.withKeySecret(instance.getKeySecret());
        fluent.withServerName(instance.getServerName());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public TLSConfigBuilder(TLSConfig instance) {
        this(instance, (Boolean)false);
    }

    public TLSConfigBuilder(TLSConfig instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCa(instance.getCa());
        this.withCaFile(instance.getCaFile());
        this.withCert(instance.getCert());
        this.withCertFile(instance.getCertFile());
        this.withInsecureSkipVerify(instance.getInsecureSkipVerify());
        this.withKeyFile(instance.getKeyFile());
        this.withKeySecret(instance.getKeySecret());
        this.withServerName(instance.getServerName());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public TLSConfig build() {
        TLSConfig buildable = new TLSConfig(this.fluent.getCa(), this.fluent.getCaFile(), this.fluent.getCert(), this.fluent.getCertFile(), this.fluent.getInsecureSkipVerify(), this.fluent.getKeyFile(), this.fluent.getKeySecret(), this.fluent.getServerName());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

