package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AlertmanagerBuilder extends AlertmanagerFluentImpl<AlertmanagerBuilder> implements VisitableBuilder<Alertmanager,AlertmanagerBuilder>{
  public AlertmanagerBuilder() {
    this(false);
  }
  public AlertmanagerBuilder(Boolean validationEnabled) {
    this(new Alertmanager(), validationEnabled);
  }
  public AlertmanagerBuilder(AlertmanagerFluent<?> fluent) {
    this(fluent, false);
  }
  public AlertmanagerBuilder(AlertmanagerFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Alertmanager(), validationEnabled);
  }
  public AlertmanagerBuilder(AlertmanagerFluent<?> fluent,Alertmanager instance) {
    this(fluent, instance, false);
  }
  public AlertmanagerBuilder(AlertmanagerFluent<?> fluent,Alertmanager instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AlertmanagerBuilder(Alertmanager instance) {
    this(instance,false);
  }
  public AlertmanagerBuilder(Alertmanager instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  AlertmanagerFluent<?> fluent;
  Boolean validationEnabled;
  public Alertmanager build() {
    Alertmanager buildable = new Alertmanager(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}