package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AlertmanagerStatusBuilder extends AlertmanagerStatusFluentImpl<AlertmanagerStatusBuilder> implements VisitableBuilder<AlertmanagerStatus,AlertmanagerStatusBuilder>{
  public AlertmanagerStatusBuilder() {
    this(false);
  }
  public AlertmanagerStatusBuilder(Boolean validationEnabled) {
    this(new AlertmanagerStatus(), validationEnabled);
  }
  public AlertmanagerStatusBuilder(AlertmanagerStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public AlertmanagerStatusBuilder(AlertmanagerStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AlertmanagerStatus(), validationEnabled);
  }
  public AlertmanagerStatusBuilder(AlertmanagerStatusFluent<?> fluent,AlertmanagerStatus instance) {
    this(fluent, instance, false);
  }
  public AlertmanagerStatusBuilder(AlertmanagerStatusFluent<?> fluent,AlertmanagerStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAvailableReplicas(instance.getAvailableReplicas());
      fluent.withPaused(instance.getPaused());
      fluent.withReplicas(instance.getReplicas());
      fluent.withUnavailableReplicas(instance.getUnavailableReplicas());
      fluent.withUpdatedReplicas(instance.getUpdatedReplicas());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AlertmanagerStatusBuilder(AlertmanagerStatus instance) {
    this(instance,false);
  }
  public AlertmanagerStatusBuilder(AlertmanagerStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAvailableReplicas(instance.getAvailableReplicas());
      this.withPaused(instance.getPaused());
      this.withReplicas(instance.getReplicas());
      this.withUnavailableReplicas(instance.getUnavailableReplicas());
      this.withUpdatedReplicas(instance.getUpdatedReplicas());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  AlertmanagerStatusFluent<?> fluent;
  Boolean validationEnabled;
  public AlertmanagerStatus build() {
    AlertmanagerStatus buildable = new AlertmanagerStatus(fluent.getAvailableReplicas(),fluent.getPaused(),fluent.getReplicas(),fluent.getUnavailableReplicas(),fluent.getUpdatedReplicas());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}