package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AuthorizationBuilder extends AuthorizationFluentImpl<AuthorizationBuilder> implements VisitableBuilder<Authorization,AuthorizationBuilder>{
  public AuthorizationBuilder() {
    this(false);
  }
  public AuthorizationBuilder(Boolean validationEnabled) {
    this(new Authorization(), validationEnabled);
  }
  public AuthorizationBuilder(AuthorizationFluent<?> fluent) {
    this(fluent, false);
  }
  public AuthorizationBuilder(AuthorizationFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Authorization(), validationEnabled);
  }
  public AuthorizationBuilder(AuthorizationFluent<?> fluent,Authorization instance) {
    this(fluent, instance, false);
  }
  public AuthorizationBuilder(AuthorizationFluent<?> fluent,Authorization instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withCredentials(instance.getCredentials());
      fluent.withCredentialsFile(instance.getCredentialsFile());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AuthorizationBuilder(Authorization instance) {
    this(instance,false);
  }
  public AuthorizationBuilder(Authorization instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withCredentials(instance.getCredentials());
      this.withCredentialsFile(instance.getCredentialsFile());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  AuthorizationFluent<?> fluent;
  Boolean validationEnabled;
  public Authorization build() {
    Authorization buildable = new Authorization(fluent.getCredentials(),fluent.getCredentialsFile(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}