package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BasicAuthBuilder extends BasicAuthFluentImpl<BasicAuthBuilder> implements VisitableBuilder<BasicAuth,BasicAuthBuilder>{
  public BasicAuthBuilder() {
    this(false);
  }
  public BasicAuthBuilder(Boolean validationEnabled) {
    this(new BasicAuth(), validationEnabled);
  }
  public BasicAuthBuilder(BasicAuthFluent<?> fluent) {
    this(fluent, false);
  }
  public BasicAuthBuilder(BasicAuthFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new BasicAuth(), validationEnabled);
  }
  public BasicAuthBuilder(BasicAuthFluent<?> fluent,BasicAuth instance) {
    this(fluent, instance, false);
  }
  public BasicAuthBuilder(BasicAuthFluent<?> fluent,BasicAuth instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withPassword(instance.getPassword());
      fluent.withUsername(instance.getUsername());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public BasicAuthBuilder(BasicAuth instance) {
    this(instance,false);
  }
  public BasicAuthBuilder(BasicAuth instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withPassword(instance.getPassword());
      this.withUsername(instance.getUsername());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  BasicAuthFluent<?> fluent;
  Boolean validationEnabled;
  public BasicAuth build() {
    BasicAuth buildable = new BasicAuth(fluent.getPassword(),fluent.getUsername());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}