package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodMetricsEndpointBuilder extends PodMetricsEndpointFluentImpl<PodMetricsEndpointBuilder> implements VisitableBuilder<PodMetricsEndpoint,PodMetricsEndpointBuilder>{
  public PodMetricsEndpointBuilder() {
    this(false);
  }
  public PodMetricsEndpointBuilder(Boolean validationEnabled) {
    this(new PodMetricsEndpoint(), validationEnabled);
  }
  public PodMetricsEndpointBuilder(PodMetricsEndpointFluent<?> fluent) {
    this(fluent, false);
  }
  public PodMetricsEndpointBuilder(PodMetricsEndpointFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodMetricsEndpoint(), validationEnabled);
  }
  public PodMetricsEndpointBuilder(PodMetricsEndpointFluent<?> fluent,PodMetricsEndpoint instance) {
    this(fluent, instance, false);
  }
  public PodMetricsEndpointBuilder(PodMetricsEndpointFluent<?> fluent,PodMetricsEndpoint instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAuthorization(instance.getAuthorization());
      fluent.withBasicAuth(instance.getBasicAuth());
      fluent.withBearerTokenSecret(instance.getBearerTokenSecret());
      fluent.withHonorLabels(instance.getHonorLabels());
      fluent.withHonorTimestamps(instance.getHonorTimestamps());
      fluent.withInterval(instance.getInterval());
      fluent.withMetricRelabelings(instance.getMetricRelabelings());
      fluent.withOauth2(instance.getOauth2());
      fluent.withParams(instance.getParams());
      fluent.withPath(instance.getPath());
      fluent.withPort(instance.getPort());
      fluent.withProxyUrl(instance.getProxyUrl());
      fluent.withRelabelings(instance.getRelabelings());
      fluent.withScheme(instance.getScheme());
      fluent.withScrapeTimeout(instance.getScrapeTimeout());
      fluent.withTargetPort(instance.getTargetPort());
      fluent.withTlsConfig(instance.getTlsConfig());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodMetricsEndpointBuilder(PodMetricsEndpoint instance) {
    this(instance,false);
  }
  public PodMetricsEndpointBuilder(PodMetricsEndpoint instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAuthorization(instance.getAuthorization());
      this.withBasicAuth(instance.getBasicAuth());
      this.withBearerTokenSecret(instance.getBearerTokenSecret());
      this.withHonorLabels(instance.getHonorLabels());
      this.withHonorTimestamps(instance.getHonorTimestamps());
      this.withInterval(instance.getInterval());
      this.withMetricRelabelings(instance.getMetricRelabelings());
      this.withOauth2(instance.getOauth2());
      this.withParams(instance.getParams());
      this.withPath(instance.getPath());
      this.withPort(instance.getPort());
      this.withProxyUrl(instance.getProxyUrl());
      this.withRelabelings(instance.getRelabelings());
      this.withScheme(instance.getScheme());
      this.withScrapeTimeout(instance.getScrapeTimeout());
      this.withTargetPort(instance.getTargetPort());
      this.withTlsConfig(instance.getTlsConfig());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodMetricsEndpointFluent<?> fluent;
  Boolean validationEnabled;
  public PodMetricsEndpoint build() {
    PodMetricsEndpoint buildable = new PodMetricsEndpoint(fluent.getAuthorization(),fluent.getBasicAuth(),fluent.getBearerTokenSecret(),fluent.getHonorLabels(),fluent.getHonorTimestamps(),fluent.getInterval(),fluent.getMetricRelabelings(),fluent.getOauth2(),fluent.getParams(),fluent.getPath(),fluent.getPort(),fluent.getProxyUrl(),fluent.getRelabelings(),fluent.getScheme(),fluent.getScrapeTimeout(),fluent.getTargetPort(),fluent.getTlsConfig());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}