package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ProbeTargetsBuilder extends ProbeTargetsFluentImpl<ProbeTargetsBuilder> implements VisitableBuilder<ProbeTargets,ProbeTargetsBuilder>{
  public ProbeTargetsBuilder() {
    this(false);
  }
  public ProbeTargetsBuilder(Boolean validationEnabled) {
    this(new ProbeTargets(), validationEnabled);
  }
  public ProbeTargetsBuilder(ProbeTargetsFluent<?> fluent) {
    this(fluent, false);
  }
  public ProbeTargetsBuilder(ProbeTargetsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ProbeTargets(), validationEnabled);
  }
  public ProbeTargetsBuilder(ProbeTargetsFluent<?> fluent,ProbeTargets instance) {
    this(fluent, instance, false);
  }
  public ProbeTargetsBuilder(ProbeTargetsFluent<?> fluent,ProbeTargets instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withIngress(instance.getIngress());
      fluent.withStaticConfig(instance.getStaticConfig());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ProbeTargetsBuilder(ProbeTargets instance) {
    this(instance,false);
  }
  public ProbeTargetsBuilder(ProbeTargets instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withIngress(instance.getIngress());
      this.withStaticConfig(instance.getStaticConfig());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ProbeTargetsFluent<?> fluent;
  Boolean validationEnabled;
  public ProbeTargets build() {
    ProbeTargets buildable = new ProbeTargets(fluent.getIngress(),fluent.getStaticConfig());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}