package io.fabric8.openshift.api.model.monitoring.v1;

import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluentImpl;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.lang.Object;
import java.util.Map;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.PodSecurityContext;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.model.TopologySpreadConstraint;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.Container;
import java.util.List;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.ContainerFluentImpl;
import io.fabric8.kubernetes.api.model.Toleration;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.Affinity;
import io.fabric8.kubernetes.api.model.VolumeMount;
import java.util.Collection;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.Iterator;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import java.lang.Integer;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PrometheusSpecFluentImpl<A extends PrometheusSpecFluent<A>> extends BaseFluent<A> implements PrometheusSpecFluent<A>{
  public PrometheusSpecFluentImpl() {
  }
  public PrometheusSpecFluentImpl(PrometheusSpec instance) {
    if (instance != null) {
      this.withAdditionalAlertManagerConfigs(instance.getAdditionalAlertManagerConfigs());
      this.withAdditionalAlertRelabelConfigs(instance.getAdditionalAlertRelabelConfigs());
      this.withAdditionalScrapeConfigs(instance.getAdditionalScrapeConfigs());
      this.withAffinity(instance.getAffinity());
      this.withAlerting(instance.getAlerting());
      this.withAllowOverlappingBlocks(instance.getAllowOverlappingBlocks());
      this.withApiserverConfig(instance.getApiserverConfig());
      this.withArbitraryFSAccessThroughSMs(instance.getArbitraryFSAccessThroughSMs());
      this.withBaseImage(instance.getBaseImage());
      this.withConfigMaps(instance.getConfigMaps());
      this.withContainers(instance.getContainers());
      this.withDisableCompaction(instance.getDisableCompaction());
      this.withEnableAdminAPI(instance.getEnableAdminAPI());
      this.withEnableFeatures(instance.getEnableFeatures());
      this.withEnforcedBodySizeLimit(instance.getEnforcedBodySizeLimit());
      this.withEnforcedLabelLimit(instance.getEnforcedLabelLimit());
      this.withEnforcedLabelNameLengthLimit(instance.getEnforcedLabelNameLengthLimit());
      this.withEnforcedLabelValueLengthLimit(instance.getEnforcedLabelValueLengthLimit());
      this.withEnforcedNamespaceLabel(instance.getEnforcedNamespaceLabel());
      this.withEnforcedSampleLimit(instance.getEnforcedSampleLimit());
      this.withEnforcedTargetLimit(instance.getEnforcedTargetLimit());
      this.withEvaluationInterval(instance.getEvaluationInterval());
      this.withExternalLabels(instance.getExternalLabels());
      this.withExternalUrl(instance.getExternalUrl());
      this.withIgnoreNamespaceSelectors(instance.getIgnoreNamespaceSelectors());
      this.withImage(instance.getImage());
      this.withImagePullSecrets(instance.getImagePullSecrets());
      this.withInitContainers(instance.getInitContainers());
      this.withListenLocal(instance.getListenLocal());
      this.withLogFormat(instance.getLogFormat());
      this.withLogLevel(instance.getLogLevel());
      this.withMinReadySeconds(instance.getMinReadySeconds());
      this.withNodeSelector(instance.getNodeSelector());
      this.withOverrideHonorLabels(instance.getOverrideHonorLabels());
      this.withOverrideHonorTimestamps(instance.getOverrideHonorTimestamps());
      this.withPaused(instance.getPaused());
      this.withPodMetadata(instance.getPodMetadata());
      this.withPodMonitorNamespaceSelector(instance.getPodMonitorNamespaceSelector());
      this.withPodMonitorSelector(instance.getPodMonitorSelector());
      this.withPortName(instance.getPortName());
      this.withPriorityClassName(instance.getPriorityClassName());
      this.withProbeNamespaceSelector(instance.getProbeNamespaceSelector());
      this.withProbeSelector(instance.getProbeSelector());
      this.withPrometheusExternalLabelName(instance.getPrometheusExternalLabelName());
      this.withPrometheusRulesExcludedFromEnforce(instance.getPrometheusRulesExcludedFromEnforce());
      this.withQuery(instance.getQuery());
      this.withQueryLogFile(instance.getQueryLogFile());
      this.withRemoteRead(instance.getRemoteRead());
      this.withRemoteWrite(instance.getRemoteWrite());
      this.withReplicaExternalLabelName(instance.getReplicaExternalLabelName());
      this.withReplicas(instance.getReplicas());
      this.withResources(instance.getResources());
      this.withRetention(instance.getRetention());
      this.withRetentionSize(instance.getRetentionSize());
      this.withRoutePrefix(instance.getRoutePrefix());
      this.withRuleNamespaceSelector(instance.getRuleNamespaceSelector());
      this.withRuleSelector(instance.getRuleSelector());
      this.withRules(instance.getRules());
      this.withScrapeInterval(instance.getScrapeInterval());
      this.withScrapeTimeout(instance.getScrapeTimeout());
      this.withSecrets(instance.getSecrets());
      this.withSecurityContext(instance.getSecurityContext());
      this.withServiceAccountName(instance.getServiceAccountName());
      this.withServiceMonitorNamespaceSelector(instance.getServiceMonitorNamespaceSelector());
      this.withServiceMonitorSelector(instance.getServiceMonitorSelector());
      this.withSha(instance.getSha());
      this.withShards(instance.getShards());
      this.withStorage(instance.getStorage());
      this.withTag(instance.getTag());
      this.withThanos(instance.getThanos());
      this.withTolerations(instance.getTolerations());
      this.withTopologySpreadConstraints(instance.getTopologySpreadConstraints());
      this.withVersion(instance.getVersion());
      this.withVolumeMounts(instance.getVolumeMounts());
      this.withVolumes(instance.getVolumes());
      this.withWalCompression(instance.getWalCompression());
      this.withWeb(instance.getWeb());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private SecretKeySelector additionalAlertManagerConfigs;
  private SecretKeySelector additionalAlertRelabelConfigs;
  private SecretKeySelector additionalScrapeConfigs;
  private Affinity affinity;
  private AlertingSpecBuilder alerting;
  private Boolean allowOverlappingBlocks;
  private APIServerConfigBuilder apiserverConfig;
  private ArbitraryFSAccessThroughSMsConfigBuilder arbitraryFSAccessThroughSMs;
  private String baseImage;
  private List<String> configMaps = new ArrayList<String>();
  private ArrayList<ContainerBuilder> containers = new ArrayList<ContainerBuilder>();
  private Boolean disableCompaction;
  private Boolean enableAdminAPI;
  private List<String> enableFeatures = new ArrayList<String>();
  private String enforcedBodySizeLimit;
  private Long enforcedLabelLimit;
  private Long enforcedLabelNameLengthLimit;
  private Long enforcedLabelValueLengthLimit;
  private String enforcedNamespaceLabel;
  private Long enforcedSampleLimit;
  private Long enforcedTargetLimit;
  private String evaluationInterval;
  private Map<String,String> externalLabels;
  private String externalUrl;
  private Boolean ignoreNamespaceSelectors;
  private String image;
  private ArrayList<LocalObjectReferenceBuilder> imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();
  private ArrayList<ContainerBuilder> initContainers = new ArrayList<ContainerBuilder>();
  private Boolean listenLocal;
  private String logFormat;
  private String logLevel;
  private Integer minReadySeconds;
  private Map<String,String> nodeSelector;
  private Boolean overrideHonorLabels;
  private Boolean overrideHonorTimestamps;
  private Boolean paused;
  private EmbeddedObjectMetadataBuilder podMetadata;
  private LabelSelectorBuilder podMonitorNamespaceSelector;
  private LabelSelectorBuilder podMonitorSelector;
  private String portName;
  private String priorityClassName;
  private LabelSelectorBuilder probeNamespaceSelector;
  private LabelSelectorBuilder probeSelector;
  private String prometheusExternalLabelName;
  private ArrayList<PrometheusRuleExcludeConfigBuilder> prometheusRulesExcludedFromEnforce = new ArrayList<PrometheusRuleExcludeConfigBuilder>();
  private QuerySpecBuilder query;
  private String queryLogFile;
  private ArrayList<RemoteReadSpecBuilder> remoteRead = new ArrayList<RemoteReadSpecBuilder>();
  private ArrayList<RemoteWriteSpecBuilder> remoteWrite = new ArrayList<RemoteWriteSpecBuilder>();
  private String replicaExternalLabelName;
  private Integer replicas;
  private ResourceRequirementsBuilder resources;
  private String retention;
  private String retentionSize;
  private String routePrefix;
  private LabelSelectorBuilder ruleNamespaceSelector;
  private LabelSelectorBuilder ruleSelector;
  private RulesBuilder rules;
  private String scrapeInterval;
  private String scrapeTimeout;
  private List<String> secrets = new ArrayList<String>();
  private PodSecurityContext securityContext;
  private String serviceAccountName;
  private LabelSelectorBuilder serviceMonitorNamespaceSelector;
  private LabelSelectorBuilder serviceMonitorSelector;
  private String sha;
  private Integer shards;
  private StorageSpecBuilder storage;
  private String tag;
  private ThanosSpecBuilder thanos;
  private List<Toleration> tolerations = new ArrayList<Toleration>();
  private List<TopologySpreadConstraint> topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
  private String version;
  private List<VolumeMount> volumeMounts = new ArrayList<VolumeMount>();
  private List<Volume> volumes = new ArrayList<Volume>();
  private Boolean walCompression;
  private WebSpecBuilder web;
  private Map<String,Object> additionalProperties;
  public SecretKeySelector getAdditionalAlertManagerConfigs() {
    return this.additionalAlertManagerConfigs;
  }
  public A withAdditionalAlertManagerConfigs(SecretKeySelector additionalAlertManagerConfigs) {
    this.additionalAlertManagerConfigs=additionalAlertManagerConfigs; return (A) this;
  }
  public Boolean hasAdditionalAlertManagerConfigs() {
    return this.additionalAlertManagerConfigs != null;
  }
  public A withNewAdditionalAlertManagerConfigs(String key,String name,Boolean optional) {
    return (A)withAdditionalAlertManagerConfigs(new SecretKeySelector(key, name, optional));
  }
  public SecretKeySelector getAdditionalAlertRelabelConfigs() {
    return this.additionalAlertRelabelConfigs;
  }
  public A withAdditionalAlertRelabelConfigs(SecretKeySelector additionalAlertRelabelConfigs) {
    this.additionalAlertRelabelConfigs=additionalAlertRelabelConfigs; return (A) this;
  }
  public Boolean hasAdditionalAlertRelabelConfigs() {
    return this.additionalAlertRelabelConfigs != null;
  }
  public A withNewAdditionalAlertRelabelConfigs(String key,String name,Boolean optional) {
    return (A)withAdditionalAlertRelabelConfigs(new SecretKeySelector(key, name, optional));
  }
  public SecretKeySelector getAdditionalScrapeConfigs() {
    return this.additionalScrapeConfigs;
  }
  public A withAdditionalScrapeConfigs(SecretKeySelector additionalScrapeConfigs) {
    this.additionalScrapeConfigs=additionalScrapeConfigs; return (A) this;
  }
  public Boolean hasAdditionalScrapeConfigs() {
    return this.additionalScrapeConfigs != null;
  }
  public A withNewAdditionalScrapeConfigs(String key,String name,Boolean optional) {
    return (A)withAdditionalScrapeConfigs(new SecretKeySelector(key, name, optional));
  }
  public Affinity getAffinity() {
    return this.affinity;
  }
  public A withAffinity(Affinity affinity) {
    this.affinity=affinity; return (A) this;
  }
  public Boolean hasAffinity() {
    return this.affinity != null;
  }
  
  /**
   * This method has been deprecated, please use method buildAlerting instead.
   * @return The buildable object.
   */
  @Deprecated
  public AlertingSpec getAlerting() {
    return this.alerting!=null ?this.alerting.build():null;
  }
  public AlertingSpec buildAlerting() {
    return this.alerting!=null ?this.alerting.build():null;
  }
  public A withAlerting(AlertingSpec alerting) {
    _visitables.get("alerting").remove(this.alerting);
    if (alerting!=null){ this.alerting= new AlertingSpecBuilder(alerting); _visitables.get("alerting").add(this.alerting);} else { this.alerting = null; _visitables.get("alerting").remove(this.alerting); } return (A) this;
  }
  public Boolean hasAlerting() {
    return this.alerting != null;
  }
  public PrometheusSpecFluentImpl.AlertingNested<A> withNewAlerting() {
    return new PrometheusSpecFluentImpl.AlertingNestedImpl();
  }
  public PrometheusSpecFluentImpl.AlertingNested<A> withNewAlertingLike(AlertingSpec item) {
    return new PrometheusSpecFluentImpl.AlertingNestedImpl(item);
  }
  public PrometheusSpecFluentImpl.AlertingNested<A> editAlerting() {
    return withNewAlertingLike(getAlerting());
  }
  public PrometheusSpecFluentImpl.AlertingNested<A> editOrNewAlerting() {
    return withNewAlertingLike(getAlerting() != null ? getAlerting(): new AlertingSpecBuilder().build());
  }
  public PrometheusSpecFluentImpl.AlertingNested<A> editOrNewAlertingLike(AlertingSpec item) {
    return withNewAlertingLike(getAlerting() != null ? getAlerting(): item);
  }
  public Boolean getAllowOverlappingBlocks() {
    return this.allowOverlappingBlocks;
  }
  public A withAllowOverlappingBlocks(Boolean allowOverlappingBlocks) {
    this.allowOverlappingBlocks=allowOverlappingBlocks; return (A) this;
  }
  public Boolean hasAllowOverlappingBlocks() {
    return this.allowOverlappingBlocks != null;
  }
  
  /**
   * This method has been deprecated, please use method buildApiserverConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public APIServerConfig getApiserverConfig() {
    return this.apiserverConfig!=null ?this.apiserverConfig.build():null;
  }
  public APIServerConfig buildApiserverConfig() {
    return this.apiserverConfig!=null ?this.apiserverConfig.build():null;
  }
  public A withApiserverConfig(APIServerConfig apiserverConfig) {
    _visitables.get("apiserverConfig").remove(this.apiserverConfig);
    if (apiserverConfig!=null){ this.apiserverConfig= new APIServerConfigBuilder(apiserverConfig); _visitables.get("apiserverConfig").add(this.apiserverConfig);} else { this.apiserverConfig = null; _visitables.get("apiserverConfig").remove(this.apiserverConfig); } return (A) this;
  }
  public Boolean hasApiserverConfig() {
    return this.apiserverConfig != null;
  }
  public PrometheusSpecFluentImpl.ApiserverConfigNested<A> withNewApiserverConfig() {
    return new PrometheusSpecFluentImpl.ApiserverConfigNestedImpl();
  }
  public PrometheusSpecFluentImpl.ApiserverConfigNested<A> withNewApiserverConfigLike(APIServerConfig item) {
    return new PrometheusSpecFluentImpl.ApiserverConfigNestedImpl(item);
  }
  public PrometheusSpecFluentImpl.ApiserverConfigNested<A> editApiserverConfig() {
    return withNewApiserverConfigLike(getApiserverConfig());
  }
  public PrometheusSpecFluentImpl.ApiserverConfigNested<A> editOrNewApiserverConfig() {
    return withNewApiserverConfigLike(getApiserverConfig() != null ? getApiserverConfig(): new APIServerConfigBuilder().build());
  }
  public PrometheusSpecFluentImpl.ApiserverConfigNested<A> editOrNewApiserverConfigLike(APIServerConfig item) {
    return withNewApiserverConfigLike(getApiserverConfig() != null ? getApiserverConfig(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildArbitraryFSAccessThroughSMs instead.
   * @return The buildable object.
   */
  @Deprecated
  public ArbitraryFSAccessThroughSMsConfig getArbitraryFSAccessThroughSMs() {
    return this.arbitraryFSAccessThroughSMs!=null ?this.arbitraryFSAccessThroughSMs.build():null;
  }
  public ArbitraryFSAccessThroughSMsConfig buildArbitraryFSAccessThroughSMs() {
    return this.arbitraryFSAccessThroughSMs!=null ?this.arbitraryFSAccessThroughSMs.build():null;
  }
  public A withArbitraryFSAccessThroughSMs(ArbitraryFSAccessThroughSMsConfig arbitraryFSAccessThroughSMs) {
    _visitables.get("arbitraryFSAccessThroughSMs").remove(this.arbitraryFSAccessThroughSMs);
    if (arbitraryFSAccessThroughSMs!=null){ this.arbitraryFSAccessThroughSMs= new ArbitraryFSAccessThroughSMsConfigBuilder(arbitraryFSAccessThroughSMs); _visitables.get("arbitraryFSAccessThroughSMs").add(this.arbitraryFSAccessThroughSMs);} else { this.arbitraryFSAccessThroughSMs = null; _visitables.get("arbitraryFSAccessThroughSMs").remove(this.arbitraryFSAccessThroughSMs); } return (A) this;
  }
  public Boolean hasArbitraryFSAccessThroughSMs() {
    return this.arbitraryFSAccessThroughSMs != null;
  }
  public A withNewArbitraryFSAccessThroughSMs(Boolean deny) {
    return (A)withArbitraryFSAccessThroughSMs(new ArbitraryFSAccessThroughSMsConfig(deny));
  }
  public PrometheusSpecFluentImpl.ArbitraryFSAccessThroughSMsNested<A> withNewArbitraryFSAccessThroughSMs() {
    return new PrometheusSpecFluentImpl.ArbitraryFSAccessThroughSMsNestedImpl();
  }
  public PrometheusSpecFluentImpl.ArbitraryFSAccessThroughSMsNested<A> withNewArbitraryFSAccessThroughSMsLike(ArbitraryFSAccessThroughSMsConfig item) {
    return new PrometheusSpecFluentImpl.ArbitraryFSAccessThroughSMsNestedImpl(item);
  }
  public PrometheusSpecFluentImpl.ArbitraryFSAccessThroughSMsNested<A> editArbitraryFSAccessThroughSMs() {
    return withNewArbitraryFSAccessThroughSMsLike(getArbitraryFSAccessThroughSMs());
  }
  public PrometheusSpecFluentImpl.ArbitraryFSAccessThroughSMsNested<A> editOrNewArbitraryFSAccessThroughSMs() {
    return withNewArbitraryFSAccessThroughSMsLike(getArbitraryFSAccessThroughSMs() != null ? getArbitraryFSAccessThroughSMs(): new ArbitraryFSAccessThroughSMsConfigBuilder().build());
  }
  public PrometheusSpecFluentImpl.ArbitraryFSAccessThroughSMsNested<A> editOrNewArbitraryFSAccessThroughSMsLike(ArbitraryFSAccessThroughSMsConfig item) {
    return withNewArbitraryFSAccessThroughSMsLike(getArbitraryFSAccessThroughSMs() != null ? getArbitraryFSAccessThroughSMs(): item);
  }
  public String getBaseImage() {
    return this.baseImage;
  }
  public A withBaseImage(String baseImage) {
    this.baseImage=baseImage; return (A) this;
  }
  public Boolean hasBaseImage() {
    return this.baseImage != null;
  }
  public A addToConfigMaps(int index,String item) {
    if (this.configMaps == null) {this.configMaps = new ArrayList<String>();}
    this.configMaps.add(index, item);
    return (A)this;
  }
  public A setToConfigMaps(int index,String item) {
    if (this.configMaps == null) {this.configMaps = new ArrayList<String>();}
    this.configMaps.set(index, item); return (A)this;
  }
  public A addToConfigMaps(java.lang.String... items) {
    if (this.configMaps == null) {this.configMaps = new ArrayList<String>();}
    for (String item : items) {this.configMaps.add(item);} return (A)this;
  }
  public A addAllToConfigMaps(Collection<String> items) {
    if (this.configMaps == null) {this.configMaps = new ArrayList<String>();}
    for (String item : items) {this.configMaps.add(item);} return (A)this;
  }
  public A removeFromConfigMaps(java.lang.String... items) {
    for (String item : items) {if (this.configMaps!= null){ this.configMaps.remove(item);}} return (A)this;
  }
  public A removeAllFromConfigMaps(Collection<String> items) {
    for (String item : items) {if (this.configMaps!= null){ this.configMaps.remove(item);}} return (A)this;
  }
  public List<String> getConfigMaps() {
    return this.configMaps;
  }
  public String getConfigMap(int index) {
    return this.configMaps.get(index);
  }
  public String getFirstConfigMap() {
    return this.configMaps.get(0);
  }
  public String getLastConfigMap() {
    return this.configMaps.get(configMaps.size() - 1);
  }
  public String getMatchingConfigMap(Predicate<String> predicate) {
    for (String item: configMaps) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingConfigMap(Predicate<String> predicate) {
    for (String item: configMaps) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConfigMaps(List<String> configMaps) {
    if (configMaps != null) {this.configMaps = new ArrayList(); for (String item : configMaps){this.addToConfigMaps(item);}} else { this.configMaps = null;} return (A) this;
  }
  public A withConfigMaps(java.lang.String... configMaps) {
    if (this.configMaps != null) {this.configMaps.clear(); _visitables.remove("configMaps"); }
    if (configMaps != null) {for (String item :configMaps){ this.addToConfigMaps(item);}} return (A) this;
  }
  public Boolean hasConfigMaps() {
    return configMaps != null && !configMaps.isEmpty();
  }
  public A addToContainers(int index,Container item) {
    if (this.containers == null) {this.containers = new ArrayList<ContainerBuilder>();}
    ContainerBuilder builder = new ContainerBuilder(item);
    if (index < 0 || index >= containers.size()) { _visitables.get("containers").add(builder); containers.add(builder); } else { _visitables.get("containers").add(index, builder); containers.add(index, builder);}
    return (A)this;
  }
  public A setToContainers(int index,Container item) {
    if (this.containers == null) {this.containers = new ArrayList<ContainerBuilder>();}
    ContainerBuilder builder = new ContainerBuilder(item);
    if (index < 0 || index >= containers.size()) { _visitables.get("containers").add(builder); containers.add(builder); } else { _visitables.get("containers").set(index, builder); containers.set(index, builder);}
    return (A)this;
  }
  public A addToContainers(io.fabric8.kubernetes.api.model.Container... items) {
    if (this.containers == null) {this.containers = new ArrayList<ContainerBuilder>();}
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("containers").add(builder);this.containers.add(builder);} return (A)this;
  }
  public A addAllToContainers(Collection<Container> items) {
    if (this.containers == null) {this.containers = new ArrayList<ContainerBuilder>();}
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("containers").add(builder);this.containers.add(builder);} return (A)this;
  }
  public A removeFromContainers(io.fabric8.kubernetes.api.model.Container... items) {
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("containers").remove(builder);if (this.containers != null) {this.containers.remove(builder);}} return (A)this;
  }
  public A removeAllFromContainers(Collection<Container> items) {
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("containers").remove(builder);if (this.containers != null) {this.containers.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromContainers(Predicate<ContainerBuilder> predicate) {
    if (containers == null) return (A) this;
    final Iterator<ContainerBuilder> each = containers.iterator();
    final List visitables = _visitables.get("containers");
    while (each.hasNext()) {
      ContainerBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildContainers instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Container> getContainers() {
    return containers != null ? build(containers) : null;
  }
  public List<Container> buildContainers() {
    return containers != null ? build(containers) : null;
  }
  public Container buildContainer(int index) {
    return this.containers.get(index).build();
  }
  public Container buildFirstContainer() {
    return this.containers.get(0).build();
  }
  public Container buildLastContainer() {
    return this.containers.get(containers.size() - 1).build();
  }
  public Container buildMatchingContainer(Predicate<ContainerBuilder> predicate) {
    for (ContainerBuilder item: containers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingContainer(Predicate<ContainerBuilder> predicate) {
    for (ContainerBuilder item: containers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withContainers(List<Container> containers) {
    if (this.containers != null) { _visitables.get("containers").clear();}
    if (containers != null) {this.containers = new ArrayList(); for (Container item : containers){this.addToContainers(item);}} else { this.containers = null;} return (A) this;
  }
  public A withContainers(io.fabric8.kubernetes.api.model.Container... containers) {
    if (this.containers != null) {this.containers.clear(); _visitables.remove("containers"); }
    if (containers != null) {for (Container item :containers){ this.addToContainers(item);}} return (A) this;
  }
  public Boolean hasContainers() {
    return containers != null && !containers.isEmpty();
  }
  public PrometheusSpecFluentImpl.ContainersNested<A> addNewContainer() {
    return new PrometheusSpecFluentImpl.ContainersNestedImpl();
  }
  public PrometheusSpecFluentImpl.ContainersNested<A> addNewContainerLike(Container item) {
    return new PrometheusSpecFluentImpl.ContainersNestedImpl(-1, item);
  }
  public PrometheusSpecFluentImpl.ContainersNested<A> setNewContainerLike(int index,Container item) {
    return new PrometheusSpecFluentImpl.ContainersNestedImpl(index, item);
  }
  public PrometheusSpecFluentImpl.ContainersNested<A> editContainer(int index) {
    if (containers.size() <= index) throw new RuntimeException("Can't edit containers. Index exceeds size.");
    return setNewContainerLike(index, buildContainer(index));
  }
  public PrometheusSpecFluentImpl.ContainersNested<A> editFirstContainer() {
    if (containers.size() == 0) throw new RuntimeException("Can't edit first containers. The list is empty.");
    return setNewContainerLike(0, buildContainer(0));
  }
  public PrometheusSpecFluentImpl.ContainersNested<A> editLastContainer() {
    int index = containers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last containers. The list is empty.");
    return setNewContainerLike(index, buildContainer(index));
  }
  public PrometheusSpecFluentImpl.ContainersNested<A> editMatchingContainer(Predicate<ContainerBuilder> predicate) {
    int index = -1;
    for (int i=0;i<containers.size();i++) { 
    if (predicate.test(containers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching containers. No match found.");
    return setNewContainerLike(index, buildContainer(index));
  }
  public Boolean getDisableCompaction() {
    return this.disableCompaction;
  }
  public A withDisableCompaction(Boolean disableCompaction) {
    this.disableCompaction=disableCompaction; return (A) this;
  }
  public Boolean hasDisableCompaction() {
    return this.disableCompaction != null;
  }
  public Boolean getEnableAdminAPI() {
    return this.enableAdminAPI;
  }
  public A withEnableAdminAPI(Boolean enableAdminAPI) {
    this.enableAdminAPI=enableAdminAPI; return (A) this;
  }
  public Boolean hasEnableAdminAPI() {
    return this.enableAdminAPI != null;
  }
  public A addToEnableFeatures(int index,String item) {
    if (this.enableFeatures == null) {this.enableFeatures = new ArrayList<String>();}
    this.enableFeatures.add(index, item);
    return (A)this;
  }
  public A setToEnableFeatures(int index,String item) {
    if (this.enableFeatures == null) {this.enableFeatures = new ArrayList<String>();}
    this.enableFeatures.set(index, item); return (A)this;
  }
  public A addToEnableFeatures(java.lang.String... items) {
    if (this.enableFeatures == null) {this.enableFeatures = new ArrayList<String>();}
    for (String item : items) {this.enableFeatures.add(item);} return (A)this;
  }
  public A addAllToEnableFeatures(Collection<String> items) {
    if (this.enableFeatures == null) {this.enableFeatures = new ArrayList<String>();}
    for (String item : items) {this.enableFeatures.add(item);} return (A)this;
  }
  public A removeFromEnableFeatures(java.lang.String... items) {
    for (String item : items) {if (this.enableFeatures!= null){ this.enableFeatures.remove(item);}} return (A)this;
  }
  public A removeAllFromEnableFeatures(Collection<String> items) {
    for (String item : items) {if (this.enableFeatures!= null){ this.enableFeatures.remove(item);}} return (A)this;
  }
  public List<String> getEnableFeatures() {
    return this.enableFeatures;
  }
  public String getEnableFeature(int index) {
    return this.enableFeatures.get(index);
  }
  public String getFirstEnableFeature() {
    return this.enableFeatures.get(0);
  }
  public String getLastEnableFeature() {
    return this.enableFeatures.get(enableFeatures.size() - 1);
  }
  public String getMatchingEnableFeature(Predicate<String> predicate) {
    for (String item: enableFeatures) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingEnableFeature(Predicate<String> predicate) {
    for (String item: enableFeatures) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withEnableFeatures(List<String> enableFeatures) {
    if (enableFeatures != null) {this.enableFeatures = new ArrayList(); for (String item : enableFeatures){this.addToEnableFeatures(item);}} else { this.enableFeatures = null;} return (A) this;
  }
  public A withEnableFeatures(java.lang.String... enableFeatures) {
    if (this.enableFeatures != null) {this.enableFeatures.clear(); _visitables.remove("enableFeatures"); }
    if (enableFeatures != null) {for (String item :enableFeatures){ this.addToEnableFeatures(item);}} return (A) this;
  }
  public Boolean hasEnableFeatures() {
    return enableFeatures != null && !enableFeatures.isEmpty();
  }
  public String getEnforcedBodySizeLimit() {
    return this.enforcedBodySizeLimit;
  }
  public A withEnforcedBodySizeLimit(String enforcedBodySizeLimit) {
    this.enforcedBodySizeLimit=enforcedBodySizeLimit; return (A) this;
  }
  public Boolean hasEnforcedBodySizeLimit() {
    return this.enforcedBodySizeLimit != null;
  }
  public Long getEnforcedLabelLimit() {
    return this.enforcedLabelLimit;
  }
  public A withEnforcedLabelLimit(Long enforcedLabelLimit) {
    this.enforcedLabelLimit=enforcedLabelLimit; return (A) this;
  }
  public Boolean hasEnforcedLabelLimit() {
    return this.enforcedLabelLimit != null;
  }
  public Long getEnforcedLabelNameLengthLimit() {
    return this.enforcedLabelNameLengthLimit;
  }
  public A withEnforcedLabelNameLengthLimit(Long enforcedLabelNameLengthLimit) {
    this.enforcedLabelNameLengthLimit=enforcedLabelNameLengthLimit; return (A) this;
  }
  public Boolean hasEnforcedLabelNameLengthLimit() {
    return this.enforcedLabelNameLengthLimit != null;
  }
  public Long getEnforcedLabelValueLengthLimit() {
    return this.enforcedLabelValueLengthLimit;
  }
  public A withEnforcedLabelValueLengthLimit(Long enforcedLabelValueLengthLimit) {
    this.enforcedLabelValueLengthLimit=enforcedLabelValueLengthLimit; return (A) this;
  }
  public Boolean hasEnforcedLabelValueLengthLimit() {
    return this.enforcedLabelValueLengthLimit != null;
  }
  public String getEnforcedNamespaceLabel() {
    return this.enforcedNamespaceLabel;
  }
  public A withEnforcedNamespaceLabel(String enforcedNamespaceLabel) {
    this.enforcedNamespaceLabel=enforcedNamespaceLabel; return (A) this;
  }
  public Boolean hasEnforcedNamespaceLabel() {
    return this.enforcedNamespaceLabel != null;
  }
  public Long getEnforcedSampleLimit() {
    return this.enforcedSampleLimit;
  }
  public A withEnforcedSampleLimit(Long enforcedSampleLimit) {
    this.enforcedSampleLimit=enforcedSampleLimit; return (A) this;
  }
  public Boolean hasEnforcedSampleLimit() {
    return this.enforcedSampleLimit != null;
  }
  public Long getEnforcedTargetLimit() {
    return this.enforcedTargetLimit;
  }
  public A withEnforcedTargetLimit(Long enforcedTargetLimit) {
    this.enforcedTargetLimit=enforcedTargetLimit; return (A) this;
  }
  public Boolean hasEnforcedTargetLimit() {
    return this.enforcedTargetLimit != null;
  }
  public String getEvaluationInterval() {
    return this.evaluationInterval;
  }
  public A withEvaluationInterval(String evaluationInterval) {
    this.evaluationInterval=evaluationInterval; return (A) this;
  }
  public Boolean hasEvaluationInterval() {
    return this.evaluationInterval != null;
  }
  public A addToExternalLabels(String key,String value) {
    if(this.externalLabels == null && key != null && value != null) { this.externalLabels = new LinkedHashMap(); }
    if(key != null && value != null) {this.externalLabels.put(key, value);} return (A)this;
  }
  public A addToExternalLabels(Map<String,String> map) {
    if(this.externalLabels == null && map != null) { this.externalLabels = new LinkedHashMap(); }
    if(map != null) { this.externalLabels.putAll(map);} return (A)this;
  }
  public A removeFromExternalLabels(String key) {
    if(this.externalLabels == null) { return (A) this; }
    if(key != null && this.externalLabels != null) {this.externalLabels.remove(key);} return (A)this;
  }
  public A removeFromExternalLabels(Map<String,String> map) {
    if(this.externalLabels == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.externalLabels != null){this.externalLabels.remove(key);}}} return (A)this;
  }
  public Map<String,String> getExternalLabels() {
    return this.externalLabels;
  }
  public <K,V>A withExternalLabels(Map<String,String> externalLabels) {
    if (externalLabels == null) { this.externalLabels =  null;} else {this.externalLabels = new LinkedHashMap(externalLabels);} return (A) this;
  }
  public Boolean hasExternalLabels() {
    return this.externalLabels != null;
  }
  public String getExternalUrl() {
    return this.externalUrl;
  }
  public A withExternalUrl(String externalUrl) {
    this.externalUrl=externalUrl; return (A) this;
  }
  public Boolean hasExternalUrl() {
    return this.externalUrl != null;
  }
  public Boolean getIgnoreNamespaceSelectors() {
    return this.ignoreNamespaceSelectors;
  }
  public A withIgnoreNamespaceSelectors(Boolean ignoreNamespaceSelectors) {
    this.ignoreNamespaceSelectors=ignoreNamespaceSelectors; return (A) this;
  }
  public Boolean hasIgnoreNamespaceSelectors() {
    return this.ignoreNamespaceSelectors != null;
  }
  public String getImage() {
    return this.image;
  }
  public A withImage(String image) {
    this.image=image; return (A) this;
  }
  public Boolean hasImage() {
    return this.image != null;
  }
  public A addToImagePullSecrets(int index,LocalObjectReference item) {
    if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();}
    LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
    if (index < 0 || index >= imagePullSecrets.size()) { _visitables.get("imagePullSecrets").add(builder); imagePullSecrets.add(builder); } else { _visitables.get("imagePullSecrets").add(index, builder); imagePullSecrets.add(index, builder);}
    return (A)this;
  }
  public A setToImagePullSecrets(int index,LocalObjectReference item) {
    if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();}
    LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
    if (index < 0 || index >= imagePullSecrets.size()) { _visitables.get("imagePullSecrets").add(builder); imagePullSecrets.add(builder); } else { _visitables.get("imagePullSecrets").set(index, builder); imagePullSecrets.set(index, builder);}
    return (A)this;
  }
  public A addToImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... items) {
    if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();}
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("imagePullSecrets").add(builder);this.imagePullSecrets.add(builder);} return (A)this;
  }
  public A addAllToImagePullSecrets(Collection<LocalObjectReference> items) {
    if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();}
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("imagePullSecrets").add(builder);this.imagePullSecrets.add(builder);} return (A)this;
  }
  public A removeFromImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... items) {
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("imagePullSecrets").remove(builder);if (this.imagePullSecrets != null) {this.imagePullSecrets.remove(builder);}} return (A)this;
  }
  public A removeAllFromImagePullSecrets(Collection<LocalObjectReference> items) {
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("imagePullSecrets").remove(builder);if (this.imagePullSecrets != null) {this.imagePullSecrets.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromImagePullSecrets(Predicate<LocalObjectReferenceBuilder> predicate) {
    if (imagePullSecrets == null) return (A) this;
    final Iterator<LocalObjectReferenceBuilder> each = imagePullSecrets.iterator();
    final List visitables = _visitables.get("imagePullSecrets");
    while (each.hasNext()) {
      LocalObjectReferenceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildImagePullSecrets instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<LocalObjectReference> getImagePullSecrets() {
    return imagePullSecrets != null ? build(imagePullSecrets) : null;
  }
  public List<LocalObjectReference> buildImagePullSecrets() {
    return imagePullSecrets != null ? build(imagePullSecrets) : null;
  }
  public LocalObjectReference buildImagePullSecret(int index) {
    return this.imagePullSecrets.get(index).build();
  }
  public LocalObjectReference buildFirstImagePullSecret() {
    return this.imagePullSecrets.get(0).build();
  }
  public LocalObjectReference buildLastImagePullSecret() {
    return this.imagePullSecrets.get(imagePullSecrets.size() - 1).build();
  }
  public LocalObjectReference buildMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
    for (LocalObjectReferenceBuilder item: imagePullSecrets) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
    for (LocalObjectReferenceBuilder item: imagePullSecrets) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withImagePullSecrets(List<LocalObjectReference> imagePullSecrets) {
    if (this.imagePullSecrets != null) { _visitables.get("imagePullSecrets").clear();}
    if (imagePullSecrets != null) {this.imagePullSecrets = new ArrayList(); for (LocalObjectReference item : imagePullSecrets){this.addToImagePullSecrets(item);}} else { this.imagePullSecrets = null;} return (A) this;
  }
  public A withImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... imagePullSecrets) {
    if (this.imagePullSecrets != null) {this.imagePullSecrets.clear(); _visitables.remove("imagePullSecrets"); }
    if (imagePullSecrets != null) {for (LocalObjectReference item :imagePullSecrets){ this.addToImagePullSecrets(item);}} return (A) this;
  }
  public Boolean hasImagePullSecrets() {
    return imagePullSecrets != null && !imagePullSecrets.isEmpty();
  }
  public A addNewImagePullSecret(String name) {
    return (A)addToImagePullSecrets(new LocalObjectReference(name));
  }
  public PrometheusSpecFluentImpl.ImagePullSecretsNested<A> addNewImagePullSecret() {
    return new PrometheusSpecFluentImpl.ImagePullSecretsNestedImpl();
  }
  public PrometheusSpecFluentImpl.ImagePullSecretsNested<A> addNewImagePullSecretLike(LocalObjectReference item) {
    return new PrometheusSpecFluentImpl.ImagePullSecretsNestedImpl(-1, item);
  }
  public PrometheusSpecFluentImpl.ImagePullSecretsNested<A> setNewImagePullSecretLike(int index,LocalObjectReference item) {
    return new PrometheusSpecFluentImpl.ImagePullSecretsNestedImpl(index, item);
  }
  public PrometheusSpecFluentImpl.ImagePullSecretsNested<A> editImagePullSecret(int index) {
    if (imagePullSecrets.size() <= index) throw new RuntimeException("Can't edit imagePullSecrets. Index exceeds size.");
    return setNewImagePullSecretLike(index, buildImagePullSecret(index));
  }
  public PrometheusSpecFluentImpl.ImagePullSecretsNested<A> editFirstImagePullSecret() {
    if (imagePullSecrets.size() == 0) throw new RuntimeException("Can't edit first imagePullSecrets. The list is empty.");
    return setNewImagePullSecretLike(0, buildImagePullSecret(0));
  }
  public PrometheusSpecFluentImpl.ImagePullSecretsNested<A> editLastImagePullSecret() {
    int index = imagePullSecrets.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last imagePullSecrets. The list is empty.");
    return setNewImagePullSecretLike(index, buildImagePullSecret(index));
  }
  public PrometheusSpecFluentImpl.ImagePullSecretsNested<A> editMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<imagePullSecrets.size();i++) { 
    if (predicate.test(imagePullSecrets.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching imagePullSecrets. No match found.");
    return setNewImagePullSecretLike(index, buildImagePullSecret(index));
  }
  public A addToInitContainers(int index,Container item) {
    if (this.initContainers == null) {this.initContainers = new ArrayList<ContainerBuilder>();}
    ContainerBuilder builder = new ContainerBuilder(item);
    if (index < 0 || index >= initContainers.size()) { _visitables.get("initContainers").add(builder); initContainers.add(builder); } else { _visitables.get("initContainers").add(index, builder); initContainers.add(index, builder);}
    return (A)this;
  }
  public A setToInitContainers(int index,Container item) {
    if (this.initContainers == null) {this.initContainers = new ArrayList<ContainerBuilder>();}
    ContainerBuilder builder = new ContainerBuilder(item);
    if (index < 0 || index >= initContainers.size()) { _visitables.get("initContainers").add(builder); initContainers.add(builder); } else { _visitables.get("initContainers").set(index, builder); initContainers.set(index, builder);}
    return (A)this;
  }
  public A addToInitContainers(io.fabric8.kubernetes.api.model.Container... items) {
    if (this.initContainers == null) {this.initContainers = new ArrayList<ContainerBuilder>();}
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("initContainers").add(builder);this.initContainers.add(builder);} return (A)this;
  }
  public A addAllToInitContainers(Collection<Container> items) {
    if (this.initContainers == null) {this.initContainers = new ArrayList<ContainerBuilder>();}
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("initContainers").add(builder);this.initContainers.add(builder);} return (A)this;
  }
  public A removeFromInitContainers(io.fabric8.kubernetes.api.model.Container... items) {
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("initContainers").remove(builder);if (this.initContainers != null) {this.initContainers.remove(builder);}} return (A)this;
  }
  public A removeAllFromInitContainers(Collection<Container> items) {
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("initContainers").remove(builder);if (this.initContainers != null) {this.initContainers.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromInitContainers(Predicate<ContainerBuilder> predicate) {
    if (initContainers == null) return (A) this;
    final Iterator<ContainerBuilder> each = initContainers.iterator();
    final List visitables = _visitables.get("initContainers");
    while (each.hasNext()) {
      ContainerBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildInitContainers instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Container> getInitContainers() {
    return initContainers != null ? build(initContainers) : null;
  }
  public List<Container> buildInitContainers() {
    return initContainers != null ? build(initContainers) : null;
  }
  public Container buildInitContainer(int index) {
    return this.initContainers.get(index).build();
  }
  public Container buildFirstInitContainer() {
    return this.initContainers.get(0).build();
  }
  public Container buildLastInitContainer() {
    return this.initContainers.get(initContainers.size() - 1).build();
  }
  public Container buildMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
    for (ContainerBuilder item: initContainers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
    for (ContainerBuilder item: initContainers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withInitContainers(List<Container> initContainers) {
    if (this.initContainers != null) { _visitables.get("initContainers").clear();}
    if (initContainers != null) {this.initContainers = new ArrayList(); for (Container item : initContainers){this.addToInitContainers(item);}} else { this.initContainers = null;} return (A) this;
  }
  public A withInitContainers(io.fabric8.kubernetes.api.model.Container... initContainers) {
    if (this.initContainers != null) {this.initContainers.clear(); _visitables.remove("initContainers"); }
    if (initContainers != null) {for (Container item :initContainers){ this.addToInitContainers(item);}} return (A) this;
  }
  public Boolean hasInitContainers() {
    return initContainers != null && !initContainers.isEmpty();
  }
  public PrometheusSpecFluentImpl.InitContainersNested<A> addNewInitContainer() {
    return new PrometheusSpecFluentImpl.InitContainersNestedImpl();
  }
  public PrometheusSpecFluentImpl.InitContainersNested<A> addNewInitContainerLike(Container item) {
    return new PrometheusSpecFluentImpl.InitContainersNestedImpl(-1, item);
  }
  public PrometheusSpecFluentImpl.InitContainersNested<A> setNewInitContainerLike(int index,Container item) {
    return new PrometheusSpecFluentImpl.InitContainersNestedImpl(index, item);
  }
  public PrometheusSpecFluentImpl.InitContainersNested<A> editInitContainer(int index) {
    if (initContainers.size() <= index) throw new RuntimeException("Can't edit initContainers. Index exceeds size.");
    return setNewInitContainerLike(index, buildInitContainer(index));
  }
  public PrometheusSpecFluentImpl.InitContainersNested<A> editFirstInitContainer() {
    if (initContainers.size() == 0) throw new RuntimeException("Can't edit first initContainers. The list is empty.");
    return setNewInitContainerLike(0, buildInitContainer(0));
  }
  public PrometheusSpecFluentImpl.InitContainersNested<A> editLastInitContainer() {
    int index = initContainers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last initContainers. The list is empty.");
    return setNewInitContainerLike(index, buildInitContainer(index));
  }
  public PrometheusSpecFluentImpl.InitContainersNested<A> editMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
    int index = -1;
    for (int i=0;i<initContainers.size();i++) { 
    if (predicate.test(initContainers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching initContainers. No match found.");
    return setNewInitContainerLike(index, buildInitContainer(index));
  }
  public Boolean getListenLocal() {
    return this.listenLocal;
  }
  public A withListenLocal(Boolean listenLocal) {
    this.listenLocal=listenLocal; return (A) this;
  }
  public Boolean hasListenLocal() {
    return this.listenLocal != null;
  }
  public String getLogFormat() {
    return this.logFormat;
  }
  public A withLogFormat(String logFormat) {
    this.logFormat=logFormat; return (A) this;
  }
  public Boolean hasLogFormat() {
    return this.logFormat != null;
  }
  public String getLogLevel() {
    return this.logLevel;
  }
  public A withLogLevel(String logLevel) {
    this.logLevel=logLevel; return (A) this;
  }
  public Boolean hasLogLevel() {
    return this.logLevel != null;
  }
  public Integer getMinReadySeconds() {
    return this.minReadySeconds;
  }
  public A withMinReadySeconds(Integer minReadySeconds) {
    this.minReadySeconds=minReadySeconds; return (A) this;
  }
  public Boolean hasMinReadySeconds() {
    return this.minReadySeconds != null;
  }
  public A addToNodeSelector(String key,String value) {
    if(this.nodeSelector == null && key != null && value != null) { this.nodeSelector = new LinkedHashMap(); }
    if(key != null && value != null) {this.nodeSelector.put(key, value);} return (A)this;
  }
  public A addToNodeSelector(Map<String,String> map) {
    if(this.nodeSelector == null && map != null) { this.nodeSelector = new LinkedHashMap(); }
    if(map != null) { this.nodeSelector.putAll(map);} return (A)this;
  }
  public A removeFromNodeSelector(String key) {
    if(this.nodeSelector == null) { return (A) this; }
    if(key != null && this.nodeSelector != null) {this.nodeSelector.remove(key);} return (A)this;
  }
  public A removeFromNodeSelector(Map<String,String> map) {
    if(this.nodeSelector == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.nodeSelector != null){this.nodeSelector.remove(key);}}} return (A)this;
  }
  public Map<String,String> getNodeSelector() {
    return this.nodeSelector;
  }
  public <K,V>A withNodeSelector(Map<String,String> nodeSelector) {
    if (nodeSelector == null) { this.nodeSelector =  null;} else {this.nodeSelector = new LinkedHashMap(nodeSelector);} return (A) this;
  }
  public Boolean hasNodeSelector() {
    return this.nodeSelector != null;
  }
  public Boolean getOverrideHonorLabels() {
    return this.overrideHonorLabels;
  }
  public A withOverrideHonorLabels(Boolean overrideHonorLabels) {
    this.overrideHonorLabels=overrideHonorLabels; return (A) this;
  }
  public Boolean hasOverrideHonorLabels() {
    return this.overrideHonorLabels != null;
  }
  public Boolean getOverrideHonorTimestamps() {
    return this.overrideHonorTimestamps;
  }
  public A withOverrideHonorTimestamps(Boolean overrideHonorTimestamps) {
    this.overrideHonorTimestamps=overrideHonorTimestamps; return (A) this;
  }
  public Boolean hasOverrideHonorTimestamps() {
    return this.overrideHonorTimestamps != null;
  }
  public Boolean getPaused() {
    return this.paused;
  }
  public A withPaused(Boolean paused) {
    this.paused=paused; return (A) this;
  }
  public Boolean hasPaused() {
    return this.paused != null;
  }
  
  /**
   * This method has been deprecated, please use method buildPodMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public EmbeddedObjectMetadata getPodMetadata() {
    return this.podMetadata!=null ?this.podMetadata.build():null;
  }
  public EmbeddedObjectMetadata buildPodMetadata() {
    return this.podMetadata!=null ?this.podMetadata.build():null;
  }
  public A withPodMetadata(EmbeddedObjectMetadata podMetadata) {
    _visitables.get("podMetadata").remove(this.podMetadata);
    if (podMetadata!=null){ this.podMetadata= new EmbeddedObjectMetadataBuilder(podMetadata); _visitables.get("podMetadata").add(this.podMetadata);} else { this.podMetadata = null; _visitables.get("podMetadata").remove(this.podMetadata); } return (A) this;
  }
  public Boolean hasPodMetadata() {
    return this.podMetadata != null;
  }
  public PrometheusSpecFluentImpl.PodMetadataNested<A> withNewPodMetadata() {
    return new PrometheusSpecFluentImpl.PodMetadataNestedImpl();
  }
  public PrometheusSpecFluentImpl.PodMetadataNested<A> withNewPodMetadataLike(EmbeddedObjectMetadata item) {
    return new PrometheusSpecFluentImpl.PodMetadataNestedImpl(item);
  }
  public PrometheusSpecFluentImpl.PodMetadataNested<A> editPodMetadata() {
    return withNewPodMetadataLike(getPodMetadata());
  }
  public PrometheusSpecFluentImpl.PodMetadataNested<A> editOrNewPodMetadata() {
    return withNewPodMetadataLike(getPodMetadata() != null ? getPodMetadata(): new EmbeddedObjectMetadataBuilder().build());
  }
  public PrometheusSpecFluentImpl.PodMetadataNested<A> editOrNewPodMetadataLike(EmbeddedObjectMetadata item) {
    return withNewPodMetadataLike(getPodMetadata() != null ? getPodMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPodMonitorNamespaceSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getPodMonitorNamespaceSelector() {
    return this.podMonitorNamespaceSelector!=null ?this.podMonitorNamespaceSelector.build():null;
  }
  public LabelSelector buildPodMonitorNamespaceSelector() {
    return this.podMonitorNamespaceSelector!=null ?this.podMonitorNamespaceSelector.build():null;
  }
  public A withPodMonitorNamespaceSelector(LabelSelector podMonitorNamespaceSelector) {
    _visitables.get("podMonitorNamespaceSelector").remove(this.podMonitorNamespaceSelector);
    if (podMonitorNamespaceSelector!=null){ this.podMonitorNamespaceSelector= new LabelSelectorBuilder(podMonitorNamespaceSelector); _visitables.get("podMonitorNamespaceSelector").add(this.podMonitorNamespaceSelector);} else { this.podMonitorNamespaceSelector = null; _visitables.get("podMonitorNamespaceSelector").remove(this.podMonitorNamespaceSelector); } return (A) this;
  }
  public Boolean hasPodMonitorNamespaceSelector() {
    return this.podMonitorNamespaceSelector != null;
  }
  public PrometheusSpecFluentImpl.PodMonitorNamespaceSelectorNested<A> withNewPodMonitorNamespaceSelector() {
    return new PrometheusSpecFluentImpl.PodMonitorNamespaceSelectorNestedImpl();
  }
  public PrometheusSpecFluentImpl.PodMonitorNamespaceSelectorNested<A> withNewPodMonitorNamespaceSelectorLike(LabelSelector item) {
    return new PrometheusSpecFluentImpl.PodMonitorNamespaceSelectorNestedImpl(item);
  }
  public PrometheusSpecFluentImpl.PodMonitorNamespaceSelectorNested<A> editPodMonitorNamespaceSelector() {
    return withNewPodMonitorNamespaceSelectorLike(getPodMonitorNamespaceSelector());
  }
  public PrometheusSpecFluentImpl.PodMonitorNamespaceSelectorNested<A> editOrNewPodMonitorNamespaceSelector() {
    return withNewPodMonitorNamespaceSelectorLike(getPodMonitorNamespaceSelector() != null ? getPodMonitorNamespaceSelector(): new LabelSelectorBuilder().build());
  }
  public PrometheusSpecFluentImpl.PodMonitorNamespaceSelectorNested<A> editOrNewPodMonitorNamespaceSelectorLike(LabelSelector item) {
    return withNewPodMonitorNamespaceSelectorLike(getPodMonitorNamespaceSelector() != null ? getPodMonitorNamespaceSelector(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPodMonitorSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getPodMonitorSelector() {
    return this.podMonitorSelector!=null ?this.podMonitorSelector.build():null;
  }
  public LabelSelector buildPodMonitorSelector() {
    return this.podMonitorSelector!=null ?this.podMonitorSelector.build():null;
  }
  public A withPodMonitorSelector(LabelSelector podMonitorSelector) {
    _visitables.get("podMonitorSelector").remove(this.podMonitorSelector);
    if (podMonitorSelector!=null){ this.podMonitorSelector= new LabelSelectorBuilder(podMonitorSelector); _visitables.get("podMonitorSelector").add(this.podMonitorSelector);} else { this.podMonitorSelector = null; _visitables.get("podMonitorSelector").remove(this.podMonitorSelector); } return (A) this;
  }
  public Boolean hasPodMonitorSelector() {
    return this.podMonitorSelector != null;
  }
  public PrometheusSpecFluentImpl.PodMonitorSelectorNested<A> withNewPodMonitorSelector() {
    return new PrometheusSpecFluentImpl.PodMonitorSelectorNestedImpl();
  }
  public PrometheusSpecFluentImpl.PodMonitorSelectorNested<A> withNewPodMonitorSelectorLike(LabelSelector item) {
    return new PrometheusSpecFluentImpl.PodMonitorSelectorNestedImpl(item);
  }
  public PrometheusSpecFluentImpl.PodMonitorSelectorNested<A> editPodMonitorSelector() {
    return withNewPodMonitorSelectorLike(getPodMonitorSelector());
  }
  public PrometheusSpecFluentImpl.PodMonitorSelectorNested<A> editOrNewPodMonitorSelector() {
    return withNewPodMonitorSelectorLike(getPodMonitorSelector() != null ? getPodMonitorSelector(): new LabelSelectorBuilder().build());
  }
  public PrometheusSpecFluentImpl.PodMonitorSelectorNested<A> editOrNewPodMonitorSelectorLike(LabelSelector item) {
    return withNewPodMonitorSelectorLike(getPodMonitorSelector() != null ? getPodMonitorSelector(): item);
  }
  public String getPortName() {
    return this.portName;
  }
  public A withPortName(String portName) {
    this.portName=portName; return (A) this;
  }
  public Boolean hasPortName() {
    return this.portName != null;
  }
  public String getPriorityClassName() {
    return this.priorityClassName;
  }
  public A withPriorityClassName(String priorityClassName) {
    this.priorityClassName=priorityClassName; return (A) this;
  }
  public Boolean hasPriorityClassName() {
    return this.priorityClassName != null;
  }
  
  /**
   * This method has been deprecated, please use method buildProbeNamespaceSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getProbeNamespaceSelector() {
    return this.probeNamespaceSelector!=null ?this.probeNamespaceSelector.build():null;
  }
  public LabelSelector buildProbeNamespaceSelector() {
    return this.probeNamespaceSelector!=null ?this.probeNamespaceSelector.build():null;
  }
  public A withProbeNamespaceSelector(LabelSelector probeNamespaceSelector) {
    _visitables.get("probeNamespaceSelector").remove(this.probeNamespaceSelector);
    if (probeNamespaceSelector!=null){ this.probeNamespaceSelector= new LabelSelectorBuilder(probeNamespaceSelector); _visitables.get("probeNamespaceSelector").add(this.probeNamespaceSelector);} else { this.probeNamespaceSelector = null; _visitables.get("probeNamespaceSelector").remove(this.probeNamespaceSelector); } return (A) this;
  }
  public Boolean hasProbeNamespaceSelector() {
    return this.probeNamespaceSelector != null;
  }
  public PrometheusSpecFluentImpl.ProbeNamespaceSelectorNested<A> withNewProbeNamespaceSelector() {
    return new PrometheusSpecFluentImpl.ProbeNamespaceSelectorNestedImpl();
  }
  public PrometheusSpecFluentImpl.ProbeNamespaceSelectorNested<A> withNewProbeNamespaceSelectorLike(LabelSelector item) {
    return new PrometheusSpecFluentImpl.ProbeNamespaceSelectorNestedImpl(item);
  }
  public PrometheusSpecFluentImpl.ProbeNamespaceSelectorNested<A> editProbeNamespaceSelector() {
    return withNewProbeNamespaceSelectorLike(getProbeNamespaceSelector());
  }
  public PrometheusSpecFluentImpl.ProbeNamespaceSelectorNested<A> editOrNewProbeNamespaceSelector() {
    return withNewProbeNamespaceSelectorLike(getProbeNamespaceSelector() != null ? getProbeNamespaceSelector(): new LabelSelectorBuilder().build());
  }
  public PrometheusSpecFluentImpl.ProbeNamespaceSelectorNested<A> editOrNewProbeNamespaceSelectorLike(LabelSelector item) {
    return withNewProbeNamespaceSelectorLike(getProbeNamespaceSelector() != null ? getProbeNamespaceSelector(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildProbeSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getProbeSelector() {
    return this.probeSelector!=null ?this.probeSelector.build():null;
  }
  public LabelSelector buildProbeSelector() {
    return this.probeSelector!=null ?this.probeSelector.build():null;
  }
  public A withProbeSelector(LabelSelector probeSelector) {
    _visitables.get("probeSelector").remove(this.probeSelector);
    if (probeSelector!=null){ this.probeSelector= new LabelSelectorBuilder(probeSelector); _visitables.get("probeSelector").add(this.probeSelector);} else { this.probeSelector = null; _visitables.get("probeSelector").remove(this.probeSelector); } return (A) this;
  }
  public Boolean hasProbeSelector() {
    return this.probeSelector != null;
  }
  public PrometheusSpecFluentImpl.ProbeSelectorNested<A> withNewProbeSelector() {
    return new PrometheusSpecFluentImpl.ProbeSelectorNestedImpl();
  }
  public PrometheusSpecFluentImpl.ProbeSelectorNested<A> withNewProbeSelectorLike(LabelSelector item) {
    return new PrometheusSpecFluentImpl.ProbeSelectorNestedImpl(item);
  }
  public PrometheusSpecFluentImpl.ProbeSelectorNested<A> editProbeSelector() {
    return withNewProbeSelectorLike(getProbeSelector());
  }
  public PrometheusSpecFluentImpl.ProbeSelectorNested<A> editOrNewProbeSelector() {
    return withNewProbeSelectorLike(getProbeSelector() != null ? getProbeSelector(): new LabelSelectorBuilder().build());
  }
  public PrometheusSpecFluentImpl.ProbeSelectorNested<A> editOrNewProbeSelectorLike(LabelSelector item) {
    return withNewProbeSelectorLike(getProbeSelector() != null ? getProbeSelector(): item);
  }
  public String getPrometheusExternalLabelName() {
    return this.prometheusExternalLabelName;
  }
  public A withPrometheusExternalLabelName(String prometheusExternalLabelName) {
    this.prometheusExternalLabelName=prometheusExternalLabelName; return (A) this;
  }
  public Boolean hasPrometheusExternalLabelName() {
    return this.prometheusExternalLabelName != null;
  }
  public A addToPrometheusRulesExcludedFromEnforce(int index,PrometheusRuleExcludeConfig item) {
    if (this.prometheusRulesExcludedFromEnforce == null) {this.prometheusRulesExcludedFromEnforce = new ArrayList<PrometheusRuleExcludeConfigBuilder>();}
    PrometheusRuleExcludeConfigBuilder builder = new PrometheusRuleExcludeConfigBuilder(item);
    if (index < 0 || index >= prometheusRulesExcludedFromEnforce.size()) { _visitables.get("prometheusRulesExcludedFromEnforce").add(builder); prometheusRulesExcludedFromEnforce.add(builder); } else { _visitables.get("prometheusRulesExcludedFromEnforce").add(index, builder); prometheusRulesExcludedFromEnforce.add(index, builder);}
    return (A)this;
  }
  public A setToPrometheusRulesExcludedFromEnforce(int index,PrometheusRuleExcludeConfig item) {
    if (this.prometheusRulesExcludedFromEnforce == null) {this.prometheusRulesExcludedFromEnforce = new ArrayList<PrometheusRuleExcludeConfigBuilder>();}
    PrometheusRuleExcludeConfigBuilder builder = new PrometheusRuleExcludeConfigBuilder(item);
    if (index < 0 || index >= prometheusRulesExcludedFromEnforce.size()) { _visitables.get("prometheusRulesExcludedFromEnforce").add(builder); prometheusRulesExcludedFromEnforce.add(builder); } else { _visitables.get("prometheusRulesExcludedFromEnforce").set(index, builder); prometheusRulesExcludedFromEnforce.set(index, builder);}
    return (A)this;
  }
  public A addToPrometheusRulesExcludedFromEnforce(io.fabric8.openshift.api.model.monitoring.v1.PrometheusRuleExcludeConfig... items) {
    if (this.prometheusRulesExcludedFromEnforce == null) {this.prometheusRulesExcludedFromEnforce = new ArrayList<PrometheusRuleExcludeConfigBuilder>();}
    for (PrometheusRuleExcludeConfig item : items) {PrometheusRuleExcludeConfigBuilder builder = new PrometheusRuleExcludeConfigBuilder(item);_visitables.get("prometheusRulesExcludedFromEnforce").add(builder);this.prometheusRulesExcludedFromEnforce.add(builder);} return (A)this;
  }
  public A addAllToPrometheusRulesExcludedFromEnforce(Collection<PrometheusRuleExcludeConfig> items) {
    if (this.prometheusRulesExcludedFromEnforce == null) {this.prometheusRulesExcludedFromEnforce = new ArrayList<PrometheusRuleExcludeConfigBuilder>();}
    for (PrometheusRuleExcludeConfig item : items) {PrometheusRuleExcludeConfigBuilder builder = new PrometheusRuleExcludeConfigBuilder(item);_visitables.get("prometheusRulesExcludedFromEnforce").add(builder);this.prometheusRulesExcludedFromEnforce.add(builder);} return (A)this;
  }
  public A removeFromPrometheusRulesExcludedFromEnforce(io.fabric8.openshift.api.model.monitoring.v1.PrometheusRuleExcludeConfig... items) {
    for (PrometheusRuleExcludeConfig item : items) {PrometheusRuleExcludeConfigBuilder builder = new PrometheusRuleExcludeConfigBuilder(item);_visitables.get("prometheusRulesExcludedFromEnforce").remove(builder);if (this.prometheusRulesExcludedFromEnforce != null) {this.prometheusRulesExcludedFromEnforce.remove(builder);}} return (A)this;
  }
  public A removeAllFromPrometheusRulesExcludedFromEnforce(Collection<PrometheusRuleExcludeConfig> items) {
    for (PrometheusRuleExcludeConfig item : items) {PrometheusRuleExcludeConfigBuilder builder = new PrometheusRuleExcludeConfigBuilder(item);_visitables.get("prometheusRulesExcludedFromEnforce").remove(builder);if (this.prometheusRulesExcludedFromEnforce != null) {this.prometheusRulesExcludedFromEnforce.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromPrometheusRulesExcludedFromEnforce(Predicate<PrometheusRuleExcludeConfigBuilder> predicate) {
    if (prometheusRulesExcludedFromEnforce == null) return (A) this;
    final Iterator<PrometheusRuleExcludeConfigBuilder> each = prometheusRulesExcludedFromEnforce.iterator();
    final List visitables = _visitables.get("prometheusRulesExcludedFromEnforce");
    while (each.hasNext()) {
      PrometheusRuleExcludeConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildPrometheusRulesExcludedFromEnforce instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<PrometheusRuleExcludeConfig> getPrometheusRulesExcludedFromEnforce() {
    return prometheusRulesExcludedFromEnforce != null ? build(prometheusRulesExcludedFromEnforce) : null;
  }
  public List<PrometheusRuleExcludeConfig> buildPrometheusRulesExcludedFromEnforce() {
    return prometheusRulesExcludedFromEnforce != null ? build(prometheusRulesExcludedFromEnforce) : null;
  }
  public PrometheusRuleExcludeConfig buildPrometheusRulesExcludedFromEnforce(int index) {
    return this.prometheusRulesExcludedFromEnforce.get(index).build();
  }
  public PrometheusRuleExcludeConfig buildFirstPrometheusRulesExcludedFromEnforce() {
    return this.prometheusRulesExcludedFromEnforce.get(0).build();
  }
  public PrometheusRuleExcludeConfig buildLastPrometheusRulesExcludedFromEnforce() {
    return this.prometheusRulesExcludedFromEnforce.get(prometheusRulesExcludedFromEnforce.size() - 1).build();
  }
  public PrometheusRuleExcludeConfig buildMatchingPrometheusRulesExcludedFromEnforce(Predicate<PrometheusRuleExcludeConfigBuilder> predicate) {
    for (PrometheusRuleExcludeConfigBuilder item: prometheusRulesExcludedFromEnforce) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingPrometheusRulesExcludedFromEnforce(Predicate<PrometheusRuleExcludeConfigBuilder> predicate) {
    for (PrometheusRuleExcludeConfigBuilder item: prometheusRulesExcludedFromEnforce) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withPrometheusRulesExcludedFromEnforce(List<PrometheusRuleExcludeConfig> prometheusRulesExcludedFromEnforce) {
    if (this.prometheusRulesExcludedFromEnforce != null) { _visitables.get("prometheusRulesExcludedFromEnforce").clear();}
    if (prometheusRulesExcludedFromEnforce != null) {this.prometheusRulesExcludedFromEnforce = new ArrayList(); for (PrometheusRuleExcludeConfig item : prometheusRulesExcludedFromEnforce){this.addToPrometheusRulesExcludedFromEnforce(item);}} else { this.prometheusRulesExcludedFromEnforce = null;} return (A) this;
  }
  public A withPrometheusRulesExcludedFromEnforce(io.fabric8.openshift.api.model.monitoring.v1.PrometheusRuleExcludeConfig... prometheusRulesExcludedFromEnforce) {
    if (this.prometheusRulesExcludedFromEnforce != null) {this.prometheusRulesExcludedFromEnforce.clear(); _visitables.remove("prometheusRulesExcludedFromEnforce"); }
    if (prometheusRulesExcludedFromEnforce != null) {for (PrometheusRuleExcludeConfig item :prometheusRulesExcludedFromEnforce){ this.addToPrometheusRulesExcludedFromEnforce(item);}} return (A) this;
  }
  public Boolean hasPrometheusRulesExcludedFromEnforce() {
    return prometheusRulesExcludedFromEnforce != null && !prometheusRulesExcludedFromEnforce.isEmpty();
  }
  public A addNewPrometheusRulesExcludedFromEnforce(String ruleName,String ruleNamespace) {
    return (A)addToPrometheusRulesExcludedFromEnforce(new PrometheusRuleExcludeConfig(ruleName, ruleNamespace));
  }
  public PrometheusSpecFluentImpl.PrometheusRulesExcludedFromEnforceNested<A> addNewPrometheusRulesExcludedFromEnforce() {
    return new PrometheusSpecFluentImpl.PrometheusRulesExcludedFromEnforceNestedImpl();
  }
  public PrometheusSpecFluentImpl.PrometheusRulesExcludedFromEnforceNested<A> addNewPrometheusRulesExcludedFromEnforceLike(PrometheusRuleExcludeConfig item) {
    return new PrometheusSpecFluentImpl.PrometheusRulesExcludedFromEnforceNestedImpl(-1, item);
  }
  public PrometheusSpecFluentImpl.PrometheusRulesExcludedFromEnforceNested<A> setNewPrometheusRulesExcludedFromEnforceLike(int index,PrometheusRuleExcludeConfig item) {
    return new PrometheusSpecFluentImpl.PrometheusRulesExcludedFromEnforceNestedImpl(index, item);
  }
  public PrometheusSpecFluentImpl.PrometheusRulesExcludedFromEnforceNested<A> editPrometheusRulesExcludedFromEnforce(int index) {
    if (prometheusRulesExcludedFromEnforce.size() <= index) throw new RuntimeException("Can't edit prometheusRulesExcludedFromEnforce. Index exceeds size.");
    return setNewPrometheusRulesExcludedFromEnforceLike(index, buildPrometheusRulesExcludedFromEnforce(index));
  }
  public PrometheusSpecFluentImpl.PrometheusRulesExcludedFromEnforceNested<A> editFirstPrometheusRulesExcludedFromEnforce() {
    if (prometheusRulesExcludedFromEnforce.size() == 0) throw new RuntimeException("Can't edit first prometheusRulesExcludedFromEnforce. The list is empty.");
    return setNewPrometheusRulesExcludedFromEnforceLike(0, buildPrometheusRulesExcludedFromEnforce(0));
  }
  public PrometheusSpecFluentImpl.PrometheusRulesExcludedFromEnforceNested<A> editLastPrometheusRulesExcludedFromEnforce() {
    int index = prometheusRulesExcludedFromEnforce.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last prometheusRulesExcludedFromEnforce. The list is empty.");
    return setNewPrometheusRulesExcludedFromEnforceLike(index, buildPrometheusRulesExcludedFromEnforce(index));
  }
  public PrometheusSpecFluentImpl.PrometheusRulesExcludedFromEnforceNested<A> editMatchingPrometheusRulesExcludedFromEnforce(Predicate<PrometheusRuleExcludeConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<prometheusRulesExcludedFromEnforce.size();i++) { 
    if (predicate.test(prometheusRulesExcludedFromEnforce.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching prometheusRulesExcludedFromEnforce. No match found.");
    return setNewPrometheusRulesExcludedFromEnforceLike(index, buildPrometheusRulesExcludedFromEnforce(index));
  }
  
  /**
   * This method has been deprecated, please use method buildQuery instead.
   * @return The buildable object.
   */
  @Deprecated
  public QuerySpec getQuery() {
    return this.query!=null ?this.query.build():null;
  }
  public QuerySpec buildQuery() {
    return this.query!=null ?this.query.build():null;
  }
  public A withQuery(QuerySpec query) {
    _visitables.get("query").remove(this.query);
    if (query!=null){ this.query= new QuerySpecBuilder(query); _visitables.get("query").add(this.query);} else { this.query = null; _visitables.get("query").remove(this.query); } return (A) this;
  }
  public Boolean hasQuery() {
    return this.query != null;
  }
  public A withNewQuery(String lookbackDelta,Integer maxConcurrency,Integer maxSamples,String timeout) {
    return (A)withQuery(new QuerySpec(lookbackDelta, maxConcurrency, maxSamples, timeout));
  }
  public PrometheusSpecFluentImpl.QueryNested<A> withNewQuery() {
    return new PrometheusSpecFluentImpl.QueryNestedImpl();
  }
  public PrometheusSpecFluentImpl.QueryNested<A> withNewQueryLike(QuerySpec item) {
    return new PrometheusSpecFluentImpl.QueryNestedImpl(item);
  }
  public PrometheusSpecFluentImpl.QueryNested<A> editQuery() {
    return withNewQueryLike(getQuery());
  }
  public PrometheusSpecFluentImpl.QueryNested<A> editOrNewQuery() {
    return withNewQueryLike(getQuery() != null ? getQuery(): new QuerySpecBuilder().build());
  }
  public PrometheusSpecFluentImpl.QueryNested<A> editOrNewQueryLike(QuerySpec item) {
    return withNewQueryLike(getQuery() != null ? getQuery(): item);
  }
  public String getQueryLogFile() {
    return this.queryLogFile;
  }
  public A withQueryLogFile(String queryLogFile) {
    this.queryLogFile=queryLogFile; return (A) this;
  }
  public Boolean hasQueryLogFile() {
    return this.queryLogFile != null;
  }
  public A addToRemoteRead(int index,RemoteReadSpec item) {
    if (this.remoteRead == null) {this.remoteRead = new ArrayList<RemoteReadSpecBuilder>();}
    RemoteReadSpecBuilder builder = new RemoteReadSpecBuilder(item);
    if (index < 0 || index >= remoteRead.size()) { _visitables.get("remoteRead").add(builder); remoteRead.add(builder); } else { _visitables.get("remoteRead").add(index, builder); remoteRead.add(index, builder);}
    return (A)this;
  }
  public A setToRemoteRead(int index,RemoteReadSpec item) {
    if (this.remoteRead == null) {this.remoteRead = new ArrayList<RemoteReadSpecBuilder>();}
    RemoteReadSpecBuilder builder = new RemoteReadSpecBuilder(item);
    if (index < 0 || index >= remoteRead.size()) { _visitables.get("remoteRead").add(builder); remoteRead.add(builder); } else { _visitables.get("remoteRead").set(index, builder); remoteRead.set(index, builder);}
    return (A)this;
  }
  public A addToRemoteRead(io.fabric8.openshift.api.model.monitoring.v1.RemoteReadSpec... items) {
    if (this.remoteRead == null) {this.remoteRead = new ArrayList<RemoteReadSpecBuilder>();}
    for (RemoteReadSpec item : items) {RemoteReadSpecBuilder builder = new RemoteReadSpecBuilder(item);_visitables.get("remoteRead").add(builder);this.remoteRead.add(builder);} return (A)this;
  }
  public A addAllToRemoteRead(Collection<RemoteReadSpec> items) {
    if (this.remoteRead == null) {this.remoteRead = new ArrayList<RemoteReadSpecBuilder>();}
    for (RemoteReadSpec item : items) {RemoteReadSpecBuilder builder = new RemoteReadSpecBuilder(item);_visitables.get("remoteRead").add(builder);this.remoteRead.add(builder);} return (A)this;
  }
  public A removeFromRemoteRead(io.fabric8.openshift.api.model.monitoring.v1.RemoteReadSpec... items) {
    for (RemoteReadSpec item : items) {RemoteReadSpecBuilder builder = new RemoteReadSpecBuilder(item);_visitables.get("remoteRead").remove(builder);if (this.remoteRead != null) {this.remoteRead.remove(builder);}} return (A)this;
  }
  public A removeAllFromRemoteRead(Collection<RemoteReadSpec> items) {
    for (RemoteReadSpec item : items) {RemoteReadSpecBuilder builder = new RemoteReadSpecBuilder(item);_visitables.get("remoteRead").remove(builder);if (this.remoteRead != null) {this.remoteRead.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromRemoteRead(Predicate<RemoteReadSpecBuilder> predicate) {
    if (remoteRead == null) return (A) this;
    final Iterator<RemoteReadSpecBuilder> each = remoteRead.iterator();
    final List visitables = _visitables.get("remoteRead");
    while (each.hasNext()) {
      RemoteReadSpecBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildRemoteRead instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<RemoteReadSpec> getRemoteRead() {
    return remoteRead != null ? build(remoteRead) : null;
  }
  public List<RemoteReadSpec> buildRemoteRead() {
    return remoteRead != null ? build(remoteRead) : null;
  }
  public RemoteReadSpec buildRemoteRead(int index) {
    return this.remoteRead.get(index).build();
  }
  public RemoteReadSpec buildFirstRemoteRead() {
    return this.remoteRead.get(0).build();
  }
  public RemoteReadSpec buildLastRemoteRead() {
    return this.remoteRead.get(remoteRead.size() - 1).build();
  }
  public RemoteReadSpec buildMatchingRemoteRead(Predicate<RemoteReadSpecBuilder> predicate) {
    for (RemoteReadSpecBuilder item: remoteRead) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingRemoteRead(Predicate<RemoteReadSpecBuilder> predicate) {
    for (RemoteReadSpecBuilder item: remoteRead) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRemoteRead(List<RemoteReadSpec> remoteRead) {
    if (this.remoteRead != null) { _visitables.get("remoteRead").clear();}
    if (remoteRead != null) {this.remoteRead = new ArrayList(); for (RemoteReadSpec item : remoteRead){this.addToRemoteRead(item);}} else { this.remoteRead = null;} return (A) this;
  }
  public A withRemoteRead(io.fabric8.openshift.api.model.monitoring.v1.RemoteReadSpec... remoteRead) {
    if (this.remoteRead != null) {this.remoteRead.clear(); _visitables.remove("remoteRead"); }
    if (remoteRead != null) {for (RemoteReadSpec item :remoteRead){ this.addToRemoteRead(item);}} return (A) this;
  }
  public Boolean hasRemoteRead() {
    return remoteRead != null && !remoteRead.isEmpty();
  }
  public PrometheusSpecFluentImpl.RemoteReadNested<A> addNewRemoteRead() {
    return new PrometheusSpecFluentImpl.RemoteReadNestedImpl();
  }
  public PrometheusSpecFluentImpl.RemoteReadNested<A> addNewRemoteReadLike(RemoteReadSpec item) {
    return new PrometheusSpecFluentImpl.RemoteReadNestedImpl(-1, item);
  }
  public PrometheusSpecFluentImpl.RemoteReadNested<A> setNewRemoteReadLike(int index,RemoteReadSpec item) {
    return new PrometheusSpecFluentImpl.RemoteReadNestedImpl(index, item);
  }
  public PrometheusSpecFluentImpl.RemoteReadNested<A> editRemoteRead(int index) {
    if (remoteRead.size() <= index) throw new RuntimeException("Can't edit remoteRead. Index exceeds size.");
    return setNewRemoteReadLike(index, buildRemoteRead(index));
  }
  public PrometheusSpecFluentImpl.RemoteReadNested<A> editFirstRemoteRead() {
    if (remoteRead.size() == 0) throw new RuntimeException("Can't edit first remoteRead. The list is empty.");
    return setNewRemoteReadLike(0, buildRemoteRead(0));
  }
  public PrometheusSpecFluentImpl.RemoteReadNested<A> editLastRemoteRead() {
    int index = remoteRead.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last remoteRead. The list is empty.");
    return setNewRemoteReadLike(index, buildRemoteRead(index));
  }
  public PrometheusSpecFluentImpl.RemoteReadNested<A> editMatchingRemoteRead(Predicate<RemoteReadSpecBuilder> predicate) {
    int index = -1;
    for (int i=0;i<remoteRead.size();i++) { 
    if (predicate.test(remoteRead.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching remoteRead. No match found.");
    return setNewRemoteReadLike(index, buildRemoteRead(index));
  }
  public A addToRemoteWrite(int index,RemoteWriteSpec item) {
    if (this.remoteWrite == null) {this.remoteWrite = new ArrayList<RemoteWriteSpecBuilder>();}
    RemoteWriteSpecBuilder builder = new RemoteWriteSpecBuilder(item);
    if (index < 0 || index >= remoteWrite.size()) { _visitables.get("remoteWrite").add(builder); remoteWrite.add(builder); } else { _visitables.get("remoteWrite").add(index, builder); remoteWrite.add(index, builder);}
    return (A)this;
  }
  public A setToRemoteWrite(int index,RemoteWriteSpec item) {
    if (this.remoteWrite == null) {this.remoteWrite = new ArrayList<RemoteWriteSpecBuilder>();}
    RemoteWriteSpecBuilder builder = new RemoteWriteSpecBuilder(item);
    if (index < 0 || index >= remoteWrite.size()) { _visitables.get("remoteWrite").add(builder); remoteWrite.add(builder); } else { _visitables.get("remoteWrite").set(index, builder); remoteWrite.set(index, builder);}
    return (A)this;
  }
  public A addToRemoteWrite(io.fabric8.openshift.api.model.monitoring.v1.RemoteWriteSpec... items) {
    if (this.remoteWrite == null) {this.remoteWrite = new ArrayList<RemoteWriteSpecBuilder>();}
    for (RemoteWriteSpec item : items) {RemoteWriteSpecBuilder builder = new RemoteWriteSpecBuilder(item);_visitables.get("remoteWrite").add(builder);this.remoteWrite.add(builder);} return (A)this;
  }
  public A addAllToRemoteWrite(Collection<RemoteWriteSpec> items) {
    if (this.remoteWrite == null) {this.remoteWrite = new ArrayList<RemoteWriteSpecBuilder>();}
    for (RemoteWriteSpec item : items) {RemoteWriteSpecBuilder builder = new RemoteWriteSpecBuilder(item);_visitables.get("remoteWrite").add(builder);this.remoteWrite.add(builder);} return (A)this;
  }
  public A removeFromRemoteWrite(io.fabric8.openshift.api.model.monitoring.v1.RemoteWriteSpec... items) {
    for (RemoteWriteSpec item : items) {RemoteWriteSpecBuilder builder = new RemoteWriteSpecBuilder(item);_visitables.get("remoteWrite").remove(builder);if (this.remoteWrite != null) {this.remoteWrite.remove(builder);}} return (A)this;
  }
  public A removeAllFromRemoteWrite(Collection<RemoteWriteSpec> items) {
    for (RemoteWriteSpec item : items) {RemoteWriteSpecBuilder builder = new RemoteWriteSpecBuilder(item);_visitables.get("remoteWrite").remove(builder);if (this.remoteWrite != null) {this.remoteWrite.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromRemoteWrite(Predicate<RemoteWriteSpecBuilder> predicate) {
    if (remoteWrite == null) return (A) this;
    final Iterator<RemoteWriteSpecBuilder> each = remoteWrite.iterator();
    final List visitables = _visitables.get("remoteWrite");
    while (each.hasNext()) {
      RemoteWriteSpecBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildRemoteWrite instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<RemoteWriteSpec> getRemoteWrite() {
    return remoteWrite != null ? build(remoteWrite) : null;
  }
  public List<RemoteWriteSpec> buildRemoteWrite() {
    return remoteWrite != null ? build(remoteWrite) : null;
  }
  public RemoteWriteSpec buildRemoteWrite(int index) {
    return this.remoteWrite.get(index).build();
  }
  public RemoteWriteSpec buildFirstRemoteWrite() {
    return this.remoteWrite.get(0).build();
  }
  public RemoteWriteSpec buildLastRemoteWrite() {
    return this.remoteWrite.get(remoteWrite.size() - 1).build();
  }
  public RemoteWriteSpec buildMatchingRemoteWrite(Predicate<RemoteWriteSpecBuilder> predicate) {
    for (RemoteWriteSpecBuilder item: remoteWrite) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingRemoteWrite(Predicate<RemoteWriteSpecBuilder> predicate) {
    for (RemoteWriteSpecBuilder item: remoteWrite) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRemoteWrite(List<RemoteWriteSpec> remoteWrite) {
    if (this.remoteWrite != null) { _visitables.get("remoteWrite").clear();}
    if (remoteWrite != null) {this.remoteWrite = new ArrayList(); for (RemoteWriteSpec item : remoteWrite){this.addToRemoteWrite(item);}} else { this.remoteWrite = null;} return (A) this;
  }
  public A withRemoteWrite(io.fabric8.openshift.api.model.monitoring.v1.RemoteWriteSpec... remoteWrite) {
    if (this.remoteWrite != null) {this.remoteWrite.clear(); _visitables.remove("remoteWrite"); }
    if (remoteWrite != null) {for (RemoteWriteSpec item :remoteWrite){ this.addToRemoteWrite(item);}} return (A) this;
  }
  public Boolean hasRemoteWrite() {
    return remoteWrite != null && !remoteWrite.isEmpty();
  }
  public PrometheusSpecFluentImpl.RemoteWriteNested<A> addNewRemoteWrite() {
    return new PrometheusSpecFluentImpl.RemoteWriteNestedImpl();
  }
  public PrometheusSpecFluentImpl.RemoteWriteNested<A> addNewRemoteWriteLike(RemoteWriteSpec item) {
    return new PrometheusSpecFluentImpl.RemoteWriteNestedImpl(-1, item);
  }
  public PrometheusSpecFluentImpl.RemoteWriteNested<A> setNewRemoteWriteLike(int index,RemoteWriteSpec item) {
    return new PrometheusSpecFluentImpl.RemoteWriteNestedImpl(index, item);
  }
  public PrometheusSpecFluentImpl.RemoteWriteNested<A> editRemoteWrite(int index) {
    if (remoteWrite.size() <= index) throw new RuntimeException("Can't edit remoteWrite. Index exceeds size.");
    return setNewRemoteWriteLike(index, buildRemoteWrite(index));
  }
  public PrometheusSpecFluentImpl.RemoteWriteNested<A> editFirstRemoteWrite() {
    if (remoteWrite.size() == 0) throw new RuntimeException("Can't edit first remoteWrite. The list is empty.");
    return setNewRemoteWriteLike(0, buildRemoteWrite(0));
  }
  public PrometheusSpecFluentImpl.RemoteWriteNested<A> editLastRemoteWrite() {
    int index = remoteWrite.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last remoteWrite. The list is empty.");
    return setNewRemoteWriteLike(index, buildRemoteWrite(index));
  }
  public PrometheusSpecFluentImpl.RemoteWriteNested<A> editMatchingRemoteWrite(Predicate<RemoteWriteSpecBuilder> predicate) {
    int index = -1;
    for (int i=0;i<remoteWrite.size();i++) { 
    if (predicate.test(remoteWrite.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching remoteWrite. No match found.");
    return setNewRemoteWriteLike(index, buildRemoteWrite(index));
  }
  public String getReplicaExternalLabelName() {
    return this.replicaExternalLabelName;
  }
  public A withReplicaExternalLabelName(String replicaExternalLabelName) {
    this.replicaExternalLabelName=replicaExternalLabelName; return (A) this;
  }
  public Boolean hasReplicaExternalLabelName() {
    return this.replicaExternalLabelName != null;
  }
  public Integer getReplicas() {
    return this.replicas;
  }
  public A withReplicas(Integer replicas) {
    this.replicas=replicas; return (A) this;
  }
  public Boolean hasReplicas() {
    return this.replicas != null;
  }
  
  /**
   * This method has been deprecated, please use method buildResources instead.
   * @return The buildable object.
   */
  @Deprecated
  public ResourceRequirements getResources() {
    return this.resources!=null ?this.resources.build():null;
  }
  public ResourceRequirements buildResources() {
    return this.resources!=null ?this.resources.build():null;
  }
  public A withResources(ResourceRequirements resources) {
    _visitables.get("resources").remove(this.resources);
    if (resources!=null){ this.resources= new ResourceRequirementsBuilder(resources); _visitables.get("resources").add(this.resources);} else { this.resources = null; _visitables.get("resources").remove(this.resources); } return (A) this;
  }
  public Boolean hasResources() {
    return this.resources != null;
  }
  public PrometheusSpecFluentImpl.ResourcesNested<A> withNewResources() {
    return new PrometheusSpecFluentImpl.ResourcesNestedImpl();
  }
  public PrometheusSpecFluentImpl.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
    return new PrometheusSpecFluentImpl.ResourcesNestedImpl(item);
  }
  public PrometheusSpecFluentImpl.ResourcesNested<A> editResources() {
    return withNewResourcesLike(getResources());
  }
  public PrometheusSpecFluentImpl.ResourcesNested<A> editOrNewResources() {
    return withNewResourcesLike(getResources() != null ? getResources(): new ResourceRequirementsBuilder().build());
  }
  public PrometheusSpecFluentImpl.ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item) {
    return withNewResourcesLike(getResources() != null ? getResources(): item);
  }
  public String getRetention() {
    return this.retention;
  }
  public A withRetention(String retention) {
    this.retention=retention; return (A) this;
  }
  public Boolean hasRetention() {
    return this.retention != null;
  }
  public String getRetentionSize() {
    return this.retentionSize;
  }
  public A withRetentionSize(String retentionSize) {
    this.retentionSize=retentionSize; return (A) this;
  }
  public Boolean hasRetentionSize() {
    return this.retentionSize != null;
  }
  public String getRoutePrefix() {
    return this.routePrefix;
  }
  public A withRoutePrefix(String routePrefix) {
    this.routePrefix=routePrefix; return (A) this;
  }
  public Boolean hasRoutePrefix() {
    return this.routePrefix != null;
  }
  
  /**
   * This method has been deprecated, please use method buildRuleNamespaceSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getRuleNamespaceSelector() {
    return this.ruleNamespaceSelector!=null ?this.ruleNamespaceSelector.build():null;
  }
  public LabelSelector buildRuleNamespaceSelector() {
    return this.ruleNamespaceSelector!=null ?this.ruleNamespaceSelector.build():null;
  }
  public A withRuleNamespaceSelector(LabelSelector ruleNamespaceSelector) {
    _visitables.get("ruleNamespaceSelector").remove(this.ruleNamespaceSelector);
    if (ruleNamespaceSelector!=null){ this.ruleNamespaceSelector= new LabelSelectorBuilder(ruleNamespaceSelector); _visitables.get("ruleNamespaceSelector").add(this.ruleNamespaceSelector);} else { this.ruleNamespaceSelector = null; _visitables.get("ruleNamespaceSelector").remove(this.ruleNamespaceSelector); } return (A) this;
  }
  public Boolean hasRuleNamespaceSelector() {
    return this.ruleNamespaceSelector != null;
  }
  public PrometheusSpecFluentImpl.RuleNamespaceSelectorNested<A> withNewRuleNamespaceSelector() {
    return new PrometheusSpecFluentImpl.RuleNamespaceSelectorNestedImpl();
  }
  public PrometheusSpecFluentImpl.RuleNamespaceSelectorNested<A> withNewRuleNamespaceSelectorLike(LabelSelector item) {
    return new PrometheusSpecFluentImpl.RuleNamespaceSelectorNestedImpl(item);
  }
  public PrometheusSpecFluentImpl.RuleNamespaceSelectorNested<A> editRuleNamespaceSelector() {
    return withNewRuleNamespaceSelectorLike(getRuleNamespaceSelector());
  }
  public PrometheusSpecFluentImpl.RuleNamespaceSelectorNested<A> editOrNewRuleNamespaceSelector() {
    return withNewRuleNamespaceSelectorLike(getRuleNamespaceSelector() != null ? getRuleNamespaceSelector(): new LabelSelectorBuilder().build());
  }
  public PrometheusSpecFluentImpl.RuleNamespaceSelectorNested<A> editOrNewRuleNamespaceSelectorLike(LabelSelector item) {
    return withNewRuleNamespaceSelectorLike(getRuleNamespaceSelector() != null ? getRuleNamespaceSelector(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildRuleSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getRuleSelector() {
    return this.ruleSelector!=null ?this.ruleSelector.build():null;
  }
  public LabelSelector buildRuleSelector() {
    return this.ruleSelector!=null ?this.ruleSelector.build():null;
  }
  public A withRuleSelector(LabelSelector ruleSelector) {
    _visitables.get("ruleSelector").remove(this.ruleSelector);
    if (ruleSelector!=null){ this.ruleSelector= new LabelSelectorBuilder(ruleSelector); _visitables.get("ruleSelector").add(this.ruleSelector);} else { this.ruleSelector = null; _visitables.get("ruleSelector").remove(this.ruleSelector); } return (A) this;
  }
  public Boolean hasRuleSelector() {
    return this.ruleSelector != null;
  }
  public PrometheusSpecFluentImpl.RuleSelectorNested<A> withNewRuleSelector() {
    return new PrometheusSpecFluentImpl.RuleSelectorNestedImpl();
  }
  public PrometheusSpecFluentImpl.RuleSelectorNested<A> withNewRuleSelectorLike(LabelSelector item) {
    return new PrometheusSpecFluentImpl.RuleSelectorNestedImpl(item);
  }
  public PrometheusSpecFluentImpl.RuleSelectorNested<A> editRuleSelector() {
    return withNewRuleSelectorLike(getRuleSelector());
  }
  public PrometheusSpecFluentImpl.RuleSelectorNested<A> editOrNewRuleSelector() {
    return withNewRuleSelectorLike(getRuleSelector() != null ? getRuleSelector(): new LabelSelectorBuilder().build());
  }
  public PrometheusSpecFluentImpl.RuleSelectorNested<A> editOrNewRuleSelectorLike(LabelSelector item) {
    return withNewRuleSelectorLike(getRuleSelector() != null ? getRuleSelector(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildRules instead.
   * @return The buildable object.
   */
  @Deprecated
  public Rules getRules() {
    return this.rules!=null ?this.rules.build():null;
  }
  public Rules buildRules() {
    return this.rules!=null ?this.rules.build():null;
  }
  public A withRules(Rules rules) {
    _visitables.get("rules").remove(this.rules);
    if (rules!=null){ this.rules= new RulesBuilder(rules); _visitables.get("rules").add(this.rules);} else { this.rules = null; _visitables.get("rules").remove(this.rules); } return (A) this;
  }
  public Boolean hasRules() {
    return this.rules != null;
  }
  public PrometheusSpecFluentImpl.RulesNested<A> withNewRules() {
    return new PrometheusSpecFluentImpl.RulesNestedImpl();
  }
  public PrometheusSpecFluentImpl.RulesNested<A> withNewRulesLike(Rules item) {
    return new PrometheusSpecFluentImpl.RulesNestedImpl(item);
  }
  public PrometheusSpecFluentImpl.RulesNested<A> editRules() {
    return withNewRulesLike(getRules());
  }
  public PrometheusSpecFluentImpl.RulesNested<A> editOrNewRules() {
    return withNewRulesLike(getRules() != null ? getRules(): new RulesBuilder().build());
  }
  public PrometheusSpecFluentImpl.RulesNested<A> editOrNewRulesLike(Rules item) {
    return withNewRulesLike(getRules() != null ? getRules(): item);
  }
  public String getScrapeInterval() {
    return this.scrapeInterval;
  }
  public A withScrapeInterval(String scrapeInterval) {
    this.scrapeInterval=scrapeInterval; return (A) this;
  }
  public Boolean hasScrapeInterval() {
    return this.scrapeInterval != null;
  }
  public String getScrapeTimeout() {
    return this.scrapeTimeout;
  }
  public A withScrapeTimeout(String scrapeTimeout) {
    this.scrapeTimeout=scrapeTimeout; return (A) this;
  }
  public Boolean hasScrapeTimeout() {
    return this.scrapeTimeout != null;
  }
  public A addToSecrets(int index,String item) {
    if (this.secrets == null) {this.secrets = new ArrayList<String>();}
    this.secrets.add(index, item);
    return (A)this;
  }
  public A setToSecrets(int index,String item) {
    if (this.secrets == null) {this.secrets = new ArrayList<String>();}
    this.secrets.set(index, item); return (A)this;
  }
  public A addToSecrets(java.lang.String... items) {
    if (this.secrets == null) {this.secrets = new ArrayList<String>();}
    for (String item : items) {this.secrets.add(item);} return (A)this;
  }
  public A addAllToSecrets(Collection<String> items) {
    if (this.secrets == null) {this.secrets = new ArrayList<String>();}
    for (String item : items) {this.secrets.add(item);} return (A)this;
  }
  public A removeFromSecrets(java.lang.String... items) {
    for (String item : items) {if (this.secrets!= null){ this.secrets.remove(item);}} return (A)this;
  }
  public A removeAllFromSecrets(Collection<String> items) {
    for (String item : items) {if (this.secrets!= null){ this.secrets.remove(item);}} return (A)this;
  }
  public List<String> getSecrets() {
    return this.secrets;
  }
  public String getSecret(int index) {
    return this.secrets.get(index);
  }
  public String getFirstSecret() {
    return this.secrets.get(0);
  }
  public String getLastSecret() {
    return this.secrets.get(secrets.size() - 1);
  }
  public String getMatchingSecret(Predicate<String> predicate) {
    for (String item: secrets) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingSecret(Predicate<String> predicate) {
    for (String item: secrets) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSecrets(List<String> secrets) {
    if (secrets != null) {this.secrets = new ArrayList(); for (String item : secrets){this.addToSecrets(item);}} else { this.secrets = null;} return (A) this;
  }
  public A withSecrets(java.lang.String... secrets) {
    if (this.secrets != null) {this.secrets.clear(); _visitables.remove("secrets"); }
    if (secrets != null) {for (String item :secrets){ this.addToSecrets(item);}} return (A) this;
  }
  public Boolean hasSecrets() {
    return secrets != null && !secrets.isEmpty();
  }
  public PodSecurityContext getSecurityContext() {
    return this.securityContext;
  }
  public A withSecurityContext(PodSecurityContext securityContext) {
    this.securityContext=securityContext; return (A) this;
  }
  public Boolean hasSecurityContext() {
    return this.securityContext != null;
  }
  public String getServiceAccountName() {
    return this.serviceAccountName;
  }
  public A withServiceAccountName(String serviceAccountName) {
    this.serviceAccountName=serviceAccountName; return (A) this;
  }
  public Boolean hasServiceAccountName() {
    return this.serviceAccountName != null;
  }
  
  /**
   * This method has been deprecated, please use method buildServiceMonitorNamespaceSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getServiceMonitorNamespaceSelector() {
    return this.serviceMonitorNamespaceSelector!=null ?this.serviceMonitorNamespaceSelector.build():null;
  }
  public LabelSelector buildServiceMonitorNamespaceSelector() {
    return this.serviceMonitorNamespaceSelector!=null ?this.serviceMonitorNamespaceSelector.build():null;
  }
  public A withServiceMonitorNamespaceSelector(LabelSelector serviceMonitorNamespaceSelector) {
    _visitables.get("serviceMonitorNamespaceSelector").remove(this.serviceMonitorNamespaceSelector);
    if (serviceMonitorNamespaceSelector!=null){ this.serviceMonitorNamespaceSelector= new LabelSelectorBuilder(serviceMonitorNamespaceSelector); _visitables.get("serviceMonitorNamespaceSelector").add(this.serviceMonitorNamespaceSelector);} else { this.serviceMonitorNamespaceSelector = null; _visitables.get("serviceMonitorNamespaceSelector").remove(this.serviceMonitorNamespaceSelector); } return (A) this;
  }
  public Boolean hasServiceMonitorNamespaceSelector() {
    return this.serviceMonitorNamespaceSelector != null;
  }
  public PrometheusSpecFluentImpl.ServiceMonitorNamespaceSelectorNested<A> withNewServiceMonitorNamespaceSelector() {
    return new PrometheusSpecFluentImpl.ServiceMonitorNamespaceSelectorNestedImpl();
  }
  public PrometheusSpecFluentImpl.ServiceMonitorNamespaceSelectorNested<A> withNewServiceMonitorNamespaceSelectorLike(LabelSelector item) {
    return new PrometheusSpecFluentImpl.ServiceMonitorNamespaceSelectorNestedImpl(item);
  }
  public PrometheusSpecFluentImpl.ServiceMonitorNamespaceSelectorNested<A> editServiceMonitorNamespaceSelector() {
    return withNewServiceMonitorNamespaceSelectorLike(getServiceMonitorNamespaceSelector());
  }
  public PrometheusSpecFluentImpl.ServiceMonitorNamespaceSelectorNested<A> editOrNewServiceMonitorNamespaceSelector() {
    return withNewServiceMonitorNamespaceSelectorLike(getServiceMonitorNamespaceSelector() != null ? getServiceMonitorNamespaceSelector(): new LabelSelectorBuilder().build());
  }
  public PrometheusSpecFluentImpl.ServiceMonitorNamespaceSelectorNested<A> editOrNewServiceMonitorNamespaceSelectorLike(LabelSelector item) {
    return withNewServiceMonitorNamespaceSelectorLike(getServiceMonitorNamespaceSelector() != null ? getServiceMonitorNamespaceSelector(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildServiceMonitorSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getServiceMonitorSelector() {
    return this.serviceMonitorSelector!=null ?this.serviceMonitorSelector.build():null;
  }
  public LabelSelector buildServiceMonitorSelector() {
    return this.serviceMonitorSelector!=null ?this.serviceMonitorSelector.build():null;
  }
  public A withServiceMonitorSelector(LabelSelector serviceMonitorSelector) {
    _visitables.get("serviceMonitorSelector").remove(this.serviceMonitorSelector);
    if (serviceMonitorSelector!=null){ this.serviceMonitorSelector= new LabelSelectorBuilder(serviceMonitorSelector); _visitables.get("serviceMonitorSelector").add(this.serviceMonitorSelector);} else { this.serviceMonitorSelector = null; _visitables.get("serviceMonitorSelector").remove(this.serviceMonitorSelector); } return (A) this;
  }
  public Boolean hasServiceMonitorSelector() {
    return this.serviceMonitorSelector != null;
  }
  public PrometheusSpecFluentImpl.ServiceMonitorSelectorNested<A> withNewServiceMonitorSelector() {
    return new PrometheusSpecFluentImpl.ServiceMonitorSelectorNestedImpl();
  }
  public PrometheusSpecFluentImpl.ServiceMonitorSelectorNested<A> withNewServiceMonitorSelectorLike(LabelSelector item) {
    return new PrometheusSpecFluentImpl.ServiceMonitorSelectorNestedImpl(item);
  }
  public PrometheusSpecFluentImpl.ServiceMonitorSelectorNested<A> editServiceMonitorSelector() {
    return withNewServiceMonitorSelectorLike(getServiceMonitorSelector());
  }
  public PrometheusSpecFluentImpl.ServiceMonitorSelectorNested<A> editOrNewServiceMonitorSelector() {
    return withNewServiceMonitorSelectorLike(getServiceMonitorSelector() != null ? getServiceMonitorSelector(): new LabelSelectorBuilder().build());
  }
  public PrometheusSpecFluentImpl.ServiceMonitorSelectorNested<A> editOrNewServiceMonitorSelectorLike(LabelSelector item) {
    return withNewServiceMonitorSelectorLike(getServiceMonitorSelector() != null ? getServiceMonitorSelector(): item);
  }
  public String getSha() {
    return this.sha;
  }
  public A withSha(String sha) {
    this.sha=sha; return (A) this;
  }
  public Boolean hasSha() {
    return this.sha != null;
  }
  public Integer getShards() {
    return this.shards;
  }
  public A withShards(Integer shards) {
    this.shards=shards; return (A) this;
  }
  public Boolean hasShards() {
    return this.shards != null;
  }
  
  /**
   * This method has been deprecated, please use method buildStorage instead.
   * @return The buildable object.
   */
  @Deprecated
  public StorageSpec getStorage() {
    return this.storage!=null ?this.storage.build():null;
  }
  public StorageSpec buildStorage() {
    return this.storage!=null ?this.storage.build():null;
  }
  public A withStorage(StorageSpec storage) {
    _visitables.get("storage").remove(this.storage);
    if (storage!=null){ this.storage= new StorageSpecBuilder(storage); _visitables.get("storage").add(this.storage);} else { this.storage = null; _visitables.get("storage").remove(this.storage); } return (A) this;
  }
  public Boolean hasStorage() {
    return this.storage != null;
  }
  public PrometheusSpecFluentImpl.StorageNested<A> withNewStorage() {
    return new PrometheusSpecFluentImpl.StorageNestedImpl();
  }
  public PrometheusSpecFluentImpl.StorageNested<A> withNewStorageLike(StorageSpec item) {
    return new PrometheusSpecFluentImpl.StorageNestedImpl(item);
  }
  public PrometheusSpecFluentImpl.StorageNested<A> editStorage() {
    return withNewStorageLike(getStorage());
  }
  public PrometheusSpecFluentImpl.StorageNested<A> editOrNewStorage() {
    return withNewStorageLike(getStorage() != null ? getStorage(): new StorageSpecBuilder().build());
  }
  public PrometheusSpecFluentImpl.StorageNested<A> editOrNewStorageLike(StorageSpec item) {
    return withNewStorageLike(getStorage() != null ? getStorage(): item);
  }
  public String getTag() {
    return this.tag;
  }
  public A withTag(String tag) {
    this.tag=tag; return (A) this;
  }
  public Boolean hasTag() {
    return this.tag != null;
  }
  
  /**
   * This method has been deprecated, please use method buildThanos instead.
   * @return The buildable object.
   */
  @Deprecated
  public ThanosSpec getThanos() {
    return this.thanos!=null ?this.thanos.build():null;
  }
  public ThanosSpec buildThanos() {
    return this.thanos!=null ?this.thanos.build():null;
  }
  public A withThanos(ThanosSpec thanos) {
    _visitables.get("thanos").remove(this.thanos);
    if (thanos!=null){ this.thanos= new ThanosSpecBuilder(thanos); _visitables.get("thanos").add(this.thanos);} else { this.thanos = null; _visitables.get("thanos").remove(this.thanos); } return (A) this;
  }
  public Boolean hasThanos() {
    return this.thanos != null;
  }
  public PrometheusSpecFluentImpl.ThanosNested<A> withNewThanos() {
    return new PrometheusSpecFluentImpl.ThanosNestedImpl();
  }
  public PrometheusSpecFluentImpl.ThanosNested<A> withNewThanosLike(ThanosSpec item) {
    return new PrometheusSpecFluentImpl.ThanosNestedImpl(item);
  }
  public PrometheusSpecFluentImpl.ThanosNested<A> editThanos() {
    return withNewThanosLike(getThanos());
  }
  public PrometheusSpecFluentImpl.ThanosNested<A> editOrNewThanos() {
    return withNewThanosLike(getThanos() != null ? getThanos(): new ThanosSpecBuilder().build());
  }
  public PrometheusSpecFluentImpl.ThanosNested<A> editOrNewThanosLike(ThanosSpec item) {
    return withNewThanosLike(getThanos() != null ? getThanos(): item);
  }
  public A addToTolerations(int index,Toleration item) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
    this.tolerations.add(index, item);
    return (A)this;
  }
  public A setToTolerations(int index,Toleration item) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
    this.tolerations.set(index, item); return (A)this;
  }
  public A addToTolerations(io.fabric8.kubernetes.api.model.Toleration... items) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
    for (Toleration item : items) {this.tolerations.add(item);} return (A)this;
  }
  public A addAllToTolerations(Collection<Toleration> items) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
    for (Toleration item : items) {this.tolerations.add(item);} return (A)this;
  }
  public A removeFromTolerations(io.fabric8.kubernetes.api.model.Toleration... items) {
    for (Toleration item : items) {if (this.tolerations!= null){ this.tolerations.remove(item);}} return (A)this;
  }
  public A removeAllFromTolerations(Collection<Toleration> items) {
    for (Toleration item : items) {if (this.tolerations!= null){ this.tolerations.remove(item);}} return (A)this;
  }
  public List<Toleration> getTolerations() {
    return this.tolerations;
  }
  public Toleration getToleration(int index) {
    return this.tolerations.get(index);
  }
  public Toleration getFirstToleration() {
    return this.tolerations.get(0);
  }
  public Toleration getLastToleration() {
    return this.tolerations.get(tolerations.size() - 1);
  }
  public Toleration getMatchingToleration(Predicate<Toleration> predicate) {
    for (Toleration item: tolerations) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingToleration(Predicate<Toleration> predicate) {
    for (Toleration item: tolerations) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTolerations(List<Toleration> tolerations) {
    if (tolerations != null) {this.tolerations = new ArrayList(); for (Toleration item : tolerations){this.addToTolerations(item);}} else { this.tolerations = null;} return (A) this;
  }
  public A withTolerations(io.fabric8.kubernetes.api.model.Toleration... tolerations) {
    if (this.tolerations != null) {this.tolerations.clear(); _visitables.remove("tolerations"); }
    if (tolerations != null) {for (Toleration item :tolerations){ this.addToTolerations(item);}} return (A) this;
  }
  public Boolean hasTolerations() {
    return tolerations != null && !tolerations.isEmpty();
  }
  public A addNewToleration(String effect,String key,String operator,Long tolerationSeconds,String value) {
    return (A)addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
  }
  public A addToTopologySpreadConstraints(int index,TopologySpreadConstraint item) {
    if (this.topologySpreadConstraints == null) {this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();}
    this.topologySpreadConstraints.add(index, item);
    return (A)this;
  }
  public A setToTopologySpreadConstraints(int index,TopologySpreadConstraint item) {
    if (this.topologySpreadConstraints == null) {this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();}
    this.topologySpreadConstraints.set(index, item); return (A)this;
  }
  public A addToTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... items) {
    if (this.topologySpreadConstraints == null) {this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();}
    for (TopologySpreadConstraint item : items) {this.topologySpreadConstraints.add(item);} return (A)this;
  }
  public A addAllToTopologySpreadConstraints(Collection<TopologySpreadConstraint> items) {
    if (this.topologySpreadConstraints == null) {this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();}
    for (TopologySpreadConstraint item : items) {this.topologySpreadConstraints.add(item);} return (A)this;
  }
  public A removeFromTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... items) {
    for (TopologySpreadConstraint item : items) {if (this.topologySpreadConstraints!= null){ this.topologySpreadConstraints.remove(item);}} return (A)this;
  }
  public A removeAllFromTopologySpreadConstraints(Collection<TopologySpreadConstraint> items) {
    for (TopologySpreadConstraint item : items) {if (this.topologySpreadConstraints!= null){ this.topologySpreadConstraints.remove(item);}} return (A)this;
  }
  public List<TopologySpreadConstraint> getTopologySpreadConstraints() {
    return this.topologySpreadConstraints;
  }
  public TopologySpreadConstraint getTopologySpreadConstraint(int index) {
    return this.topologySpreadConstraints.get(index);
  }
  public TopologySpreadConstraint getFirstTopologySpreadConstraint() {
    return this.topologySpreadConstraints.get(0);
  }
  public TopologySpreadConstraint getLastTopologySpreadConstraint() {
    return this.topologySpreadConstraints.get(topologySpreadConstraints.size() - 1);
  }
  public TopologySpreadConstraint getMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraint> predicate) {
    for (TopologySpreadConstraint item: topologySpreadConstraints) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraint> predicate) {
    for (TopologySpreadConstraint item: topologySpreadConstraints) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTopologySpreadConstraints(List<TopologySpreadConstraint> topologySpreadConstraints) {
    if (topologySpreadConstraints != null) {this.topologySpreadConstraints = new ArrayList(); for (TopologySpreadConstraint item : topologySpreadConstraints){this.addToTopologySpreadConstraints(item);}} else { this.topologySpreadConstraints = null;} return (A) this;
  }
  public A withTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... topologySpreadConstraints) {
    if (this.topologySpreadConstraints != null) {this.topologySpreadConstraints.clear(); _visitables.remove("topologySpreadConstraints"); }
    if (topologySpreadConstraints != null) {for (TopologySpreadConstraint item :topologySpreadConstraints){ this.addToTopologySpreadConstraints(item);}} return (A) this;
  }
  public Boolean hasTopologySpreadConstraints() {
    return topologySpreadConstraints != null && !topologySpreadConstraints.isEmpty();
  }
  public String getVersion() {
    return this.version;
  }
  public A withVersion(String version) {
    this.version=version; return (A) this;
  }
  public Boolean hasVersion() {
    return this.version != null;
  }
  public A addToVolumeMounts(int index,VolumeMount item) {
    if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMount>();}
    this.volumeMounts.add(index, item);
    return (A)this;
  }
  public A setToVolumeMounts(int index,VolumeMount item) {
    if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMount>();}
    this.volumeMounts.set(index, item); return (A)this;
  }
  public A addToVolumeMounts(io.fabric8.kubernetes.api.model.VolumeMount... items) {
    if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMount>();}
    for (VolumeMount item : items) {this.volumeMounts.add(item);} return (A)this;
  }
  public A addAllToVolumeMounts(Collection<VolumeMount> items) {
    if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMount>();}
    for (VolumeMount item : items) {this.volumeMounts.add(item);} return (A)this;
  }
  public A removeFromVolumeMounts(io.fabric8.kubernetes.api.model.VolumeMount... items) {
    for (VolumeMount item : items) {if (this.volumeMounts!= null){ this.volumeMounts.remove(item);}} return (A)this;
  }
  public A removeAllFromVolumeMounts(Collection<VolumeMount> items) {
    for (VolumeMount item : items) {if (this.volumeMounts!= null){ this.volumeMounts.remove(item);}} return (A)this;
  }
  public List<VolumeMount> getVolumeMounts() {
    return this.volumeMounts;
  }
  public VolumeMount getVolumeMount(int index) {
    return this.volumeMounts.get(index);
  }
  public VolumeMount getFirstVolumeMount() {
    return this.volumeMounts.get(0);
  }
  public VolumeMount getLastVolumeMount() {
    return this.volumeMounts.get(volumeMounts.size() - 1);
  }
  public VolumeMount getMatchingVolumeMount(Predicate<VolumeMount> predicate) {
    for (VolumeMount item: volumeMounts) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingVolumeMount(Predicate<VolumeMount> predicate) {
    for (VolumeMount item: volumeMounts) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withVolumeMounts(List<VolumeMount> volumeMounts) {
    if (volumeMounts != null) {this.volumeMounts = new ArrayList(); for (VolumeMount item : volumeMounts){this.addToVolumeMounts(item);}} else { this.volumeMounts = null;} return (A) this;
  }
  public A withVolumeMounts(io.fabric8.kubernetes.api.model.VolumeMount... volumeMounts) {
    if (this.volumeMounts != null) {this.volumeMounts.clear(); _visitables.remove("volumeMounts"); }
    if (volumeMounts != null) {for (VolumeMount item :volumeMounts){ this.addToVolumeMounts(item);}} return (A) this;
  }
  public Boolean hasVolumeMounts() {
    return volumeMounts != null && !volumeMounts.isEmpty();
  }
  public A addToVolumes(int index,Volume item) {
    if (this.volumes == null) {this.volumes = new ArrayList<Volume>();}
    this.volumes.add(index, item);
    return (A)this;
  }
  public A setToVolumes(int index,Volume item) {
    if (this.volumes == null) {this.volumes = new ArrayList<Volume>();}
    this.volumes.set(index, item); return (A)this;
  }
  public A addToVolumes(io.fabric8.kubernetes.api.model.Volume... items) {
    if (this.volumes == null) {this.volumes = new ArrayList<Volume>();}
    for (Volume item : items) {this.volumes.add(item);} return (A)this;
  }
  public A addAllToVolumes(Collection<Volume> items) {
    if (this.volumes == null) {this.volumes = new ArrayList<Volume>();}
    for (Volume item : items) {this.volumes.add(item);} return (A)this;
  }
  public A removeFromVolumes(io.fabric8.kubernetes.api.model.Volume... items) {
    for (Volume item : items) {if (this.volumes!= null){ this.volumes.remove(item);}} return (A)this;
  }
  public A removeAllFromVolumes(Collection<Volume> items) {
    for (Volume item : items) {if (this.volumes!= null){ this.volumes.remove(item);}} return (A)this;
  }
  public List<Volume> getVolumes() {
    return this.volumes;
  }
  public Volume getVolume(int index) {
    return this.volumes.get(index);
  }
  public Volume getFirstVolume() {
    return this.volumes.get(0);
  }
  public Volume getLastVolume() {
    return this.volumes.get(volumes.size() - 1);
  }
  public Volume getMatchingVolume(Predicate<Volume> predicate) {
    for (Volume item: volumes) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingVolume(Predicate<Volume> predicate) {
    for (Volume item: volumes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withVolumes(List<Volume> volumes) {
    if (volumes != null) {this.volumes = new ArrayList(); for (Volume item : volumes){this.addToVolumes(item);}} else { this.volumes = null;} return (A) this;
  }
  public A withVolumes(io.fabric8.kubernetes.api.model.Volume... volumes) {
    if (this.volumes != null) {this.volumes.clear(); _visitables.remove("volumes"); }
    if (volumes != null) {for (Volume item :volumes){ this.addToVolumes(item);}} return (A) this;
  }
  public Boolean hasVolumes() {
    return volumes != null && !volumes.isEmpty();
  }
  public Boolean getWalCompression() {
    return this.walCompression;
  }
  public A withWalCompression(Boolean walCompression) {
    this.walCompression=walCompression; return (A) this;
  }
  public Boolean hasWalCompression() {
    return this.walCompression != null;
  }
  
  /**
   * This method has been deprecated, please use method buildWeb instead.
   * @return The buildable object.
   */
  @Deprecated
  public WebSpec getWeb() {
    return this.web!=null ?this.web.build():null;
  }
  public WebSpec buildWeb() {
    return this.web!=null ?this.web.build():null;
  }
  public A withWeb(WebSpec web) {
    _visitables.get("web").remove(this.web);
    if (web!=null){ this.web= new WebSpecBuilder(web); _visitables.get("web").add(this.web);} else { this.web = null; _visitables.get("web").remove(this.web); } return (A) this;
  }
  public Boolean hasWeb() {
    return this.web != null;
  }
  public PrometheusSpecFluentImpl.WebNested<A> withNewWeb() {
    return new PrometheusSpecFluentImpl.WebNestedImpl();
  }
  public PrometheusSpecFluentImpl.WebNested<A> withNewWebLike(WebSpec item) {
    return new PrometheusSpecFluentImpl.WebNestedImpl(item);
  }
  public PrometheusSpecFluentImpl.WebNested<A> editWeb() {
    return withNewWebLike(getWeb());
  }
  public PrometheusSpecFluentImpl.WebNested<A> editOrNewWeb() {
    return withNewWebLike(getWeb() != null ? getWeb(): new WebSpecBuilder().build());
  }
  public PrometheusSpecFluentImpl.WebNested<A> editOrNewWebLike(WebSpec item) {
    return withNewWebLike(getWeb() != null ? getWeb(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PrometheusSpecFluentImpl that = (PrometheusSpecFluentImpl) o;
    if (!java.util.Objects.equals(additionalAlertManagerConfigs, that.additionalAlertManagerConfigs)) return false;

    if (!java.util.Objects.equals(additionalAlertRelabelConfigs, that.additionalAlertRelabelConfigs)) return false;

    if (!java.util.Objects.equals(additionalScrapeConfigs, that.additionalScrapeConfigs)) return false;

    if (!java.util.Objects.equals(affinity, that.affinity)) return false;

    if (!java.util.Objects.equals(alerting, that.alerting)) return false;

    if (!java.util.Objects.equals(allowOverlappingBlocks, that.allowOverlappingBlocks)) return false;

    if (!java.util.Objects.equals(apiserverConfig, that.apiserverConfig)) return false;

    if (!java.util.Objects.equals(arbitraryFSAccessThroughSMs, that.arbitraryFSAccessThroughSMs)) return false;

    if (!java.util.Objects.equals(baseImage, that.baseImage)) return false;

    if (!java.util.Objects.equals(configMaps, that.configMaps)) return false;

    if (!java.util.Objects.equals(containers, that.containers)) return false;

    if (!java.util.Objects.equals(disableCompaction, that.disableCompaction)) return false;

    if (!java.util.Objects.equals(enableAdminAPI, that.enableAdminAPI)) return false;

    if (!java.util.Objects.equals(enableFeatures, that.enableFeatures)) return false;

    if (!java.util.Objects.equals(enforcedBodySizeLimit, that.enforcedBodySizeLimit)) return false;

    if (!java.util.Objects.equals(enforcedLabelLimit, that.enforcedLabelLimit)) return false;

    if (!java.util.Objects.equals(enforcedLabelNameLengthLimit, that.enforcedLabelNameLengthLimit)) return false;

    if (!java.util.Objects.equals(enforcedLabelValueLengthLimit, that.enforcedLabelValueLengthLimit)) return false;

    if (!java.util.Objects.equals(enforcedNamespaceLabel, that.enforcedNamespaceLabel)) return false;

    if (!java.util.Objects.equals(enforcedSampleLimit, that.enforcedSampleLimit)) return false;

    if (!java.util.Objects.equals(enforcedTargetLimit, that.enforcedTargetLimit)) return false;

    if (!java.util.Objects.equals(evaluationInterval, that.evaluationInterval)) return false;

    if (!java.util.Objects.equals(externalLabels, that.externalLabels)) return false;

    if (!java.util.Objects.equals(externalUrl, that.externalUrl)) return false;

    if (!java.util.Objects.equals(ignoreNamespaceSelectors, that.ignoreNamespaceSelectors)) return false;

    if (!java.util.Objects.equals(image, that.image)) return false;

    if (!java.util.Objects.equals(imagePullSecrets, that.imagePullSecrets)) return false;

    if (!java.util.Objects.equals(initContainers, that.initContainers)) return false;

    if (!java.util.Objects.equals(listenLocal, that.listenLocal)) return false;

    if (!java.util.Objects.equals(logFormat, that.logFormat)) return false;

    if (!java.util.Objects.equals(logLevel, that.logLevel)) return false;

    if (!java.util.Objects.equals(minReadySeconds, that.minReadySeconds)) return false;

    if (!java.util.Objects.equals(nodeSelector, that.nodeSelector)) return false;

    if (!java.util.Objects.equals(overrideHonorLabels, that.overrideHonorLabels)) return false;

    if (!java.util.Objects.equals(overrideHonorTimestamps, that.overrideHonorTimestamps)) return false;

    if (!java.util.Objects.equals(paused, that.paused)) return false;

    if (!java.util.Objects.equals(podMetadata, that.podMetadata)) return false;

    if (!java.util.Objects.equals(podMonitorNamespaceSelector, that.podMonitorNamespaceSelector)) return false;

    if (!java.util.Objects.equals(podMonitorSelector, that.podMonitorSelector)) return false;

    if (!java.util.Objects.equals(portName, that.portName)) return false;

    if (!java.util.Objects.equals(priorityClassName, that.priorityClassName)) return false;

    if (!java.util.Objects.equals(probeNamespaceSelector, that.probeNamespaceSelector)) return false;

    if (!java.util.Objects.equals(probeSelector, that.probeSelector)) return false;

    if (!java.util.Objects.equals(prometheusExternalLabelName, that.prometheusExternalLabelName)) return false;

    if (!java.util.Objects.equals(prometheusRulesExcludedFromEnforce, that.prometheusRulesExcludedFromEnforce)) return false;

    if (!java.util.Objects.equals(query, that.query)) return false;

    if (!java.util.Objects.equals(queryLogFile, that.queryLogFile)) return false;

    if (!java.util.Objects.equals(remoteRead, that.remoteRead)) return false;

    if (!java.util.Objects.equals(remoteWrite, that.remoteWrite)) return false;

    if (!java.util.Objects.equals(replicaExternalLabelName, that.replicaExternalLabelName)) return false;

    if (!java.util.Objects.equals(replicas, that.replicas)) return false;

    if (!java.util.Objects.equals(resources, that.resources)) return false;

    if (!java.util.Objects.equals(retention, that.retention)) return false;

    if (!java.util.Objects.equals(retentionSize, that.retentionSize)) return false;

    if (!java.util.Objects.equals(routePrefix, that.routePrefix)) return false;

    if (!java.util.Objects.equals(ruleNamespaceSelector, that.ruleNamespaceSelector)) return false;

    if (!java.util.Objects.equals(ruleSelector, that.ruleSelector)) return false;

    if (!java.util.Objects.equals(rules, that.rules)) return false;

    if (!java.util.Objects.equals(scrapeInterval, that.scrapeInterval)) return false;

    if (!java.util.Objects.equals(scrapeTimeout, that.scrapeTimeout)) return false;

    if (!java.util.Objects.equals(secrets, that.secrets)) return false;

    if (!java.util.Objects.equals(securityContext, that.securityContext)) return false;

    if (!java.util.Objects.equals(serviceAccountName, that.serviceAccountName)) return false;

    if (!java.util.Objects.equals(serviceMonitorNamespaceSelector, that.serviceMonitorNamespaceSelector)) return false;

    if (!java.util.Objects.equals(serviceMonitorSelector, that.serviceMonitorSelector)) return false;

    if (!java.util.Objects.equals(sha, that.sha)) return false;

    if (!java.util.Objects.equals(shards, that.shards)) return false;

    if (!java.util.Objects.equals(storage, that.storage)) return false;

    if (!java.util.Objects.equals(tag, that.tag)) return false;

    if (!java.util.Objects.equals(thanos, that.thanos)) return false;

    if (!java.util.Objects.equals(tolerations, that.tolerations)) return false;

    if (!java.util.Objects.equals(topologySpreadConstraints, that.topologySpreadConstraints)) return false;

    if (!java.util.Objects.equals(version, that.version)) return false;

    if (!java.util.Objects.equals(volumeMounts, that.volumeMounts)) return false;

    if (!java.util.Objects.equals(volumes, that.volumes)) return false;

    if (!java.util.Objects.equals(walCompression, that.walCompression)) return false;

    if (!java.util.Objects.equals(web, that.web)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(additionalAlertManagerConfigs,  additionalAlertRelabelConfigs,  additionalScrapeConfigs,  affinity,  alerting,  allowOverlappingBlocks,  apiserverConfig,  arbitraryFSAccessThroughSMs,  baseImage,  configMaps,  containers,  disableCompaction,  enableAdminAPI,  enableFeatures,  enforcedBodySizeLimit,  enforcedLabelLimit,  enforcedLabelNameLengthLimit,  enforcedLabelValueLengthLimit,  enforcedNamespaceLabel,  enforcedSampleLimit,  enforcedTargetLimit,  evaluationInterval,  externalLabels,  externalUrl,  ignoreNamespaceSelectors,  image,  imagePullSecrets,  initContainers,  listenLocal,  logFormat,  logLevel,  minReadySeconds,  nodeSelector,  overrideHonorLabels,  overrideHonorTimestamps,  paused,  podMetadata,  podMonitorNamespaceSelector,  podMonitorSelector,  portName,  priorityClassName,  probeNamespaceSelector,  probeSelector,  prometheusExternalLabelName,  prometheusRulesExcludedFromEnforce,  query,  queryLogFile,  remoteRead,  remoteWrite,  replicaExternalLabelName,  replicas,  resources,  retention,  retentionSize,  routePrefix,  ruleNamespaceSelector,  ruleSelector,  rules,  scrapeInterval,  scrapeTimeout,  secrets,  securityContext,  serviceAccountName,  serviceMonitorNamespaceSelector,  serviceMonitorSelector,  sha,  shards,  storage,  tag,  thanos,  tolerations,  topologySpreadConstraints,  version,  volumeMounts,  volumes,  walCompression,  web,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (additionalAlertManagerConfigs != null) { sb.append("additionalAlertManagerConfigs:"); sb.append(additionalAlertManagerConfigs + ","); }
    if (additionalAlertRelabelConfigs != null) { sb.append("additionalAlertRelabelConfigs:"); sb.append(additionalAlertRelabelConfigs + ","); }
    if (additionalScrapeConfigs != null) { sb.append("additionalScrapeConfigs:"); sb.append(additionalScrapeConfigs + ","); }
    if (affinity != null) { sb.append("affinity:"); sb.append(affinity + ","); }
    if (alerting != null) { sb.append("alerting:"); sb.append(alerting + ","); }
    if (allowOverlappingBlocks != null) { sb.append("allowOverlappingBlocks:"); sb.append(allowOverlappingBlocks + ","); }
    if (apiserverConfig != null) { sb.append("apiserverConfig:"); sb.append(apiserverConfig + ","); }
    if (arbitraryFSAccessThroughSMs != null) { sb.append("arbitraryFSAccessThroughSMs:"); sb.append(arbitraryFSAccessThroughSMs + ","); }
    if (baseImage != null) { sb.append("baseImage:"); sb.append(baseImage + ","); }
    if (configMaps != null && !configMaps.isEmpty()) { sb.append("configMaps:"); sb.append(configMaps + ","); }
    if (containers != null && !containers.isEmpty()) { sb.append("containers:"); sb.append(containers + ","); }
    if (disableCompaction != null) { sb.append("disableCompaction:"); sb.append(disableCompaction + ","); }
    if (enableAdminAPI != null) { sb.append("enableAdminAPI:"); sb.append(enableAdminAPI + ","); }
    if (enableFeatures != null && !enableFeatures.isEmpty()) { sb.append("enableFeatures:"); sb.append(enableFeatures + ","); }
    if (enforcedBodySizeLimit != null) { sb.append("enforcedBodySizeLimit:"); sb.append(enforcedBodySizeLimit + ","); }
    if (enforcedLabelLimit != null) { sb.append("enforcedLabelLimit:"); sb.append(enforcedLabelLimit + ","); }
    if (enforcedLabelNameLengthLimit != null) { sb.append("enforcedLabelNameLengthLimit:"); sb.append(enforcedLabelNameLengthLimit + ","); }
    if (enforcedLabelValueLengthLimit != null) { sb.append("enforcedLabelValueLengthLimit:"); sb.append(enforcedLabelValueLengthLimit + ","); }
    if (enforcedNamespaceLabel != null) { sb.append("enforcedNamespaceLabel:"); sb.append(enforcedNamespaceLabel + ","); }
    if (enforcedSampleLimit != null) { sb.append("enforcedSampleLimit:"); sb.append(enforcedSampleLimit + ","); }
    if (enforcedTargetLimit != null) { sb.append("enforcedTargetLimit:"); sb.append(enforcedTargetLimit + ","); }
    if (evaluationInterval != null) { sb.append("evaluationInterval:"); sb.append(evaluationInterval + ","); }
    if (externalLabels != null && !externalLabels.isEmpty()) { sb.append("externalLabels:"); sb.append(externalLabels + ","); }
    if (externalUrl != null) { sb.append("externalUrl:"); sb.append(externalUrl + ","); }
    if (ignoreNamespaceSelectors != null) { sb.append("ignoreNamespaceSelectors:"); sb.append(ignoreNamespaceSelectors + ","); }
    if (image != null) { sb.append("image:"); sb.append(image + ","); }
    if (imagePullSecrets != null && !imagePullSecrets.isEmpty()) { sb.append("imagePullSecrets:"); sb.append(imagePullSecrets + ","); }
    if (initContainers != null && !initContainers.isEmpty()) { sb.append("initContainers:"); sb.append(initContainers + ","); }
    if (listenLocal != null) { sb.append("listenLocal:"); sb.append(listenLocal + ","); }
    if (logFormat != null) { sb.append("logFormat:"); sb.append(logFormat + ","); }
    if (logLevel != null) { sb.append("logLevel:"); sb.append(logLevel + ","); }
    if (minReadySeconds != null) { sb.append("minReadySeconds:"); sb.append(minReadySeconds + ","); }
    if (nodeSelector != null && !nodeSelector.isEmpty()) { sb.append("nodeSelector:"); sb.append(nodeSelector + ","); }
    if (overrideHonorLabels != null) { sb.append("overrideHonorLabels:"); sb.append(overrideHonorLabels + ","); }
    if (overrideHonorTimestamps != null) { sb.append("overrideHonorTimestamps:"); sb.append(overrideHonorTimestamps + ","); }
    if (paused != null) { sb.append("paused:"); sb.append(paused + ","); }
    if (podMetadata != null) { sb.append("podMetadata:"); sb.append(podMetadata + ","); }
    if (podMonitorNamespaceSelector != null) { sb.append("podMonitorNamespaceSelector:"); sb.append(podMonitorNamespaceSelector + ","); }
    if (podMonitorSelector != null) { sb.append("podMonitorSelector:"); sb.append(podMonitorSelector + ","); }
    if (portName != null) { sb.append("portName:"); sb.append(portName + ","); }
    if (priorityClassName != null) { sb.append("priorityClassName:"); sb.append(priorityClassName + ","); }
    if (probeNamespaceSelector != null) { sb.append("probeNamespaceSelector:"); sb.append(probeNamespaceSelector + ","); }
    if (probeSelector != null) { sb.append("probeSelector:"); sb.append(probeSelector + ","); }
    if (prometheusExternalLabelName != null) { sb.append("prometheusExternalLabelName:"); sb.append(prometheusExternalLabelName + ","); }
    if (prometheusRulesExcludedFromEnforce != null && !prometheusRulesExcludedFromEnforce.isEmpty()) { sb.append("prometheusRulesExcludedFromEnforce:"); sb.append(prometheusRulesExcludedFromEnforce + ","); }
    if (query != null) { sb.append("query:"); sb.append(query + ","); }
    if (queryLogFile != null) { sb.append("queryLogFile:"); sb.append(queryLogFile + ","); }
    if (remoteRead != null && !remoteRead.isEmpty()) { sb.append("remoteRead:"); sb.append(remoteRead + ","); }
    if (remoteWrite != null && !remoteWrite.isEmpty()) { sb.append("remoteWrite:"); sb.append(remoteWrite + ","); }
    if (replicaExternalLabelName != null) { sb.append("replicaExternalLabelName:"); sb.append(replicaExternalLabelName + ","); }
    if (replicas != null) { sb.append("replicas:"); sb.append(replicas + ","); }
    if (resources != null) { sb.append("resources:"); sb.append(resources + ","); }
    if (retention != null) { sb.append("retention:"); sb.append(retention + ","); }
    if (retentionSize != null) { sb.append("retentionSize:"); sb.append(retentionSize + ","); }
    if (routePrefix != null) { sb.append("routePrefix:"); sb.append(routePrefix + ","); }
    if (ruleNamespaceSelector != null) { sb.append("ruleNamespaceSelector:"); sb.append(ruleNamespaceSelector + ","); }
    if (ruleSelector != null) { sb.append("ruleSelector:"); sb.append(ruleSelector + ","); }
    if (rules != null) { sb.append("rules:"); sb.append(rules + ","); }
    if (scrapeInterval != null) { sb.append("scrapeInterval:"); sb.append(scrapeInterval + ","); }
    if (scrapeTimeout != null) { sb.append("scrapeTimeout:"); sb.append(scrapeTimeout + ","); }
    if (secrets != null && !secrets.isEmpty()) { sb.append("secrets:"); sb.append(secrets + ","); }
    if (securityContext != null) { sb.append("securityContext:"); sb.append(securityContext + ","); }
    if (serviceAccountName != null) { sb.append("serviceAccountName:"); sb.append(serviceAccountName + ","); }
    if (serviceMonitorNamespaceSelector != null) { sb.append("serviceMonitorNamespaceSelector:"); sb.append(serviceMonitorNamespaceSelector + ","); }
    if (serviceMonitorSelector != null) { sb.append("serviceMonitorSelector:"); sb.append(serviceMonitorSelector + ","); }
    if (sha != null) { sb.append("sha:"); sb.append(sha + ","); }
    if (shards != null) { sb.append("shards:"); sb.append(shards + ","); }
    if (storage != null) { sb.append("storage:"); sb.append(storage + ","); }
    if (tag != null) { sb.append("tag:"); sb.append(tag + ","); }
    if (thanos != null) { sb.append("thanos:"); sb.append(thanos + ","); }
    if (tolerations != null && !tolerations.isEmpty()) { sb.append("tolerations:"); sb.append(tolerations + ","); }
    if (topologySpreadConstraints != null && !topologySpreadConstraints.isEmpty()) { sb.append("topologySpreadConstraints:"); sb.append(topologySpreadConstraints + ","); }
    if (version != null) { sb.append("version:"); sb.append(version + ","); }
    if (volumeMounts != null && !volumeMounts.isEmpty()) { sb.append("volumeMounts:"); sb.append(volumeMounts + ","); }
    if (volumes != null && !volumes.isEmpty()) { sb.append("volumes:"); sb.append(volumes + ","); }
    if (walCompression != null) { sb.append("walCompression:"); sb.append(walCompression + ","); }
    if (web != null) { sb.append("web:"); sb.append(web + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withAllowOverlappingBlocks() {
    return withAllowOverlappingBlocks(true);
  }
  public A withDisableCompaction() {
    return withDisableCompaction(true);
  }
  public A withEnableAdminAPI() {
    return withEnableAdminAPI(true);
  }
  public A withIgnoreNamespaceSelectors() {
    return withIgnoreNamespaceSelectors(true);
  }
  public A withListenLocal() {
    return withListenLocal(true);
  }
  public A withOverrideHonorLabels() {
    return withOverrideHonorLabels(true);
  }
  public A withOverrideHonorTimestamps() {
    return withOverrideHonorTimestamps(true);
  }
  public A withPaused() {
    return withPaused(true);
  }
  public A withWalCompression() {
    return withWalCompression(true);
  }
  class AlertingNestedImpl<N> extends AlertingSpecFluentImpl<PrometheusSpecFluentImpl.AlertingNested<N>> implements PrometheusSpecFluentImpl.AlertingNested<N>,Nested<N>{
    AlertingNestedImpl(AlertingSpec item) {
      this.builder = new AlertingSpecBuilder(this, item);
    }
    AlertingNestedImpl() {
      this.builder = new AlertingSpecBuilder(this);
    }
    AlertingSpecBuilder builder;
    public N and() {
      return (N) PrometheusSpecFluentImpl.this.withAlerting(builder.build());
    }
    public N endAlerting() {
      return and();
    }
    
  }
  class ApiserverConfigNestedImpl<N> extends APIServerConfigFluentImpl<PrometheusSpecFluentImpl.ApiserverConfigNested<N>> implements PrometheusSpecFluentImpl.ApiserverConfigNested<N>,Nested<N>{
    ApiserverConfigNestedImpl(APIServerConfig item) {
      this.builder = new APIServerConfigBuilder(this, item);
    }
    ApiserverConfigNestedImpl() {
      this.builder = new APIServerConfigBuilder(this);
    }
    APIServerConfigBuilder builder;
    public N and() {
      return (N) PrometheusSpecFluentImpl.this.withApiserverConfig(builder.build());
    }
    public N endApiserverConfig() {
      return and();
    }
    
  }
  class ArbitraryFSAccessThroughSMsNestedImpl<N> extends ArbitraryFSAccessThroughSMsConfigFluentImpl<PrometheusSpecFluentImpl.ArbitraryFSAccessThroughSMsNested<N>> implements PrometheusSpecFluentImpl.ArbitraryFSAccessThroughSMsNested<N>,Nested<N>{
    ArbitraryFSAccessThroughSMsNestedImpl(ArbitraryFSAccessThroughSMsConfig item) {
      this.builder = new ArbitraryFSAccessThroughSMsConfigBuilder(this, item);
    }
    ArbitraryFSAccessThroughSMsNestedImpl() {
      this.builder = new ArbitraryFSAccessThroughSMsConfigBuilder(this);
    }
    ArbitraryFSAccessThroughSMsConfigBuilder builder;
    public N and() {
      return (N) PrometheusSpecFluentImpl.this.withArbitraryFSAccessThroughSMs(builder.build());
    }
    public N endArbitraryFSAccessThroughSMs() {
      return and();
    }
    
  }
  class ContainersNestedImpl<N> extends ContainerFluentImpl<PrometheusSpecFluentImpl.ContainersNested<N>> implements PrometheusSpecFluentImpl.ContainersNested<N>,Nested<N>{
    ContainersNestedImpl(int index,Container item) {
      this.index = index;
      this.builder = new ContainerBuilder(this, item);
    }
    ContainersNestedImpl() {
      this.index = -1;
      this.builder = new ContainerBuilder(this);
    }
    ContainerBuilder builder;
    int index;
    public N and() {
      return (N) PrometheusSpecFluentImpl.this.setToContainers(index,builder.build());
    }
    public N endContainer() {
      return and();
    }
    
  }
  class ImagePullSecretsNestedImpl<N> extends LocalObjectReferenceFluentImpl<PrometheusSpecFluentImpl.ImagePullSecretsNested<N>> implements PrometheusSpecFluentImpl.ImagePullSecretsNested<N>,Nested<N>{
    ImagePullSecretsNestedImpl(int index,LocalObjectReference item) {
      this.index = index;
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    ImagePullSecretsNestedImpl() {
      this.index = -1;
      this.builder = new LocalObjectReferenceBuilder(this);
    }
    LocalObjectReferenceBuilder builder;
    int index;
    public N and() {
      return (N) PrometheusSpecFluentImpl.this.setToImagePullSecrets(index,builder.build());
    }
    public N endImagePullSecret() {
      return and();
    }
    
  }
  class InitContainersNestedImpl<N> extends ContainerFluentImpl<PrometheusSpecFluentImpl.InitContainersNested<N>> implements PrometheusSpecFluentImpl.InitContainersNested<N>,Nested<N>{
    InitContainersNestedImpl(int index,Container item) {
      this.index = index;
      this.builder = new ContainerBuilder(this, item);
    }
    InitContainersNestedImpl() {
      this.index = -1;
      this.builder = new ContainerBuilder(this);
    }
    ContainerBuilder builder;
    int index;
    public N and() {
      return (N) PrometheusSpecFluentImpl.this.setToInitContainers(index,builder.build());
    }
    public N endInitContainer() {
      return and();
    }
    
  }
  class PodMetadataNestedImpl<N> extends EmbeddedObjectMetadataFluentImpl<PrometheusSpecFluentImpl.PodMetadataNested<N>> implements PrometheusSpecFluentImpl.PodMetadataNested<N>,Nested<N>{
    PodMetadataNestedImpl(EmbeddedObjectMetadata item) {
      this.builder = new EmbeddedObjectMetadataBuilder(this, item);
    }
    PodMetadataNestedImpl() {
      this.builder = new EmbeddedObjectMetadataBuilder(this);
    }
    EmbeddedObjectMetadataBuilder builder;
    public N and() {
      return (N) PrometheusSpecFluentImpl.this.withPodMetadata(builder.build());
    }
    public N endPodMetadata() {
      return and();
    }
    
  }
  class PodMonitorNamespaceSelectorNestedImpl<N> extends LabelSelectorFluentImpl<PrometheusSpecFluentImpl.PodMonitorNamespaceSelectorNested<N>> implements PrometheusSpecFluentImpl.PodMonitorNamespaceSelectorNested<N>,Nested<N>{
    PodMonitorNamespaceSelectorNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    PodMonitorNamespaceSelectorNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) PrometheusSpecFluentImpl.this.withPodMonitorNamespaceSelector(builder.build());
    }
    public N endPodMonitorNamespaceSelector() {
      return and();
    }
    
  }
  class PodMonitorSelectorNestedImpl<N> extends LabelSelectorFluentImpl<PrometheusSpecFluentImpl.PodMonitorSelectorNested<N>> implements PrometheusSpecFluentImpl.PodMonitorSelectorNested<N>,Nested<N>{
    PodMonitorSelectorNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    PodMonitorSelectorNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) PrometheusSpecFluentImpl.this.withPodMonitorSelector(builder.build());
    }
    public N endPodMonitorSelector() {
      return and();
    }
    
  }
  class ProbeNamespaceSelectorNestedImpl<N> extends LabelSelectorFluentImpl<PrometheusSpecFluentImpl.ProbeNamespaceSelectorNested<N>> implements PrometheusSpecFluentImpl.ProbeNamespaceSelectorNested<N>,Nested<N>{
    ProbeNamespaceSelectorNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    ProbeNamespaceSelectorNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) PrometheusSpecFluentImpl.this.withProbeNamespaceSelector(builder.build());
    }
    public N endProbeNamespaceSelector() {
      return and();
    }
    
  }
  class ProbeSelectorNestedImpl<N> extends LabelSelectorFluentImpl<PrometheusSpecFluentImpl.ProbeSelectorNested<N>> implements PrometheusSpecFluentImpl.ProbeSelectorNested<N>,Nested<N>{
    ProbeSelectorNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    ProbeSelectorNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) PrometheusSpecFluentImpl.this.withProbeSelector(builder.build());
    }
    public N endProbeSelector() {
      return and();
    }
    
  }
  class PrometheusRulesExcludedFromEnforceNestedImpl<N> extends PrometheusRuleExcludeConfigFluentImpl<PrometheusSpecFluentImpl.PrometheusRulesExcludedFromEnforceNested<N>> implements PrometheusSpecFluentImpl.PrometheusRulesExcludedFromEnforceNested<N>,Nested<N>{
    PrometheusRulesExcludedFromEnforceNestedImpl(int index,PrometheusRuleExcludeConfig item) {
      this.index = index;
      this.builder = new PrometheusRuleExcludeConfigBuilder(this, item);
    }
    PrometheusRulesExcludedFromEnforceNestedImpl() {
      this.index = -1;
      this.builder = new PrometheusRuleExcludeConfigBuilder(this);
    }
    PrometheusRuleExcludeConfigBuilder builder;
    int index;
    public N and() {
      return (N) PrometheusSpecFluentImpl.this.setToPrometheusRulesExcludedFromEnforce(index,builder.build());
    }
    public N endPrometheusRulesExcludedFromEnforce() {
      return and();
    }
    
  }
  class QueryNestedImpl<N> extends QuerySpecFluentImpl<PrometheusSpecFluentImpl.QueryNested<N>> implements PrometheusSpecFluentImpl.QueryNested<N>,Nested<N>{
    QueryNestedImpl(QuerySpec item) {
      this.builder = new QuerySpecBuilder(this, item);
    }
    QueryNestedImpl() {
      this.builder = new QuerySpecBuilder(this);
    }
    QuerySpecBuilder builder;
    public N and() {
      return (N) PrometheusSpecFluentImpl.this.withQuery(builder.build());
    }
    public N endQuery() {
      return and();
    }
    
  }
  class RemoteReadNestedImpl<N> extends RemoteReadSpecFluentImpl<PrometheusSpecFluentImpl.RemoteReadNested<N>> implements PrometheusSpecFluentImpl.RemoteReadNested<N>,Nested<N>{
    RemoteReadNestedImpl(int index,RemoteReadSpec item) {
      this.index = index;
      this.builder = new RemoteReadSpecBuilder(this, item);
    }
    RemoteReadNestedImpl() {
      this.index = -1;
      this.builder = new RemoteReadSpecBuilder(this);
    }
    RemoteReadSpecBuilder builder;
    int index;
    public N and() {
      return (N) PrometheusSpecFluentImpl.this.setToRemoteRead(index,builder.build());
    }
    public N endRemoteRead() {
      return and();
    }
    
  }
  class RemoteWriteNestedImpl<N> extends RemoteWriteSpecFluentImpl<PrometheusSpecFluentImpl.RemoteWriteNested<N>> implements PrometheusSpecFluentImpl.RemoteWriteNested<N>,Nested<N>{
    RemoteWriteNestedImpl(int index,RemoteWriteSpec item) {
      this.index = index;
      this.builder = new RemoteWriteSpecBuilder(this, item);
    }
    RemoteWriteNestedImpl() {
      this.index = -1;
      this.builder = new RemoteWriteSpecBuilder(this);
    }
    RemoteWriteSpecBuilder builder;
    int index;
    public N and() {
      return (N) PrometheusSpecFluentImpl.this.setToRemoteWrite(index,builder.build());
    }
    public N endRemoteWrite() {
      return and();
    }
    
  }
  class ResourcesNestedImpl<N> extends ResourceRequirementsFluentImpl<PrometheusSpecFluentImpl.ResourcesNested<N>> implements PrometheusSpecFluentImpl.ResourcesNested<N>,Nested<N>{
    ResourcesNestedImpl(ResourceRequirements item) {
      this.builder = new ResourceRequirementsBuilder(this, item);
    }
    ResourcesNestedImpl() {
      this.builder = new ResourceRequirementsBuilder(this);
    }
    ResourceRequirementsBuilder builder;
    public N and() {
      return (N) PrometheusSpecFluentImpl.this.withResources(builder.build());
    }
    public N endResources() {
      return and();
    }
    
  }
  class RuleNamespaceSelectorNestedImpl<N> extends LabelSelectorFluentImpl<PrometheusSpecFluentImpl.RuleNamespaceSelectorNested<N>> implements PrometheusSpecFluentImpl.RuleNamespaceSelectorNested<N>,Nested<N>{
    RuleNamespaceSelectorNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    RuleNamespaceSelectorNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) PrometheusSpecFluentImpl.this.withRuleNamespaceSelector(builder.build());
    }
    public N endRuleNamespaceSelector() {
      return and();
    }
    
  }
  class RuleSelectorNestedImpl<N> extends LabelSelectorFluentImpl<PrometheusSpecFluentImpl.RuleSelectorNested<N>> implements PrometheusSpecFluentImpl.RuleSelectorNested<N>,Nested<N>{
    RuleSelectorNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    RuleSelectorNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) PrometheusSpecFluentImpl.this.withRuleSelector(builder.build());
    }
    public N endRuleSelector() {
      return and();
    }
    
  }
  class RulesNestedImpl<N> extends RulesFluentImpl<PrometheusSpecFluentImpl.RulesNested<N>> implements PrometheusSpecFluentImpl.RulesNested<N>,Nested<N>{
    RulesNestedImpl(Rules item) {
      this.builder = new RulesBuilder(this, item);
    }
    RulesNestedImpl() {
      this.builder = new RulesBuilder(this);
    }
    RulesBuilder builder;
    public N and() {
      return (N) PrometheusSpecFluentImpl.this.withRules(builder.build());
    }
    public N endRules() {
      return and();
    }
    
  }
  class ServiceMonitorNamespaceSelectorNestedImpl<N> extends LabelSelectorFluentImpl<PrometheusSpecFluentImpl.ServiceMonitorNamespaceSelectorNested<N>> implements PrometheusSpecFluentImpl.ServiceMonitorNamespaceSelectorNested<N>,Nested<N>{
    ServiceMonitorNamespaceSelectorNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    ServiceMonitorNamespaceSelectorNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) PrometheusSpecFluentImpl.this.withServiceMonitorNamespaceSelector(builder.build());
    }
    public N endServiceMonitorNamespaceSelector() {
      return and();
    }
    
  }
  class ServiceMonitorSelectorNestedImpl<N> extends LabelSelectorFluentImpl<PrometheusSpecFluentImpl.ServiceMonitorSelectorNested<N>> implements PrometheusSpecFluentImpl.ServiceMonitorSelectorNested<N>,Nested<N>{
    ServiceMonitorSelectorNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    ServiceMonitorSelectorNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) PrometheusSpecFluentImpl.this.withServiceMonitorSelector(builder.build());
    }
    public N endServiceMonitorSelector() {
      return and();
    }
    
  }
  class StorageNestedImpl<N> extends StorageSpecFluentImpl<PrometheusSpecFluentImpl.StorageNested<N>> implements PrometheusSpecFluentImpl.StorageNested<N>,Nested<N>{
    StorageNestedImpl(StorageSpec item) {
      this.builder = new StorageSpecBuilder(this, item);
    }
    StorageNestedImpl() {
      this.builder = new StorageSpecBuilder(this);
    }
    StorageSpecBuilder builder;
    public N and() {
      return (N) PrometheusSpecFluentImpl.this.withStorage(builder.build());
    }
    public N endStorage() {
      return and();
    }
    
  }
  class ThanosNestedImpl<N> extends ThanosSpecFluentImpl<PrometheusSpecFluentImpl.ThanosNested<N>> implements PrometheusSpecFluentImpl.ThanosNested<N>,Nested<N>{
    ThanosNestedImpl(ThanosSpec item) {
      this.builder = new ThanosSpecBuilder(this, item);
    }
    ThanosNestedImpl() {
      this.builder = new ThanosSpecBuilder(this);
    }
    ThanosSpecBuilder builder;
    public N and() {
      return (N) PrometheusSpecFluentImpl.this.withThanos(builder.build());
    }
    public N endThanos() {
      return and();
    }
    
  }
  class WebNestedImpl<N> extends WebSpecFluentImpl<PrometheusSpecFluentImpl.WebNested<N>> implements PrometheusSpecFluentImpl.WebNested<N>,Nested<N>{
    WebNestedImpl(WebSpec item) {
      this.builder = new WebSpecBuilder(this, item);
    }
    WebNestedImpl() {
      this.builder = new WebSpecBuilder(this);
    }
    WebSpecBuilder builder;
    public N and() {
      return (N) PrometheusSpecFluentImpl.this.withWeb(builder.build());
    }
    public N endWeb() {
      return and();
    }
    
  }
  
}