package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class QuerySpecBuilder extends QuerySpecFluentImpl<QuerySpecBuilder> implements VisitableBuilder<QuerySpec,QuerySpecBuilder>{
  public QuerySpecBuilder() {
    this(false);
  }
  public QuerySpecBuilder(Boolean validationEnabled) {
    this(new QuerySpec(), validationEnabled);
  }
  public QuerySpecBuilder(QuerySpecFluent<?> fluent) {
    this(fluent, false);
  }
  public QuerySpecBuilder(QuerySpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new QuerySpec(), validationEnabled);
  }
  public QuerySpecBuilder(QuerySpecFluent<?> fluent,QuerySpec instance) {
    this(fluent, instance, false);
  }
  public QuerySpecBuilder(QuerySpecFluent<?> fluent,QuerySpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withLookbackDelta(instance.getLookbackDelta());
      fluent.withMaxConcurrency(instance.getMaxConcurrency());
      fluent.withMaxSamples(instance.getMaxSamples());
      fluent.withTimeout(instance.getTimeout());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public QuerySpecBuilder(QuerySpec instance) {
    this(instance,false);
  }
  public QuerySpecBuilder(QuerySpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withLookbackDelta(instance.getLookbackDelta());
      this.withMaxConcurrency(instance.getMaxConcurrency());
      this.withMaxSamples(instance.getMaxSamples());
      this.withTimeout(instance.getTimeout());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  QuerySpecFluent<?> fluent;
  Boolean validationEnabled;
  public QuerySpec build() {
    QuerySpec buildable = new QuerySpec(fluent.getLookbackDelta(),fluent.getMaxConcurrency(),fluent.getMaxSamples(),fluent.getTimeout());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}