package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SafeAuthorizationBuilder extends SafeAuthorizationFluentImpl<SafeAuthorizationBuilder> implements VisitableBuilder<SafeAuthorization,SafeAuthorizationBuilder>{
  public SafeAuthorizationBuilder() {
    this(false);
  }
  public SafeAuthorizationBuilder(Boolean validationEnabled) {
    this(new SafeAuthorization(), validationEnabled);
  }
  public SafeAuthorizationBuilder(SafeAuthorizationFluent<?> fluent) {
    this(fluent, false);
  }
  public SafeAuthorizationBuilder(SafeAuthorizationFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SafeAuthorization(), validationEnabled);
  }
  public SafeAuthorizationBuilder(SafeAuthorizationFluent<?> fluent,SafeAuthorization instance) {
    this(fluent, instance, false);
  }
  public SafeAuthorizationBuilder(SafeAuthorizationFluent<?> fluent,SafeAuthorization instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withCredentials(instance.getCredentials());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SafeAuthorizationBuilder(SafeAuthorization instance) {
    this(instance,false);
  }
  public SafeAuthorizationBuilder(SafeAuthorization instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withCredentials(instance.getCredentials());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SafeAuthorizationFluent<?> fluent;
  Boolean validationEnabled;
  public SafeAuthorization build() {
    SafeAuthorization buildable = new SafeAuthorization(fluent.getCredentials(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}