package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceMonitorListBuilder extends ServiceMonitorListFluentImpl<ServiceMonitorListBuilder> implements VisitableBuilder<ServiceMonitorList,ServiceMonitorListBuilder>{
  public ServiceMonitorListBuilder() {
    this(false);
  }
  public ServiceMonitorListBuilder(Boolean validationEnabled) {
    this(new ServiceMonitorList(), validationEnabled);
  }
  public ServiceMonitorListBuilder(ServiceMonitorListFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceMonitorListBuilder(ServiceMonitorListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceMonitorList(), validationEnabled);
  }
  public ServiceMonitorListBuilder(ServiceMonitorListFluent<?> fluent,ServiceMonitorList instance) {
    this(fluent, instance, false);
  }
  public ServiceMonitorListBuilder(ServiceMonitorListFluent<?> fluent,ServiceMonitorList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ServiceMonitorListBuilder(ServiceMonitorList instance) {
    this(instance,false);
  }
  public ServiceMonitorListBuilder(ServiceMonitorList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ServiceMonitorListFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceMonitorList build() {
    ServiceMonitorList buildable = new ServiceMonitorList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}