package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface ServiceMonitorListFluent<A extends ServiceMonitorListFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public A addToItems(int index,ServiceMonitor item);
  public A setToItems(int index,ServiceMonitor item);
  public A addToItems(io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitor... items);
  public A addAllToItems(Collection<ServiceMonitor> items);
  public A removeFromItems(io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitor... items);
  public A removeAllFromItems(Collection<ServiceMonitor> items);
  public A removeMatchingFromItems(Predicate<ServiceMonitorBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildItems instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ServiceMonitor> getItems();
  public List<ServiceMonitor> buildItems();
  public ServiceMonitor buildItem(int index);
  public ServiceMonitor buildFirstItem();
  public ServiceMonitor buildLastItem();
  public ServiceMonitor buildMatchingItem(Predicate<ServiceMonitorBuilder> predicate);
  public Boolean hasMatchingItem(Predicate<ServiceMonitorBuilder> predicate);
  public A withItems(List<ServiceMonitor> items);
  public A withItems(io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitor... items);
  public Boolean hasItems();
  public ServiceMonitorListFluent.ItemsNested<A> addNewItem();
  public ServiceMonitorListFluent.ItemsNested<A> addNewItemLike(ServiceMonitor item);
  public ServiceMonitorListFluent.ItemsNested<A> setNewItemLike(int index,ServiceMonitor item);
  public ServiceMonitorListFluent.ItemsNested<A> editItem(int index);
  public ServiceMonitorListFluent.ItemsNested<A> editFirstItem();
  public ServiceMonitorListFluent.ItemsNested<A> editLastItem();
  public ServiceMonitorListFluent.ItemsNested<A> editMatchingItem(Predicate<ServiceMonitorBuilder> predicate);
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  public ListMeta getMetadata();
  public A withMetadata(ListMeta metadata);
  public Boolean hasMetadata();
  public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ItemsNested<N> extends Nested<N>,ServiceMonitorFluent<ServiceMonitorListFluent.ItemsNested<N>>{
    public N and();
    public N endItem();
    
  }
  
}