package io.fabric8.openshift.api.model.monitoring.v1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import io.fabric8.kubernetes.api.model.VolumeMount;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface ThanosSpecFluent<A extends ThanosSpecFluent<A>> extends Fluent<A>{
  public String getBaseImage();
  public A withBaseImage(String baseImage);
  public Boolean hasBaseImage();
  
  /**
   * This method has been deprecated, please use method buildGrpcServerTlsConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public TLSConfig getGrpcServerTlsConfig();
  public TLSConfig buildGrpcServerTlsConfig();
  public A withGrpcServerTlsConfig(TLSConfig grpcServerTlsConfig);
  public Boolean hasGrpcServerTlsConfig();
  public ThanosSpecFluent.GrpcServerTlsConfigNested<A> withNewGrpcServerTlsConfig();
  public ThanosSpecFluent.GrpcServerTlsConfigNested<A> withNewGrpcServerTlsConfigLike(TLSConfig item);
  public ThanosSpecFluent.GrpcServerTlsConfigNested<A> editGrpcServerTlsConfig();
  public ThanosSpecFluent.GrpcServerTlsConfigNested<A> editOrNewGrpcServerTlsConfig();
  public ThanosSpecFluent.GrpcServerTlsConfigNested<A> editOrNewGrpcServerTlsConfigLike(TLSConfig item);
  public String getImage();
  public A withImage(String image);
  public Boolean hasImage();
  public Boolean getListenLocal();
  public A withListenLocal(Boolean listenLocal);
  public Boolean hasListenLocal();
  public String getLogFormat();
  public A withLogFormat(String logFormat);
  public Boolean hasLogFormat();
  public String getLogLevel();
  public A withLogLevel(String logLevel);
  public Boolean hasLogLevel();
  public String getMinTime();
  public A withMinTime(String minTime);
  public Boolean hasMinTime();
  public SecretKeySelector getObjectStorageConfig();
  public A withObjectStorageConfig(SecretKeySelector objectStorageConfig);
  public Boolean hasObjectStorageConfig();
  public A withNewObjectStorageConfig(String key,String name,Boolean optional);
  public String getObjectStorageConfigFile();
  public A withObjectStorageConfigFile(String objectStorageConfigFile);
  public Boolean hasObjectStorageConfigFile();
  public String getReadyTimeout();
  public A withReadyTimeout(String readyTimeout);
  public Boolean hasReadyTimeout();
  
  /**
   * This method has been deprecated, please use method buildResources instead.
   * @return The buildable object.
   */
  @Deprecated
  public ResourceRequirements getResources();
  public ResourceRequirements buildResources();
  public A withResources(ResourceRequirements resources);
  public Boolean hasResources();
  public ThanosSpecFluent.ResourcesNested<A> withNewResources();
  public ThanosSpecFluent.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item);
  public ThanosSpecFluent.ResourcesNested<A> editResources();
  public ThanosSpecFluent.ResourcesNested<A> editOrNewResources();
  public ThanosSpecFluent.ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item);
  public String getSha();
  public A withSha(String sha);
  public Boolean hasSha();
  public String getTag();
  public A withTag(String tag);
  public Boolean hasTag();
  public SecretKeySelector getTracingConfig();
  public A withTracingConfig(SecretKeySelector tracingConfig);
  public Boolean hasTracingConfig();
  public A withNewTracingConfig(String key,String name,Boolean optional);
  public String getTracingConfigFile();
  public A withTracingConfigFile(String tracingConfigFile);
  public Boolean hasTracingConfigFile();
  public String getVersion();
  public A withVersion(String version);
  public Boolean hasVersion();
  public A addToVolumeMounts(int index,VolumeMount item);
  public A setToVolumeMounts(int index,VolumeMount item);
  public A addToVolumeMounts(io.fabric8.kubernetes.api.model.VolumeMount... items);
  public A addAllToVolumeMounts(Collection<VolumeMount> items);
  public A removeFromVolumeMounts(io.fabric8.kubernetes.api.model.VolumeMount... items);
  public A removeAllFromVolumeMounts(Collection<VolumeMount> items);
  public List<VolumeMount> getVolumeMounts();
  public VolumeMount getVolumeMount(int index);
  public VolumeMount getFirstVolumeMount();
  public VolumeMount getLastVolumeMount();
  public VolumeMount getMatchingVolumeMount(Predicate<VolumeMount> predicate);
  public Boolean hasMatchingVolumeMount(Predicate<VolumeMount> predicate);
  public A withVolumeMounts(List<VolumeMount> volumeMounts);
  public A withVolumeMounts(io.fabric8.kubernetes.api.model.VolumeMount... volumeMounts);
  public Boolean hasVolumeMounts();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public A withListenLocal();
  public interface GrpcServerTlsConfigNested<N> extends Nested<N>,TLSConfigFluent<ThanosSpecFluent.GrpcServerTlsConfigNested<N>>{
    public N and();
    public N endGrpcServerTlsConfig();
    
  }
  public interface ResourcesNested<N> extends Nested<N>,ResourceRequirementsFluent<ThanosSpecFluent.ResourcesNested<N>>{
    public N and();
    public N endResources();
    
  }
  
}