package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PushoverConfigFluentImpl<A extends PushoverConfigFluent<A>> extends BaseFluent<A> implements PushoverConfigFluent<A>{
  public PushoverConfigFluentImpl() {
  }
  public PushoverConfigFluentImpl(PushoverConfig instance) {
    if (instance != null) {
      this.withExpire(instance.getExpire());
      this.withHtml(instance.getHtml());
      this.withHttpConfig(instance.getHttpConfig());
      this.withMessage(instance.getMessage());
      this.withPriority(instance.getPriority());
      this.withRetry(instance.getRetry());
      this.withSendResolved(instance.getSendResolved());
      this.withSound(instance.getSound());
      this.withTitle(instance.getTitle());
      this.withToken(instance.getToken());
      this.withUrl(instance.getUrl());
      this.withUrlTitle(instance.getUrlTitle());
      this.withUserKey(instance.getUserKey());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String expire;
  private Boolean html;
  private HTTPConfigBuilder httpConfig;
  private String message;
  private String priority;
  private String retry;
  private Boolean sendResolved;
  private String sound;
  private String title;
  private SecretKeySelector token;
  private String url;
  private String urlTitle;
  private SecretKeySelector userKey;
  private Map<String,Object> additionalProperties;
  public String getExpire() {
    return this.expire;
  }
  public A withExpire(String expire) {
    this.expire=expire; return (A) this;
  }
  public Boolean hasExpire() {
    return this.expire != null;
  }
  public Boolean getHtml() {
    return this.html;
  }
  public A withHtml(Boolean html) {
    this.html=html; return (A) this;
  }
  public Boolean hasHtml() {
    return this.html != null;
  }
  
  /**
   * This method has been deprecated, please use method buildHttpConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public HTTPConfig getHttpConfig() {
    return this.httpConfig!=null ?this.httpConfig.build():null;
  }
  public HTTPConfig buildHttpConfig() {
    return this.httpConfig!=null ?this.httpConfig.build():null;
  }
  public A withHttpConfig(HTTPConfig httpConfig) {
    _visitables.get("httpConfig").remove(this.httpConfig);
    if (httpConfig!=null){ this.httpConfig= new HTTPConfigBuilder(httpConfig); _visitables.get("httpConfig").add(this.httpConfig);} else { this.httpConfig = null; _visitables.get("httpConfig").remove(this.httpConfig); } return (A) this;
  }
  public Boolean hasHttpConfig() {
    return this.httpConfig != null;
  }
  public PushoverConfigFluentImpl.HttpConfigNested<A> withNewHttpConfig() {
    return new PushoverConfigFluentImpl.HttpConfigNestedImpl();
  }
  public PushoverConfigFluentImpl.HttpConfigNested<A> withNewHttpConfigLike(HTTPConfig item) {
    return new PushoverConfigFluentImpl.HttpConfigNestedImpl(item);
  }
  public PushoverConfigFluentImpl.HttpConfigNested<A> editHttpConfig() {
    return withNewHttpConfigLike(getHttpConfig());
  }
  public PushoverConfigFluentImpl.HttpConfigNested<A> editOrNewHttpConfig() {
    return withNewHttpConfigLike(getHttpConfig() != null ? getHttpConfig(): new HTTPConfigBuilder().build());
  }
  public PushoverConfigFluentImpl.HttpConfigNested<A> editOrNewHttpConfigLike(HTTPConfig item) {
    return withNewHttpConfigLike(getHttpConfig() != null ? getHttpConfig(): item);
  }
  public String getMessage() {
    return this.message;
  }
  public A withMessage(String message) {
    this.message=message; return (A) this;
  }
  public Boolean hasMessage() {
    return this.message != null;
  }
  public String getPriority() {
    return this.priority;
  }
  public A withPriority(String priority) {
    this.priority=priority; return (A) this;
  }
  public Boolean hasPriority() {
    return this.priority != null;
  }
  public String getRetry() {
    return this.retry;
  }
  public A withRetry(String retry) {
    this.retry=retry; return (A) this;
  }
  public Boolean hasRetry() {
    return this.retry != null;
  }
  public Boolean getSendResolved() {
    return this.sendResolved;
  }
  public A withSendResolved(Boolean sendResolved) {
    this.sendResolved=sendResolved; return (A) this;
  }
  public Boolean hasSendResolved() {
    return this.sendResolved != null;
  }
  public String getSound() {
    return this.sound;
  }
  public A withSound(String sound) {
    this.sound=sound; return (A) this;
  }
  public Boolean hasSound() {
    return this.sound != null;
  }
  public String getTitle() {
    return this.title;
  }
  public A withTitle(String title) {
    this.title=title; return (A) this;
  }
  public Boolean hasTitle() {
    return this.title != null;
  }
  public SecretKeySelector getToken() {
    return this.token;
  }
  public A withToken(SecretKeySelector token) {
    this.token=token; return (A) this;
  }
  public Boolean hasToken() {
    return this.token != null;
  }
  public A withNewToken(String key,String name,Boolean optional) {
    return (A)withToken(new SecretKeySelector(key, name, optional));
  }
  public String getUrl() {
    return this.url;
  }
  public A withUrl(String url) {
    this.url=url; return (A) this;
  }
  public Boolean hasUrl() {
    return this.url != null;
  }
  public String getUrlTitle() {
    return this.urlTitle;
  }
  public A withUrlTitle(String urlTitle) {
    this.urlTitle=urlTitle; return (A) this;
  }
  public Boolean hasUrlTitle() {
    return this.urlTitle != null;
  }
  public SecretKeySelector getUserKey() {
    return this.userKey;
  }
  public A withUserKey(SecretKeySelector userKey) {
    this.userKey=userKey; return (A) this;
  }
  public Boolean hasUserKey() {
    return this.userKey != null;
  }
  public A withNewUserKey(String key,String name,Boolean optional) {
    return (A)withUserKey(new SecretKeySelector(key, name, optional));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PushoverConfigFluentImpl that = (PushoverConfigFluentImpl) o;
    if (!java.util.Objects.equals(expire, that.expire)) return false;

    if (!java.util.Objects.equals(html, that.html)) return false;

    if (!java.util.Objects.equals(httpConfig, that.httpConfig)) return false;

    if (!java.util.Objects.equals(message, that.message)) return false;

    if (!java.util.Objects.equals(priority, that.priority)) return false;

    if (!java.util.Objects.equals(retry, that.retry)) return false;

    if (!java.util.Objects.equals(sendResolved, that.sendResolved)) return false;

    if (!java.util.Objects.equals(sound, that.sound)) return false;

    if (!java.util.Objects.equals(title, that.title)) return false;

    if (!java.util.Objects.equals(token, that.token)) return false;

    if (!java.util.Objects.equals(url, that.url)) return false;

    if (!java.util.Objects.equals(urlTitle, that.urlTitle)) return false;

    if (!java.util.Objects.equals(userKey, that.userKey)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(expire,  html,  httpConfig,  message,  priority,  retry,  sendResolved,  sound,  title,  token,  url,  urlTitle,  userKey,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (expire != null) { sb.append("expire:"); sb.append(expire + ","); }
    if (html != null) { sb.append("html:"); sb.append(html + ","); }
    if (httpConfig != null) { sb.append("httpConfig:"); sb.append(httpConfig + ","); }
    if (message != null) { sb.append("message:"); sb.append(message + ","); }
    if (priority != null) { sb.append("priority:"); sb.append(priority + ","); }
    if (retry != null) { sb.append("retry:"); sb.append(retry + ","); }
    if (sendResolved != null) { sb.append("sendResolved:"); sb.append(sendResolved + ","); }
    if (sound != null) { sb.append("sound:"); sb.append(sound + ","); }
    if (title != null) { sb.append("title:"); sb.append(title + ","); }
    if (token != null) { sb.append("token:"); sb.append(token + ","); }
    if (url != null) { sb.append("url:"); sb.append(url + ","); }
    if (urlTitle != null) { sb.append("urlTitle:"); sb.append(urlTitle + ","); }
    if (userKey != null) { sb.append("userKey:"); sb.append(userKey + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withHtml() {
    return withHtml(true);
  }
  public A withSendResolved() {
    return withSendResolved(true);
  }
  class HttpConfigNestedImpl<N> extends HTTPConfigFluentImpl<PushoverConfigFluentImpl.HttpConfigNested<N>> implements PushoverConfigFluentImpl.HttpConfigNested<N>,Nested<N>{
    HttpConfigNestedImpl(HTTPConfig item) {
      this.builder = new HTTPConfigBuilder(this, item);
    }
    HttpConfigNestedImpl() {
      this.builder = new HTTPConfigBuilder(this);
    }
    HTTPConfigBuilder builder;
    public N and() {
      return (N) PushoverConfigFluentImpl.this.withHttpConfig(builder.build());
    }
    public N endHttpConfig() {
      return and();
    }
    
  }
  
}