package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import java.util.Iterator;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ReceiverFluentImpl<A extends ReceiverFluent<A>> extends BaseFluent<A> implements ReceiverFluent<A>{
  public ReceiverFluentImpl() {
  }
  public ReceiverFluentImpl(Receiver instance) {
    if (instance != null) {
      this.withEmailConfigs(instance.getEmailConfigs());
      this.withName(instance.getName());
      this.withOpsgenieConfigs(instance.getOpsgenieConfigs());
      this.withPagerdutyConfigs(instance.getPagerdutyConfigs());
      this.withPushoverConfigs(instance.getPushoverConfigs());
      this.withSlackConfigs(instance.getSlackConfigs());
      this.withVictoropsConfigs(instance.getVictoropsConfigs());
      this.withWebhookConfigs(instance.getWebhookConfigs());
      this.withWechatConfigs(instance.getWechatConfigs());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ArrayList<EmailConfigBuilder> emailConfigs = new ArrayList<EmailConfigBuilder>();
  private String name;
  private ArrayList<OpsGenieConfigBuilder> opsgenieConfigs = new ArrayList<OpsGenieConfigBuilder>();
  private ArrayList<PagerDutyConfigBuilder> pagerdutyConfigs = new ArrayList<PagerDutyConfigBuilder>();
  private ArrayList<PushoverConfigBuilder> pushoverConfigs = new ArrayList<PushoverConfigBuilder>();
  private ArrayList<SlackConfigBuilder> slackConfigs = new ArrayList<SlackConfigBuilder>();
  private ArrayList<VictorOpsConfigBuilder> victoropsConfigs = new ArrayList<VictorOpsConfigBuilder>();
  private ArrayList<WebhookConfigBuilder> webhookConfigs = new ArrayList<WebhookConfigBuilder>();
  private ArrayList<WeChatConfigBuilder> wechatConfigs = new ArrayList<WeChatConfigBuilder>();
  private Map<String,Object> additionalProperties;
  public A addToEmailConfigs(int index,EmailConfig item) {
    if (this.emailConfigs == null) {this.emailConfigs = new ArrayList<EmailConfigBuilder>();}
    EmailConfigBuilder builder = new EmailConfigBuilder(item);
    if (index < 0 || index >= emailConfigs.size()) { _visitables.get("emailConfigs").add(builder); emailConfigs.add(builder); } else { _visitables.get("emailConfigs").add(index, builder); emailConfigs.add(index, builder);}
    return (A)this;
  }
  public A setToEmailConfigs(int index,EmailConfig item) {
    if (this.emailConfigs == null) {this.emailConfigs = new ArrayList<EmailConfigBuilder>();}
    EmailConfigBuilder builder = new EmailConfigBuilder(item);
    if (index < 0 || index >= emailConfigs.size()) { _visitables.get("emailConfigs").add(builder); emailConfigs.add(builder); } else { _visitables.get("emailConfigs").set(index, builder); emailConfigs.set(index, builder);}
    return (A)this;
  }
  public A addToEmailConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.EmailConfig... items) {
    if (this.emailConfigs == null) {this.emailConfigs = new ArrayList<EmailConfigBuilder>();}
    for (EmailConfig item : items) {EmailConfigBuilder builder = new EmailConfigBuilder(item);_visitables.get("emailConfigs").add(builder);this.emailConfigs.add(builder);} return (A)this;
  }
  public A addAllToEmailConfigs(Collection<EmailConfig> items) {
    if (this.emailConfigs == null) {this.emailConfigs = new ArrayList<EmailConfigBuilder>();}
    for (EmailConfig item : items) {EmailConfigBuilder builder = new EmailConfigBuilder(item);_visitables.get("emailConfigs").add(builder);this.emailConfigs.add(builder);} return (A)this;
  }
  public A removeFromEmailConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.EmailConfig... items) {
    for (EmailConfig item : items) {EmailConfigBuilder builder = new EmailConfigBuilder(item);_visitables.get("emailConfigs").remove(builder);if (this.emailConfigs != null) {this.emailConfigs.remove(builder);}} return (A)this;
  }
  public A removeAllFromEmailConfigs(Collection<EmailConfig> items) {
    for (EmailConfig item : items) {EmailConfigBuilder builder = new EmailConfigBuilder(item);_visitables.get("emailConfigs").remove(builder);if (this.emailConfigs != null) {this.emailConfigs.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromEmailConfigs(Predicate<EmailConfigBuilder> predicate) {
    if (emailConfigs == null) return (A) this;
    final Iterator<EmailConfigBuilder> each = emailConfigs.iterator();
    final List visitables = _visitables.get("emailConfigs");
    while (each.hasNext()) {
      EmailConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildEmailConfigs instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<EmailConfig> getEmailConfigs() {
    return emailConfigs != null ? build(emailConfigs) : null;
  }
  public List<EmailConfig> buildEmailConfigs() {
    return emailConfigs != null ? build(emailConfigs) : null;
  }
  public EmailConfig buildEmailConfig(int index) {
    return this.emailConfigs.get(index).build();
  }
  public EmailConfig buildFirstEmailConfig() {
    return this.emailConfigs.get(0).build();
  }
  public EmailConfig buildLastEmailConfig() {
    return this.emailConfigs.get(emailConfigs.size() - 1).build();
  }
  public EmailConfig buildMatchingEmailConfig(Predicate<EmailConfigBuilder> predicate) {
    for (EmailConfigBuilder item: emailConfigs) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingEmailConfig(Predicate<EmailConfigBuilder> predicate) {
    for (EmailConfigBuilder item: emailConfigs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withEmailConfigs(List<EmailConfig> emailConfigs) {
    if (this.emailConfigs != null) { _visitables.get("emailConfigs").clear();}
    if (emailConfigs != null) {this.emailConfigs = new ArrayList(); for (EmailConfig item : emailConfigs){this.addToEmailConfigs(item);}} else { this.emailConfigs = null;} return (A) this;
  }
  public A withEmailConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.EmailConfig... emailConfigs) {
    if (this.emailConfigs != null) {this.emailConfigs.clear(); _visitables.remove("emailConfigs"); }
    if (emailConfigs != null) {for (EmailConfig item :emailConfigs){ this.addToEmailConfigs(item);}} return (A) this;
  }
  public Boolean hasEmailConfigs() {
    return emailConfigs != null && !emailConfigs.isEmpty();
  }
  public ReceiverFluentImpl.EmailConfigsNested<A> addNewEmailConfig() {
    return new ReceiverFluentImpl.EmailConfigsNestedImpl();
  }
  public ReceiverFluentImpl.EmailConfigsNested<A> addNewEmailConfigLike(EmailConfig item) {
    return new ReceiverFluentImpl.EmailConfigsNestedImpl(-1, item);
  }
  public ReceiverFluentImpl.EmailConfigsNested<A> setNewEmailConfigLike(int index,EmailConfig item) {
    return new ReceiverFluentImpl.EmailConfigsNestedImpl(index, item);
  }
  public ReceiverFluentImpl.EmailConfigsNested<A> editEmailConfig(int index) {
    if (emailConfigs.size() <= index) throw new RuntimeException("Can't edit emailConfigs. Index exceeds size.");
    return setNewEmailConfigLike(index, buildEmailConfig(index));
  }
  public ReceiverFluentImpl.EmailConfigsNested<A> editFirstEmailConfig() {
    if (emailConfigs.size() == 0) throw new RuntimeException("Can't edit first emailConfigs. The list is empty.");
    return setNewEmailConfigLike(0, buildEmailConfig(0));
  }
  public ReceiverFluentImpl.EmailConfigsNested<A> editLastEmailConfig() {
    int index = emailConfigs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last emailConfigs. The list is empty.");
    return setNewEmailConfigLike(index, buildEmailConfig(index));
  }
  public ReceiverFluentImpl.EmailConfigsNested<A> editMatchingEmailConfig(Predicate<EmailConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<emailConfigs.size();i++) { 
    if (predicate.test(emailConfigs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching emailConfigs. No match found.");
    return setNewEmailConfigLike(index, buildEmailConfig(index));
  }
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public Boolean hasName() {
    return this.name != null;
  }
  public A addToOpsgenieConfigs(int index,OpsGenieConfig item) {
    if (this.opsgenieConfigs == null) {this.opsgenieConfigs = new ArrayList<OpsGenieConfigBuilder>();}
    OpsGenieConfigBuilder builder = new OpsGenieConfigBuilder(item);
    if (index < 0 || index >= opsgenieConfigs.size()) { _visitables.get("opsgenieConfigs").add(builder); opsgenieConfigs.add(builder); } else { _visitables.get("opsgenieConfigs").add(index, builder); opsgenieConfigs.add(index, builder);}
    return (A)this;
  }
  public A setToOpsgenieConfigs(int index,OpsGenieConfig item) {
    if (this.opsgenieConfigs == null) {this.opsgenieConfigs = new ArrayList<OpsGenieConfigBuilder>();}
    OpsGenieConfigBuilder builder = new OpsGenieConfigBuilder(item);
    if (index < 0 || index >= opsgenieConfigs.size()) { _visitables.get("opsgenieConfigs").add(builder); opsgenieConfigs.add(builder); } else { _visitables.get("opsgenieConfigs").set(index, builder); opsgenieConfigs.set(index, builder);}
    return (A)this;
  }
  public A addToOpsgenieConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfig... items) {
    if (this.opsgenieConfigs == null) {this.opsgenieConfigs = new ArrayList<OpsGenieConfigBuilder>();}
    for (OpsGenieConfig item : items) {OpsGenieConfigBuilder builder = new OpsGenieConfigBuilder(item);_visitables.get("opsgenieConfigs").add(builder);this.opsgenieConfigs.add(builder);} return (A)this;
  }
  public A addAllToOpsgenieConfigs(Collection<OpsGenieConfig> items) {
    if (this.opsgenieConfigs == null) {this.opsgenieConfigs = new ArrayList<OpsGenieConfigBuilder>();}
    for (OpsGenieConfig item : items) {OpsGenieConfigBuilder builder = new OpsGenieConfigBuilder(item);_visitables.get("opsgenieConfigs").add(builder);this.opsgenieConfigs.add(builder);} return (A)this;
  }
  public A removeFromOpsgenieConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfig... items) {
    for (OpsGenieConfig item : items) {OpsGenieConfigBuilder builder = new OpsGenieConfigBuilder(item);_visitables.get("opsgenieConfigs").remove(builder);if (this.opsgenieConfigs != null) {this.opsgenieConfigs.remove(builder);}} return (A)this;
  }
  public A removeAllFromOpsgenieConfigs(Collection<OpsGenieConfig> items) {
    for (OpsGenieConfig item : items) {OpsGenieConfigBuilder builder = new OpsGenieConfigBuilder(item);_visitables.get("opsgenieConfigs").remove(builder);if (this.opsgenieConfigs != null) {this.opsgenieConfigs.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromOpsgenieConfigs(Predicate<OpsGenieConfigBuilder> predicate) {
    if (opsgenieConfigs == null) return (A) this;
    final Iterator<OpsGenieConfigBuilder> each = opsgenieConfigs.iterator();
    final List visitables = _visitables.get("opsgenieConfigs");
    while (each.hasNext()) {
      OpsGenieConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildOpsgenieConfigs instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<OpsGenieConfig> getOpsgenieConfigs() {
    return opsgenieConfigs != null ? build(opsgenieConfigs) : null;
  }
  public List<OpsGenieConfig> buildOpsgenieConfigs() {
    return opsgenieConfigs != null ? build(opsgenieConfigs) : null;
  }
  public OpsGenieConfig buildOpsgenieConfig(int index) {
    return this.opsgenieConfigs.get(index).build();
  }
  public OpsGenieConfig buildFirstOpsgenieConfig() {
    return this.opsgenieConfigs.get(0).build();
  }
  public OpsGenieConfig buildLastOpsgenieConfig() {
    return this.opsgenieConfigs.get(opsgenieConfigs.size() - 1).build();
  }
  public OpsGenieConfig buildMatchingOpsgenieConfig(Predicate<OpsGenieConfigBuilder> predicate) {
    for (OpsGenieConfigBuilder item: opsgenieConfigs) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingOpsgenieConfig(Predicate<OpsGenieConfigBuilder> predicate) {
    for (OpsGenieConfigBuilder item: opsgenieConfigs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withOpsgenieConfigs(List<OpsGenieConfig> opsgenieConfigs) {
    if (this.opsgenieConfigs != null) { _visitables.get("opsgenieConfigs").clear();}
    if (opsgenieConfigs != null) {this.opsgenieConfigs = new ArrayList(); for (OpsGenieConfig item : opsgenieConfigs){this.addToOpsgenieConfigs(item);}} else { this.opsgenieConfigs = null;} return (A) this;
  }
  public A withOpsgenieConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfig... opsgenieConfigs) {
    if (this.opsgenieConfigs != null) {this.opsgenieConfigs.clear(); _visitables.remove("opsgenieConfigs"); }
    if (opsgenieConfigs != null) {for (OpsGenieConfig item :opsgenieConfigs){ this.addToOpsgenieConfigs(item);}} return (A) this;
  }
  public Boolean hasOpsgenieConfigs() {
    return opsgenieConfigs != null && !opsgenieConfigs.isEmpty();
  }
  public ReceiverFluentImpl.OpsgenieConfigsNested<A> addNewOpsgenieConfig() {
    return new ReceiverFluentImpl.OpsgenieConfigsNestedImpl();
  }
  public ReceiverFluentImpl.OpsgenieConfigsNested<A> addNewOpsgenieConfigLike(OpsGenieConfig item) {
    return new ReceiverFluentImpl.OpsgenieConfigsNestedImpl(-1, item);
  }
  public ReceiverFluentImpl.OpsgenieConfigsNested<A> setNewOpsgenieConfigLike(int index,OpsGenieConfig item) {
    return new ReceiverFluentImpl.OpsgenieConfigsNestedImpl(index, item);
  }
  public ReceiverFluentImpl.OpsgenieConfigsNested<A> editOpsgenieConfig(int index) {
    if (opsgenieConfigs.size() <= index) throw new RuntimeException("Can't edit opsgenieConfigs. Index exceeds size.");
    return setNewOpsgenieConfigLike(index, buildOpsgenieConfig(index));
  }
  public ReceiverFluentImpl.OpsgenieConfigsNested<A> editFirstOpsgenieConfig() {
    if (opsgenieConfigs.size() == 0) throw new RuntimeException("Can't edit first opsgenieConfigs. The list is empty.");
    return setNewOpsgenieConfigLike(0, buildOpsgenieConfig(0));
  }
  public ReceiverFluentImpl.OpsgenieConfigsNested<A> editLastOpsgenieConfig() {
    int index = opsgenieConfigs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last opsgenieConfigs. The list is empty.");
    return setNewOpsgenieConfigLike(index, buildOpsgenieConfig(index));
  }
  public ReceiverFluentImpl.OpsgenieConfigsNested<A> editMatchingOpsgenieConfig(Predicate<OpsGenieConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<opsgenieConfigs.size();i++) { 
    if (predicate.test(opsgenieConfigs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching opsgenieConfigs. No match found.");
    return setNewOpsgenieConfigLike(index, buildOpsgenieConfig(index));
  }
  public A addToPagerdutyConfigs(int index,PagerDutyConfig item) {
    if (this.pagerdutyConfigs == null) {this.pagerdutyConfigs = new ArrayList<PagerDutyConfigBuilder>();}
    PagerDutyConfigBuilder builder = new PagerDutyConfigBuilder(item);
    if (index < 0 || index >= pagerdutyConfigs.size()) { _visitables.get("pagerdutyConfigs").add(builder); pagerdutyConfigs.add(builder); } else { _visitables.get("pagerdutyConfigs").add(index, builder); pagerdutyConfigs.add(index, builder);}
    return (A)this;
  }
  public A setToPagerdutyConfigs(int index,PagerDutyConfig item) {
    if (this.pagerdutyConfigs == null) {this.pagerdutyConfigs = new ArrayList<PagerDutyConfigBuilder>();}
    PagerDutyConfigBuilder builder = new PagerDutyConfigBuilder(item);
    if (index < 0 || index >= pagerdutyConfigs.size()) { _visitables.get("pagerdutyConfigs").add(builder); pagerdutyConfigs.add(builder); } else { _visitables.get("pagerdutyConfigs").set(index, builder); pagerdutyConfigs.set(index, builder);}
    return (A)this;
  }
  public A addToPagerdutyConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.PagerDutyConfig... items) {
    if (this.pagerdutyConfigs == null) {this.pagerdutyConfigs = new ArrayList<PagerDutyConfigBuilder>();}
    for (PagerDutyConfig item : items) {PagerDutyConfigBuilder builder = new PagerDutyConfigBuilder(item);_visitables.get("pagerdutyConfigs").add(builder);this.pagerdutyConfigs.add(builder);} return (A)this;
  }
  public A addAllToPagerdutyConfigs(Collection<PagerDutyConfig> items) {
    if (this.pagerdutyConfigs == null) {this.pagerdutyConfigs = new ArrayList<PagerDutyConfigBuilder>();}
    for (PagerDutyConfig item : items) {PagerDutyConfigBuilder builder = new PagerDutyConfigBuilder(item);_visitables.get("pagerdutyConfigs").add(builder);this.pagerdutyConfigs.add(builder);} return (A)this;
  }
  public A removeFromPagerdutyConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.PagerDutyConfig... items) {
    for (PagerDutyConfig item : items) {PagerDutyConfigBuilder builder = new PagerDutyConfigBuilder(item);_visitables.get("pagerdutyConfigs").remove(builder);if (this.pagerdutyConfigs != null) {this.pagerdutyConfigs.remove(builder);}} return (A)this;
  }
  public A removeAllFromPagerdutyConfigs(Collection<PagerDutyConfig> items) {
    for (PagerDutyConfig item : items) {PagerDutyConfigBuilder builder = new PagerDutyConfigBuilder(item);_visitables.get("pagerdutyConfigs").remove(builder);if (this.pagerdutyConfigs != null) {this.pagerdutyConfigs.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromPagerdutyConfigs(Predicate<PagerDutyConfigBuilder> predicate) {
    if (pagerdutyConfigs == null) return (A) this;
    final Iterator<PagerDutyConfigBuilder> each = pagerdutyConfigs.iterator();
    final List visitables = _visitables.get("pagerdutyConfigs");
    while (each.hasNext()) {
      PagerDutyConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildPagerdutyConfigs instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<PagerDutyConfig> getPagerdutyConfigs() {
    return pagerdutyConfigs != null ? build(pagerdutyConfigs) : null;
  }
  public List<PagerDutyConfig> buildPagerdutyConfigs() {
    return pagerdutyConfigs != null ? build(pagerdutyConfigs) : null;
  }
  public PagerDutyConfig buildPagerdutyConfig(int index) {
    return this.pagerdutyConfigs.get(index).build();
  }
  public PagerDutyConfig buildFirstPagerdutyConfig() {
    return this.pagerdutyConfigs.get(0).build();
  }
  public PagerDutyConfig buildLastPagerdutyConfig() {
    return this.pagerdutyConfigs.get(pagerdutyConfigs.size() - 1).build();
  }
  public PagerDutyConfig buildMatchingPagerdutyConfig(Predicate<PagerDutyConfigBuilder> predicate) {
    for (PagerDutyConfigBuilder item: pagerdutyConfigs) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingPagerdutyConfig(Predicate<PagerDutyConfigBuilder> predicate) {
    for (PagerDutyConfigBuilder item: pagerdutyConfigs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withPagerdutyConfigs(List<PagerDutyConfig> pagerdutyConfigs) {
    if (this.pagerdutyConfigs != null) { _visitables.get("pagerdutyConfigs").clear();}
    if (pagerdutyConfigs != null) {this.pagerdutyConfigs = new ArrayList(); for (PagerDutyConfig item : pagerdutyConfigs){this.addToPagerdutyConfigs(item);}} else { this.pagerdutyConfigs = null;} return (A) this;
  }
  public A withPagerdutyConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.PagerDutyConfig... pagerdutyConfigs) {
    if (this.pagerdutyConfigs != null) {this.pagerdutyConfigs.clear(); _visitables.remove("pagerdutyConfigs"); }
    if (pagerdutyConfigs != null) {for (PagerDutyConfig item :pagerdutyConfigs){ this.addToPagerdutyConfigs(item);}} return (A) this;
  }
  public Boolean hasPagerdutyConfigs() {
    return pagerdutyConfigs != null && !pagerdutyConfigs.isEmpty();
  }
  public ReceiverFluentImpl.PagerdutyConfigsNested<A> addNewPagerdutyConfig() {
    return new ReceiverFluentImpl.PagerdutyConfigsNestedImpl();
  }
  public ReceiverFluentImpl.PagerdutyConfigsNested<A> addNewPagerdutyConfigLike(PagerDutyConfig item) {
    return new ReceiverFluentImpl.PagerdutyConfigsNestedImpl(-1, item);
  }
  public ReceiverFluentImpl.PagerdutyConfigsNested<A> setNewPagerdutyConfigLike(int index,PagerDutyConfig item) {
    return new ReceiverFluentImpl.PagerdutyConfigsNestedImpl(index, item);
  }
  public ReceiverFluentImpl.PagerdutyConfigsNested<A> editPagerdutyConfig(int index) {
    if (pagerdutyConfigs.size() <= index) throw new RuntimeException("Can't edit pagerdutyConfigs. Index exceeds size.");
    return setNewPagerdutyConfigLike(index, buildPagerdutyConfig(index));
  }
  public ReceiverFluentImpl.PagerdutyConfigsNested<A> editFirstPagerdutyConfig() {
    if (pagerdutyConfigs.size() == 0) throw new RuntimeException("Can't edit first pagerdutyConfigs. The list is empty.");
    return setNewPagerdutyConfigLike(0, buildPagerdutyConfig(0));
  }
  public ReceiverFluentImpl.PagerdutyConfigsNested<A> editLastPagerdutyConfig() {
    int index = pagerdutyConfigs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last pagerdutyConfigs. The list is empty.");
    return setNewPagerdutyConfigLike(index, buildPagerdutyConfig(index));
  }
  public ReceiverFluentImpl.PagerdutyConfigsNested<A> editMatchingPagerdutyConfig(Predicate<PagerDutyConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<pagerdutyConfigs.size();i++) { 
    if (predicate.test(pagerdutyConfigs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching pagerdutyConfigs. No match found.");
    return setNewPagerdutyConfigLike(index, buildPagerdutyConfig(index));
  }
  public A addToPushoverConfigs(int index,PushoverConfig item) {
    if (this.pushoverConfigs == null) {this.pushoverConfigs = new ArrayList<PushoverConfigBuilder>();}
    PushoverConfigBuilder builder = new PushoverConfigBuilder(item);
    if (index < 0 || index >= pushoverConfigs.size()) { _visitables.get("pushoverConfigs").add(builder); pushoverConfigs.add(builder); } else { _visitables.get("pushoverConfigs").add(index, builder); pushoverConfigs.add(index, builder);}
    return (A)this;
  }
  public A setToPushoverConfigs(int index,PushoverConfig item) {
    if (this.pushoverConfigs == null) {this.pushoverConfigs = new ArrayList<PushoverConfigBuilder>();}
    PushoverConfigBuilder builder = new PushoverConfigBuilder(item);
    if (index < 0 || index >= pushoverConfigs.size()) { _visitables.get("pushoverConfigs").add(builder); pushoverConfigs.add(builder); } else { _visitables.get("pushoverConfigs").set(index, builder); pushoverConfigs.set(index, builder);}
    return (A)this;
  }
  public A addToPushoverConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.PushoverConfig... items) {
    if (this.pushoverConfigs == null) {this.pushoverConfigs = new ArrayList<PushoverConfigBuilder>();}
    for (PushoverConfig item : items) {PushoverConfigBuilder builder = new PushoverConfigBuilder(item);_visitables.get("pushoverConfigs").add(builder);this.pushoverConfigs.add(builder);} return (A)this;
  }
  public A addAllToPushoverConfigs(Collection<PushoverConfig> items) {
    if (this.pushoverConfigs == null) {this.pushoverConfigs = new ArrayList<PushoverConfigBuilder>();}
    for (PushoverConfig item : items) {PushoverConfigBuilder builder = new PushoverConfigBuilder(item);_visitables.get("pushoverConfigs").add(builder);this.pushoverConfigs.add(builder);} return (A)this;
  }
  public A removeFromPushoverConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.PushoverConfig... items) {
    for (PushoverConfig item : items) {PushoverConfigBuilder builder = new PushoverConfigBuilder(item);_visitables.get("pushoverConfigs").remove(builder);if (this.pushoverConfigs != null) {this.pushoverConfigs.remove(builder);}} return (A)this;
  }
  public A removeAllFromPushoverConfigs(Collection<PushoverConfig> items) {
    for (PushoverConfig item : items) {PushoverConfigBuilder builder = new PushoverConfigBuilder(item);_visitables.get("pushoverConfigs").remove(builder);if (this.pushoverConfigs != null) {this.pushoverConfigs.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromPushoverConfigs(Predicate<PushoverConfigBuilder> predicate) {
    if (pushoverConfigs == null) return (A) this;
    final Iterator<PushoverConfigBuilder> each = pushoverConfigs.iterator();
    final List visitables = _visitables.get("pushoverConfigs");
    while (each.hasNext()) {
      PushoverConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildPushoverConfigs instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<PushoverConfig> getPushoverConfigs() {
    return pushoverConfigs != null ? build(pushoverConfigs) : null;
  }
  public List<PushoverConfig> buildPushoverConfigs() {
    return pushoverConfigs != null ? build(pushoverConfigs) : null;
  }
  public PushoverConfig buildPushoverConfig(int index) {
    return this.pushoverConfigs.get(index).build();
  }
  public PushoverConfig buildFirstPushoverConfig() {
    return this.pushoverConfigs.get(0).build();
  }
  public PushoverConfig buildLastPushoverConfig() {
    return this.pushoverConfigs.get(pushoverConfigs.size() - 1).build();
  }
  public PushoverConfig buildMatchingPushoverConfig(Predicate<PushoverConfigBuilder> predicate) {
    for (PushoverConfigBuilder item: pushoverConfigs) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingPushoverConfig(Predicate<PushoverConfigBuilder> predicate) {
    for (PushoverConfigBuilder item: pushoverConfigs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withPushoverConfigs(List<PushoverConfig> pushoverConfigs) {
    if (this.pushoverConfigs != null) { _visitables.get("pushoverConfigs").clear();}
    if (pushoverConfigs != null) {this.pushoverConfigs = new ArrayList(); for (PushoverConfig item : pushoverConfigs){this.addToPushoverConfigs(item);}} else { this.pushoverConfigs = null;} return (A) this;
  }
  public A withPushoverConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.PushoverConfig... pushoverConfigs) {
    if (this.pushoverConfigs != null) {this.pushoverConfigs.clear(); _visitables.remove("pushoverConfigs"); }
    if (pushoverConfigs != null) {for (PushoverConfig item :pushoverConfigs){ this.addToPushoverConfigs(item);}} return (A) this;
  }
  public Boolean hasPushoverConfigs() {
    return pushoverConfigs != null && !pushoverConfigs.isEmpty();
  }
  public ReceiverFluentImpl.PushoverConfigsNested<A> addNewPushoverConfig() {
    return new ReceiverFluentImpl.PushoverConfigsNestedImpl();
  }
  public ReceiverFluentImpl.PushoverConfigsNested<A> addNewPushoverConfigLike(PushoverConfig item) {
    return new ReceiverFluentImpl.PushoverConfigsNestedImpl(-1, item);
  }
  public ReceiverFluentImpl.PushoverConfigsNested<A> setNewPushoverConfigLike(int index,PushoverConfig item) {
    return new ReceiverFluentImpl.PushoverConfigsNestedImpl(index, item);
  }
  public ReceiverFluentImpl.PushoverConfigsNested<A> editPushoverConfig(int index) {
    if (pushoverConfigs.size() <= index) throw new RuntimeException("Can't edit pushoverConfigs. Index exceeds size.");
    return setNewPushoverConfigLike(index, buildPushoverConfig(index));
  }
  public ReceiverFluentImpl.PushoverConfigsNested<A> editFirstPushoverConfig() {
    if (pushoverConfigs.size() == 0) throw new RuntimeException("Can't edit first pushoverConfigs. The list is empty.");
    return setNewPushoverConfigLike(0, buildPushoverConfig(0));
  }
  public ReceiverFluentImpl.PushoverConfigsNested<A> editLastPushoverConfig() {
    int index = pushoverConfigs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last pushoverConfigs. The list is empty.");
    return setNewPushoverConfigLike(index, buildPushoverConfig(index));
  }
  public ReceiverFluentImpl.PushoverConfigsNested<A> editMatchingPushoverConfig(Predicate<PushoverConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<pushoverConfigs.size();i++) { 
    if (predicate.test(pushoverConfigs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching pushoverConfigs. No match found.");
    return setNewPushoverConfigLike(index, buildPushoverConfig(index));
  }
  public A addToSlackConfigs(int index,SlackConfig item) {
    if (this.slackConfigs == null) {this.slackConfigs = new ArrayList<SlackConfigBuilder>();}
    SlackConfigBuilder builder = new SlackConfigBuilder(item);
    if (index < 0 || index >= slackConfigs.size()) { _visitables.get("slackConfigs").add(builder); slackConfigs.add(builder); } else { _visitables.get("slackConfigs").add(index, builder); slackConfigs.add(index, builder);}
    return (A)this;
  }
  public A setToSlackConfigs(int index,SlackConfig item) {
    if (this.slackConfigs == null) {this.slackConfigs = new ArrayList<SlackConfigBuilder>();}
    SlackConfigBuilder builder = new SlackConfigBuilder(item);
    if (index < 0 || index >= slackConfigs.size()) { _visitables.get("slackConfigs").add(builder); slackConfigs.add(builder); } else { _visitables.get("slackConfigs").set(index, builder); slackConfigs.set(index, builder);}
    return (A)this;
  }
  public A addToSlackConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.SlackConfig... items) {
    if (this.slackConfigs == null) {this.slackConfigs = new ArrayList<SlackConfigBuilder>();}
    for (SlackConfig item : items) {SlackConfigBuilder builder = new SlackConfigBuilder(item);_visitables.get("slackConfigs").add(builder);this.slackConfigs.add(builder);} return (A)this;
  }
  public A addAllToSlackConfigs(Collection<SlackConfig> items) {
    if (this.slackConfigs == null) {this.slackConfigs = new ArrayList<SlackConfigBuilder>();}
    for (SlackConfig item : items) {SlackConfigBuilder builder = new SlackConfigBuilder(item);_visitables.get("slackConfigs").add(builder);this.slackConfigs.add(builder);} return (A)this;
  }
  public A removeFromSlackConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.SlackConfig... items) {
    for (SlackConfig item : items) {SlackConfigBuilder builder = new SlackConfigBuilder(item);_visitables.get("slackConfigs").remove(builder);if (this.slackConfigs != null) {this.slackConfigs.remove(builder);}} return (A)this;
  }
  public A removeAllFromSlackConfigs(Collection<SlackConfig> items) {
    for (SlackConfig item : items) {SlackConfigBuilder builder = new SlackConfigBuilder(item);_visitables.get("slackConfigs").remove(builder);if (this.slackConfigs != null) {this.slackConfigs.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromSlackConfigs(Predicate<SlackConfigBuilder> predicate) {
    if (slackConfigs == null) return (A) this;
    final Iterator<SlackConfigBuilder> each = slackConfigs.iterator();
    final List visitables = _visitables.get("slackConfigs");
    while (each.hasNext()) {
      SlackConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildSlackConfigs instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<SlackConfig> getSlackConfigs() {
    return slackConfigs != null ? build(slackConfigs) : null;
  }
  public List<SlackConfig> buildSlackConfigs() {
    return slackConfigs != null ? build(slackConfigs) : null;
  }
  public SlackConfig buildSlackConfig(int index) {
    return this.slackConfigs.get(index).build();
  }
  public SlackConfig buildFirstSlackConfig() {
    return this.slackConfigs.get(0).build();
  }
  public SlackConfig buildLastSlackConfig() {
    return this.slackConfigs.get(slackConfigs.size() - 1).build();
  }
  public SlackConfig buildMatchingSlackConfig(Predicate<SlackConfigBuilder> predicate) {
    for (SlackConfigBuilder item: slackConfigs) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingSlackConfig(Predicate<SlackConfigBuilder> predicate) {
    for (SlackConfigBuilder item: slackConfigs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSlackConfigs(List<SlackConfig> slackConfigs) {
    if (this.slackConfigs != null) { _visitables.get("slackConfigs").clear();}
    if (slackConfigs != null) {this.slackConfigs = new ArrayList(); for (SlackConfig item : slackConfigs){this.addToSlackConfigs(item);}} else { this.slackConfigs = null;} return (A) this;
  }
  public A withSlackConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.SlackConfig... slackConfigs) {
    if (this.slackConfigs != null) {this.slackConfigs.clear(); _visitables.remove("slackConfigs"); }
    if (slackConfigs != null) {for (SlackConfig item :slackConfigs){ this.addToSlackConfigs(item);}} return (A) this;
  }
  public Boolean hasSlackConfigs() {
    return slackConfigs != null && !slackConfigs.isEmpty();
  }
  public ReceiverFluentImpl.SlackConfigsNested<A> addNewSlackConfig() {
    return new ReceiverFluentImpl.SlackConfigsNestedImpl();
  }
  public ReceiverFluentImpl.SlackConfigsNested<A> addNewSlackConfigLike(SlackConfig item) {
    return new ReceiverFluentImpl.SlackConfigsNestedImpl(-1, item);
  }
  public ReceiverFluentImpl.SlackConfigsNested<A> setNewSlackConfigLike(int index,SlackConfig item) {
    return new ReceiverFluentImpl.SlackConfigsNestedImpl(index, item);
  }
  public ReceiverFluentImpl.SlackConfigsNested<A> editSlackConfig(int index) {
    if (slackConfigs.size() <= index) throw new RuntimeException("Can't edit slackConfigs. Index exceeds size.");
    return setNewSlackConfigLike(index, buildSlackConfig(index));
  }
  public ReceiverFluentImpl.SlackConfigsNested<A> editFirstSlackConfig() {
    if (slackConfigs.size() == 0) throw new RuntimeException("Can't edit first slackConfigs. The list is empty.");
    return setNewSlackConfigLike(0, buildSlackConfig(0));
  }
  public ReceiverFluentImpl.SlackConfigsNested<A> editLastSlackConfig() {
    int index = slackConfigs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last slackConfigs. The list is empty.");
    return setNewSlackConfigLike(index, buildSlackConfig(index));
  }
  public ReceiverFluentImpl.SlackConfigsNested<A> editMatchingSlackConfig(Predicate<SlackConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<slackConfigs.size();i++) { 
    if (predicate.test(slackConfigs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching slackConfigs. No match found.");
    return setNewSlackConfigLike(index, buildSlackConfig(index));
  }
  public A addToVictoropsConfigs(int index,VictorOpsConfig item) {
    if (this.victoropsConfigs == null) {this.victoropsConfigs = new ArrayList<VictorOpsConfigBuilder>();}
    VictorOpsConfigBuilder builder = new VictorOpsConfigBuilder(item);
    if (index < 0 || index >= victoropsConfigs.size()) { _visitables.get("victoropsConfigs").add(builder); victoropsConfigs.add(builder); } else { _visitables.get("victoropsConfigs").add(index, builder); victoropsConfigs.add(index, builder);}
    return (A)this;
  }
  public A setToVictoropsConfigs(int index,VictorOpsConfig item) {
    if (this.victoropsConfigs == null) {this.victoropsConfigs = new ArrayList<VictorOpsConfigBuilder>();}
    VictorOpsConfigBuilder builder = new VictorOpsConfigBuilder(item);
    if (index < 0 || index >= victoropsConfigs.size()) { _visitables.get("victoropsConfigs").add(builder); victoropsConfigs.add(builder); } else { _visitables.get("victoropsConfigs").set(index, builder); victoropsConfigs.set(index, builder);}
    return (A)this;
  }
  public A addToVictoropsConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.VictorOpsConfig... items) {
    if (this.victoropsConfigs == null) {this.victoropsConfigs = new ArrayList<VictorOpsConfigBuilder>();}
    for (VictorOpsConfig item : items) {VictorOpsConfigBuilder builder = new VictorOpsConfigBuilder(item);_visitables.get("victoropsConfigs").add(builder);this.victoropsConfigs.add(builder);} return (A)this;
  }
  public A addAllToVictoropsConfigs(Collection<VictorOpsConfig> items) {
    if (this.victoropsConfigs == null) {this.victoropsConfigs = new ArrayList<VictorOpsConfigBuilder>();}
    for (VictorOpsConfig item : items) {VictorOpsConfigBuilder builder = new VictorOpsConfigBuilder(item);_visitables.get("victoropsConfigs").add(builder);this.victoropsConfigs.add(builder);} return (A)this;
  }
  public A removeFromVictoropsConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.VictorOpsConfig... items) {
    for (VictorOpsConfig item : items) {VictorOpsConfigBuilder builder = new VictorOpsConfigBuilder(item);_visitables.get("victoropsConfigs").remove(builder);if (this.victoropsConfigs != null) {this.victoropsConfigs.remove(builder);}} return (A)this;
  }
  public A removeAllFromVictoropsConfigs(Collection<VictorOpsConfig> items) {
    for (VictorOpsConfig item : items) {VictorOpsConfigBuilder builder = new VictorOpsConfigBuilder(item);_visitables.get("victoropsConfigs").remove(builder);if (this.victoropsConfigs != null) {this.victoropsConfigs.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromVictoropsConfigs(Predicate<VictorOpsConfigBuilder> predicate) {
    if (victoropsConfigs == null) return (A) this;
    final Iterator<VictorOpsConfigBuilder> each = victoropsConfigs.iterator();
    final List visitables = _visitables.get("victoropsConfigs");
    while (each.hasNext()) {
      VictorOpsConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildVictoropsConfigs instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<VictorOpsConfig> getVictoropsConfigs() {
    return victoropsConfigs != null ? build(victoropsConfigs) : null;
  }
  public List<VictorOpsConfig> buildVictoropsConfigs() {
    return victoropsConfigs != null ? build(victoropsConfigs) : null;
  }
  public VictorOpsConfig buildVictoropsConfig(int index) {
    return this.victoropsConfigs.get(index).build();
  }
  public VictorOpsConfig buildFirstVictoropsConfig() {
    return this.victoropsConfigs.get(0).build();
  }
  public VictorOpsConfig buildLastVictoropsConfig() {
    return this.victoropsConfigs.get(victoropsConfigs.size() - 1).build();
  }
  public VictorOpsConfig buildMatchingVictoropsConfig(Predicate<VictorOpsConfigBuilder> predicate) {
    for (VictorOpsConfigBuilder item: victoropsConfigs) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingVictoropsConfig(Predicate<VictorOpsConfigBuilder> predicate) {
    for (VictorOpsConfigBuilder item: victoropsConfigs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withVictoropsConfigs(List<VictorOpsConfig> victoropsConfigs) {
    if (this.victoropsConfigs != null) { _visitables.get("victoropsConfigs").clear();}
    if (victoropsConfigs != null) {this.victoropsConfigs = new ArrayList(); for (VictorOpsConfig item : victoropsConfigs){this.addToVictoropsConfigs(item);}} else { this.victoropsConfigs = null;} return (A) this;
  }
  public A withVictoropsConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.VictorOpsConfig... victoropsConfigs) {
    if (this.victoropsConfigs != null) {this.victoropsConfigs.clear(); _visitables.remove("victoropsConfigs"); }
    if (victoropsConfigs != null) {for (VictorOpsConfig item :victoropsConfigs){ this.addToVictoropsConfigs(item);}} return (A) this;
  }
  public Boolean hasVictoropsConfigs() {
    return victoropsConfigs != null && !victoropsConfigs.isEmpty();
  }
  public ReceiverFluentImpl.VictoropsConfigsNested<A> addNewVictoropsConfig() {
    return new ReceiverFluentImpl.VictoropsConfigsNestedImpl();
  }
  public ReceiverFluentImpl.VictoropsConfigsNested<A> addNewVictoropsConfigLike(VictorOpsConfig item) {
    return new ReceiverFluentImpl.VictoropsConfigsNestedImpl(-1, item);
  }
  public ReceiverFluentImpl.VictoropsConfigsNested<A> setNewVictoropsConfigLike(int index,VictorOpsConfig item) {
    return new ReceiverFluentImpl.VictoropsConfigsNestedImpl(index, item);
  }
  public ReceiverFluentImpl.VictoropsConfigsNested<A> editVictoropsConfig(int index) {
    if (victoropsConfigs.size() <= index) throw new RuntimeException("Can't edit victoropsConfigs. Index exceeds size.");
    return setNewVictoropsConfigLike(index, buildVictoropsConfig(index));
  }
  public ReceiverFluentImpl.VictoropsConfigsNested<A> editFirstVictoropsConfig() {
    if (victoropsConfigs.size() == 0) throw new RuntimeException("Can't edit first victoropsConfigs. The list is empty.");
    return setNewVictoropsConfigLike(0, buildVictoropsConfig(0));
  }
  public ReceiverFluentImpl.VictoropsConfigsNested<A> editLastVictoropsConfig() {
    int index = victoropsConfigs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last victoropsConfigs. The list is empty.");
    return setNewVictoropsConfigLike(index, buildVictoropsConfig(index));
  }
  public ReceiverFluentImpl.VictoropsConfigsNested<A> editMatchingVictoropsConfig(Predicate<VictorOpsConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<victoropsConfigs.size();i++) { 
    if (predicate.test(victoropsConfigs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching victoropsConfigs. No match found.");
    return setNewVictoropsConfigLike(index, buildVictoropsConfig(index));
  }
  public A addToWebhookConfigs(int index,WebhookConfig item) {
    if (this.webhookConfigs == null) {this.webhookConfigs = new ArrayList<WebhookConfigBuilder>();}
    WebhookConfigBuilder builder = new WebhookConfigBuilder(item);
    if (index < 0 || index >= webhookConfigs.size()) { _visitables.get("webhookConfigs").add(builder); webhookConfigs.add(builder); } else { _visitables.get("webhookConfigs").add(index, builder); webhookConfigs.add(index, builder);}
    return (A)this;
  }
  public A setToWebhookConfigs(int index,WebhookConfig item) {
    if (this.webhookConfigs == null) {this.webhookConfigs = new ArrayList<WebhookConfigBuilder>();}
    WebhookConfigBuilder builder = new WebhookConfigBuilder(item);
    if (index < 0 || index >= webhookConfigs.size()) { _visitables.get("webhookConfigs").add(builder); webhookConfigs.add(builder); } else { _visitables.get("webhookConfigs").set(index, builder); webhookConfigs.set(index, builder);}
    return (A)this;
  }
  public A addToWebhookConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.WebhookConfig... items) {
    if (this.webhookConfigs == null) {this.webhookConfigs = new ArrayList<WebhookConfigBuilder>();}
    for (WebhookConfig item : items) {WebhookConfigBuilder builder = new WebhookConfigBuilder(item);_visitables.get("webhookConfigs").add(builder);this.webhookConfigs.add(builder);} return (A)this;
  }
  public A addAllToWebhookConfigs(Collection<WebhookConfig> items) {
    if (this.webhookConfigs == null) {this.webhookConfigs = new ArrayList<WebhookConfigBuilder>();}
    for (WebhookConfig item : items) {WebhookConfigBuilder builder = new WebhookConfigBuilder(item);_visitables.get("webhookConfigs").add(builder);this.webhookConfigs.add(builder);} return (A)this;
  }
  public A removeFromWebhookConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.WebhookConfig... items) {
    for (WebhookConfig item : items) {WebhookConfigBuilder builder = new WebhookConfigBuilder(item);_visitables.get("webhookConfigs").remove(builder);if (this.webhookConfigs != null) {this.webhookConfigs.remove(builder);}} return (A)this;
  }
  public A removeAllFromWebhookConfigs(Collection<WebhookConfig> items) {
    for (WebhookConfig item : items) {WebhookConfigBuilder builder = new WebhookConfigBuilder(item);_visitables.get("webhookConfigs").remove(builder);if (this.webhookConfigs != null) {this.webhookConfigs.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromWebhookConfigs(Predicate<WebhookConfigBuilder> predicate) {
    if (webhookConfigs == null) return (A) this;
    final Iterator<WebhookConfigBuilder> each = webhookConfigs.iterator();
    final List visitables = _visitables.get("webhookConfigs");
    while (each.hasNext()) {
      WebhookConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildWebhookConfigs instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<WebhookConfig> getWebhookConfigs() {
    return webhookConfigs != null ? build(webhookConfigs) : null;
  }
  public List<WebhookConfig> buildWebhookConfigs() {
    return webhookConfigs != null ? build(webhookConfigs) : null;
  }
  public WebhookConfig buildWebhookConfig(int index) {
    return this.webhookConfigs.get(index).build();
  }
  public WebhookConfig buildFirstWebhookConfig() {
    return this.webhookConfigs.get(0).build();
  }
  public WebhookConfig buildLastWebhookConfig() {
    return this.webhookConfigs.get(webhookConfigs.size() - 1).build();
  }
  public WebhookConfig buildMatchingWebhookConfig(Predicate<WebhookConfigBuilder> predicate) {
    for (WebhookConfigBuilder item: webhookConfigs) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingWebhookConfig(Predicate<WebhookConfigBuilder> predicate) {
    for (WebhookConfigBuilder item: webhookConfigs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withWebhookConfigs(List<WebhookConfig> webhookConfigs) {
    if (this.webhookConfigs != null) { _visitables.get("webhookConfigs").clear();}
    if (webhookConfigs != null) {this.webhookConfigs = new ArrayList(); for (WebhookConfig item : webhookConfigs){this.addToWebhookConfigs(item);}} else { this.webhookConfigs = null;} return (A) this;
  }
  public A withWebhookConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.WebhookConfig... webhookConfigs) {
    if (this.webhookConfigs != null) {this.webhookConfigs.clear(); _visitables.remove("webhookConfigs"); }
    if (webhookConfigs != null) {for (WebhookConfig item :webhookConfigs){ this.addToWebhookConfigs(item);}} return (A) this;
  }
  public Boolean hasWebhookConfigs() {
    return webhookConfigs != null && !webhookConfigs.isEmpty();
  }
  public ReceiverFluentImpl.WebhookConfigsNested<A> addNewWebhookConfig() {
    return new ReceiverFluentImpl.WebhookConfigsNestedImpl();
  }
  public ReceiverFluentImpl.WebhookConfigsNested<A> addNewWebhookConfigLike(WebhookConfig item) {
    return new ReceiverFluentImpl.WebhookConfigsNestedImpl(-1, item);
  }
  public ReceiverFluentImpl.WebhookConfigsNested<A> setNewWebhookConfigLike(int index,WebhookConfig item) {
    return new ReceiverFluentImpl.WebhookConfigsNestedImpl(index, item);
  }
  public ReceiverFluentImpl.WebhookConfigsNested<A> editWebhookConfig(int index) {
    if (webhookConfigs.size() <= index) throw new RuntimeException("Can't edit webhookConfigs. Index exceeds size.");
    return setNewWebhookConfigLike(index, buildWebhookConfig(index));
  }
  public ReceiverFluentImpl.WebhookConfigsNested<A> editFirstWebhookConfig() {
    if (webhookConfigs.size() == 0) throw new RuntimeException("Can't edit first webhookConfigs. The list is empty.");
    return setNewWebhookConfigLike(0, buildWebhookConfig(0));
  }
  public ReceiverFluentImpl.WebhookConfigsNested<A> editLastWebhookConfig() {
    int index = webhookConfigs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last webhookConfigs. The list is empty.");
    return setNewWebhookConfigLike(index, buildWebhookConfig(index));
  }
  public ReceiverFluentImpl.WebhookConfigsNested<A> editMatchingWebhookConfig(Predicate<WebhookConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<webhookConfigs.size();i++) { 
    if (predicate.test(webhookConfigs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching webhookConfigs. No match found.");
    return setNewWebhookConfigLike(index, buildWebhookConfig(index));
  }
  public A addToWechatConfigs(int index,WeChatConfig item) {
    if (this.wechatConfigs == null) {this.wechatConfigs = new ArrayList<WeChatConfigBuilder>();}
    WeChatConfigBuilder builder = new WeChatConfigBuilder(item);
    if (index < 0 || index >= wechatConfigs.size()) { _visitables.get("wechatConfigs").add(builder); wechatConfigs.add(builder); } else { _visitables.get("wechatConfigs").add(index, builder); wechatConfigs.add(index, builder);}
    return (A)this;
  }
  public A setToWechatConfigs(int index,WeChatConfig item) {
    if (this.wechatConfigs == null) {this.wechatConfigs = new ArrayList<WeChatConfigBuilder>();}
    WeChatConfigBuilder builder = new WeChatConfigBuilder(item);
    if (index < 0 || index >= wechatConfigs.size()) { _visitables.get("wechatConfigs").add(builder); wechatConfigs.add(builder); } else { _visitables.get("wechatConfigs").set(index, builder); wechatConfigs.set(index, builder);}
    return (A)this;
  }
  public A addToWechatConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.WeChatConfig... items) {
    if (this.wechatConfigs == null) {this.wechatConfigs = new ArrayList<WeChatConfigBuilder>();}
    for (WeChatConfig item : items) {WeChatConfigBuilder builder = new WeChatConfigBuilder(item);_visitables.get("wechatConfigs").add(builder);this.wechatConfigs.add(builder);} return (A)this;
  }
  public A addAllToWechatConfigs(Collection<WeChatConfig> items) {
    if (this.wechatConfigs == null) {this.wechatConfigs = new ArrayList<WeChatConfigBuilder>();}
    for (WeChatConfig item : items) {WeChatConfigBuilder builder = new WeChatConfigBuilder(item);_visitables.get("wechatConfigs").add(builder);this.wechatConfigs.add(builder);} return (A)this;
  }
  public A removeFromWechatConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.WeChatConfig... items) {
    for (WeChatConfig item : items) {WeChatConfigBuilder builder = new WeChatConfigBuilder(item);_visitables.get("wechatConfigs").remove(builder);if (this.wechatConfigs != null) {this.wechatConfigs.remove(builder);}} return (A)this;
  }
  public A removeAllFromWechatConfigs(Collection<WeChatConfig> items) {
    for (WeChatConfig item : items) {WeChatConfigBuilder builder = new WeChatConfigBuilder(item);_visitables.get("wechatConfigs").remove(builder);if (this.wechatConfigs != null) {this.wechatConfigs.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromWechatConfigs(Predicate<WeChatConfigBuilder> predicate) {
    if (wechatConfigs == null) return (A) this;
    final Iterator<WeChatConfigBuilder> each = wechatConfigs.iterator();
    final List visitables = _visitables.get("wechatConfigs");
    while (each.hasNext()) {
      WeChatConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildWechatConfigs instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<WeChatConfig> getWechatConfigs() {
    return wechatConfigs != null ? build(wechatConfigs) : null;
  }
  public List<WeChatConfig> buildWechatConfigs() {
    return wechatConfigs != null ? build(wechatConfigs) : null;
  }
  public WeChatConfig buildWechatConfig(int index) {
    return this.wechatConfigs.get(index).build();
  }
  public WeChatConfig buildFirstWechatConfig() {
    return this.wechatConfigs.get(0).build();
  }
  public WeChatConfig buildLastWechatConfig() {
    return this.wechatConfigs.get(wechatConfigs.size() - 1).build();
  }
  public WeChatConfig buildMatchingWechatConfig(Predicate<WeChatConfigBuilder> predicate) {
    for (WeChatConfigBuilder item: wechatConfigs) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingWechatConfig(Predicate<WeChatConfigBuilder> predicate) {
    for (WeChatConfigBuilder item: wechatConfigs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withWechatConfigs(List<WeChatConfig> wechatConfigs) {
    if (this.wechatConfigs != null) { _visitables.get("wechatConfigs").clear();}
    if (wechatConfigs != null) {this.wechatConfigs = new ArrayList(); for (WeChatConfig item : wechatConfigs){this.addToWechatConfigs(item);}} else { this.wechatConfigs = null;} return (A) this;
  }
  public A withWechatConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.WeChatConfig... wechatConfigs) {
    if (this.wechatConfigs != null) {this.wechatConfigs.clear(); _visitables.remove("wechatConfigs"); }
    if (wechatConfigs != null) {for (WeChatConfig item :wechatConfigs){ this.addToWechatConfigs(item);}} return (A) this;
  }
  public Boolean hasWechatConfigs() {
    return wechatConfigs != null && !wechatConfigs.isEmpty();
  }
  public ReceiverFluentImpl.WechatConfigsNested<A> addNewWechatConfig() {
    return new ReceiverFluentImpl.WechatConfigsNestedImpl();
  }
  public ReceiverFluentImpl.WechatConfigsNested<A> addNewWechatConfigLike(WeChatConfig item) {
    return new ReceiverFluentImpl.WechatConfigsNestedImpl(-1, item);
  }
  public ReceiverFluentImpl.WechatConfigsNested<A> setNewWechatConfigLike(int index,WeChatConfig item) {
    return new ReceiverFluentImpl.WechatConfigsNestedImpl(index, item);
  }
  public ReceiverFluentImpl.WechatConfigsNested<A> editWechatConfig(int index) {
    if (wechatConfigs.size() <= index) throw new RuntimeException("Can't edit wechatConfigs. Index exceeds size.");
    return setNewWechatConfigLike(index, buildWechatConfig(index));
  }
  public ReceiverFluentImpl.WechatConfigsNested<A> editFirstWechatConfig() {
    if (wechatConfigs.size() == 0) throw new RuntimeException("Can't edit first wechatConfigs. The list is empty.");
    return setNewWechatConfigLike(0, buildWechatConfig(0));
  }
  public ReceiverFluentImpl.WechatConfigsNested<A> editLastWechatConfig() {
    int index = wechatConfigs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last wechatConfigs. The list is empty.");
    return setNewWechatConfigLike(index, buildWechatConfig(index));
  }
  public ReceiverFluentImpl.WechatConfigsNested<A> editMatchingWechatConfig(Predicate<WeChatConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<wechatConfigs.size();i++) { 
    if (predicate.test(wechatConfigs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching wechatConfigs. No match found.");
    return setNewWechatConfigLike(index, buildWechatConfig(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ReceiverFluentImpl that = (ReceiverFluentImpl) o;
    if (!java.util.Objects.equals(emailConfigs, that.emailConfigs)) return false;

    if (!java.util.Objects.equals(name, that.name)) return false;

    if (!java.util.Objects.equals(opsgenieConfigs, that.opsgenieConfigs)) return false;

    if (!java.util.Objects.equals(pagerdutyConfigs, that.pagerdutyConfigs)) return false;

    if (!java.util.Objects.equals(pushoverConfigs, that.pushoverConfigs)) return false;

    if (!java.util.Objects.equals(slackConfigs, that.slackConfigs)) return false;

    if (!java.util.Objects.equals(victoropsConfigs, that.victoropsConfigs)) return false;

    if (!java.util.Objects.equals(webhookConfigs, that.webhookConfigs)) return false;

    if (!java.util.Objects.equals(wechatConfigs, that.wechatConfigs)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(emailConfigs,  name,  opsgenieConfigs,  pagerdutyConfigs,  pushoverConfigs,  slackConfigs,  victoropsConfigs,  webhookConfigs,  wechatConfigs,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (emailConfigs != null && !emailConfigs.isEmpty()) { sb.append("emailConfigs:"); sb.append(emailConfigs + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (opsgenieConfigs != null && !opsgenieConfigs.isEmpty()) { sb.append("opsgenieConfigs:"); sb.append(opsgenieConfigs + ","); }
    if (pagerdutyConfigs != null && !pagerdutyConfigs.isEmpty()) { sb.append("pagerdutyConfigs:"); sb.append(pagerdutyConfigs + ","); }
    if (pushoverConfigs != null && !pushoverConfigs.isEmpty()) { sb.append("pushoverConfigs:"); sb.append(pushoverConfigs + ","); }
    if (slackConfigs != null && !slackConfigs.isEmpty()) { sb.append("slackConfigs:"); sb.append(slackConfigs + ","); }
    if (victoropsConfigs != null && !victoropsConfigs.isEmpty()) { sb.append("victoropsConfigs:"); sb.append(victoropsConfigs + ","); }
    if (webhookConfigs != null && !webhookConfigs.isEmpty()) { sb.append("webhookConfigs:"); sb.append(webhookConfigs + ","); }
    if (wechatConfigs != null && !wechatConfigs.isEmpty()) { sb.append("wechatConfigs:"); sb.append(wechatConfigs + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class EmailConfigsNestedImpl<N> extends EmailConfigFluentImpl<ReceiverFluentImpl.EmailConfigsNested<N>> implements ReceiverFluentImpl.EmailConfigsNested<N>,Nested<N>{
    EmailConfigsNestedImpl(int index,EmailConfig item) {
      this.index = index;
      this.builder = new EmailConfigBuilder(this, item);
    }
    EmailConfigsNestedImpl() {
      this.index = -1;
      this.builder = new EmailConfigBuilder(this);
    }
    EmailConfigBuilder builder;
    int index;
    public N and() {
      return (N) ReceiverFluentImpl.this.setToEmailConfigs(index,builder.build());
    }
    public N endEmailConfig() {
      return and();
    }
    
  }
  class OpsgenieConfigsNestedImpl<N> extends OpsGenieConfigFluentImpl<ReceiverFluentImpl.OpsgenieConfigsNested<N>> implements ReceiverFluentImpl.OpsgenieConfigsNested<N>,Nested<N>{
    OpsgenieConfigsNestedImpl(int index,OpsGenieConfig item) {
      this.index = index;
      this.builder = new OpsGenieConfigBuilder(this, item);
    }
    OpsgenieConfigsNestedImpl() {
      this.index = -1;
      this.builder = new OpsGenieConfigBuilder(this);
    }
    OpsGenieConfigBuilder builder;
    int index;
    public N and() {
      return (N) ReceiverFluentImpl.this.setToOpsgenieConfigs(index,builder.build());
    }
    public N endOpsgenieConfig() {
      return and();
    }
    
  }
  class PagerdutyConfigsNestedImpl<N> extends PagerDutyConfigFluentImpl<ReceiverFluentImpl.PagerdutyConfigsNested<N>> implements ReceiverFluentImpl.PagerdutyConfigsNested<N>,Nested<N>{
    PagerdutyConfigsNestedImpl(int index,PagerDutyConfig item) {
      this.index = index;
      this.builder = new PagerDutyConfigBuilder(this, item);
    }
    PagerdutyConfigsNestedImpl() {
      this.index = -1;
      this.builder = new PagerDutyConfigBuilder(this);
    }
    PagerDutyConfigBuilder builder;
    int index;
    public N and() {
      return (N) ReceiverFluentImpl.this.setToPagerdutyConfigs(index,builder.build());
    }
    public N endPagerdutyConfig() {
      return and();
    }
    
  }
  class PushoverConfigsNestedImpl<N> extends PushoverConfigFluentImpl<ReceiverFluentImpl.PushoverConfigsNested<N>> implements ReceiverFluentImpl.PushoverConfigsNested<N>,Nested<N>{
    PushoverConfigsNestedImpl(int index,PushoverConfig item) {
      this.index = index;
      this.builder = new PushoverConfigBuilder(this, item);
    }
    PushoverConfigsNestedImpl() {
      this.index = -1;
      this.builder = new PushoverConfigBuilder(this);
    }
    PushoverConfigBuilder builder;
    int index;
    public N and() {
      return (N) ReceiverFluentImpl.this.setToPushoverConfigs(index,builder.build());
    }
    public N endPushoverConfig() {
      return and();
    }
    
  }
  class SlackConfigsNestedImpl<N> extends SlackConfigFluentImpl<ReceiverFluentImpl.SlackConfigsNested<N>> implements ReceiverFluentImpl.SlackConfigsNested<N>,Nested<N>{
    SlackConfigsNestedImpl(int index,SlackConfig item) {
      this.index = index;
      this.builder = new SlackConfigBuilder(this, item);
    }
    SlackConfigsNestedImpl() {
      this.index = -1;
      this.builder = new SlackConfigBuilder(this);
    }
    SlackConfigBuilder builder;
    int index;
    public N and() {
      return (N) ReceiverFluentImpl.this.setToSlackConfigs(index,builder.build());
    }
    public N endSlackConfig() {
      return and();
    }
    
  }
  class VictoropsConfigsNestedImpl<N> extends VictorOpsConfigFluentImpl<ReceiverFluentImpl.VictoropsConfigsNested<N>> implements ReceiverFluentImpl.VictoropsConfigsNested<N>,Nested<N>{
    VictoropsConfigsNestedImpl(int index,VictorOpsConfig item) {
      this.index = index;
      this.builder = new VictorOpsConfigBuilder(this, item);
    }
    VictoropsConfigsNestedImpl() {
      this.index = -1;
      this.builder = new VictorOpsConfigBuilder(this);
    }
    VictorOpsConfigBuilder builder;
    int index;
    public N and() {
      return (N) ReceiverFluentImpl.this.setToVictoropsConfigs(index,builder.build());
    }
    public N endVictoropsConfig() {
      return and();
    }
    
  }
  class WebhookConfigsNestedImpl<N> extends WebhookConfigFluentImpl<ReceiverFluentImpl.WebhookConfigsNested<N>> implements ReceiverFluentImpl.WebhookConfigsNested<N>,Nested<N>{
    WebhookConfigsNestedImpl(int index,WebhookConfig item) {
      this.index = index;
      this.builder = new WebhookConfigBuilder(this, item);
    }
    WebhookConfigsNestedImpl() {
      this.index = -1;
      this.builder = new WebhookConfigBuilder(this);
    }
    WebhookConfigBuilder builder;
    int index;
    public N and() {
      return (N) ReceiverFluentImpl.this.setToWebhookConfigs(index,builder.build());
    }
    public N endWebhookConfig() {
      return and();
    }
    
  }
  class WechatConfigsNestedImpl<N> extends WeChatConfigFluentImpl<ReceiverFluentImpl.WechatConfigsNested<N>> implements ReceiverFluentImpl.WechatConfigsNested<N>,Nested<N>{
    WechatConfigsNestedImpl(int index,WeChatConfig item) {
      this.index = index;
      this.builder = new WeChatConfigBuilder(this, item);
    }
    WechatConfigsNestedImpl() {
      this.index = -1;
      this.builder = new WeChatConfigBuilder(this);
    }
    WeChatConfigBuilder builder;
    int index;
    public N and() {
      return (N) ReceiverFluentImpl.this.setToWechatConfigs(index,builder.build());
    }
    public N endWechatConfig() {
      return and();
    }
    
  }
  
}