package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface WeChatConfigFluent<A extends WeChatConfigFluent<A>> extends Fluent<A>{
  public String getAgentID();
  public A withAgentID(String agentID);
  public Boolean hasAgentID();
  public SecretKeySelector getApiSecret();
  public A withApiSecret(SecretKeySelector apiSecret);
  public Boolean hasApiSecret();
  public A withNewApiSecret(String key,String name,Boolean optional);
  public String getApiURL();
  public A withApiURL(String apiURL);
  public Boolean hasApiURL();
  public String getCorpID();
  public A withCorpID(String corpID);
  public Boolean hasCorpID();
  
  /**
   * This method has been deprecated, please use method buildHttpConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public HTTPConfig getHttpConfig();
  public HTTPConfig buildHttpConfig();
  public A withHttpConfig(HTTPConfig httpConfig);
  public Boolean hasHttpConfig();
  public WeChatConfigFluent.HttpConfigNested<A> withNewHttpConfig();
  public WeChatConfigFluent.HttpConfigNested<A> withNewHttpConfigLike(HTTPConfig item);
  public WeChatConfigFluent.HttpConfigNested<A> editHttpConfig();
  public WeChatConfigFluent.HttpConfigNested<A> editOrNewHttpConfig();
  public WeChatConfigFluent.HttpConfigNested<A> editOrNewHttpConfigLike(HTTPConfig item);
  public String getMessage();
  public A withMessage(String message);
  public Boolean hasMessage();
  public String getMessageType();
  public A withMessageType(String messageType);
  public Boolean hasMessageType();
  public Boolean getSendResolved();
  public A withSendResolved(Boolean sendResolved);
  public Boolean hasSendResolved();
  public String getToParty();
  public A withToParty(String toParty);
  public Boolean hasToParty();
  public String getToTag();
  public A withToTag(String toTag);
  public Boolean hasToTag();
  public String getToUser();
  public A withToUser(String toUser);
  public Boolean hasToUser();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public A withSendResolved();
  public interface HttpConfigNested<N> extends Nested<N>,HTTPConfigFluent<WeChatConfigFluent.HttpConfigNested<N>>{
    public N and();
    public N endHttpConfig();
    
  }
  
}