/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Affinity;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.ContainerFluentImpl;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.PodSecurityContext;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluentImpl;
import io.fabric8.kubernetes.api.model.Toleration;
import io.fabric8.kubernetes.api.model.TopologySpreadConstraint;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerSpec;
import io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerSpecFluent;
import io.fabric8.openshift.api.model.monitoring.v1.EmbeddedObjectMetadata;
import io.fabric8.openshift.api.model.monitoring.v1.EmbeddedObjectMetadataBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.EmbeddedObjectMetadataFluentImpl;
import io.fabric8.openshift.api.model.monitoring.v1.StorageSpec;
import io.fabric8.openshift.api.model.monitoring.v1.StorageSpecBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.StorageSpecFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class AlertmanagerSpecFluentImpl<A extends AlertmanagerSpecFluent<A>>
extends BaseFluent<A>
implements AlertmanagerSpecFluent<A> {
    private List<String> additionalPeers = new ArrayList<String>();
    private Affinity affinity;
    private LabelSelectorBuilder alertmanagerConfigNamespaceSelector;
    private LabelSelectorBuilder alertmanagerConfigSelector;
    private String baseImage;
    private String clusterAdvertiseAddress;
    private String clusterGossipInterval;
    private String clusterPeerTimeout;
    private String clusterPushpullInterval;
    private List<String> configMaps = new ArrayList<String>();
    private String configSecret;
    private ArrayList<ContainerBuilder> containers = new ArrayList();
    private String externalUrl;
    private Boolean forceEnableClusterMode;
    private String image;
    private ArrayList<LocalObjectReferenceBuilder> imagePullSecrets = new ArrayList();
    private ArrayList<ContainerBuilder> initContainers = new ArrayList();
    private Boolean listenLocal;
    private String logFormat;
    private String logLevel;
    private Integer minReadySeconds;
    private Map<String, String> nodeSelector;
    private Boolean paused;
    private EmbeddedObjectMetadataBuilder podMetadata;
    private String portName;
    private String priorityClassName;
    private Integer replicas;
    private ResourceRequirementsBuilder resources;
    private String retention;
    private String routePrefix;
    private List<String> secrets = new ArrayList<String>();
    private PodSecurityContext securityContext;
    private String serviceAccountName;
    private String sha;
    private StorageSpecBuilder storage;
    private String tag;
    private List<Toleration> tolerations = new ArrayList<Toleration>();
    private List<TopologySpreadConstraint> topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
    private String version;
    private List<VolumeMount> volumeMounts = new ArrayList<VolumeMount>();
    private List<Volume> volumes = new ArrayList<Volume>();
    private Map<String, Object> additionalProperties;

    public AlertmanagerSpecFluentImpl() {
    }

    public AlertmanagerSpecFluentImpl(AlertmanagerSpec instance) {
        if (instance != null) {
            this.withAdditionalPeers(instance.getAdditionalPeers());
            this.withAffinity(instance.getAffinity());
            this.withAlertmanagerConfigNamespaceSelector(instance.getAlertmanagerConfigNamespaceSelector());
            this.withAlertmanagerConfigSelector(instance.getAlertmanagerConfigSelector());
            this.withBaseImage(instance.getBaseImage());
            this.withClusterAdvertiseAddress(instance.getClusterAdvertiseAddress());
            this.withClusterGossipInterval(instance.getClusterGossipInterval());
            this.withClusterPeerTimeout(instance.getClusterPeerTimeout());
            this.withClusterPushpullInterval(instance.getClusterPushpullInterval());
            this.withConfigMaps(instance.getConfigMaps());
            this.withConfigSecret(instance.getConfigSecret());
            this.withContainers(instance.getContainers());
            this.withExternalUrl(instance.getExternalUrl());
            this.withForceEnableClusterMode(instance.getForceEnableClusterMode());
            this.withImage(instance.getImage());
            this.withImagePullSecrets(instance.getImagePullSecrets());
            this.withInitContainers(instance.getInitContainers());
            this.withListenLocal(instance.getListenLocal());
            this.withLogFormat(instance.getLogFormat());
            this.withLogLevel(instance.getLogLevel());
            this.withMinReadySeconds(instance.getMinReadySeconds());
            this.withNodeSelector(instance.getNodeSelector());
            this.withPaused(instance.getPaused());
            this.withPodMetadata(instance.getPodMetadata());
            this.withPortName(instance.getPortName());
            this.withPriorityClassName(instance.getPriorityClassName());
            this.withReplicas(instance.getReplicas());
            this.withResources(instance.getResources());
            this.withRetention(instance.getRetention());
            this.withRoutePrefix(instance.getRoutePrefix());
            this.withSecrets(instance.getSecrets());
            this.withSecurityContext(instance.getSecurityContext());
            this.withServiceAccountName(instance.getServiceAccountName());
            this.withSha(instance.getSha());
            this.withStorage(instance.getStorage());
            this.withTag(instance.getTag());
            this.withTolerations(instance.getTolerations());
            this.withTopologySpreadConstraints(instance.getTopologySpreadConstraints());
            this.withVersion(instance.getVersion());
            this.withVolumeMounts(instance.getVolumeMounts());
            this.withVolumes(instance.getVolumes());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public A addToAdditionalPeers(int index, String item) {
        if (this.additionalPeers == null) {
            this.additionalPeers = new ArrayList<String>();
        }
        this.additionalPeers.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAdditionalPeers(int index, String item) {
        if (this.additionalPeers == null) {
            this.additionalPeers = new ArrayList<String>();
        }
        this.additionalPeers.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAdditionalPeers(String ... items) {
        if (this.additionalPeers == null) {
            this.additionalPeers = new ArrayList<String>();
        }
        for (String item : items) {
            this.additionalPeers.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAdditionalPeers(Collection<String> items) {
        if (this.additionalPeers == null) {
            this.additionalPeers = new ArrayList<String>();
        }
        for (String item : items) {
            this.additionalPeers.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalPeers(String ... items) {
        for (String item : items) {
            if (this.additionalPeers == null) continue;
            this.additionalPeers.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAdditionalPeers(Collection<String> items) {
        for (String item : items) {
            if (this.additionalPeers == null) continue;
            this.additionalPeers.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAdditionalPeers() {
        return this.additionalPeers;
    }

    @Override
    public String getAdditionalPeer(int index) {
        return this.additionalPeers.get(index);
    }

    @Override
    public String getFirstAdditionalPeer() {
        return this.additionalPeers.get(0);
    }

    @Override
    public String getLastAdditionalPeer() {
        return this.additionalPeers.get(this.additionalPeers.size() - 1);
    }

    @Override
    public String getMatchingAdditionalPeer(Predicate<String> predicate) {
        for (String item : this.additionalPeers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAdditionalPeer(Predicate<String> predicate) {
        for (String item : this.additionalPeers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAdditionalPeers(List<String> additionalPeers) {
        if (additionalPeers != null) {
            this.additionalPeers = new ArrayList<String>();
            for (String item : additionalPeers) {
                this.addToAdditionalPeers(item);
            }
        } else {
            this.additionalPeers = null;
        }
        return (A)this;
    }

    @Override
    public A withAdditionalPeers(String ... additionalPeers) {
        if (this.additionalPeers != null) {
            this.additionalPeers.clear();
            this._visitables.remove((Object)"additionalPeers");
        }
        if (additionalPeers != null) {
            for (String item : additionalPeers) {
                this.addToAdditionalPeers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalPeers() {
        return this.additionalPeers != null && !this.additionalPeers.isEmpty();
    }

    @Override
    public Affinity getAffinity() {
        return this.affinity;
    }

    @Override
    public A withAffinity(Affinity affinity) {
        this.affinity = affinity;
        return (A)this;
    }

    @Override
    public Boolean hasAffinity() {
        return this.affinity != null;
    }

    @Override
    @Deprecated
    public LabelSelector getAlertmanagerConfigNamespaceSelector() {
        return this.alertmanagerConfigNamespaceSelector != null ? this.alertmanagerConfigNamespaceSelector.build() : null;
    }

    @Override
    public LabelSelector buildAlertmanagerConfigNamespaceSelector() {
        return this.alertmanagerConfigNamespaceSelector != null ? this.alertmanagerConfigNamespaceSelector.build() : null;
    }

    @Override
    public A withAlertmanagerConfigNamespaceSelector(LabelSelector alertmanagerConfigNamespaceSelector) {
        this._visitables.get((Object)"alertmanagerConfigNamespaceSelector").remove(this.alertmanagerConfigNamespaceSelector);
        if (alertmanagerConfigNamespaceSelector != null) {
            this.alertmanagerConfigNamespaceSelector = new LabelSelectorBuilder(alertmanagerConfigNamespaceSelector);
            this._visitables.get((Object)"alertmanagerConfigNamespaceSelector").add(this.alertmanagerConfigNamespaceSelector);
        } else {
            this.alertmanagerConfigNamespaceSelector = null;
            this._visitables.get((Object)"alertmanagerConfigNamespaceSelector").remove(this.alertmanagerConfigNamespaceSelector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAlertmanagerConfigNamespaceSelector() {
        return this.alertmanagerConfigNamespaceSelector != null;
    }

    @Override
    public AlertmanagerSpecFluent.AlertmanagerConfigNamespaceSelectorNested<A> withNewAlertmanagerConfigNamespaceSelector() {
        return new AlertmanagerConfigNamespaceSelectorNestedImpl();
    }

    @Override
    public AlertmanagerSpecFluent.AlertmanagerConfigNamespaceSelectorNested<A> withNewAlertmanagerConfigNamespaceSelectorLike(LabelSelector item) {
        return new AlertmanagerConfigNamespaceSelectorNestedImpl(item);
    }

    @Override
    public AlertmanagerSpecFluent.AlertmanagerConfigNamespaceSelectorNested<A> editAlertmanagerConfigNamespaceSelector() {
        return this.withNewAlertmanagerConfigNamespaceSelectorLike(this.getAlertmanagerConfigNamespaceSelector());
    }

    @Override
    public AlertmanagerSpecFluent.AlertmanagerConfigNamespaceSelectorNested<A> editOrNewAlertmanagerConfigNamespaceSelector() {
        return this.withNewAlertmanagerConfigNamespaceSelectorLike(this.getAlertmanagerConfigNamespaceSelector() != null ? this.getAlertmanagerConfigNamespaceSelector() : new LabelSelectorBuilder().build());
    }

    @Override
    public AlertmanagerSpecFluent.AlertmanagerConfigNamespaceSelectorNested<A> editOrNewAlertmanagerConfigNamespaceSelectorLike(LabelSelector item) {
        return this.withNewAlertmanagerConfigNamespaceSelectorLike(this.getAlertmanagerConfigNamespaceSelector() != null ? this.getAlertmanagerConfigNamespaceSelector() : item);
    }

    @Override
    @Deprecated
    public LabelSelector getAlertmanagerConfigSelector() {
        return this.alertmanagerConfigSelector != null ? this.alertmanagerConfigSelector.build() : null;
    }

    @Override
    public LabelSelector buildAlertmanagerConfigSelector() {
        return this.alertmanagerConfigSelector != null ? this.alertmanagerConfigSelector.build() : null;
    }

    @Override
    public A withAlertmanagerConfigSelector(LabelSelector alertmanagerConfigSelector) {
        this._visitables.get((Object)"alertmanagerConfigSelector").remove(this.alertmanagerConfigSelector);
        if (alertmanagerConfigSelector != null) {
            this.alertmanagerConfigSelector = new LabelSelectorBuilder(alertmanagerConfigSelector);
            this._visitables.get((Object)"alertmanagerConfigSelector").add(this.alertmanagerConfigSelector);
        } else {
            this.alertmanagerConfigSelector = null;
            this._visitables.get((Object)"alertmanagerConfigSelector").remove(this.alertmanagerConfigSelector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAlertmanagerConfigSelector() {
        return this.alertmanagerConfigSelector != null;
    }

    @Override
    public AlertmanagerSpecFluent.AlertmanagerConfigSelectorNested<A> withNewAlertmanagerConfigSelector() {
        return new AlertmanagerConfigSelectorNestedImpl();
    }

    @Override
    public AlertmanagerSpecFluent.AlertmanagerConfigSelectorNested<A> withNewAlertmanagerConfigSelectorLike(LabelSelector item) {
        return new AlertmanagerConfigSelectorNestedImpl(item);
    }

    @Override
    public AlertmanagerSpecFluent.AlertmanagerConfigSelectorNested<A> editAlertmanagerConfigSelector() {
        return this.withNewAlertmanagerConfigSelectorLike(this.getAlertmanagerConfigSelector());
    }

    @Override
    public AlertmanagerSpecFluent.AlertmanagerConfigSelectorNested<A> editOrNewAlertmanagerConfigSelector() {
        return this.withNewAlertmanagerConfigSelectorLike(this.getAlertmanagerConfigSelector() != null ? this.getAlertmanagerConfigSelector() : new LabelSelectorBuilder().build());
    }

    @Override
    public AlertmanagerSpecFluent.AlertmanagerConfigSelectorNested<A> editOrNewAlertmanagerConfigSelectorLike(LabelSelector item) {
        return this.withNewAlertmanagerConfigSelectorLike(this.getAlertmanagerConfigSelector() != null ? this.getAlertmanagerConfigSelector() : item);
    }

    @Override
    public String getBaseImage() {
        return this.baseImage;
    }

    @Override
    public A withBaseImage(String baseImage) {
        this.baseImage = baseImage;
        return (A)this;
    }

    @Override
    public Boolean hasBaseImage() {
        return this.baseImage != null;
    }

    @Override
    public String getClusterAdvertiseAddress() {
        return this.clusterAdvertiseAddress;
    }

    @Override
    public A withClusterAdvertiseAddress(String clusterAdvertiseAddress) {
        this.clusterAdvertiseAddress = clusterAdvertiseAddress;
        return (A)this;
    }

    @Override
    public Boolean hasClusterAdvertiseAddress() {
        return this.clusterAdvertiseAddress != null;
    }

    @Override
    public String getClusterGossipInterval() {
        return this.clusterGossipInterval;
    }

    @Override
    public A withClusterGossipInterval(String clusterGossipInterval) {
        this.clusterGossipInterval = clusterGossipInterval;
        return (A)this;
    }

    @Override
    public Boolean hasClusterGossipInterval() {
        return this.clusterGossipInterval != null;
    }

    @Override
    public String getClusterPeerTimeout() {
        return this.clusterPeerTimeout;
    }

    @Override
    public A withClusterPeerTimeout(String clusterPeerTimeout) {
        this.clusterPeerTimeout = clusterPeerTimeout;
        return (A)this;
    }

    @Override
    public Boolean hasClusterPeerTimeout() {
        return this.clusterPeerTimeout != null;
    }

    @Override
    public String getClusterPushpullInterval() {
        return this.clusterPushpullInterval;
    }

    @Override
    public A withClusterPushpullInterval(String clusterPushpullInterval) {
        this.clusterPushpullInterval = clusterPushpullInterval;
        return (A)this;
    }

    @Override
    public Boolean hasClusterPushpullInterval() {
        return this.clusterPushpullInterval != null;
    }

    @Override
    public A addToConfigMaps(int index, String item) {
        if (this.configMaps == null) {
            this.configMaps = new ArrayList<String>();
        }
        this.configMaps.add(index, item);
        return (A)this;
    }

    @Override
    public A setToConfigMaps(int index, String item) {
        if (this.configMaps == null) {
            this.configMaps = new ArrayList<String>();
        }
        this.configMaps.set(index, item);
        return (A)this;
    }

    @Override
    public A addToConfigMaps(String ... items) {
        if (this.configMaps == null) {
            this.configMaps = new ArrayList<String>();
        }
        for (String item : items) {
            this.configMaps.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToConfigMaps(Collection<String> items) {
        if (this.configMaps == null) {
            this.configMaps = new ArrayList<String>();
        }
        for (String item : items) {
            this.configMaps.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromConfigMaps(String ... items) {
        for (String item : items) {
            if (this.configMaps == null) continue;
            this.configMaps.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConfigMaps(Collection<String> items) {
        for (String item : items) {
            if (this.configMaps == null) continue;
            this.configMaps.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getConfigMaps() {
        return this.configMaps;
    }

    @Override
    public String getConfigMap(int index) {
        return this.configMaps.get(index);
    }

    @Override
    public String getFirstConfigMap() {
        return this.configMaps.get(0);
    }

    @Override
    public String getLastConfigMap() {
        return this.configMaps.get(this.configMaps.size() - 1);
    }

    @Override
    public String getMatchingConfigMap(Predicate<String> predicate) {
        for (String item : this.configMaps) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingConfigMap(Predicate<String> predicate) {
        for (String item : this.configMaps) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConfigMaps(List<String> configMaps) {
        if (configMaps != null) {
            this.configMaps = new ArrayList<String>();
            for (String item : configMaps) {
                this.addToConfigMaps(item);
            }
        } else {
            this.configMaps = null;
        }
        return (A)this;
    }

    @Override
    public A withConfigMaps(String ... configMaps) {
        if (this.configMaps != null) {
            this.configMaps.clear();
            this._visitables.remove((Object)"configMaps");
        }
        if (configMaps != null) {
            for (String item : configMaps) {
                this.addToConfigMaps(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConfigMaps() {
        return this.configMaps != null && !this.configMaps.isEmpty();
    }

    @Override
    public String getConfigSecret() {
        return this.configSecret;
    }

    @Override
    public A withConfigSecret(String configSecret) {
        this.configSecret = configSecret;
        return (A)this;
    }

    @Override
    public Boolean hasConfigSecret() {
        return this.configSecret != null;
    }

    @Override
    public A addToContainers(int index, Container item) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        if (index < 0 || index >= this.containers.size()) {
            this._visitables.get((Object)"containers").add(builder);
            this.containers.add(builder);
        } else {
            this._visitables.get((Object)"containers").add(index, builder);
            this.containers.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToContainers(int index, Container item) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        if (index < 0 || index >= this.containers.size()) {
            this._visitables.get((Object)"containers").add(builder);
            this.containers.add(builder);
        } else {
            this._visitables.get((Object)"containers").set(index, builder);
            this.containers.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToContainers(Container ... items) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"containers").add(builder);
            this.containers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToContainers(Collection<Container> items) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"containers").add(builder);
            this.containers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromContainers(Container ... items) {
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"containers").remove(builder);
            if (this.containers == null) continue;
            this.containers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromContainers(Collection<Container> items) {
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"containers").remove(builder);
            if (this.containers == null) continue;
            this.containers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromContainers(Predicate<ContainerBuilder> predicate) {
        if (this.containers == null) {
            return (A)this;
        }
        Iterator<ContainerBuilder> each = this.containers.iterator();
        List visitables = this._visitables.get((Object)"containers");
        while (each.hasNext()) {
            ContainerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Container> getContainers() {
        return this.containers != null ? AlertmanagerSpecFluentImpl.build(this.containers) : null;
    }

    @Override
    public List<Container> buildContainers() {
        return this.containers != null ? AlertmanagerSpecFluentImpl.build(this.containers) : null;
    }

    @Override
    public Container buildContainer(int index) {
        return this.containers.get(index).build();
    }

    @Override
    public Container buildFirstContainer() {
        return this.containers.get(0).build();
    }

    @Override
    public Container buildLastContainer() {
        return this.containers.get(this.containers.size() - 1).build();
    }

    @Override
    public Container buildMatchingContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.containers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.containers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withContainers(List<Container> containers) {
        if (this.containers != null) {
            this._visitables.get((Object)"containers").clear();
        }
        if (containers != null) {
            this.containers = new ArrayList();
            for (Container item : containers) {
                this.addToContainers(item);
            }
        } else {
            this.containers = null;
        }
        return (A)this;
    }

    @Override
    public A withContainers(Container ... containers) {
        if (this.containers != null) {
            this.containers.clear();
            this._visitables.remove((Object)"containers");
        }
        if (containers != null) {
            for (Container item : containers) {
                this.addToContainers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasContainers() {
        return this.containers != null && !this.containers.isEmpty();
    }

    @Override
    public AlertmanagerSpecFluent.ContainersNested<A> addNewContainer() {
        return new ContainersNestedImpl();
    }

    @Override
    public AlertmanagerSpecFluent.ContainersNested<A> addNewContainerLike(Container item) {
        return new ContainersNestedImpl(-1, item);
    }

    @Override
    public AlertmanagerSpecFluent.ContainersNested<A> setNewContainerLike(int index, Container item) {
        return new ContainersNestedImpl(index, item);
    }

    @Override
    public AlertmanagerSpecFluent.ContainersNested<A> editContainer(int index) {
        if (this.containers.size() <= index) {
            throw new RuntimeException("Can't edit containers. Index exceeds size.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    @Override
    public AlertmanagerSpecFluent.ContainersNested<A> editFirstContainer() {
        if (this.containers.size() == 0) {
            throw new RuntimeException("Can't edit first containers. The list is empty.");
        }
        return this.setNewContainerLike(0, this.buildContainer(0));
    }

    @Override
    public AlertmanagerSpecFluent.ContainersNested<A> editLastContainer() {
        int index = this.containers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last containers. The list is empty.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    @Override
    public AlertmanagerSpecFluent.ContainersNested<A> editMatchingContainer(Predicate<ContainerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.containers.size(); ++i) {
            if (!predicate.test(this.containers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching containers. No match found.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    @Override
    public String getExternalUrl() {
        return this.externalUrl;
    }

    @Override
    public A withExternalUrl(String externalUrl) {
        this.externalUrl = externalUrl;
        return (A)this;
    }

    @Override
    public Boolean hasExternalUrl() {
        return this.externalUrl != null;
    }

    @Override
    public Boolean getForceEnableClusterMode() {
        return this.forceEnableClusterMode;
    }

    @Override
    public A withForceEnableClusterMode(Boolean forceEnableClusterMode) {
        this.forceEnableClusterMode = forceEnableClusterMode;
        return (A)this;
    }

    @Override
    public Boolean hasForceEnableClusterMode() {
        return this.forceEnableClusterMode != null;
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public A withImage(String image) {
        this.image = image;
        return (A)this;
    }

    @Override
    public Boolean hasImage() {
        return this.image != null;
    }

    @Override
    public A addToImagePullSecrets(int index, LocalObjectReference item) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList();
        }
        LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
        if (index < 0 || index >= this.imagePullSecrets.size()) {
            this._visitables.get((Object)"imagePullSecrets").add(builder);
            this.imagePullSecrets.add(builder);
        } else {
            this._visitables.get((Object)"imagePullSecrets").add(index, builder);
            this.imagePullSecrets.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToImagePullSecrets(int index, LocalObjectReference item) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList();
        }
        LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
        if (index < 0 || index >= this.imagePullSecrets.size()) {
            this._visitables.get((Object)"imagePullSecrets").add(builder);
            this.imagePullSecrets.add(builder);
        } else {
            this._visitables.get((Object)"imagePullSecrets").set(index, builder);
            this.imagePullSecrets.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToImagePullSecrets(LocalObjectReference ... items) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList();
        }
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.get((Object)"imagePullSecrets").add(builder);
            this.imagePullSecrets.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToImagePullSecrets(Collection<LocalObjectReference> items) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList();
        }
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.get((Object)"imagePullSecrets").add(builder);
            this.imagePullSecrets.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromImagePullSecrets(LocalObjectReference ... items) {
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.get((Object)"imagePullSecrets").remove(builder);
            if (this.imagePullSecrets == null) continue;
            this.imagePullSecrets.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromImagePullSecrets(Collection<LocalObjectReference> items) {
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.get((Object)"imagePullSecrets").remove(builder);
            if (this.imagePullSecrets == null) continue;
            this.imagePullSecrets.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromImagePullSecrets(Predicate<LocalObjectReferenceBuilder> predicate) {
        if (this.imagePullSecrets == null) {
            return (A)this;
        }
        Iterator<LocalObjectReferenceBuilder> each = this.imagePullSecrets.iterator();
        List visitables = this._visitables.get((Object)"imagePullSecrets");
        while (each.hasNext()) {
            LocalObjectReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<LocalObjectReference> getImagePullSecrets() {
        return this.imagePullSecrets != null ? AlertmanagerSpecFluentImpl.build(this.imagePullSecrets) : null;
    }

    @Override
    public List<LocalObjectReference> buildImagePullSecrets() {
        return this.imagePullSecrets != null ? AlertmanagerSpecFluentImpl.build(this.imagePullSecrets) : null;
    }

    @Override
    public LocalObjectReference buildImagePullSecret(int index) {
        return this.imagePullSecrets.get(index).build();
    }

    @Override
    public LocalObjectReference buildFirstImagePullSecret() {
        return this.imagePullSecrets.get(0).build();
    }

    @Override
    public LocalObjectReference buildLastImagePullSecret() {
        return this.imagePullSecrets.get(this.imagePullSecrets.size() - 1).build();
    }

    @Override
    public LocalObjectReference buildMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
        for (LocalObjectReferenceBuilder item : this.imagePullSecrets) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
        for (LocalObjectReferenceBuilder item : this.imagePullSecrets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withImagePullSecrets(List<LocalObjectReference> imagePullSecrets) {
        if (this.imagePullSecrets != null) {
            this._visitables.get((Object)"imagePullSecrets").clear();
        }
        if (imagePullSecrets != null) {
            this.imagePullSecrets = new ArrayList();
            for (LocalObjectReference item : imagePullSecrets) {
                this.addToImagePullSecrets(item);
            }
        } else {
            this.imagePullSecrets = null;
        }
        return (A)this;
    }

    @Override
    public A withImagePullSecrets(LocalObjectReference ... imagePullSecrets) {
        if (this.imagePullSecrets != null) {
            this.imagePullSecrets.clear();
            this._visitables.remove((Object)"imagePullSecrets");
        }
        if (imagePullSecrets != null) {
            for (LocalObjectReference item : imagePullSecrets) {
                this.addToImagePullSecrets(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasImagePullSecrets() {
        return this.imagePullSecrets != null && !this.imagePullSecrets.isEmpty();
    }

    @Override
    public A addNewImagePullSecret(String name) {
        return this.addToImagePullSecrets(new LocalObjectReference(name));
    }

    @Override
    public AlertmanagerSpecFluent.ImagePullSecretsNested<A> addNewImagePullSecret() {
        return new ImagePullSecretsNestedImpl();
    }

    @Override
    public AlertmanagerSpecFluent.ImagePullSecretsNested<A> addNewImagePullSecretLike(LocalObjectReference item) {
        return new ImagePullSecretsNestedImpl(-1, item);
    }

    @Override
    public AlertmanagerSpecFluent.ImagePullSecretsNested<A> setNewImagePullSecretLike(int index, LocalObjectReference item) {
        return new ImagePullSecretsNestedImpl(index, item);
    }

    @Override
    public AlertmanagerSpecFluent.ImagePullSecretsNested<A> editImagePullSecret(int index) {
        if (this.imagePullSecrets.size() <= index) {
            throw new RuntimeException("Can't edit imagePullSecrets. Index exceeds size.");
        }
        return this.setNewImagePullSecretLike(index, this.buildImagePullSecret(index));
    }

    @Override
    public AlertmanagerSpecFluent.ImagePullSecretsNested<A> editFirstImagePullSecret() {
        if (this.imagePullSecrets.size() == 0) {
            throw new RuntimeException("Can't edit first imagePullSecrets. The list is empty.");
        }
        return this.setNewImagePullSecretLike(0, this.buildImagePullSecret(0));
    }

    @Override
    public AlertmanagerSpecFluent.ImagePullSecretsNested<A> editLastImagePullSecret() {
        int index = this.imagePullSecrets.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last imagePullSecrets. The list is empty.");
        }
        return this.setNewImagePullSecretLike(index, this.buildImagePullSecret(index));
    }

    @Override
    public AlertmanagerSpecFluent.ImagePullSecretsNested<A> editMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.imagePullSecrets.size(); ++i) {
            if (!predicate.test(this.imagePullSecrets.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching imagePullSecrets. No match found.");
        }
        return this.setNewImagePullSecretLike(index, this.buildImagePullSecret(index));
    }

    @Override
    public A addToInitContainers(int index, Container item) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        if (index < 0 || index >= this.initContainers.size()) {
            this._visitables.get((Object)"initContainers").add(builder);
            this.initContainers.add(builder);
        } else {
            this._visitables.get((Object)"initContainers").add(index, builder);
            this.initContainers.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToInitContainers(int index, Container item) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        if (index < 0 || index >= this.initContainers.size()) {
            this._visitables.get((Object)"initContainers").add(builder);
            this.initContainers.add(builder);
        } else {
            this._visitables.get((Object)"initContainers").set(index, builder);
            this.initContainers.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToInitContainers(Container ... items) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"initContainers").add(builder);
            this.initContainers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToInitContainers(Collection<Container> items) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"initContainers").add(builder);
            this.initContainers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromInitContainers(Container ... items) {
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"initContainers").remove(builder);
            if (this.initContainers == null) continue;
            this.initContainers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromInitContainers(Collection<Container> items) {
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"initContainers").remove(builder);
            if (this.initContainers == null) continue;
            this.initContainers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromInitContainers(Predicate<ContainerBuilder> predicate) {
        if (this.initContainers == null) {
            return (A)this;
        }
        Iterator<ContainerBuilder> each = this.initContainers.iterator();
        List visitables = this._visitables.get((Object)"initContainers");
        while (each.hasNext()) {
            ContainerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Container> getInitContainers() {
        return this.initContainers != null ? AlertmanagerSpecFluentImpl.build(this.initContainers) : null;
    }

    @Override
    public List<Container> buildInitContainers() {
        return this.initContainers != null ? AlertmanagerSpecFluentImpl.build(this.initContainers) : null;
    }

    @Override
    public Container buildInitContainer(int index) {
        return this.initContainers.get(index).build();
    }

    @Override
    public Container buildFirstInitContainer() {
        return this.initContainers.get(0).build();
    }

    @Override
    public Container buildLastInitContainer() {
        return this.initContainers.get(this.initContainers.size() - 1).build();
    }

    @Override
    public Container buildMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.initContainers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.initContainers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withInitContainers(List<Container> initContainers) {
        if (this.initContainers != null) {
            this._visitables.get((Object)"initContainers").clear();
        }
        if (initContainers != null) {
            this.initContainers = new ArrayList();
            for (Container item : initContainers) {
                this.addToInitContainers(item);
            }
        } else {
            this.initContainers = null;
        }
        return (A)this;
    }

    @Override
    public A withInitContainers(Container ... initContainers) {
        if (this.initContainers != null) {
            this.initContainers.clear();
            this._visitables.remove((Object)"initContainers");
        }
        if (initContainers != null) {
            for (Container item : initContainers) {
                this.addToInitContainers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasInitContainers() {
        return this.initContainers != null && !this.initContainers.isEmpty();
    }

    @Override
    public AlertmanagerSpecFluent.InitContainersNested<A> addNewInitContainer() {
        return new InitContainersNestedImpl();
    }

    @Override
    public AlertmanagerSpecFluent.InitContainersNested<A> addNewInitContainerLike(Container item) {
        return new InitContainersNestedImpl(-1, item);
    }

    @Override
    public AlertmanagerSpecFluent.InitContainersNested<A> setNewInitContainerLike(int index, Container item) {
        return new InitContainersNestedImpl(index, item);
    }

    @Override
    public AlertmanagerSpecFluent.InitContainersNested<A> editInitContainer(int index) {
        if (this.initContainers.size() <= index) {
            throw new RuntimeException("Can't edit initContainers. Index exceeds size.");
        }
        return this.setNewInitContainerLike(index, this.buildInitContainer(index));
    }

    @Override
    public AlertmanagerSpecFluent.InitContainersNested<A> editFirstInitContainer() {
        if (this.initContainers.size() == 0) {
            throw new RuntimeException("Can't edit first initContainers. The list is empty.");
        }
        return this.setNewInitContainerLike(0, this.buildInitContainer(0));
    }

    @Override
    public AlertmanagerSpecFluent.InitContainersNested<A> editLastInitContainer() {
        int index = this.initContainers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last initContainers. The list is empty.");
        }
        return this.setNewInitContainerLike(index, this.buildInitContainer(index));
    }

    @Override
    public AlertmanagerSpecFluent.InitContainersNested<A> editMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.initContainers.size(); ++i) {
            if (!predicate.test(this.initContainers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching initContainers. No match found.");
        }
        return this.setNewInitContainerLike(index, this.buildInitContainer(index));
    }

    @Override
    public Boolean getListenLocal() {
        return this.listenLocal;
    }

    @Override
    public A withListenLocal(Boolean listenLocal) {
        this.listenLocal = listenLocal;
        return (A)this;
    }

    @Override
    public Boolean hasListenLocal() {
        return this.listenLocal != null;
    }

    @Override
    public String getLogFormat() {
        return this.logFormat;
    }

    @Override
    public A withLogFormat(String logFormat) {
        this.logFormat = logFormat;
        return (A)this;
    }

    @Override
    public Boolean hasLogFormat() {
        return this.logFormat != null;
    }

    @Override
    public String getLogLevel() {
        return this.logLevel;
    }

    @Override
    public A withLogLevel(String logLevel) {
        this.logLevel = logLevel;
        return (A)this;
    }

    @Override
    public Boolean hasLogLevel() {
        return this.logLevel != null;
    }

    @Override
    public Integer getMinReadySeconds() {
        return this.minReadySeconds;
    }

    @Override
    public A withMinReadySeconds(Integer minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
        return (A)this;
    }

    @Override
    public Boolean hasMinReadySeconds() {
        return this.minReadySeconds != null;
    }

    @Override
    public A addToNodeSelector(String key, String value) {
        if (this.nodeSelector == null && key != null && value != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.nodeSelector.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null && map != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.nodeSelector.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromNodeSelector(String key) {
        if (this.nodeSelector == null) {
            return (A)this;
        }
        if (key != null && this.nodeSelector != null) {
            this.nodeSelector.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.nodeSelector == null) continue;
                this.nodeSelector.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getNodeSelector() {
        return this.nodeSelector;
    }

    @Override
    public <K, V> A withNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector == null ? null : new LinkedHashMap<String, String>(nodeSelector);
        return (A)this;
    }

    @Override
    public Boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    @Override
    public Boolean getPaused() {
        return this.paused;
    }

    @Override
    public A withPaused(Boolean paused) {
        this.paused = paused;
        return (A)this;
    }

    @Override
    public Boolean hasPaused() {
        return this.paused != null;
    }

    @Override
    @Deprecated
    public EmbeddedObjectMetadata getPodMetadata() {
        return this.podMetadata != null ? this.podMetadata.build() : null;
    }

    @Override
    public EmbeddedObjectMetadata buildPodMetadata() {
        return this.podMetadata != null ? this.podMetadata.build() : null;
    }

    @Override
    public A withPodMetadata(EmbeddedObjectMetadata podMetadata) {
        this._visitables.get((Object)"podMetadata").remove(this.podMetadata);
        if (podMetadata != null) {
            this.podMetadata = new EmbeddedObjectMetadataBuilder(podMetadata);
            this._visitables.get((Object)"podMetadata").add(this.podMetadata);
        } else {
            this.podMetadata = null;
            this._visitables.get((Object)"podMetadata").remove(this.podMetadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPodMetadata() {
        return this.podMetadata != null;
    }

    @Override
    public AlertmanagerSpecFluent.PodMetadataNested<A> withNewPodMetadata() {
        return new PodMetadataNestedImpl();
    }

    @Override
    public AlertmanagerSpecFluent.PodMetadataNested<A> withNewPodMetadataLike(EmbeddedObjectMetadata item) {
        return new PodMetadataNestedImpl(item);
    }

    @Override
    public AlertmanagerSpecFluent.PodMetadataNested<A> editPodMetadata() {
        return this.withNewPodMetadataLike(this.getPodMetadata());
    }

    @Override
    public AlertmanagerSpecFluent.PodMetadataNested<A> editOrNewPodMetadata() {
        return this.withNewPodMetadataLike(this.getPodMetadata() != null ? this.getPodMetadata() : new EmbeddedObjectMetadataBuilder().build());
    }

    @Override
    public AlertmanagerSpecFluent.PodMetadataNested<A> editOrNewPodMetadataLike(EmbeddedObjectMetadata item) {
        return this.withNewPodMetadataLike(this.getPodMetadata() != null ? this.getPodMetadata() : item);
    }

    @Override
    public String getPortName() {
        return this.portName;
    }

    @Override
    public A withPortName(String portName) {
        this.portName = portName;
        return (A)this;
    }

    @Override
    public Boolean hasPortName() {
        return this.portName != null;
    }

    @Override
    public String getPriorityClassName() {
        return this.priorityClassName;
    }

    @Override
    public A withPriorityClassName(String priorityClassName) {
        this.priorityClassName = priorityClassName;
        return (A)this;
    }

    @Override
    public Boolean hasPriorityClassName() {
        return this.priorityClassName != null;
    }

    @Override
    public Integer getReplicas() {
        return this.replicas;
    }

    @Override
    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)this;
    }

    @Override
    public Boolean hasReplicas() {
        return this.replicas != null;
    }

    @Override
    @Deprecated
    public ResourceRequirements getResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    @Override
    public ResourceRequirements buildResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    @Override
    public A withResources(ResourceRequirements resources) {
        this._visitables.get((Object)"resources").remove(this.resources);
        if (resources != null) {
            this.resources = new ResourceRequirementsBuilder(resources);
            this._visitables.get((Object)"resources").add(this.resources);
        } else {
            this.resources = null;
            this._visitables.get((Object)"resources").remove(this.resources);
        }
        return (A)this;
    }

    @Override
    public Boolean hasResources() {
        return this.resources != null;
    }

    @Override
    public AlertmanagerSpecFluent.ResourcesNested<A> withNewResources() {
        return new ResourcesNestedImpl();
    }

    @Override
    public AlertmanagerSpecFluent.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
        return new ResourcesNestedImpl(item);
    }

    @Override
    public AlertmanagerSpecFluent.ResourcesNested<A> editResources() {
        return this.withNewResourcesLike(this.getResources());
    }

    @Override
    public AlertmanagerSpecFluent.ResourcesNested<A> editOrNewResources() {
        return this.withNewResourcesLike(this.getResources() != null ? this.getResources() : new ResourceRequirementsBuilder().build());
    }

    @Override
    public AlertmanagerSpecFluent.ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item) {
        return this.withNewResourcesLike(this.getResources() != null ? this.getResources() : item);
    }

    @Override
    public String getRetention() {
        return this.retention;
    }

    @Override
    public A withRetention(String retention) {
        this.retention = retention;
        return (A)this;
    }

    @Override
    public Boolean hasRetention() {
        return this.retention != null;
    }

    @Override
    public String getRoutePrefix() {
        return this.routePrefix;
    }

    @Override
    public A withRoutePrefix(String routePrefix) {
        this.routePrefix = routePrefix;
        return (A)this;
    }

    @Override
    public Boolean hasRoutePrefix() {
        return this.routePrefix != null;
    }

    @Override
    public A addToSecrets(int index, String item) {
        if (this.secrets == null) {
            this.secrets = new ArrayList<String>();
        }
        this.secrets.add(index, item);
        return (A)this;
    }

    @Override
    public A setToSecrets(int index, String item) {
        if (this.secrets == null) {
            this.secrets = new ArrayList<String>();
        }
        this.secrets.set(index, item);
        return (A)this;
    }

    @Override
    public A addToSecrets(String ... items) {
        if (this.secrets == null) {
            this.secrets = new ArrayList<String>();
        }
        for (String item : items) {
            this.secrets.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToSecrets(Collection<String> items) {
        if (this.secrets == null) {
            this.secrets = new ArrayList<String>();
        }
        for (String item : items) {
            this.secrets.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromSecrets(String ... items) {
        for (String item : items) {
            if (this.secrets == null) continue;
            this.secrets.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSecrets(Collection<String> items) {
        for (String item : items) {
            if (this.secrets == null) continue;
            this.secrets.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getSecrets() {
        return this.secrets;
    }

    @Override
    public String getSecret(int index) {
        return this.secrets.get(index);
    }

    @Override
    public String getFirstSecret() {
        return this.secrets.get(0);
    }

    @Override
    public String getLastSecret() {
        return this.secrets.get(this.secrets.size() - 1);
    }

    @Override
    public String getMatchingSecret(Predicate<String> predicate) {
        for (String item : this.secrets) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSecret(Predicate<String> predicate) {
        for (String item : this.secrets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSecrets(List<String> secrets) {
        if (secrets != null) {
            this.secrets = new ArrayList<String>();
            for (String item : secrets) {
                this.addToSecrets(item);
            }
        } else {
            this.secrets = null;
        }
        return (A)this;
    }

    @Override
    public A withSecrets(String ... secrets) {
        if (this.secrets != null) {
            this.secrets.clear();
            this._visitables.remove((Object)"secrets");
        }
        if (secrets != null) {
            for (String item : secrets) {
                this.addToSecrets(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecrets() {
        return this.secrets != null && !this.secrets.isEmpty();
    }

    @Override
    public PodSecurityContext getSecurityContext() {
        return this.securityContext;
    }

    @Override
    public A withSecurityContext(PodSecurityContext securityContext) {
        this.securityContext = securityContext;
        return (A)this;
    }

    @Override
    public Boolean hasSecurityContext() {
        return this.securityContext != null;
    }

    @Override
    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    @Override
    public A withServiceAccountName(String serviceAccountName) {
        this.serviceAccountName = serviceAccountName;
        return (A)this;
    }

    @Override
    public Boolean hasServiceAccountName() {
        return this.serviceAccountName != null;
    }

    @Override
    public String getSha() {
        return this.sha;
    }

    @Override
    public A withSha(String sha) {
        this.sha = sha;
        return (A)this;
    }

    @Override
    public Boolean hasSha() {
        return this.sha != null;
    }

    @Override
    @Deprecated
    public StorageSpec getStorage() {
        return this.storage != null ? this.storage.build() : null;
    }

    @Override
    public StorageSpec buildStorage() {
        return this.storage != null ? this.storage.build() : null;
    }

    @Override
    public A withStorage(StorageSpec storage) {
        this._visitables.get((Object)"storage").remove(this.storage);
        if (storage != null) {
            this.storage = new StorageSpecBuilder(storage);
            this._visitables.get((Object)"storage").add(this.storage);
        } else {
            this.storage = null;
            this._visitables.get((Object)"storage").remove(this.storage);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStorage() {
        return this.storage != null;
    }

    @Override
    public AlertmanagerSpecFluent.StorageNested<A> withNewStorage() {
        return new StorageNestedImpl();
    }

    @Override
    public AlertmanagerSpecFluent.StorageNested<A> withNewStorageLike(StorageSpec item) {
        return new StorageNestedImpl(item);
    }

    @Override
    public AlertmanagerSpecFluent.StorageNested<A> editStorage() {
        return this.withNewStorageLike(this.getStorage());
    }

    @Override
    public AlertmanagerSpecFluent.StorageNested<A> editOrNewStorage() {
        return this.withNewStorageLike(this.getStorage() != null ? this.getStorage() : new StorageSpecBuilder().build());
    }

    @Override
    public AlertmanagerSpecFluent.StorageNested<A> editOrNewStorageLike(StorageSpec item) {
        return this.withNewStorageLike(this.getStorage() != null ? this.getStorage() : item);
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public A withTag(String tag) {
        this.tag = tag;
        return (A)this;
    }

    @Override
    public Boolean hasTag() {
        return this.tag != null;
    }

    @Override
    public A addToTolerations(int index, Toleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        this.tolerations.add(index, item);
        return (A)this;
    }

    @Override
    public A setToTolerations(int index, Toleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        this.tolerations.set(index, item);
        return (A)this;
    }

    @Override
    public A addToTolerations(Toleration ... items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        for (Toleration item : items) {
            this.tolerations.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToTolerations(Collection<Toleration> items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        for (Toleration item : items) {
            this.tolerations.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromTolerations(Toleration ... items) {
        for (Toleration item : items) {
            if (this.tolerations == null) continue;
            this.tolerations.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTolerations(Collection<Toleration> items) {
        for (Toleration item : items) {
            if (this.tolerations == null) continue;
            this.tolerations.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Toleration> getTolerations() {
        return this.tolerations;
    }

    @Override
    public Toleration getToleration(int index) {
        return this.tolerations.get(index);
    }

    @Override
    public Toleration getFirstToleration() {
        return this.tolerations.get(0);
    }

    @Override
    public Toleration getLastToleration() {
        return this.tolerations.get(this.tolerations.size() - 1);
    }

    @Override
    public Toleration getMatchingToleration(Predicate<Toleration> predicate) {
        for (Toleration item : this.tolerations) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingToleration(Predicate<Toleration> predicate) {
        for (Toleration item : this.tolerations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTolerations(List<Toleration> tolerations) {
        if (tolerations != null) {
            this.tolerations = new ArrayList<Toleration>();
            for (Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        } else {
            this.tolerations = null;
        }
        return (A)this;
    }

    @Override
    public A withTolerations(Toleration ... tolerations) {
        if (this.tolerations != null) {
            this.tolerations.clear();
            this._visitables.remove((Object)"tolerations");
        }
        if (tolerations != null) {
            for (Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTolerations() {
        return this.tolerations != null && !this.tolerations.isEmpty();
    }

    @Override
    public A addNewToleration(String effect, String key, String operator, Long tolerationSeconds, String value) {
        return this.addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
    }

    @Override
    public A addToTopologySpreadConstraints(int index, TopologySpreadConstraint item) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
        }
        this.topologySpreadConstraints.add(index, item);
        return (A)this;
    }

    @Override
    public A setToTopologySpreadConstraints(int index, TopologySpreadConstraint item) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
        }
        this.topologySpreadConstraints.set(index, item);
        return (A)this;
    }

    @Override
    public A addToTopologySpreadConstraints(TopologySpreadConstraint ... items) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
        }
        for (TopologySpreadConstraint item : items) {
            this.topologySpreadConstraints.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToTopologySpreadConstraints(Collection<TopologySpreadConstraint> items) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
        }
        for (TopologySpreadConstraint item : items) {
            this.topologySpreadConstraints.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromTopologySpreadConstraints(TopologySpreadConstraint ... items) {
        for (TopologySpreadConstraint item : items) {
            if (this.topologySpreadConstraints == null) continue;
            this.topologySpreadConstraints.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTopologySpreadConstraints(Collection<TopologySpreadConstraint> items) {
        for (TopologySpreadConstraint item : items) {
            if (this.topologySpreadConstraints == null) continue;
            this.topologySpreadConstraints.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<TopologySpreadConstraint> getTopologySpreadConstraints() {
        return this.topologySpreadConstraints;
    }

    @Override
    public TopologySpreadConstraint getTopologySpreadConstraint(int index) {
        return this.topologySpreadConstraints.get(index);
    }

    @Override
    public TopologySpreadConstraint getFirstTopologySpreadConstraint() {
        return this.topologySpreadConstraints.get(0);
    }

    @Override
    public TopologySpreadConstraint getLastTopologySpreadConstraint() {
        return this.topologySpreadConstraints.get(this.topologySpreadConstraints.size() - 1);
    }

    @Override
    public TopologySpreadConstraint getMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraint> predicate) {
        for (TopologySpreadConstraint item : this.topologySpreadConstraints) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraint> predicate) {
        for (TopologySpreadConstraint item : this.topologySpreadConstraints) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTopologySpreadConstraints(List<TopologySpreadConstraint> topologySpreadConstraints) {
        if (topologySpreadConstraints != null) {
            this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
            for (TopologySpreadConstraint item : topologySpreadConstraints) {
                this.addToTopologySpreadConstraints(item);
            }
        } else {
            this.topologySpreadConstraints = null;
        }
        return (A)this;
    }

    @Override
    public A withTopologySpreadConstraints(TopologySpreadConstraint ... topologySpreadConstraints) {
        if (this.topologySpreadConstraints != null) {
            this.topologySpreadConstraints.clear();
            this._visitables.remove((Object)"topologySpreadConstraints");
        }
        if (topologySpreadConstraints != null) {
            for (TopologySpreadConstraint item : topologySpreadConstraints) {
                this.addToTopologySpreadConstraints(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTopologySpreadConstraints() {
        return this.topologySpreadConstraints != null && !this.topologySpreadConstraints.isEmpty();
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public A withVersion(String version) {
        this.version = version;
        return (A)this;
    }

    @Override
    public Boolean hasVersion() {
        return this.version != null;
    }

    @Override
    public A addToVolumeMounts(int index, VolumeMount item) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList<VolumeMount>();
        }
        this.volumeMounts.add(index, item);
        return (A)this;
    }

    @Override
    public A setToVolumeMounts(int index, VolumeMount item) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList<VolumeMount>();
        }
        this.volumeMounts.set(index, item);
        return (A)this;
    }

    @Override
    public A addToVolumeMounts(VolumeMount ... items) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList<VolumeMount>();
        }
        for (VolumeMount item : items) {
            this.volumeMounts.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToVolumeMounts(Collection<VolumeMount> items) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList<VolumeMount>();
        }
        for (VolumeMount item : items) {
            this.volumeMounts.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumeMounts(VolumeMount ... items) {
        for (VolumeMount item : items) {
            if (this.volumeMounts == null) continue;
            this.volumeMounts.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVolumeMounts(Collection<VolumeMount> items) {
        for (VolumeMount item : items) {
            if (this.volumeMounts == null) continue;
            this.volumeMounts.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<VolumeMount> getVolumeMounts() {
        return this.volumeMounts;
    }

    @Override
    public VolumeMount getVolumeMount(int index) {
        return this.volumeMounts.get(index);
    }

    @Override
    public VolumeMount getFirstVolumeMount() {
        return this.volumeMounts.get(0);
    }

    @Override
    public VolumeMount getLastVolumeMount() {
        return this.volumeMounts.get(this.volumeMounts.size() - 1);
    }

    @Override
    public VolumeMount getMatchingVolumeMount(Predicate<VolumeMount> predicate) {
        for (VolumeMount item : this.volumeMounts) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingVolumeMount(Predicate<VolumeMount> predicate) {
        for (VolumeMount item : this.volumeMounts) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withVolumeMounts(List<VolumeMount> volumeMounts) {
        if (volumeMounts != null) {
            this.volumeMounts = new ArrayList<VolumeMount>();
            for (VolumeMount item : volumeMounts) {
                this.addToVolumeMounts(item);
            }
        } else {
            this.volumeMounts = null;
        }
        return (A)this;
    }

    @Override
    public A withVolumeMounts(VolumeMount ... volumeMounts) {
        if (this.volumeMounts != null) {
            this.volumeMounts.clear();
            this._visitables.remove((Object)"volumeMounts");
        }
        if (volumeMounts != null) {
            for (VolumeMount item : volumeMounts) {
                this.addToVolumeMounts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVolumeMounts() {
        return this.volumeMounts != null && !this.volumeMounts.isEmpty();
    }

    @Override
    public A addToVolumes(int index, Volume item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<Volume>();
        }
        this.volumes.add(index, item);
        return (A)this;
    }

    @Override
    public A setToVolumes(int index, Volume item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<Volume>();
        }
        this.volumes.set(index, item);
        return (A)this;
    }

    @Override
    public A addToVolumes(Volume ... items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<Volume>();
        }
        for (Volume item : items) {
            this.volumes.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToVolumes(Collection<Volume> items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<Volume>();
        }
        for (Volume item : items) {
            this.volumes.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumes(Volume ... items) {
        for (Volume item : items) {
            if (this.volumes == null) continue;
            this.volumes.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVolumes(Collection<Volume> items) {
        for (Volume item : items) {
            if (this.volumes == null) continue;
            this.volumes.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Volume> getVolumes() {
        return this.volumes;
    }

    @Override
    public Volume getVolume(int index) {
        return this.volumes.get(index);
    }

    @Override
    public Volume getFirstVolume() {
        return this.volumes.get(0);
    }

    @Override
    public Volume getLastVolume() {
        return this.volumes.get(this.volumes.size() - 1);
    }

    @Override
    public Volume getMatchingVolume(Predicate<Volume> predicate) {
        for (Volume item : this.volumes) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingVolume(Predicate<Volume> predicate) {
        for (Volume item : this.volumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withVolumes(List<Volume> volumes) {
        if (volumes != null) {
            this.volumes = new ArrayList<Volume>();
            for (Volume item : volumes) {
                this.addToVolumes(item);
            }
        } else {
            this.volumes = null;
        }
        return (A)this;
    }

    @Override
    public A withVolumes(Volume ... volumes) {
        if (this.volumes != null) {
            this.volumes.clear();
            this._visitables.remove((Object)"volumes");
        }
        if (volumes != null) {
            for (Volume item : volumes) {
                this.addToVolumes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVolumes() {
        return this.volumes != null && !this.volumes.isEmpty();
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AlertmanagerSpecFluentImpl that = (AlertmanagerSpecFluentImpl)o;
        if (!Objects.equals(this.additionalPeers, that.additionalPeers)) {
            return false;
        }
        if (!Objects.equals(this.affinity, that.affinity)) {
            return false;
        }
        if (!Objects.equals(this.alertmanagerConfigNamespaceSelector, that.alertmanagerConfigNamespaceSelector)) {
            return false;
        }
        if (!Objects.equals(this.alertmanagerConfigSelector, that.alertmanagerConfigSelector)) {
            return false;
        }
        if (!Objects.equals(this.baseImage, that.baseImage)) {
            return false;
        }
        if (!Objects.equals(this.clusterAdvertiseAddress, that.clusterAdvertiseAddress)) {
            return false;
        }
        if (!Objects.equals(this.clusterGossipInterval, that.clusterGossipInterval)) {
            return false;
        }
        if (!Objects.equals(this.clusterPeerTimeout, that.clusterPeerTimeout)) {
            return false;
        }
        if (!Objects.equals(this.clusterPushpullInterval, that.clusterPushpullInterval)) {
            return false;
        }
        if (!Objects.equals(this.configMaps, that.configMaps)) {
            return false;
        }
        if (!Objects.equals(this.configSecret, that.configSecret)) {
            return false;
        }
        if (!Objects.equals(this.containers, that.containers)) {
            return false;
        }
        if (!Objects.equals(this.externalUrl, that.externalUrl)) {
            return false;
        }
        if (!Objects.equals(this.forceEnableClusterMode, that.forceEnableClusterMode)) {
            return false;
        }
        if (!Objects.equals(this.image, that.image)) {
            return false;
        }
        if (!Objects.equals(this.imagePullSecrets, that.imagePullSecrets)) {
            return false;
        }
        if (!Objects.equals(this.initContainers, that.initContainers)) {
            return false;
        }
        if (!Objects.equals(this.listenLocal, that.listenLocal)) {
            return false;
        }
        if (!Objects.equals(this.logFormat, that.logFormat)) {
            return false;
        }
        if (!Objects.equals(this.logLevel, that.logLevel)) {
            return false;
        }
        if (!Objects.equals(this.minReadySeconds, that.minReadySeconds)) {
            return false;
        }
        if (!Objects.equals(this.nodeSelector, that.nodeSelector)) {
            return false;
        }
        if (!Objects.equals(this.paused, that.paused)) {
            return false;
        }
        if (!Objects.equals(this.podMetadata, that.podMetadata)) {
            return false;
        }
        if (!Objects.equals(this.portName, that.portName)) {
            return false;
        }
        if (!Objects.equals(this.priorityClassName, that.priorityClassName)) {
            return false;
        }
        if (!Objects.equals(this.replicas, that.replicas)) {
            return false;
        }
        if (!Objects.equals(this.resources, that.resources)) {
            return false;
        }
        if (!Objects.equals(this.retention, that.retention)) {
            return false;
        }
        if (!Objects.equals(this.routePrefix, that.routePrefix)) {
            return false;
        }
        if (!Objects.equals(this.secrets, that.secrets)) {
            return false;
        }
        if (!Objects.equals(this.securityContext, that.securityContext)) {
            return false;
        }
        if (!Objects.equals(this.serviceAccountName, that.serviceAccountName)) {
            return false;
        }
        if (!Objects.equals(this.sha, that.sha)) {
            return false;
        }
        if (!Objects.equals(this.storage, that.storage)) {
            return false;
        }
        if (!Objects.equals(this.tag, that.tag)) {
            return false;
        }
        if (!Objects.equals(this.tolerations, that.tolerations)) {
            return false;
        }
        if (!Objects.equals(this.topologySpreadConstraints, that.topologySpreadConstraints)) {
            return false;
        }
        if (!Objects.equals(this.version, that.version)) {
            return false;
        }
        if (!Objects.equals(this.volumeMounts, that.volumeMounts)) {
            return false;
        }
        if (!Objects.equals(this.volumes, that.volumes)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.additionalPeers, this.affinity, this.alertmanagerConfigNamespaceSelector, this.alertmanagerConfigSelector, this.baseImage, this.clusterAdvertiseAddress, this.clusterGossipInterval, this.clusterPeerTimeout, this.clusterPushpullInterval, this.configMaps, this.configSecret, this.containers, this.externalUrl, this.forceEnableClusterMode, this.image, this.imagePullSecrets, this.initContainers, this.listenLocal, this.logFormat, this.logLevel, this.minReadySeconds, this.nodeSelector, this.paused, this.podMetadata, this.portName, this.priorityClassName, this.replicas, this.resources, this.retention, this.routePrefix, this.secrets, this.securityContext, this.serviceAccountName, this.sha, this.storage, this.tag, this.tolerations, this.topologySpreadConstraints, this.version, this.volumeMounts, this.volumes, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.additionalPeers != null && !this.additionalPeers.isEmpty()) {
            sb.append("additionalPeers:");
            sb.append(this.additionalPeers + ",");
        }
        if (this.affinity != null) {
            sb.append("affinity:");
            sb.append(this.affinity + ",");
        }
        if (this.alertmanagerConfigNamespaceSelector != null) {
            sb.append("alertmanagerConfigNamespaceSelector:");
            sb.append(this.alertmanagerConfigNamespaceSelector + ",");
        }
        if (this.alertmanagerConfigSelector != null) {
            sb.append("alertmanagerConfigSelector:");
            sb.append(this.alertmanagerConfigSelector + ",");
        }
        if (this.baseImage != null) {
            sb.append("baseImage:");
            sb.append(this.baseImage + ",");
        }
        if (this.clusterAdvertiseAddress != null) {
            sb.append("clusterAdvertiseAddress:");
            sb.append(this.clusterAdvertiseAddress + ",");
        }
        if (this.clusterGossipInterval != null) {
            sb.append("clusterGossipInterval:");
            sb.append(this.clusterGossipInterval + ",");
        }
        if (this.clusterPeerTimeout != null) {
            sb.append("clusterPeerTimeout:");
            sb.append(this.clusterPeerTimeout + ",");
        }
        if (this.clusterPushpullInterval != null) {
            sb.append("clusterPushpullInterval:");
            sb.append(this.clusterPushpullInterval + ",");
        }
        if (this.configMaps != null && !this.configMaps.isEmpty()) {
            sb.append("configMaps:");
            sb.append(this.configMaps + ",");
        }
        if (this.configSecret != null) {
            sb.append("configSecret:");
            sb.append(this.configSecret + ",");
        }
        if (this.containers != null && !this.containers.isEmpty()) {
            sb.append("containers:");
            sb.append(this.containers + ",");
        }
        if (this.externalUrl != null) {
            sb.append("externalUrl:");
            sb.append(this.externalUrl + ",");
        }
        if (this.forceEnableClusterMode != null) {
            sb.append("forceEnableClusterMode:");
            sb.append(this.forceEnableClusterMode + ",");
        }
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image + ",");
        }
        if (this.imagePullSecrets != null && !this.imagePullSecrets.isEmpty()) {
            sb.append("imagePullSecrets:");
            sb.append(this.imagePullSecrets + ",");
        }
        if (this.initContainers != null && !this.initContainers.isEmpty()) {
            sb.append("initContainers:");
            sb.append(this.initContainers + ",");
        }
        if (this.listenLocal != null) {
            sb.append("listenLocal:");
            sb.append(this.listenLocal + ",");
        }
        if (this.logFormat != null) {
            sb.append("logFormat:");
            sb.append(this.logFormat + ",");
        }
        if (this.logLevel != null) {
            sb.append("logLevel:");
            sb.append(this.logLevel + ",");
        }
        if (this.minReadySeconds != null) {
            sb.append("minReadySeconds:");
            sb.append(this.minReadySeconds + ",");
        }
        if (this.nodeSelector != null && !this.nodeSelector.isEmpty()) {
            sb.append("nodeSelector:");
            sb.append(this.nodeSelector + ",");
        }
        if (this.paused != null) {
            sb.append("paused:");
            sb.append(this.paused + ",");
        }
        if (this.podMetadata != null) {
            sb.append("podMetadata:");
            sb.append(this.podMetadata + ",");
        }
        if (this.portName != null) {
            sb.append("portName:");
            sb.append(this.portName + ",");
        }
        if (this.priorityClassName != null) {
            sb.append("priorityClassName:");
            sb.append(this.priorityClassName + ",");
        }
        if (this.replicas != null) {
            sb.append("replicas:");
            sb.append(this.replicas + ",");
        }
        if (this.resources != null) {
            sb.append("resources:");
            sb.append(this.resources + ",");
        }
        if (this.retention != null) {
            sb.append("retention:");
            sb.append(this.retention + ",");
        }
        if (this.routePrefix != null) {
            sb.append("routePrefix:");
            sb.append(this.routePrefix + ",");
        }
        if (this.secrets != null && !this.secrets.isEmpty()) {
            sb.append("secrets:");
            sb.append(this.secrets + ",");
        }
        if (this.securityContext != null) {
            sb.append("securityContext:");
            sb.append(this.securityContext + ",");
        }
        if (this.serviceAccountName != null) {
            sb.append("serviceAccountName:");
            sb.append(this.serviceAccountName + ",");
        }
        if (this.sha != null) {
            sb.append("sha:");
            sb.append(this.sha + ",");
        }
        if (this.storage != null) {
            sb.append("storage:");
            sb.append(this.storage + ",");
        }
        if (this.tag != null) {
            sb.append("tag:");
            sb.append(this.tag + ",");
        }
        if (this.tolerations != null && !this.tolerations.isEmpty()) {
            sb.append("tolerations:");
            sb.append(this.tolerations + ",");
        }
        if (this.topologySpreadConstraints != null && !this.topologySpreadConstraints.isEmpty()) {
            sb.append("topologySpreadConstraints:");
            sb.append(this.topologySpreadConstraints + ",");
        }
        if (this.version != null) {
            sb.append("version:");
            sb.append(this.version + ",");
        }
        if (this.volumeMounts != null && !this.volumeMounts.isEmpty()) {
            sb.append("volumeMounts:");
            sb.append(this.volumeMounts + ",");
        }
        if (this.volumes != null && !this.volumes.isEmpty()) {
            sb.append("volumes:");
            sb.append(this.volumes + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withForceEnableClusterMode() {
        return this.withForceEnableClusterMode(true);
    }

    @Override
    public A withListenLocal() {
        return this.withListenLocal(true);
    }

    @Override
    public A withPaused() {
        return this.withPaused(true);
    }

    class StorageNestedImpl<N>
    extends StorageSpecFluentImpl<AlertmanagerSpecFluent.StorageNested<N>>
    implements AlertmanagerSpecFluent.StorageNested<N>,
    Nested<N> {
        StorageSpecBuilder builder;

        StorageNestedImpl(StorageSpec item) {
            this.builder = new StorageSpecBuilder(this, item);
        }

        StorageNestedImpl() {
            this.builder = new StorageSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)AlertmanagerSpecFluentImpl.this.withStorage(this.builder.build());
        }

        @Override
        public N endStorage() {
            return this.and();
        }
    }

    class ResourcesNestedImpl<N>
    extends ResourceRequirementsFluentImpl<AlertmanagerSpecFluent.ResourcesNested<N>>
    implements AlertmanagerSpecFluent.ResourcesNested<N>,
    Nested<N> {
        ResourceRequirementsBuilder builder;

        ResourcesNestedImpl(ResourceRequirements item) {
            this.builder = new ResourceRequirementsBuilder((ResourceRequirementsFluent)this, item);
        }

        ResourcesNestedImpl() {
            this.builder = new ResourceRequirementsBuilder((ResourceRequirementsFluent)this);
        }

        @Override
        public N and() {
            return (N)AlertmanagerSpecFluentImpl.this.withResources(this.builder.build());
        }

        @Override
        public N endResources() {
            return this.and();
        }
    }

    class PodMetadataNestedImpl<N>
    extends EmbeddedObjectMetadataFluentImpl<AlertmanagerSpecFluent.PodMetadataNested<N>>
    implements AlertmanagerSpecFluent.PodMetadataNested<N>,
    Nested<N> {
        EmbeddedObjectMetadataBuilder builder;

        PodMetadataNestedImpl(EmbeddedObjectMetadata item) {
            this.builder = new EmbeddedObjectMetadataBuilder(this, item);
        }

        PodMetadataNestedImpl() {
            this.builder = new EmbeddedObjectMetadataBuilder(this);
        }

        @Override
        public N and() {
            return (N)AlertmanagerSpecFluentImpl.this.withPodMetadata(this.builder.build());
        }

        @Override
        public N endPodMetadata() {
            return this.and();
        }
    }

    class InitContainersNestedImpl<N>
    extends ContainerFluentImpl<AlertmanagerSpecFluent.InitContainersNested<N>>
    implements AlertmanagerSpecFluent.InitContainersNested<N>,
    Nested<N> {
        ContainerBuilder builder;
        int index;

        InitContainersNestedImpl(int index, Container item) {
            this.index = index;
            this.builder = new ContainerBuilder((ContainerFluent)this, item);
        }

        InitContainersNestedImpl() {
            this.index = -1;
            this.builder = new ContainerBuilder((ContainerFluent)this);
        }

        @Override
        public N and() {
            return (N)AlertmanagerSpecFluentImpl.this.setToInitContainers(this.index, this.builder.build());
        }

        @Override
        public N endInitContainer() {
            return this.and();
        }
    }

    class ImagePullSecretsNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<AlertmanagerSpecFluent.ImagePullSecretsNested<N>>
    implements AlertmanagerSpecFluent.ImagePullSecretsNested<N>,
    Nested<N> {
        LocalObjectReferenceBuilder builder;
        int index;

        ImagePullSecretsNestedImpl(int index, LocalObjectReference item) {
            this.index = index;
            this.builder = new LocalObjectReferenceBuilder((LocalObjectReferenceFluent)this, item);
        }

        ImagePullSecretsNestedImpl() {
            this.index = -1;
            this.builder = new LocalObjectReferenceBuilder((LocalObjectReferenceFluent)this);
        }

        @Override
        public N and() {
            return (N)AlertmanagerSpecFluentImpl.this.setToImagePullSecrets(this.index, this.builder.build());
        }

        @Override
        public N endImagePullSecret() {
            return this.and();
        }
    }

    class ContainersNestedImpl<N>
    extends ContainerFluentImpl<AlertmanagerSpecFluent.ContainersNested<N>>
    implements AlertmanagerSpecFluent.ContainersNested<N>,
    Nested<N> {
        ContainerBuilder builder;
        int index;

        ContainersNestedImpl(int index, Container item) {
            this.index = index;
            this.builder = new ContainerBuilder((ContainerFluent)this, item);
        }

        ContainersNestedImpl() {
            this.index = -1;
            this.builder = new ContainerBuilder((ContainerFluent)this);
        }

        @Override
        public N and() {
            return (N)AlertmanagerSpecFluentImpl.this.setToContainers(this.index, this.builder.build());
        }

        @Override
        public N endContainer() {
            return this.and();
        }
    }

    class AlertmanagerConfigSelectorNestedImpl<N>
    extends LabelSelectorFluentImpl<AlertmanagerSpecFluent.AlertmanagerConfigSelectorNested<N>>
    implements AlertmanagerSpecFluent.AlertmanagerConfigSelectorNested<N>,
    Nested<N> {
        LabelSelectorBuilder builder;

        AlertmanagerConfigSelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this, item);
        }

        AlertmanagerConfigSelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this);
        }

        @Override
        public N and() {
            return (N)AlertmanagerSpecFluentImpl.this.withAlertmanagerConfigSelector(this.builder.build());
        }

        @Override
        public N endAlertmanagerConfigSelector() {
            return this.and();
        }
    }

    class AlertmanagerConfigNamespaceSelectorNestedImpl<N>
    extends LabelSelectorFluentImpl<AlertmanagerSpecFluent.AlertmanagerConfigNamespaceSelectorNested<N>>
    implements AlertmanagerSpecFluent.AlertmanagerConfigNamespaceSelectorNested<N>,
    Nested<N> {
        LabelSelectorBuilder builder;

        AlertmanagerConfigNamespaceSelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this, item);
        }

        AlertmanagerConfigNamespaceSelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this);
        }

        @Override
        public N and() {
            return (N)AlertmanagerSpecFluentImpl.this.withAlertmanagerConfigNamespaceSelector(this.builder.build());
        }

        @Override
        public N endAlertmanagerConfigNamespaceSelector() {
            return this.and();
        }
    }
}

