/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfig;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfigFluent;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueFluent;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.VictorOpsConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class VictorOpsConfigFluent<A extends VictorOpsConfigFluent<A>>
extends BaseFluent<A> {
    private SecretKeySelector apiKey;
    private String apiUrl;
    private ArrayList<KeyValueBuilder> customFields = new ArrayList();
    private String entityDisplayName;
    private HTTPConfigBuilder httpConfig;
    private String messageType;
    private String monitoringTool;
    private String routingKey;
    private Boolean sendResolved;
    private String stateMessage;
    private Map<String, Object> additionalProperties;

    public VictorOpsConfigFluent() {
    }

    public VictorOpsConfigFluent(VictorOpsConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(VictorOpsConfig instance) {
        VictorOpsConfig victorOpsConfig = instance = instance != null ? instance : new VictorOpsConfig();
        if (instance != null) {
            this.withApiKey(instance.getApiKey());
            this.withApiUrl(instance.getApiUrl());
            this.withCustomFields(instance.getCustomFields());
            this.withEntityDisplayName(instance.getEntityDisplayName());
            this.withHttpConfig(instance.getHttpConfig());
            this.withMessageType(instance.getMessageType());
            this.withMonitoringTool(instance.getMonitoringTool());
            this.withRoutingKey(instance.getRoutingKey());
            this.withSendResolved(instance.getSendResolved());
            this.withStateMessage(instance.getStateMessage());
            this.withApiKey(instance.getApiKey());
            this.withApiUrl(instance.getApiUrl());
            this.withCustomFields(instance.getCustomFields());
            this.withEntityDisplayName(instance.getEntityDisplayName());
            this.withHttpConfig(instance.getHttpConfig());
            this.withMessageType(instance.getMessageType());
            this.withMonitoringTool(instance.getMonitoringTool());
            this.withRoutingKey(instance.getRoutingKey());
            this.withSendResolved(instance.getSendResolved());
            this.withStateMessage(instance.getStateMessage());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public SecretKeySelector getApiKey() {
        return this.apiKey;
    }

    public A withApiKey(SecretKeySelector apiKey) {
        this.apiKey = apiKey;
        return (A)((Object)this);
    }

    public boolean hasApiKey() {
        return this.apiKey != null;
    }

    public A withNewApiKey(String key, String name, Boolean optional) {
        return this.withApiKey(new SecretKeySelector(key, name, optional));
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public A withApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
        return (A)((Object)this);
    }

    public boolean hasApiUrl() {
        return this.apiUrl != null;
    }

    public A addToCustomFields(int index, KeyValue item) {
        if (this.customFields == null) {
            this.customFields = new ArrayList();
        }
        KeyValueBuilder builder = new KeyValueBuilder(item);
        if (index < 0 || index >= this.customFields.size()) {
            this._visitables.get((Object)"customFields").add(builder);
            this.customFields.add(builder);
        } else {
            this._visitables.get((Object)"customFields").add(index, builder);
            this.customFields.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToCustomFields(int index, KeyValue item) {
        if (this.customFields == null) {
            this.customFields = new ArrayList();
        }
        KeyValueBuilder builder = new KeyValueBuilder(item);
        if (index < 0 || index >= this.customFields.size()) {
            this._visitables.get((Object)"customFields").add(builder);
            this.customFields.add(builder);
        } else {
            this._visitables.get((Object)"customFields").set(index, builder);
            this.customFields.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToCustomFields(KeyValue ... items) {
        if (this.customFields == null) {
            this.customFields = new ArrayList();
        }
        for (KeyValue item : items) {
            KeyValueBuilder builder = new KeyValueBuilder(item);
            this._visitables.get((Object)"customFields").add(builder);
            this.customFields.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToCustomFields(Collection<KeyValue> items) {
        if (this.customFields == null) {
            this.customFields = new ArrayList();
        }
        for (KeyValue item : items) {
            KeyValueBuilder builder = new KeyValueBuilder(item);
            this._visitables.get((Object)"customFields").add(builder);
            this.customFields.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromCustomFields(KeyValue ... items) {
        if (this.customFields == null) {
            return (A)((Object)this);
        }
        for (KeyValue item : items) {
            KeyValueBuilder builder = new KeyValueBuilder(item);
            this._visitables.get((Object)"customFields").remove((Object)builder);
            this.customFields.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromCustomFields(Collection<KeyValue> items) {
        if (this.customFields == null) {
            return (A)((Object)this);
        }
        for (KeyValue item : items) {
            KeyValueBuilder builder = new KeyValueBuilder(item);
            this._visitables.get((Object)"customFields").remove((Object)builder);
            this.customFields.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromCustomFields(Predicate<KeyValueBuilder> predicate) {
        if (this.customFields == null) {
            return (A)((Object)this);
        }
        Iterator<KeyValueBuilder> each = this.customFields.iterator();
        List visitables = this._visitables.get((Object)"customFields");
        while (each.hasNext()) {
            KeyValueBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<KeyValue> buildCustomFields() {
        return this.customFields != null ? VictorOpsConfigFluent.build(this.customFields) : null;
    }

    public KeyValue buildCustomField(int index) {
        return this.customFields.get(index).build();
    }

    public KeyValue buildFirstCustomField() {
        return this.customFields.get(0).build();
    }

    public KeyValue buildLastCustomField() {
        return this.customFields.get(this.customFields.size() - 1).build();
    }

    public KeyValue buildMatchingCustomField(Predicate<KeyValueBuilder> predicate) {
        for (KeyValueBuilder item : this.customFields) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCustomField(Predicate<KeyValueBuilder> predicate) {
        for (KeyValueBuilder item : this.customFields) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withCustomFields(List<KeyValue> customFields) {
        if (this.customFields != null) {
            this._visitables.get((Object)"customFields").clear();
        }
        if (customFields != null) {
            this.customFields = new ArrayList();
            for (KeyValue item : customFields) {
                this.addToCustomFields(item);
            }
        } else {
            this.customFields = null;
        }
        return (A)((Object)this);
    }

    public A withCustomFields(KeyValue ... customFields) {
        if (this.customFields != null) {
            this.customFields.clear();
            this._visitables.remove((Object)"customFields");
        }
        if (customFields != null) {
            for (KeyValue item : customFields) {
                this.addToCustomFields(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasCustomFields() {
        return this.customFields != null && !this.customFields.isEmpty();
    }

    public A addNewCustomField(String key, String value) {
        return this.addToCustomFields(new KeyValue(key, value));
    }

    public CustomFieldsNested<A> addNewCustomField() {
        return new CustomFieldsNested(-1, null);
    }

    public CustomFieldsNested<A> addNewCustomFieldLike(KeyValue item) {
        return new CustomFieldsNested(-1, item);
    }

    public CustomFieldsNested<A> setNewCustomFieldLike(int index, KeyValue item) {
        return new CustomFieldsNested(index, item);
    }

    public CustomFieldsNested<A> editCustomField(int index) {
        if (this.customFields.size() <= index) {
            throw new RuntimeException("Can't edit customFields. Index exceeds size.");
        }
        return this.setNewCustomFieldLike(index, this.buildCustomField(index));
    }

    public CustomFieldsNested<A> editFirstCustomField() {
        if (this.customFields.size() == 0) {
            throw new RuntimeException("Can't edit first customFields. The list is empty.");
        }
        return this.setNewCustomFieldLike(0, this.buildCustomField(0));
    }

    public CustomFieldsNested<A> editLastCustomField() {
        int index = this.customFields.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last customFields. The list is empty.");
        }
        return this.setNewCustomFieldLike(index, this.buildCustomField(index));
    }

    public CustomFieldsNested<A> editMatchingCustomField(Predicate<KeyValueBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.customFields.size(); ++i) {
            if (!predicate.test(this.customFields.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching customFields. No match found.");
        }
        return this.setNewCustomFieldLike(index, this.buildCustomField(index));
    }

    public String getEntityDisplayName() {
        return this.entityDisplayName;
    }

    public A withEntityDisplayName(String entityDisplayName) {
        this.entityDisplayName = entityDisplayName;
        return (A)((Object)this);
    }

    public boolean hasEntityDisplayName() {
        return this.entityDisplayName != null;
    }

    public HTTPConfig buildHttpConfig() {
        return this.httpConfig != null ? this.httpConfig.build() : null;
    }

    public A withHttpConfig(HTTPConfig httpConfig) {
        this._visitables.get((Object)"httpConfig").remove((Object)this.httpConfig);
        if (httpConfig != null) {
            this.httpConfig = new HTTPConfigBuilder(httpConfig);
            this._visitables.get((Object)"httpConfig").add(this.httpConfig);
        } else {
            this.httpConfig = null;
            this._visitables.get((Object)"httpConfig").remove((Object)this.httpConfig);
        }
        return (A)((Object)this);
    }

    public boolean hasHttpConfig() {
        return this.httpConfig != null;
    }

    public HttpConfigNested<A> withNewHttpConfig() {
        return new HttpConfigNested(null);
    }

    public HttpConfigNested<A> withNewHttpConfigLike(HTTPConfig item) {
        return new HttpConfigNested(item);
    }

    public HttpConfigNested<A> editHttpConfig() {
        return this.withNewHttpConfigLike(Optional.ofNullable(this.buildHttpConfig()).orElse(null));
    }

    public HttpConfigNested<A> editOrNewHttpConfig() {
        return this.withNewHttpConfigLike(Optional.ofNullable(this.buildHttpConfig()).orElse(new HTTPConfigBuilder().build()));
    }

    public HttpConfigNested<A> editOrNewHttpConfigLike(HTTPConfig item) {
        return this.withNewHttpConfigLike(Optional.ofNullable(this.buildHttpConfig()).orElse(item));
    }

    public String getMessageType() {
        return this.messageType;
    }

    public A withMessageType(String messageType) {
        this.messageType = messageType;
        return (A)((Object)this);
    }

    public boolean hasMessageType() {
        return this.messageType != null;
    }

    public String getMonitoringTool() {
        return this.monitoringTool;
    }

    public A withMonitoringTool(String monitoringTool) {
        this.monitoringTool = monitoringTool;
        return (A)((Object)this);
    }

    public boolean hasMonitoringTool() {
        return this.monitoringTool != null;
    }

    public String getRoutingKey() {
        return this.routingKey;
    }

    public A withRoutingKey(String routingKey) {
        this.routingKey = routingKey;
        return (A)((Object)this);
    }

    public boolean hasRoutingKey() {
        return this.routingKey != null;
    }

    public Boolean getSendResolved() {
        return this.sendResolved;
    }

    public A withSendResolved(Boolean sendResolved) {
        this.sendResolved = sendResolved;
        return (A)((Object)this);
    }

    public boolean hasSendResolved() {
        return this.sendResolved != null;
    }

    public String getStateMessage() {
        return this.stateMessage;
    }

    public A withStateMessage(String stateMessage) {
        this.stateMessage = stateMessage;
        return (A)((Object)this);
    }

    public boolean hasStateMessage() {
        return this.stateMessage != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VictorOpsConfigFluent that = (VictorOpsConfigFluent)((Object)o);
        if (!Objects.equals(this.apiKey, that.apiKey)) {
            return false;
        }
        if (!Objects.equals(this.apiUrl, that.apiUrl)) {
            return false;
        }
        if (!Objects.equals(this.customFields, that.customFields)) {
            return false;
        }
        if (!Objects.equals(this.entityDisplayName, that.entityDisplayName)) {
            return false;
        }
        if (!Objects.equals((Object)this.httpConfig, (Object)that.httpConfig)) {
            return false;
        }
        if (!Objects.equals(this.messageType, that.messageType)) {
            return false;
        }
        if (!Objects.equals(this.monitoringTool, that.monitoringTool)) {
            return false;
        }
        if (!Objects.equals(this.routingKey, that.routingKey)) {
            return false;
        }
        if (!Objects.equals(this.sendResolved, that.sendResolved)) {
            return false;
        }
        if (!Objects.equals(this.stateMessage, that.stateMessage)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.apiKey, this.apiUrl, this.customFields, this.entityDisplayName, this.httpConfig, this.messageType, this.monitoringTool, this.routingKey, this.sendResolved, this.stateMessage, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiKey != null) {
            sb.append("apiKey:");
            sb.append(this.apiKey + ",");
        }
        if (this.apiUrl != null) {
            sb.append("apiUrl:");
            sb.append(this.apiUrl + ",");
        }
        if (this.customFields != null && !this.customFields.isEmpty()) {
            sb.append("customFields:");
            sb.append(this.customFields + ",");
        }
        if (this.entityDisplayName != null) {
            sb.append("entityDisplayName:");
            sb.append(this.entityDisplayName + ",");
        }
        if (this.httpConfig != null) {
            sb.append("httpConfig:");
            sb.append((Object)((Object)this.httpConfig) + ",");
        }
        if (this.messageType != null) {
            sb.append("messageType:");
            sb.append(this.messageType + ",");
        }
        if (this.monitoringTool != null) {
            sb.append("monitoringTool:");
            sb.append(this.monitoringTool + ",");
        }
        if (this.routingKey != null) {
            sb.append("routingKey:");
            sb.append(this.routingKey + ",");
        }
        if (this.sendResolved != null) {
            sb.append("sendResolved:");
            sb.append(this.sendResolved + ",");
        }
        if (this.stateMessage != null) {
            sb.append("stateMessage:");
            sb.append(this.stateMessage + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withSendResolved() {
        return this.withSendResolved(true);
    }

    public class HttpConfigNested<N>
    extends HTTPConfigFluent<HttpConfigNested<N>>
    implements Nested<N> {
        HTTPConfigBuilder builder;

        HttpConfigNested(HTTPConfig item) {
            this.builder = new HTTPConfigBuilder(this, item);
        }

        public N and() {
            return (N)VictorOpsConfigFluent.this.withHttpConfig(this.builder.build());
        }

        public N endHttpConfig() {
            return this.and();
        }
    }

    public class CustomFieldsNested<N>
    extends KeyValueFluent<CustomFieldsNested<N>>
    implements Nested<N> {
        KeyValueBuilder builder;
        int index;

        CustomFieldsNested(int index, KeyValue item) {
            this.index = index;
            this.builder = new KeyValueBuilder(this, item);
        }

        public N and() {
            return (N)VictorOpsConfigFluent.this.setToCustomFields(this.index, this.builder.build());
        }

        public N endCustomField() {
            return this.and();
        }
    }
}

