package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class AlertmanagerConfigurationFluent<A extends AlertmanagerConfigurationFluent<A>> extends BaseFluent<A>{
  public AlertmanagerConfigurationFluent() {
  }
  
  public AlertmanagerConfigurationFluent(AlertmanagerConfiguration instance) {
    this.copyInstance(instance);
  }
  private AlertmanagerGlobalConfigBuilder global;
  private String name;
  private ArrayList<SecretOrConfigMapBuilder> templates = new ArrayList<SecretOrConfigMapBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(AlertmanagerConfiguration instance) {
    instance = (instance != null ? instance : new AlertmanagerConfiguration());
    if (instance != null) {
          this.withGlobal(instance.getGlobal());
          this.withName(instance.getName());
          this.withTemplates(instance.getTemplates());
          this.withGlobal(instance.getGlobal());
          this.withName(instance.getName());
          this.withTemplates(instance.getTemplates());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public AlertmanagerGlobalConfig buildGlobal() {
    return this.global != null ? this.global.build() : null;
  }
  
  public A withGlobal(AlertmanagerGlobalConfig global) {
    this._visitables.remove(this.global);
    if (global != null) {
        this.global = new AlertmanagerGlobalConfigBuilder(global);
        this._visitables.get("global").add(this.global);
    } else {
        this.global = null;
        this._visitables.get("global").remove(this.global);
    }
    return (A) this;
  }
  
  public boolean hasGlobal() {
    return this.global != null;
  }
  
  public GlobalNested<A> withNewGlobal() {
    return new GlobalNested(null);
  }
  
  public GlobalNested<A> withNewGlobalLike(AlertmanagerGlobalConfig item) {
    return new GlobalNested(item);
  }
  
  public GlobalNested<A> editGlobal() {
    return withNewGlobalLike(java.util.Optional.ofNullable(buildGlobal()).orElse(null));
  }
  
  public GlobalNested<A> editOrNewGlobal() {
    return withNewGlobalLike(java.util.Optional.ofNullable(buildGlobal()).orElse(new AlertmanagerGlobalConfigBuilder().build()));
  }
  
  public GlobalNested<A> editOrNewGlobalLike(AlertmanagerGlobalConfig item) {
    return withNewGlobalLike(java.util.Optional.ofNullable(buildGlobal()).orElse(item));
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public A addToTemplates(int index,SecretOrConfigMap item) {
    if (this.templates == null) {this.templates = new ArrayList<SecretOrConfigMapBuilder>();}
    SecretOrConfigMapBuilder builder = new SecretOrConfigMapBuilder(item);
    if (index < 0 || index >= templates.size()) { _visitables.get("templates").add(builder); templates.add(builder); } else { _visitables.get("templates").add(index, builder); templates.add(index, builder);}
    return (A)this;
  }
  
  public A setToTemplates(int index,SecretOrConfigMap item) {
    if (this.templates == null) {this.templates = new ArrayList<SecretOrConfigMapBuilder>();}
    SecretOrConfigMapBuilder builder = new SecretOrConfigMapBuilder(item);
    if (index < 0 || index >= templates.size()) { _visitables.get("templates").add(builder); templates.add(builder); } else { _visitables.get("templates").set(index, builder); templates.set(index, builder);}
    return (A)this;
  }
  
  public A addToTemplates(io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMap... items) {
    if (this.templates == null) {this.templates = new ArrayList<SecretOrConfigMapBuilder>();}
    for (SecretOrConfigMap item : items) {SecretOrConfigMapBuilder builder = new SecretOrConfigMapBuilder(item);_visitables.get("templates").add(builder);this.templates.add(builder);} return (A)this;
  }
  
  public A addAllToTemplates(Collection<SecretOrConfigMap> items) {
    if (this.templates == null) {this.templates = new ArrayList<SecretOrConfigMapBuilder>();}
    for (SecretOrConfigMap item : items) {SecretOrConfigMapBuilder builder = new SecretOrConfigMapBuilder(item);_visitables.get("templates").add(builder);this.templates.add(builder);} return (A)this;
  }
  
  public A removeFromTemplates(io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMap... items) {
    if (this.templates == null) return (A)this;
    for (SecretOrConfigMap item : items) {SecretOrConfigMapBuilder builder = new SecretOrConfigMapBuilder(item);_visitables.get("templates").remove(builder); this.templates.remove(builder);} return (A)this;
  }
  
  public A removeAllFromTemplates(Collection<SecretOrConfigMap> items) {
    if (this.templates == null) return (A)this;
    for (SecretOrConfigMap item : items) {SecretOrConfigMapBuilder builder = new SecretOrConfigMapBuilder(item);_visitables.get("templates").remove(builder); this.templates.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromTemplates(Predicate<SecretOrConfigMapBuilder> predicate) {
    if (templates == null) return (A) this;
    final Iterator<SecretOrConfigMapBuilder> each = templates.iterator();
    final List visitables = _visitables.get("templates");
    while (each.hasNext()) {
      SecretOrConfigMapBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<SecretOrConfigMap> buildTemplates() {
    return this.templates != null ? build(templates) : null;
  }
  
  public SecretOrConfigMap buildTemplate(int index) {
    return this.templates.get(index).build();
  }
  
  public SecretOrConfigMap buildFirstTemplate() {
    return this.templates.get(0).build();
  }
  
  public SecretOrConfigMap buildLastTemplate() {
    return this.templates.get(templates.size() - 1).build();
  }
  
  public SecretOrConfigMap buildMatchingTemplate(Predicate<SecretOrConfigMapBuilder> predicate) {
      for (SecretOrConfigMapBuilder item : templates) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingTemplate(Predicate<SecretOrConfigMapBuilder> predicate) {
      for (SecretOrConfigMapBuilder item : templates) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withTemplates(List<SecretOrConfigMap> templates) {
    if (this.templates != null) {
      this._visitables.get("templates").clear();
    }
    if (templates != null) {
        this.templates = new ArrayList();
        for (SecretOrConfigMap item : templates) {
          this.addToTemplates(item);
        }
    } else {
      this.templates = null;
    }
    return (A) this;
  }
  
  public A withTemplates(io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMap... templates) {
    if (this.templates != null) {this.templates.clear(); _visitables.remove("templates"); }
    if (templates != null) {for (SecretOrConfigMap item :templates){ this.addToTemplates(item);}} return (A) this;
  }
  
  public boolean hasTemplates() {
    return this.templates != null && !this.templates.isEmpty();
  }
  
  public TemplatesNested<A> addNewTemplate() {
    return new TemplatesNested(-1, null);
  }
  
  public TemplatesNested<A> addNewTemplateLike(SecretOrConfigMap item) {
    return new TemplatesNested(-1, item);
  }
  
  public TemplatesNested<A> setNewTemplateLike(int index,SecretOrConfigMap item) {
    return new TemplatesNested(index, item);
  }
  
  public TemplatesNested<A> editTemplate(int index) {
    if (templates.size() <= index) throw new RuntimeException("Can't edit templates. Index exceeds size.");
    return setNewTemplateLike(index, buildTemplate(index));
  }
  
  public TemplatesNested<A> editFirstTemplate() {
    if (templates.size() == 0) throw new RuntimeException("Can't edit first templates. The list is empty.");
    return setNewTemplateLike(0, buildTemplate(0));
  }
  
  public TemplatesNested<A> editLastTemplate() {
    int index = templates.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last templates. The list is empty.");
    return setNewTemplateLike(index, buildTemplate(index));
  }
  
  public TemplatesNested<A> editMatchingTemplate(Predicate<SecretOrConfigMapBuilder> predicate) {
    int index = -1;
    for (int i=0;i<templates.size();i++) { 
    if (predicate.test(templates.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching templates. No match found.");
    return setNewTemplateLike(index, buildTemplate(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AlertmanagerConfigurationFluent that = (AlertmanagerConfigurationFluent) o;
    if (!java.util.Objects.equals(global, that.global)) return false;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(templates, that.templates)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(global,  name,  templates,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (global != null) { sb.append("global:"); sb.append(global + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (templates != null && !templates.isEmpty()) { sb.append("templates:"); sb.append(templates + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class GlobalNested<N> extends AlertmanagerGlobalConfigFluent<GlobalNested<N>> implements Nested<N>{
    GlobalNested(AlertmanagerGlobalConfig item) {
      this.builder = new AlertmanagerGlobalConfigBuilder(this, item);
    }
    AlertmanagerGlobalConfigBuilder builder;
    
    public N and() {
      return (N) AlertmanagerConfigurationFluent.this.withGlobal(builder.build());
    }
    
    public N endGlobal() {
      return and();
    }
    
  
  }
  public class TemplatesNested<N> extends SecretOrConfigMapFluent<TemplatesNested<N>> implements Nested<N>{
    TemplatesNested(int index,SecretOrConfigMap item) {
      this.index = index;
      this.builder = new SecretOrConfigMapBuilder(this, item);
    }
    SecretOrConfigMapBuilder builder;
    int index;
    
    public N and() {
      return (N) AlertmanagerConfigurationFluent.this.setToTemplates(index,builder.build());
    }
    
    public N endTemplate() {
      return and();
    }
    
  
  }

}