package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.Iterator;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ProbeSpecFluent<A extends ProbeSpecFluent<A>> extends BaseFluent<A>{
  public ProbeSpecFluent() {
  }
  
  public ProbeSpecFluent(ProbeSpec instance) {
    this.copyInstance(instance);
  }
  private SafeAuthorizationBuilder authorization;
  private BasicAuthBuilder basicAuth;
  private SecretKeySelector bearerTokenSecret;
  private String interval;
  private String jobName;
  private Long keepDroppedTargets;
  private Long labelLimit;
  private Long labelNameLengthLimit;
  private Long labelValueLengthLimit;
  private ArrayList<RelabelConfigBuilder> metricRelabelings = new ArrayList<RelabelConfigBuilder>();
  private String module;
  private OAuth2Builder oauth2;
  private ProberSpecBuilder prober;
  private Long sampleLimit;
  private String scrapeTimeout;
  private Long targetLimit;
  private ProbeTargetsBuilder targets;
  private ProbeTLSConfigBuilder tlsConfig;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ProbeSpec instance) {
    instance = (instance != null ? instance : new ProbeSpec());
    if (instance != null) {
          this.withAuthorization(instance.getAuthorization());
          this.withBasicAuth(instance.getBasicAuth());
          this.withBearerTokenSecret(instance.getBearerTokenSecret());
          this.withInterval(instance.getInterval());
          this.withJobName(instance.getJobName());
          this.withKeepDroppedTargets(instance.getKeepDroppedTargets());
          this.withLabelLimit(instance.getLabelLimit());
          this.withLabelNameLengthLimit(instance.getLabelNameLengthLimit());
          this.withLabelValueLengthLimit(instance.getLabelValueLengthLimit());
          this.withMetricRelabelings(instance.getMetricRelabelings());
          this.withModule(instance.getModule());
          this.withOauth2(instance.getOauth2());
          this.withProber(instance.getProber());
          this.withSampleLimit(instance.getSampleLimit());
          this.withScrapeTimeout(instance.getScrapeTimeout());
          this.withTargetLimit(instance.getTargetLimit());
          this.withTargets(instance.getTargets());
          this.withTlsConfig(instance.getTlsConfig());
          this.withAuthorization(instance.getAuthorization());
          this.withBasicAuth(instance.getBasicAuth());
          this.withBearerTokenSecret(instance.getBearerTokenSecret());
          this.withInterval(instance.getInterval());
          this.withJobName(instance.getJobName());
          this.withKeepDroppedTargets(instance.getKeepDroppedTargets());
          this.withLabelLimit(instance.getLabelLimit());
          this.withLabelNameLengthLimit(instance.getLabelNameLengthLimit());
          this.withLabelValueLengthLimit(instance.getLabelValueLengthLimit());
          this.withMetricRelabelings(instance.getMetricRelabelings());
          this.withModule(instance.getModule());
          this.withOauth2(instance.getOauth2());
          this.withProber(instance.getProber());
          this.withSampleLimit(instance.getSampleLimit());
          this.withScrapeTimeout(instance.getScrapeTimeout());
          this.withTargetLimit(instance.getTargetLimit());
          this.withTargets(instance.getTargets());
          this.withTlsConfig(instance.getTlsConfig());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public SafeAuthorization buildAuthorization() {
    return this.authorization != null ? this.authorization.build() : null;
  }
  
  public A withAuthorization(SafeAuthorization authorization) {
    this._visitables.remove(this.authorization);
    if (authorization != null) {
        this.authorization = new SafeAuthorizationBuilder(authorization);
        this._visitables.get("authorization").add(this.authorization);
    } else {
        this.authorization = null;
        this._visitables.get("authorization").remove(this.authorization);
    }
    return (A) this;
  }
  
  public boolean hasAuthorization() {
    return this.authorization != null;
  }
  
  public AuthorizationNested<A> withNewAuthorization() {
    return new AuthorizationNested(null);
  }
  
  public AuthorizationNested<A> withNewAuthorizationLike(SafeAuthorization item) {
    return new AuthorizationNested(item);
  }
  
  public AuthorizationNested<A> editAuthorization() {
    return withNewAuthorizationLike(java.util.Optional.ofNullable(buildAuthorization()).orElse(null));
  }
  
  public AuthorizationNested<A> editOrNewAuthorization() {
    return withNewAuthorizationLike(java.util.Optional.ofNullable(buildAuthorization()).orElse(new SafeAuthorizationBuilder().build()));
  }
  
  public AuthorizationNested<A> editOrNewAuthorizationLike(SafeAuthorization item) {
    return withNewAuthorizationLike(java.util.Optional.ofNullable(buildAuthorization()).orElse(item));
  }
  
  public BasicAuth buildBasicAuth() {
    return this.basicAuth != null ? this.basicAuth.build() : null;
  }
  
  public A withBasicAuth(BasicAuth basicAuth) {
    this._visitables.remove(this.basicAuth);
    if (basicAuth != null) {
        this.basicAuth = new BasicAuthBuilder(basicAuth);
        this._visitables.get("basicAuth").add(this.basicAuth);
    } else {
        this.basicAuth = null;
        this._visitables.get("basicAuth").remove(this.basicAuth);
    }
    return (A) this;
  }
  
  public boolean hasBasicAuth() {
    return this.basicAuth != null;
  }
  
  public BasicAuthNested<A> withNewBasicAuth() {
    return new BasicAuthNested(null);
  }
  
  public BasicAuthNested<A> withNewBasicAuthLike(BasicAuth item) {
    return new BasicAuthNested(item);
  }
  
  public BasicAuthNested<A> editBasicAuth() {
    return withNewBasicAuthLike(java.util.Optional.ofNullable(buildBasicAuth()).orElse(null));
  }
  
  public BasicAuthNested<A> editOrNewBasicAuth() {
    return withNewBasicAuthLike(java.util.Optional.ofNullable(buildBasicAuth()).orElse(new BasicAuthBuilder().build()));
  }
  
  public BasicAuthNested<A> editOrNewBasicAuthLike(BasicAuth item) {
    return withNewBasicAuthLike(java.util.Optional.ofNullable(buildBasicAuth()).orElse(item));
  }
  
  public SecretKeySelector getBearerTokenSecret() {
    return this.bearerTokenSecret;
  }
  
  public A withBearerTokenSecret(SecretKeySelector bearerTokenSecret) {
    this.bearerTokenSecret = bearerTokenSecret;
    return (A) this;
  }
  
  public boolean hasBearerTokenSecret() {
    return this.bearerTokenSecret != null;
  }
  
  public A withNewBearerTokenSecret(String key,String name,Boolean optional) {
    return (A)withBearerTokenSecret(new SecretKeySelector(key, name, optional));
  }
  
  public String getInterval() {
    return this.interval;
  }
  
  public A withInterval(String interval) {
    this.interval = interval;
    return (A) this;
  }
  
  public boolean hasInterval() {
    return this.interval != null;
  }
  
  public String getJobName() {
    return this.jobName;
  }
  
  public A withJobName(String jobName) {
    this.jobName = jobName;
    return (A) this;
  }
  
  public boolean hasJobName() {
    return this.jobName != null;
  }
  
  public Long getKeepDroppedTargets() {
    return this.keepDroppedTargets;
  }
  
  public A withKeepDroppedTargets(Long keepDroppedTargets) {
    this.keepDroppedTargets = keepDroppedTargets;
    return (A) this;
  }
  
  public boolean hasKeepDroppedTargets() {
    return this.keepDroppedTargets != null;
  }
  
  public Long getLabelLimit() {
    return this.labelLimit;
  }
  
  public A withLabelLimit(Long labelLimit) {
    this.labelLimit = labelLimit;
    return (A) this;
  }
  
  public boolean hasLabelLimit() {
    return this.labelLimit != null;
  }
  
  public Long getLabelNameLengthLimit() {
    return this.labelNameLengthLimit;
  }
  
  public A withLabelNameLengthLimit(Long labelNameLengthLimit) {
    this.labelNameLengthLimit = labelNameLengthLimit;
    return (A) this;
  }
  
  public boolean hasLabelNameLengthLimit() {
    return this.labelNameLengthLimit != null;
  }
  
  public Long getLabelValueLengthLimit() {
    return this.labelValueLengthLimit;
  }
  
  public A withLabelValueLengthLimit(Long labelValueLengthLimit) {
    this.labelValueLengthLimit = labelValueLengthLimit;
    return (A) this;
  }
  
  public boolean hasLabelValueLengthLimit() {
    return this.labelValueLengthLimit != null;
  }
  
  public A addToMetricRelabelings(int index,RelabelConfig item) {
    if (this.metricRelabelings == null) {this.metricRelabelings = new ArrayList<RelabelConfigBuilder>();}
    RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
    if (index < 0 || index >= metricRelabelings.size()) { _visitables.get("metricRelabelings").add(builder); metricRelabelings.add(builder); } else { _visitables.get("metricRelabelings").add(index, builder); metricRelabelings.add(index, builder);}
    return (A)this;
  }
  
  public A setToMetricRelabelings(int index,RelabelConfig item) {
    if (this.metricRelabelings == null) {this.metricRelabelings = new ArrayList<RelabelConfigBuilder>();}
    RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
    if (index < 0 || index >= metricRelabelings.size()) { _visitables.get("metricRelabelings").add(builder); metricRelabelings.add(builder); } else { _visitables.get("metricRelabelings").set(index, builder); metricRelabelings.set(index, builder);}
    return (A)this;
  }
  
  public A addToMetricRelabelings(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... items) {
    if (this.metricRelabelings == null) {this.metricRelabelings = new ArrayList<RelabelConfigBuilder>();}
    for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("metricRelabelings").add(builder);this.metricRelabelings.add(builder);} return (A)this;
  }
  
  public A addAllToMetricRelabelings(Collection<RelabelConfig> items) {
    if (this.metricRelabelings == null) {this.metricRelabelings = new ArrayList<RelabelConfigBuilder>();}
    for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("metricRelabelings").add(builder);this.metricRelabelings.add(builder);} return (A)this;
  }
  
  public A removeFromMetricRelabelings(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... items) {
    if (this.metricRelabelings == null) return (A)this;
    for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("metricRelabelings").remove(builder); this.metricRelabelings.remove(builder);} return (A)this;
  }
  
  public A removeAllFromMetricRelabelings(Collection<RelabelConfig> items) {
    if (this.metricRelabelings == null) return (A)this;
    for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("metricRelabelings").remove(builder); this.metricRelabelings.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromMetricRelabelings(Predicate<RelabelConfigBuilder> predicate) {
    if (metricRelabelings == null) return (A) this;
    final Iterator<RelabelConfigBuilder> each = metricRelabelings.iterator();
    final List visitables = _visitables.get("metricRelabelings");
    while (each.hasNext()) {
      RelabelConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<RelabelConfig> buildMetricRelabelings() {
    return this.metricRelabelings != null ? build(metricRelabelings) : null;
  }
  
  public RelabelConfig buildMetricRelabeling(int index) {
    return this.metricRelabelings.get(index).build();
  }
  
  public RelabelConfig buildFirstMetricRelabeling() {
    return this.metricRelabelings.get(0).build();
  }
  
  public RelabelConfig buildLastMetricRelabeling() {
    return this.metricRelabelings.get(metricRelabelings.size() - 1).build();
  }
  
  public RelabelConfig buildMatchingMetricRelabeling(Predicate<RelabelConfigBuilder> predicate) {
      for (RelabelConfigBuilder item : metricRelabelings) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingMetricRelabeling(Predicate<RelabelConfigBuilder> predicate) {
      for (RelabelConfigBuilder item : metricRelabelings) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withMetricRelabelings(List<RelabelConfig> metricRelabelings) {
    if (this.metricRelabelings != null) {
      this._visitables.get("metricRelabelings").clear();
    }
    if (metricRelabelings != null) {
        this.metricRelabelings = new ArrayList();
        for (RelabelConfig item : metricRelabelings) {
          this.addToMetricRelabelings(item);
        }
    } else {
      this.metricRelabelings = null;
    }
    return (A) this;
  }
  
  public A withMetricRelabelings(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... metricRelabelings) {
    if (this.metricRelabelings != null) {this.metricRelabelings.clear(); _visitables.remove("metricRelabelings"); }
    if (metricRelabelings != null) {for (RelabelConfig item :metricRelabelings){ this.addToMetricRelabelings(item);}} return (A) this;
  }
  
  public boolean hasMetricRelabelings() {
    return this.metricRelabelings != null && !this.metricRelabelings.isEmpty();
  }
  
  public MetricRelabelingsNested<A> addNewMetricRelabeling() {
    return new MetricRelabelingsNested(-1, null);
  }
  
  public MetricRelabelingsNested<A> addNewMetricRelabelingLike(RelabelConfig item) {
    return new MetricRelabelingsNested(-1, item);
  }
  
  public MetricRelabelingsNested<A> setNewMetricRelabelingLike(int index,RelabelConfig item) {
    return new MetricRelabelingsNested(index, item);
  }
  
  public MetricRelabelingsNested<A> editMetricRelabeling(int index) {
    if (metricRelabelings.size() <= index) throw new RuntimeException("Can't edit metricRelabelings. Index exceeds size.");
    return setNewMetricRelabelingLike(index, buildMetricRelabeling(index));
  }
  
  public MetricRelabelingsNested<A> editFirstMetricRelabeling() {
    if (metricRelabelings.size() == 0) throw new RuntimeException("Can't edit first metricRelabelings. The list is empty.");
    return setNewMetricRelabelingLike(0, buildMetricRelabeling(0));
  }
  
  public MetricRelabelingsNested<A> editLastMetricRelabeling() {
    int index = metricRelabelings.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last metricRelabelings. The list is empty.");
    return setNewMetricRelabelingLike(index, buildMetricRelabeling(index));
  }
  
  public MetricRelabelingsNested<A> editMatchingMetricRelabeling(Predicate<RelabelConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<metricRelabelings.size();i++) { 
    if (predicate.test(metricRelabelings.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching metricRelabelings. No match found.");
    return setNewMetricRelabelingLike(index, buildMetricRelabeling(index));
  }
  
  public String getModule() {
    return this.module;
  }
  
  public A withModule(String module) {
    this.module = module;
    return (A) this;
  }
  
  public boolean hasModule() {
    return this.module != null;
  }
  
  public OAuth2 buildOauth2() {
    return this.oauth2 != null ? this.oauth2.build() : null;
  }
  
  public A withOauth2(OAuth2 oauth2) {
    this._visitables.remove(this.oauth2);
    if (oauth2 != null) {
        this.oauth2 = new OAuth2Builder(oauth2);
        this._visitables.get("oauth2").add(this.oauth2);
    } else {
        this.oauth2 = null;
        this._visitables.get("oauth2").remove(this.oauth2);
    }
    return (A) this;
  }
  
  public boolean hasOauth2() {
    return this.oauth2 != null;
  }
  
  public Oauth2Nested<A> withNewOauth2() {
    return new Oauth2Nested(null);
  }
  
  public Oauth2Nested<A> withNewOauth2Like(OAuth2 item) {
    return new Oauth2Nested(item);
  }
  
  public Oauth2Nested<A> editOauth2() {
    return withNewOauth2Like(java.util.Optional.ofNullable(buildOauth2()).orElse(null));
  }
  
  public Oauth2Nested<A> editOrNewOauth2() {
    return withNewOauth2Like(java.util.Optional.ofNullable(buildOauth2()).orElse(new OAuth2Builder().build()));
  }
  
  public Oauth2Nested<A> editOrNewOauth2Like(OAuth2 item) {
    return withNewOauth2Like(java.util.Optional.ofNullable(buildOauth2()).orElse(item));
  }
  
  public ProberSpec buildProber() {
    return this.prober != null ? this.prober.build() : null;
  }
  
  public A withProber(ProberSpec prober) {
    this._visitables.remove(this.prober);
    if (prober != null) {
        this.prober = new ProberSpecBuilder(prober);
        this._visitables.get("prober").add(this.prober);
    } else {
        this.prober = null;
        this._visitables.get("prober").remove(this.prober);
    }
    return (A) this;
  }
  
  public boolean hasProber() {
    return this.prober != null;
  }
  
  public A withNewProber(String path,String proxyUrl,String scheme,String url) {
    return (A)withProber(new ProberSpec(path, proxyUrl, scheme, url));
  }
  
  public ProberNested<A> withNewProber() {
    return new ProberNested(null);
  }
  
  public ProberNested<A> withNewProberLike(ProberSpec item) {
    return new ProberNested(item);
  }
  
  public ProberNested<A> editProber() {
    return withNewProberLike(java.util.Optional.ofNullable(buildProber()).orElse(null));
  }
  
  public ProberNested<A> editOrNewProber() {
    return withNewProberLike(java.util.Optional.ofNullable(buildProber()).orElse(new ProberSpecBuilder().build()));
  }
  
  public ProberNested<A> editOrNewProberLike(ProberSpec item) {
    return withNewProberLike(java.util.Optional.ofNullable(buildProber()).orElse(item));
  }
  
  public Long getSampleLimit() {
    return this.sampleLimit;
  }
  
  public A withSampleLimit(Long sampleLimit) {
    this.sampleLimit = sampleLimit;
    return (A) this;
  }
  
  public boolean hasSampleLimit() {
    return this.sampleLimit != null;
  }
  
  public String getScrapeTimeout() {
    return this.scrapeTimeout;
  }
  
  public A withScrapeTimeout(String scrapeTimeout) {
    this.scrapeTimeout = scrapeTimeout;
    return (A) this;
  }
  
  public boolean hasScrapeTimeout() {
    return this.scrapeTimeout != null;
  }
  
  public Long getTargetLimit() {
    return this.targetLimit;
  }
  
  public A withTargetLimit(Long targetLimit) {
    this.targetLimit = targetLimit;
    return (A) this;
  }
  
  public boolean hasTargetLimit() {
    return this.targetLimit != null;
  }
  
  public ProbeTargets buildTargets() {
    return this.targets != null ? this.targets.build() : null;
  }
  
  public A withTargets(ProbeTargets targets) {
    this._visitables.remove(this.targets);
    if (targets != null) {
        this.targets = new ProbeTargetsBuilder(targets);
        this._visitables.get("targets").add(this.targets);
    } else {
        this.targets = null;
        this._visitables.get("targets").remove(this.targets);
    }
    return (A) this;
  }
  
  public boolean hasTargets() {
    return this.targets != null;
  }
  
  public TargetsNested<A> withNewTargets() {
    return new TargetsNested(null);
  }
  
  public TargetsNested<A> withNewTargetsLike(ProbeTargets item) {
    return new TargetsNested(item);
  }
  
  public TargetsNested<A> editTargets() {
    return withNewTargetsLike(java.util.Optional.ofNullable(buildTargets()).orElse(null));
  }
  
  public TargetsNested<A> editOrNewTargets() {
    return withNewTargetsLike(java.util.Optional.ofNullable(buildTargets()).orElse(new ProbeTargetsBuilder().build()));
  }
  
  public TargetsNested<A> editOrNewTargetsLike(ProbeTargets item) {
    return withNewTargetsLike(java.util.Optional.ofNullable(buildTargets()).orElse(item));
  }
  
  public ProbeTLSConfig buildTlsConfig() {
    return this.tlsConfig != null ? this.tlsConfig.build() : null;
  }
  
  public A withTlsConfig(ProbeTLSConfig tlsConfig) {
    this._visitables.remove(this.tlsConfig);
    if (tlsConfig != null) {
        this.tlsConfig = new ProbeTLSConfigBuilder(tlsConfig);
        this._visitables.get("tlsConfig").add(this.tlsConfig);
    } else {
        this.tlsConfig = null;
        this._visitables.get("tlsConfig").remove(this.tlsConfig);
    }
    return (A) this;
  }
  
  public boolean hasTlsConfig() {
    return this.tlsConfig != null;
  }
  
  public TlsConfigNested<A> withNewTlsConfig() {
    return new TlsConfigNested(null);
  }
  
  public TlsConfigNested<A> withNewTlsConfigLike(ProbeTLSConfig item) {
    return new TlsConfigNested(item);
  }
  
  public TlsConfigNested<A> editTlsConfig() {
    return withNewTlsConfigLike(java.util.Optional.ofNullable(buildTlsConfig()).orElse(null));
  }
  
  public TlsConfigNested<A> editOrNewTlsConfig() {
    return withNewTlsConfigLike(java.util.Optional.ofNullable(buildTlsConfig()).orElse(new ProbeTLSConfigBuilder().build()));
  }
  
  public TlsConfigNested<A> editOrNewTlsConfigLike(ProbeTLSConfig item) {
    return withNewTlsConfigLike(java.util.Optional.ofNullable(buildTlsConfig()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ProbeSpecFluent that = (ProbeSpecFluent) o;
    if (!java.util.Objects.equals(authorization, that.authorization)) return false;
    if (!java.util.Objects.equals(basicAuth, that.basicAuth)) return false;
    if (!java.util.Objects.equals(bearerTokenSecret, that.bearerTokenSecret)) return false;
    if (!java.util.Objects.equals(interval, that.interval)) return false;
    if (!java.util.Objects.equals(jobName, that.jobName)) return false;
    if (!java.util.Objects.equals(keepDroppedTargets, that.keepDroppedTargets)) return false;
    if (!java.util.Objects.equals(labelLimit, that.labelLimit)) return false;
    if (!java.util.Objects.equals(labelNameLengthLimit, that.labelNameLengthLimit)) return false;
    if (!java.util.Objects.equals(labelValueLengthLimit, that.labelValueLengthLimit)) return false;
    if (!java.util.Objects.equals(metricRelabelings, that.metricRelabelings)) return false;
    if (!java.util.Objects.equals(module, that.module)) return false;
    if (!java.util.Objects.equals(oauth2, that.oauth2)) return false;
    if (!java.util.Objects.equals(prober, that.prober)) return false;
    if (!java.util.Objects.equals(sampleLimit, that.sampleLimit)) return false;
    if (!java.util.Objects.equals(scrapeTimeout, that.scrapeTimeout)) return false;
    if (!java.util.Objects.equals(targetLimit, that.targetLimit)) return false;
    if (!java.util.Objects.equals(targets, that.targets)) return false;
    if (!java.util.Objects.equals(tlsConfig, that.tlsConfig)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(authorization,  basicAuth,  bearerTokenSecret,  interval,  jobName,  keepDroppedTargets,  labelLimit,  labelNameLengthLimit,  labelValueLengthLimit,  metricRelabelings,  module,  oauth2,  prober,  sampleLimit,  scrapeTimeout,  targetLimit,  targets,  tlsConfig,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (authorization != null) { sb.append("authorization:"); sb.append(authorization + ","); }
    if (basicAuth != null) { sb.append("basicAuth:"); sb.append(basicAuth + ","); }
    if (bearerTokenSecret != null) { sb.append("bearerTokenSecret:"); sb.append(bearerTokenSecret + ","); }
    if (interval != null) { sb.append("interval:"); sb.append(interval + ","); }
    if (jobName != null) { sb.append("jobName:"); sb.append(jobName + ","); }
    if (keepDroppedTargets != null) { sb.append("keepDroppedTargets:"); sb.append(keepDroppedTargets + ","); }
    if (labelLimit != null) { sb.append("labelLimit:"); sb.append(labelLimit + ","); }
    if (labelNameLengthLimit != null) { sb.append("labelNameLengthLimit:"); sb.append(labelNameLengthLimit + ","); }
    if (labelValueLengthLimit != null) { sb.append("labelValueLengthLimit:"); sb.append(labelValueLengthLimit + ","); }
    if (metricRelabelings != null && !metricRelabelings.isEmpty()) { sb.append("metricRelabelings:"); sb.append(metricRelabelings + ","); }
    if (module != null) { sb.append("module:"); sb.append(module + ","); }
    if (oauth2 != null) { sb.append("oauth2:"); sb.append(oauth2 + ","); }
    if (prober != null) { sb.append("prober:"); sb.append(prober + ","); }
    if (sampleLimit != null) { sb.append("sampleLimit:"); sb.append(sampleLimit + ","); }
    if (scrapeTimeout != null) { sb.append("scrapeTimeout:"); sb.append(scrapeTimeout + ","); }
    if (targetLimit != null) { sb.append("targetLimit:"); sb.append(targetLimit + ","); }
    if (targets != null) { sb.append("targets:"); sb.append(targets + ","); }
    if (tlsConfig != null) { sb.append("tlsConfig:"); sb.append(tlsConfig + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class AuthorizationNested<N> extends SafeAuthorizationFluent<AuthorizationNested<N>> implements Nested<N>{
    AuthorizationNested(SafeAuthorization item) {
      this.builder = new SafeAuthorizationBuilder(this, item);
    }
    SafeAuthorizationBuilder builder;
    
    public N and() {
      return (N) ProbeSpecFluent.this.withAuthorization(builder.build());
    }
    
    public N endAuthorization() {
      return and();
    }
    
  
  }
  public class BasicAuthNested<N> extends BasicAuthFluent<BasicAuthNested<N>> implements Nested<N>{
    BasicAuthNested(BasicAuth item) {
      this.builder = new BasicAuthBuilder(this, item);
    }
    BasicAuthBuilder builder;
    
    public N and() {
      return (N) ProbeSpecFluent.this.withBasicAuth(builder.build());
    }
    
    public N endBasicAuth() {
      return and();
    }
    
  
  }
  public class MetricRelabelingsNested<N> extends RelabelConfigFluent<MetricRelabelingsNested<N>> implements Nested<N>{
    MetricRelabelingsNested(int index,RelabelConfig item) {
      this.index = index;
      this.builder = new RelabelConfigBuilder(this, item);
    }
    RelabelConfigBuilder builder;
    int index;
    
    public N and() {
      return (N) ProbeSpecFluent.this.setToMetricRelabelings(index,builder.build());
    }
    
    public N endMetricRelabeling() {
      return and();
    }
    
  
  }
  public class Oauth2Nested<N> extends OAuth2Fluent<Oauth2Nested<N>> implements Nested<N>{
    Oauth2Nested(OAuth2 item) {
      this.builder = new OAuth2Builder(this, item);
    }
    OAuth2Builder builder;
    
    public N and() {
      return (N) ProbeSpecFluent.this.withOauth2(builder.build());
    }
    
    public N endOauth2() {
      return and();
    }
    
  
  }
  public class ProberNested<N> extends ProberSpecFluent<ProberNested<N>> implements Nested<N>{
    ProberNested(ProberSpec item) {
      this.builder = new ProberSpecBuilder(this, item);
    }
    ProberSpecBuilder builder;
    
    public N and() {
      return (N) ProbeSpecFluent.this.withProber(builder.build());
    }
    
    public N endProber() {
      return and();
    }
    
  
  }
  public class TargetsNested<N> extends ProbeTargetsFluent<TargetsNested<N>> implements Nested<N>{
    TargetsNested(ProbeTargets item) {
      this.builder = new ProbeTargetsBuilder(this, item);
    }
    ProbeTargetsBuilder builder;
    
    public N and() {
      return (N) ProbeSpecFluent.this.withTargets(builder.build());
    }
    
    public N endTargets() {
      return and();
    }
    
  
  }
  public class TlsConfigNested<N> extends ProbeTLSConfigFluent<TlsConfigNested<N>> implements Nested<N>{
    TlsConfigNested(ProbeTLSConfig item) {
      this.builder = new ProbeTLSConfigBuilder(this, item);
    }
    ProbeTLSConfigBuilder builder;
    
    public N and() {
      return (N) ProbeSpecFluent.this.withTlsConfig(builder.build());
    }
    
    public N endTlsConfig() {
      return and();
    }
    
  
  }

}