package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ProbeTargetIngressFluent<A extends ProbeTargetIngressFluent<A>> extends BaseFluent<A>{
  public ProbeTargetIngressFluent() {
  }
  
  public ProbeTargetIngressFluent(ProbeTargetIngress instance) {
    this.copyInstance(instance);
  }
  private NamespaceSelectorBuilder namespaceSelector;
  private ArrayList<RelabelConfigBuilder> relabelingConfigs = new ArrayList<RelabelConfigBuilder>();
  private LabelSelectorBuilder selector;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ProbeTargetIngress instance) {
    instance = (instance != null ? instance : new ProbeTargetIngress());
    if (instance != null) {
          this.withNamespaceSelector(instance.getNamespaceSelector());
          this.withRelabelingConfigs(instance.getRelabelingConfigs());
          this.withSelector(instance.getSelector());
          this.withNamespaceSelector(instance.getNamespaceSelector());
          this.withRelabelingConfigs(instance.getRelabelingConfigs());
          this.withSelector(instance.getSelector());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public NamespaceSelector buildNamespaceSelector() {
    return this.namespaceSelector != null ? this.namespaceSelector.build() : null;
  }
  
  public A withNamespaceSelector(NamespaceSelector namespaceSelector) {
    this._visitables.remove(this.namespaceSelector);
    if (namespaceSelector != null) {
        this.namespaceSelector = new NamespaceSelectorBuilder(namespaceSelector);
        this._visitables.get("namespaceSelector").add(this.namespaceSelector);
    } else {
        this.namespaceSelector = null;
        this._visitables.get("namespaceSelector").remove(this.namespaceSelector);
    }
    return (A) this;
  }
  
  public boolean hasNamespaceSelector() {
    return this.namespaceSelector != null;
  }
  
  public NamespaceSelectorNested<A> withNewNamespaceSelector() {
    return new NamespaceSelectorNested(null);
  }
  
  public NamespaceSelectorNested<A> withNewNamespaceSelectorLike(NamespaceSelector item) {
    return new NamespaceSelectorNested(item);
  }
  
  public NamespaceSelectorNested<A> editNamespaceSelector() {
    return withNewNamespaceSelectorLike(java.util.Optional.ofNullable(buildNamespaceSelector()).orElse(null));
  }
  
  public NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
    return withNewNamespaceSelectorLike(java.util.Optional.ofNullable(buildNamespaceSelector()).orElse(new NamespaceSelectorBuilder().build()));
  }
  
  public NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(NamespaceSelector item) {
    return withNewNamespaceSelectorLike(java.util.Optional.ofNullable(buildNamespaceSelector()).orElse(item));
  }
  
  public A addToRelabelingConfigs(int index,RelabelConfig item) {
    if (this.relabelingConfigs == null) {this.relabelingConfigs = new ArrayList<RelabelConfigBuilder>();}
    RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
    if (index < 0 || index >= relabelingConfigs.size()) { _visitables.get("relabelingConfigs").add(builder); relabelingConfigs.add(builder); } else { _visitables.get("relabelingConfigs").add(index, builder); relabelingConfigs.add(index, builder);}
    return (A)this;
  }
  
  public A setToRelabelingConfigs(int index,RelabelConfig item) {
    if (this.relabelingConfigs == null) {this.relabelingConfigs = new ArrayList<RelabelConfigBuilder>();}
    RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
    if (index < 0 || index >= relabelingConfigs.size()) { _visitables.get("relabelingConfigs").add(builder); relabelingConfigs.add(builder); } else { _visitables.get("relabelingConfigs").set(index, builder); relabelingConfigs.set(index, builder);}
    return (A)this;
  }
  
  public A addToRelabelingConfigs(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... items) {
    if (this.relabelingConfigs == null) {this.relabelingConfigs = new ArrayList<RelabelConfigBuilder>();}
    for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("relabelingConfigs").add(builder);this.relabelingConfigs.add(builder);} return (A)this;
  }
  
  public A addAllToRelabelingConfigs(Collection<RelabelConfig> items) {
    if (this.relabelingConfigs == null) {this.relabelingConfigs = new ArrayList<RelabelConfigBuilder>();}
    for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("relabelingConfigs").add(builder);this.relabelingConfigs.add(builder);} return (A)this;
  }
  
  public A removeFromRelabelingConfigs(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... items) {
    if (this.relabelingConfigs == null) return (A)this;
    for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("relabelingConfigs").remove(builder); this.relabelingConfigs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromRelabelingConfigs(Collection<RelabelConfig> items) {
    if (this.relabelingConfigs == null) return (A)this;
    for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("relabelingConfigs").remove(builder); this.relabelingConfigs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromRelabelingConfigs(Predicate<RelabelConfigBuilder> predicate) {
    if (relabelingConfigs == null) return (A) this;
    final Iterator<RelabelConfigBuilder> each = relabelingConfigs.iterator();
    final List visitables = _visitables.get("relabelingConfigs");
    while (each.hasNext()) {
      RelabelConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<RelabelConfig> buildRelabelingConfigs() {
    return this.relabelingConfigs != null ? build(relabelingConfigs) : null;
  }
  
  public RelabelConfig buildRelabelingConfig(int index) {
    return this.relabelingConfigs.get(index).build();
  }
  
  public RelabelConfig buildFirstRelabelingConfig() {
    return this.relabelingConfigs.get(0).build();
  }
  
  public RelabelConfig buildLastRelabelingConfig() {
    return this.relabelingConfigs.get(relabelingConfigs.size() - 1).build();
  }
  
  public RelabelConfig buildMatchingRelabelingConfig(Predicate<RelabelConfigBuilder> predicate) {
      for (RelabelConfigBuilder item : relabelingConfigs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingRelabelingConfig(Predicate<RelabelConfigBuilder> predicate) {
      for (RelabelConfigBuilder item : relabelingConfigs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withRelabelingConfigs(List<RelabelConfig> relabelingConfigs) {
    if (this.relabelingConfigs != null) {
      this._visitables.get("relabelingConfigs").clear();
    }
    if (relabelingConfigs != null) {
        this.relabelingConfigs = new ArrayList();
        for (RelabelConfig item : relabelingConfigs) {
          this.addToRelabelingConfigs(item);
        }
    } else {
      this.relabelingConfigs = null;
    }
    return (A) this;
  }
  
  public A withRelabelingConfigs(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... relabelingConfigs) {
    if (this.relabelingConfigs != null) {this.relabelingConfigs.clear(); _visitables.remove("relabelingConfigs"); }
    if (relabelingConfigs != null) {for (RelabelConfig item :relabelingConfigs){ this.addToRelabelingConfigs(item);}} return (A) this;
  }
  
  public boolean hasRelabelingConfigs() {
    return this.relabelingConfigs != null && !this.relabelingConfigs.isEmpty();
  }
  
  public RelabelingConfigsNested<A> addNewRelabelingConfig() {
    return new RelabelingConfigsNested(-1, null);
  }
  
  public RelabelingConfigsNested<A> addNewRelabelingConfigLike(RelabelConfig item) {
    return new RelabelingConfigsNested(-1, item);
  }
  
  public RelabelingConfigsNested<A> setNewRelabelingConfigLike(int index,RelabelConfig item) {
    return new RelabelingConfigsNested(index, item);
  }
  
  public RelabelingConfigsNested<A> editRelabelingConfig(int index) {
    if (relabelingConfigs.size() <= index) throw new RuntimeException("Can't edit relabelingConfigs. Index exceeds size.");
    return setNewRelabelingConfigLike(index, buildRelabelingConfig(index));
  }
  
  public RelabelingConfigsNested<A> editFirstRelabelingConfig() {
    if (relabelingConfigs.size() == 0) throw new RuntimeException("Can't edit first relabelingConfigs. The list is empty.");
    return setNewRelabelingConfigLike(0, buildRelabelingConfig(0));
  }
  
  public RelabelingConfigsNested<A> editLastRelabelingConfig() {
    int index = relabelingConfigs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last relabelingConfigs. The list is empty.");
    return setNewRelabelingConfigLike(index, buildRelabelingConfig(index));
  }
  
  public RelabelingConfigsNested<A> editMatchingRelabelingConfig(Predicate<RelabelConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<relabelingConfigs.size();i++) { 
    if (predicate.test(relabelingConfigs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching relabelingConfigs. No match found.");
    return setNewRelabelingConfigLike(index, buildRelabelingConfig(index));
  }
  
  public LabelSelector buildSelector() {
    return this.selector != null ? this.selector.build() : null;
  }
  
  public A withSelector(LabelSelector selector) {
    this._visitables.remove(this.selector);
    if (selector != null) {
        this.selector = new LabelSelectorBuilder(selector);
        this._visitables.get("selector").add(this.selector);
    } else {
        this.selector = null;
        this._visitables.get("selector").remove(this.selector);
    }
    return (A) this;
  }
  
  public boolean hasSelector() {
    return this.selector != null;
  }
  
  public SelectorNested<A> withNewSelector() {
    return new SelectorNested(null);
  }
  
  public SelectorNested<A> withNewSelectorLike(LabelSelector item) {
    return new SelectorNested(item);
  }
  
  public SelectorNested<A> editSelector() {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(null));
  }
  
  public SelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(new LabelSelectorBuilder().build()));
  }
  
  public SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ProbeTargetIngressFluent that = (ProbeTargetIngressFluent) o;
    if (!java.util.Objects.equals(namespaceSelector, that.namespaceSelector)) return false;
    if (!java.util.Objects.equals(relabelingConfigs, that.relabelingConfigs)) return false;
    if (!java.util.Objects.equals(selector, that.selector)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(namespaceSelector,  relabelingConfigs,  selector,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (namespaceSelector != null) { sb.append("namespaceSelector:"); sb.append(namespaceSelector + ","); }
    if (relabelingConfigs != null && !relabelingConfigs.isEmpty()) { sb.append("relabelingConfigs:"); sb.append(relabelingConfigs + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class NamespaceSelectorNested<N> extends NamespaceSelectorFluent<NamespaceSelectorNested<N>> implements Nested<N>{
    NamespaceSelectorNested(NamespaceSelector item) {
      this.builder = new NamespaceSelectorBuilder(this, item);
    }
    NamespaceSelectorBuilder builder;
    
    public N and() {
      return (N) ProbeTargetIngressFluent.this.withNamespaceSelector(builder.build());
    }
    
    public N endNamespaceSelector() {
      return and();
    }
    
  
  }
  public class RelabelingConfigsNested<N> extends RelabelConfigFluent<RelabelingConfigsNested<N>> implements Nested<N>{
    RelabelingConfigsNested(int index,RelabelConfig item) {
      this.index = index;
      this.builder = new RelabelConfigBuilder(this, item);
    }
    RelabelConfigBuilder builder;
    int index;
    
    public N and() {
      return (N) ProbeTargetIngressFluent.this.setToRelabelingConfigs(index,builder.build());
    }
    
    public N endRelabelingConfig() {
      return and();
    }
    
  
  }
  public class SelectorNested<N> extends LabelSelectorFluent<SelectorNested<N>> implements Nested<N>{
    SelectorNested(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    
    public N and() {
      return (N) ProbeTargetIngressFluent.this.withSelector(builder.build());
    }
    
    public N endSelector() {
      return and();
    }
    
  
  }

}