package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ProberSpecBuilder extends ProberSpecFluent<ProberSpecBuilder> implements VisitableBuilder<ProberSpec,ProberSpecBuilder>{
  public ProberSpecBuilder() {
    this(new ProberSpec());
  }
  
  public ProberSpecBuilder(ProberSpecFluent<?> fluent) {
    this(fluent, new ProberSpec());
  }
  
  public ProberSpecBuilder(ProberSpecFluent<?> fluent,ProberSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ProberSpecBuilder(ProberSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ProberSpecFluent<?> fluent;
  
  public ProberSpec build() {
    ProberSpec buildable = new ProberSpec(fluent.getPath(),fluent.getProxyUrl(),fluent.getScheme(),fluent.getUrl());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}