package io.fabric8.openshift.api.model.monitoring.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PrometheusTracingConfigFluent<A extends PrometheusTracingConfigFluent<A>> extends BaseFluent<A>{
  public PrometheusTracingConfigFluent() {
  }
  
  public PrometheusTracingConfigFluent(PrometheusTracingConfig instance) {
    this.copyInstance(instance);
  }
  private String clientType;
  private String compression;
  private String endpoint;
  private Map<String,String> headers;
  private Boolean insecure;
  private Quantity samplingFraction;
  private String timeout;
  private TLSConfigBuilder tlsConfig;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(PrometheusTracingConfig instance) {
    instance = (instance != null ? instance : new PrometheusTracingConfig());
    if (instance != null) {
          this.withClientType(instance.getClientType());
          this.withCompression(instance.getCompression());
          this.withEndpoint(instance.getEndpoint());
          this.withHeaders(instance.getHeaders());
          this.withInsecure(instance.getInsecure());
          this.withSamplingFraction(instance.getSamplingFraction());
          this.withTimeout(instance.getTimeout());
          this.withTlsConfig(instance.getTlsConfig());
          this.withClientType(instance.getClientType());
          this.withCompression(instance.getCompression());
          this.withEndpoint(instance.getEndpoint());
          this.withHeaders(instance.getHeaders());
          this.withInsecure(instance.getInsecure());
          this.withSamplingFraction(instance.getSamplingFraction());
          this.withTimeout(instance.getTimeout());
          this.withTlsConfig(instance.getTlsConfig());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getClientType() {
    return this.clientType;
  }
  
  public A withClientType(String clientType) {
    this.clientType = clientType;
    return (A) this;
  }
  
  public boolean hasClientType() {
    return this.clientType != null;
  }
  
  public String getCompression() {
    return this.compression;
  }
  
  public A withCompression(String compression) {
    this.compression = compression;
    return (A) this;
  }
  
  public boolean hasCompression() {
    return this.compression != null;
  }
  
  public String getEndpoint() {
    return this.endpoint;
  }
  
  public A withEndpoint(String endpoint) {
    this.endpoint = endpoint;
    return (A) this;
  }
  
  public boolean hasEndpoint() {
    return this.endpoint != null;
  }
  
  public A addToHeaders(String key,String value) {
    if(this.headers == null && key != null && value != null) { this.headers = new LinkedHashMap(); }
    if(key != null && value != null) {this.headers.put(key, value);} return (A)this;
  }
  
  public A addToHeaders(Map<String,String> map) {
    if(this.headers == null && map != null) { this.headers = new LinkedHashMap(); }
    if(map != null) { this.headers.putAll(map);} return (A)this;
  }
  
  public A removeFromHeaders(String key) {
    if(this.headers == null) { return (A) this; }
    if(key != null && this.headers != null) {this.headers.remove(key);} return (A)this;
  }
  
  public A removeFromHeaders(Map<String,String> map) {
    if(this.headers == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.headers != null){this.headers.remove(key);}}} return (A)this;
  }
  
  public Map<String,String> getHeaders() {
    return this.headers;
  }
  
  public <K,V>A withHeaders(Map<String,String> headers) {
    if (headers == null) {
      this.headers = null;
    } else {
      this.headers = new LinkedHashMap(headers);
    }
    return (A) this;
  }
  
  public boolean hasHeaders() {
    return this.headers != null;
  }
  
  public Boolean getInsecure() {
    return this.insecure;
  }
  
  public A withInsecure(Boolean insecure) {
    this.insecure = insecure;
    return (A) this;
  }
  
  public boolean hasInsecure() {
    return this.insecure != null;
  }
  
  public Quantity getSamplingFraction() {
    return this.samplingFraction;
  }
  
  public A withSamplingFraction(Quantity samplingFraction) {
    this.samplingFraction = samplingFraction;
    return (A) this;
  }
  
  public boolean hasSamplingFraction() {
    return this.samplingFraction != null;
  }
  
  public A withNewSamplingFraction(String amount,String format) {
    return (A)withSamplingFraction(new Quantity(amount, format));
  }
  
  public A withNewSamplingFraction(String amount) {
    return (A)withSamplingFraction(new Quantity(amount));
  }
  
  public String getTimeout() {
    return this.timeout;
  }
  
  public A withTimeout(String timeout) {
    this.timeout = timeout;
    return (A) this;
  }
  
  public boolean hasTimeout() {
    return this.timeout != null;
  }
  
  public TLSConfig buildTlsConfig() {
    return this.tlsConfig != null ? this.tlsConfig.build() : null;
  }
  
  public A withTlsConfig(TLSConfig tlsConfig) {
    this._visitables.remove(this.tlsConfig);
    if (tlsConfig != null) {
        this.tlsConfig = new TLSConfigBuilder(tlsConfig);
        this._visitables.get("tlsConfig").add(this.tlsConfig);
    } else {
        this.tlsConfig = null;
        this._visitables.get("tlsConfig").remove(this.tlsConfig);
    }
    return (A) this;
  }
  
  public boolean hasTlsConfig() {
    return this.tlsConfig != null;
  }
  
  public TlsConfigNested<A> withNewTlsConfig() {
    return new TlsConfigNested(null);
  }
  
  public TlsConfigNested<A> withNewTlsConfigLike(TLSConfig item) {
    return new TlsConfigNested(item);
  }
  
  public TlsConfigNested<A> editTlsConfig() {
    return withNewTlsConfigLike(java.util.Optional.ofNullable(buildTlsConfig()).orElse(null));
  }
  
  public TlsConfigNested<A> editOrNewTlsConfig() {
    return withNewTlsConfigLike(java.util.Optional.ofNullable(buildTlsConfig()).orElse(new TLSConfigBuilder().build()));
  }
  
  public TlsConfigNested<A> editOrNewTlsConfigLike(TLSConfig item) {
    return withNewTlsConfigLike(java.util.Optional.ofNullable(buildTlsConfig()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PrometheusTracingConfigFluent that = (PrometheusTracingConfigFluent) o;
    if (!java.util.Objects.equals(clientType, that.clientType)) return false;
    if (!java.util.Objects.equals(compression, that.compression)) return false;
    if (!java.util.Objects.equals(endpoint, that.endpoint)) return false;
    if (!java.util.Objects.equals(headers, that.headers)) return false;
    if (!java.util.Objects.equals(insecure, that.insecure)) return false;
    if (!java.util.Objects.equals(samplingFraction, that.samplingFraction)) return false;
    if (!java.util.Objects.equals(timeout, that.timeout)) return false;
    if (!java.util.Objects.equals(tlsConfig, that.tlsConfig)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(clientType,  compression,  endpoint,  headers,  insecure,  samplingFraction,  timeout,  tlsConfig,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clientType != null) { sb.append("clientType:"); sb.append(clientType + ","); }
    if (compression != null) { sb.append("compression:"); sb.append(compression + ","); }
    if (endpoint != null) { sb.append("endpoint:"); sb.append(endpoint + ","); }
    if (headers != null && !headers.isEmpty()) { sb.append("headers:"); sb.append(headers + ","); }
    if (insecure != null) { sb.append("insecure:"); sb.append(insecure + ","); }
    if (samplingFraction != null) { sb.append("samplingFraction:"); sb.append(samplingFraction + ","); }
    if (timeout != null) { sb.append("timeout:"); sb.append(timeout + ","); }
    if (tlsConfig != null) { sb.append("tlsConfig:"); sb.append(tlsConfig + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withInsecure() {
    return withInsecure(true);
  }
  public class TlsConfigNested<N> extends TLSConfigFluent<TlsConfigNested<N>> implements Nested<N>{
    TlsConfigNested(TLSConfig item) {
      this.builder = new TLSConfigBuilder(this, item);
    }
    TLSConfigBuilder builder;
    
    public N and() {
      return (N) PrometheusTracingConfigFluent.this.withTlsConfig(builder.build());
    }
    
    public N endTlsConfig() {
      return and();
    }
    
  
  }

}