package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Iterator;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class RemoteWriteSpecFluent<A extends RemoteWriteSpecFluent<A>> extends BaseFluent<A>{
  public RemoteWriteSpecFluent() {
  }
  
  public RemoteWriteSpecFluent(RemoteWriteSpec instance) {
    this.copyInstance(instance);
  }
  private AuthorizationBuilder authorization;
  private BasicAuthBuilder basicAuth;
  private String bearerToken;
  private String bearerTokenFile;
  private Map<String,String> headers;
  private MetadataConfigBuilder metadataConfig;
  private String name;
  private OAuth2Builder oauth2;
  private String proxyUrl;
  private QueueConfigBuilder queueConfig;
  private String remoteTimeout;
  private Boolean sendExemplars;
  private Boolean sendNativeHistograms;
  private Sigv4Builder sigv4;
  private TLSConfigBuilder tlsConfig;
  private String url;
  private ArrayList<RelabelConfigBuilder> writeRelabelConfigs = new ArrayList<RelabelConfigBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(RemoteWriteSpec instance) {
    instance = (instance != null ? instance : new RemoteWriteSpec());
    if (instance != null) {
          this.withAuthorization(instance.getAuthorization());
          this.withBasicAuth(instance.getBasicAuth());
          this.withBearerToken(instance.getBearerToken());
          this.withBearerTokenFile(instance.getBearerTokenFile());
          this.withHeaders(instance.getHeaders());
          this.withMetadataConfig(instance.getMetadataConfig());
          this.withName(instance.getName());
          this.withOauth2(instance.getOauth2());
          this.withProxyUrl(instance.getProxyUrl());
          this.withQueueConfig(instance.getQueueConfig());
          this.withRemoteTimeout(instance.getRemoteTimeout());
          this.withSendExemplars(instance.getSendExemplars());
          this.withSendNativeHistograms(instance.getSendNativeHistograms());
          this.withSigv4(instance.getSigv4());
          this.withTlsConfig(instance.getTlsConfig());
          this.withUrl(instance.getUrl());
          this.withWriteRelabelConfigs(instance.getWriteRelabelConfigs());
          this.withAuthorization(instance.getAuthorization());
          this.withBasicAuth(instance.getBasicAuth());
          this.withBearerToken(instance.getBearerToken());
          this.withBearerTokenFile(instance.getBearerTokenFile());
          this.withHeaders(instance.getHeaders());
          this.withMetadataConfig(instance.getMetadataConfig());
          this.withName(instance.getName());
          this.withOauth2(instance.getOauth2());
          this.withProxyUrl(instance.getProxyUrl());
          this.withQueueConfig(instance.getQueueConfig());
          this.withRemoteTimeout(instance.getRemoteTimeout());
          this.withSendExemplars(instance.getSendExemplars());
          this.withSendNativeHistograms(instance.getSendNativeHistograms());
          this.withSigv4(instance.getSigv4());
          this.withTlsConfig(instance.getTlsConfig());
          this.withUrl(instance.getUrl());
          this.withWriteRelabelConfigs(instance.getWriteRelabelConfigs());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Authorization buildAuthorization() {
    return this.authorization != null ? this.authorization.build() : null;
  }
  
  public A withAuthorization(Authorization authorization) {
    this._visitables.remove(this.authorization);
    if (authorization != null) {
        this.authorization = new AuthorizationBuilder(authorization);
        this._visitables.get("authorization").add(this.authorization);
    } else {
        this.authorization = null;
        this._visitables.get("authorization").remove(this.authorization);
    }
    return (A) this;
  }
  
  public boolean hasAuthorization() {
    return this.authorization != null;
  }
  
  public AuthorizationNested<A> withNewAuthorization() {
    return new AuthorizationNested(null);
  }
  
  public AuthorizationNested<A> withNewAuthorizationLike(Authorization item) {
    return new AuthorizationNested(item);
  }
  
  public AuthorizationNested<A> editAuthorization() {
    return withNewAuthorizationLike(java.util.Optional.ofNullable(buildAuthorization()).orElse(null));
  }
  
  public AuthorizationNested<A> editOrNewAuthorization() {
    return withNewAuthorizationLike(java.util.Optional.ofNullable(buildAuthorization()).orElse(new AuthorizationBuilder().build()));
  }
  
  public AuthorizationNested<A> editOrNewAuthorizationLike(Authorization item) {
    return withNewAuthorizationLike(java.util.Optional.ofNullable(buildAuthorization()).orElse(item));
  }
  
  public BasicAuth buildBasicAuth() {
    return this.basicAuth != null ? this.basicAuth.build() : null;
  }
  
  public A withBasicAuth(BasicAuth basicAuth) {
    this._visitables.remove(this.basicAuth);
    if (basicAuth != null) {
        this.basicAuth = new BasicAuthBuilder(basicAuth);
        this._visitables.get("basicAuth").add(this.basicAuth);
    } else {
        this.basicAuth = null;
        this._visitables.get("basicAuth").remove(this.basicAuth);
    }
    return (A) this;
  }
  
  public boolean hasBasicAuth() {
    return this.basicAuth != null;
  }
  
  public BasicAuthNested<A> withNewBasicAuth() {
    return new BasicAuthNested(null);
  }
  
  public BasicAuthNested<A> withNewBasicAuthLike(BasicAuth item) {
    return new BasicAuthNested(item);
  }
  
  public BasicAuthNested<A> editBasicAuth() {
    return withNewBasicAuthLike(java.util.Optional.ofNullable(buildBasicAuth()).orElse(null));
  }
  
  public BasicAuthNested<A> editOrNewBasicAuth() {
    return withNewBasicAuthLike(java.util.Optional.ofNullable(buildBasicAuth()).orElse(new BasicAuthBuilder().build()));
  }
  
  public BasicAuthNested<A> editOrNewBasicAuthLike(BasicAuth item) {
    return withNewBasicAuthLike(java.util.Optional.ofNullable(buildBasicAuth()).orElse(item));
  }
  
  public String getBearerToken() {
    return this.bearerToken;
  }
  
  public A withBearerToken(String bearerToken) {
    this.bearerToken = bearerToken;
    return (A) this;
  }
  
  public boolean hasBearerToken() {
    return this.bearerToken != null;
  }
  
  public String getBearerTokenFile() {
    return this.bearerTokenFile;
  }
  
  public A withBearerTokenFile(String bearerTokenFile) {
    this.bearerTokenFile = bearerTokenFile;
    return (A) this;
  }
  
  public boolean hasBearerTokenFile() {
    return this.bearerTokenFile != null;
  }
  
  public A addToHeaders(String key,String value) {
    if(this.headers == null && key != null && value != null) { this.headers = new LinkedHashMap(); }
    if(key != null && value != null) {this.headers.put(key, value);} return (A)this;
  }
  
  public A addToHeaders(Map<String,String> map) {
    if(this.headers == null && map != null) { this.headers = new LinkedHashMap(); }
    if(map != null) { this.headers.putAll(map);} return (A)this;
  }
  
  public A removeFromHeaders(String key) {
    if(this.headers == null) { return (A) this; }
    if(key != null && this.headers != null) {this.headers.remove(key);} return (A)this;
  }
  
  public A removeFromHeaders(Map<String,String> map) {
    if(this.headers == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.headers != null){this.headers.remove(key);}}} return (A)this;
  }
  
  public Map<String,String> getHeaders() {
    return this.headers;
  }
  
  public <K,V>A withHeaders(Map<String,String> headers) {
    if (headers == null) {
      this.headers = null;
    } else {
      this.headers = new LinkedHashMap(headers);
    }
    return (A) this;
  }
  
  public boolean hasHeaders() {
    return this.headers != null;
  }
  
  public MetadataConfig buildMetadataConfig() {
    return this.metadataConfig != null ? this.metadataConfig.build() : null;
  }
  
  public A withMetadataConfig(MetadataConfig metadataConfig) {
    this._visitables.remove(this.metadataConfig);
    if (metadataConfig != null) {
        this.metadataConfig = new MetadataConfigBuilder(metadataConfig);
        this._visitables.get("metadataConfig").add(this.metadataConfig);
    } else {
        this.metadataConfig = null;
        this._visitables.get("metadataConfig").remove(this.metadataConfig);
    }
    return (A) this;
  }
  
  public boolean hasMetadataConfig() {
    return this.metadataConfig != null;
  }
  
  public A withNewMetadataConfig(Boolean send,String sendInterval) {
    return (A)withMetadataConfig(new MetadataConfig(send, sendInterval));
  }
  
  public MetadataConfigNested<A> withNewMetadataConfig() {
    return new MetadataConfigNested(null);
  }
  
  public MetadataConfigNested<A> withNewMetadataConfigLike(MetadataConfig item) {
    return new MetadataConfigNested(item);
  }
  
  public MetadataConfigNested<A> editMetadataConfig() {
    return withNewMetadataConfigLike(java.util.Optional.ofNullable(buildMetadataConfig()).orElse(null));
  }
  
  public MetadataConfigNested<A> editOrNewMetadataConfig() {
    return withNewMetadataConfigLike(java.util.Optional.ofNullable(buildMetadataConfig()).orElse(new MetadataConfigBuilder().build()));
  }
  
  public MetadataConfigNested<A> editOrNewMetadataConfigLike(MetadataConfig item) {
    return withNewMetadataConfigLike(java.util.Optional.ofNullable(buildMetadataConfig()).orElse(item));
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public OAuth2 buildOauth2() {
    return this.oauth2 != null ? this.oauth2.build() : null;
  }
  
  public A withOauth2(OAuth2 oauth2) {
    this._visitables.remove(this.oauth2);
    if (oauth2 != null) {
        this.oauth2 = new OAuth2Builder(oauth2);
        this._visitables.get("oauth2").add(this.oauth2);
    } else {
        this.oauth2 = null;
        this._visitables.get("oauth2").remove(this.oauth2);
    }
    return (A) this;
  }
  
  public boolean hasOauth2() {
    return this.oauth2 != null;
  }
  
  public Oauth2Nested<A> withNewOauth2() {
    return new Oauth2Nested(null);
  }
  
  public Oauth2Nested<A> withNewOauth2Like(OAuth2 item) {
    return new Oauth2Nested(item);
  }
  
  public Oauth2Nested<A> editOauth2() {
    return withNewOauth2Like(java.util.Optional.ofNullable(buildOauth2()).orElse(null));
  }
  
  public Oauth2Nested<A> editOrNewOauth2() {
    return withNewOauth2Like(java.util.Optional.ofNullable(buildOauth2()).orElse(new OAuth2Builder().build()));
  }
  
  public Oauth2Nested<A> editOrNewOauth2Like(OAuth2 item) {
    return withNewOauth2Like(java.util.Optional.ofNullable(buildOauth2()).orElse(item));
  }
  
  public String getProxyUrl() {
    return this.proxyUrl;
  }
  
  public A withProxyUrl(String proxyUrl) {
    this.proxyUrl = proxyUrl;
    return (A) this;
  }
  
  public boolean hasProxyUrl() {
    return this.proxyUrl != null;
  }
  
  public QueueConfig buildQueueConfig() {
    return this.queueConfig != null ? this.queueConfig.build() : null;
  }
  
  public A withQueueConfig(QueueConfig queueConfig) {
    this._visitables.remove(this.queueConfig);
    if (queueConfig != null) {
        this.queueConfig = new QueueConfigBuilder(queueConfig);
        this._visitables.get("queueConfig").add(this.queueConfig);
    } else {
        this.queueConfig = null;
        this._visitables.get("queueConfig").remove(this.queueConfig);
    }
    return (A) this;
  }
  
  public boolean hasQueueConfig() {
    return this.queueConfig != null;
  }
  
  public QueueConfigNested<A> withNewQueueConfig() {
    return new QueueConfigNested(null);
  }
  
  public QueueConfigNested<A> withNewQueueConfigLike(QueueConfig item) {
    return new QueueConfigNested(item);
  }
  
  public QueueConfigNested<A> editQueueConfig() {
    return withNewQueueConfigLike(java.util.Optional.ofNullable(buildQueueConfig()).orElse(null));
  }
  
  public QueueConfigNested<A> editOrNewQueueConfig() {
    return withNewQueueConfigLike(java.util.Optional.ofNullable(buildQueueConfig()).orElse(new QueueConfigBuilder().build()));
  }
  
  public QueueConfigNested<A> editOrNewQueueConfigLike(QueueConfig item) {
    return withNewQueueConfigLike(java.util.Optional.ofNullable(buildQueueConfig()).orElse(item));
  }
  
  public String getRemoteTimeout() {
    return this.remoteTimeout;
  }
  
  public A withRemoteTimeout(String remoteTimeout) {
    this.remoteTimeout = remoteTimeout;
    return (A) this;
  }
  
  public boolean hasRemoteTimeout() {
    return this.remoteTimeout != null;
  }
  
  public Boolean getSendExemplars() {
    return this.sendExemplars;
  }
  
  public A withSendExemplars(Boolean sendExemplars) {
    this.sendExemplars = sendExemplars;
    return (A) this;
  }
  
  public boolean hasSendExemplars() {
    return this.sendExemplars != null;
  }
  
  public Boolean getSendNativeHistograms() {
    return this.sendNativeHistograms;
  }
  
  public A withSendNativeHistograms(Boolean sendNativeHistograms) {
    this.sendNativeHistograms = sendNativeHistograms;
    return (A) this;
  }
  
  public boolean hasSendNativeHistograms() {
    return this.sendNativeHistograms != null;
  }
  
  public Sigv4 buildSigv4() {
    return this.sigv4 != null ? this.sigv4.build() : null;
  }
  
  public A withSigv4(Sigv4 sigv4) {
    this._visitables.remove(this.sigv4);
    if (sigv4 != null) {
        this.sigv4 = new Sigv4Builder(sigv4);
        this._visitables.get("sigv4").add(this.sigv4);
    } else {
        this.sigv4 = null;
        this._visitables.get("sigv4").remove(this.sigv4);
    }
    return (A) this;
  }
  
  public boolean hasSigv4() {
    return this.sigv4 != null;
  }
  
  public Sigv4Nested<A> withNewSigv4() {
    return new Sigv4Nested(null);
  }
  
  public Sigv4Nested<A> withNewSigv4Like(Sigv4 item) {
    return new Sigv4Nested(item);
  }
  
  public Sigv4Nested<A> editSigv4() {
    return withNewSigv4Like(java.util.Optional.ofNullable(buildSigv4()).orElse(null));
  }
  
  public Sigv4Nested<A> editOrNewSigv4() {
    return withNewSigv4Like(java.util.Optional.ofNullable(buildSigv4()).orElse(new Sigv4Builder().build()));
  }
  
  public Sigv4Nested<A> editOrNewSigv4Like(Sigv4 item) {
    return withNewSigv4Like(java.util.Optional.ofNullable(buildSigv4()).orElse(item));
  }
  
  public TLSConfig buildTlsConfig() {
    return this.tlsConfig != null ? this.tlsConfig.build() : null;
  }
  
  public A withTlsConfig(TLSConfig tlsConfig) {
    this._visitables.remove(this.tlsConfig);
    if (tlsConfig != null) {
        this.tlsConfig = new TLSConfigBuilder(tlsConfig);
        this._visitables.get("tlsConfig").add(this.tlsConfig);
    } else {
        this.tlsConfig = null;
        this._visitables.get("tlsConfig").remove(this.tlsConfig);
    }
    return (A) this;
  }
  
  public boolean hasTlsConfig() {
    return this.tlsConfig != null;
  }
  
  public TlsConfigNested<A> withNewTlsConfig() {
    return new TlsConfigNested(null);
  }
  
  public TlsConfigNested<A> withNewTlsConfigLike(TLSConfig item) {
    return new TlsConfigNested(item);
  }
  
  public TlsConfigNested<A> editTlsConfig() {
    return withNewTlsConfigLike(java.util.Optional.ofNullable(buildTlsConfig()).orElse(null));
  }
  
  public TlsConfigNested<A> editOrNewTlsConfig() {
    return withNewTlsConfigLike(java.util.Optional.ofNullable(buildTlsConfig()).orElse(new TLSConfigBuilder().build()));
  }
  
  public TlsConfigNested<A> editOrNewTlsConfigLike(TLSConfig item) {
    return withNewTlsConfigLike(java.util.Optional.ofNullable(buildTlsConfig()).orElse(item));
  }
  
  public String getUrl() {
    return this.url;
  }
  
  public A withUrl(String url) {
    this.url = url;
    return (A) this;
  }
  
  public boolean hasUrl() {
    return this.url != null;
  }
  
  public A addToWriteRelabelConfigs(int index,RelabelConfig item) {
    if (this.writeRelabelConfigs == null) {this.writeRelabelConfigs = new ArrayList<RelabelConfigBuilder>();}
    RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
    if (index < 0 || index >= writeRelabelConfigs.size()) { _visitables.get("writeRelabelConfigs").add(builder); writeRelabelConfigs.add(builder); } else { _visitables.get("writeRelabelConfigs").add(index, builder); writeRelabelConfigs.add(index, builder);}
    return (A)this;
  }
  
  public A setToWriteRelabelConfigs(int index,RelabelConfig item) {
    if (this.writeRelabelConfigs == null) {this.writeRelabelConfigs = new ArrayList<RelabelConfigBuilder>();}
    RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
    if (index < 0 || index >= writeRelabelConfigs.size()) { _visitables.get("writeRelabelConfigs").add(builder); writeRelabelConfigs.add(builder); } else { _visitables.get("writeRelabelConfigs").set(index, builder); writeRelabelConfigs.set(index, builder);}
    return (A)this;
  }
  
  public A addToWriteRelabelConfigs(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... items) {
    if (this.writeRelabelConfigs == null) {this.writeRelabelConfigs = new ArrayList<RelabelConfigBuilder>();}
    for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("writeRelabelConfigs").add(builder);this.writeRelabelConfigs.add(builder);} return (A)this;
  }
  
  public A addAllToWriteRelabelConfigs(Collection<RelabelConfig> items) {
    if (this.writeRelabelConfigs == null) {this.writeRelabelConfigs = new ArrayList<RelabelConfigBuilder>();}
    for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("writeRelabelConfigs").add(builder);this.writeRelabelConfigs.add(builder);} return (A)this;
  }
  
  public A removeFromWriteRelabelConfigs(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... items) {
    if (this.writeRelabelConfigs == null) return (A)this;
    for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("writeRelabelConfigs").remove(builder); this.writeRelabelConfigs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromWriteRelabelConfigs(Collection<RelabelConfig> items) {
    if (this.writeRelabelConfigs == null) return (A)this;
    for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("writeRelabelConfigs").remove(builder); this.writeRelabelConfigs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromWriteRelabelConfigs(Predicate<RelabelConfigBuilder> predicate) {
    if (writeRelabelConfigs == null) return (A) this;
    final Iterator<RelabelConfigBuilder> each = writeRelabelConfigs.iterator();
    final List visitables = _visitables.get("writeRelabelConfigs");
    while (each.hasNext()) {
      RelabelConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<RelabelConfig> buildWriteRelabelConfigs() {
    return this.writeRelabelConfigs != null ? build(writeRelabelConfigs) : null;
  }
  
  public RelabelConfig buildWriteRelabelConfig(int index) {
    return this.writeRelabelConfigs.get(index).build();
  }
  
  public RelabelConfig buildFirstWriteRelabelConfig() {
    return this.writeRelabelConfigs.get(0).build();
  }
  
  public RelabelConfig buildLastWriteRelabelConfig() {
    return this.writeRelabelConfigs.get(writeRelabelConfigs.size() - 1).build();
  }
  
  public RelabelConfig buildMatchingWriteRelabelConfig(Predicate<RelabelConfigBuilder> predicate) {
      for (RelabelConfigBuilder item : writeRelabelConfigs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingWriteRelabelConfig(Predicate<RelabelConfigBuilder> predicate) {
      for (RelabelConfigBuilder item : writeRelabelConfigs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withWriteRelabelConfigs(List<RelabelConfig> writeRelabelConfigs) {
    if (this.writeRelabelConfigs != null) {
      this._visitables.get("writeRelabelConfigs").clear();
    }
    if (writeRelabelConfigs != null) {
        this.writeRelabelConfigs = new ArrayList();
        for (RelabelConfig item : writeRelabelConfigs) {
          this.addToWriteRelabelConfigs(item);
        }
    } else {
      this.writeRelabelConfigs = null;
    }
    return (A) this;
  }
  
  public A withWriteRelabelConfigs(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... writeRelabelConfigs) {
    if (this.writeRelabelConfigs != null) {this.writeRelabelConfigs.clear(); _visitables.remove("writeRelabelConfigs"); }
    if (writeRelabelConfigs != null) {for (RelabelConfig item :writeRelabelConfigs){ this.addToWriteRelabelConfigs(item);}} return (A) this;
  }
  
  public boolean hasWriteRelabelConfigs() {
    return this.writeRelabelConfigs != null && !this.writeRelabelConfigs.isEmpty();
  }
  
  public WriteRelabelConfigsNested<A> addNewWriteRelabelConfig() {
    return new WriteRelabelConfigsNested(-1, null);
  }
  
  public WriteRelabelConfigsNested<A> addNewWriteRelabelConfigLike(RelabelConfig item) {
    return new WriteRelabelConfigsNested(-1, item);
  }
  
  public WriteRelabelConfigsNested<A> setNewWriteRelabelConfigLike(int index,RelabelConfig item) {
    return new WriteRelabelConfigsNested(index, item);
  }
  
  public WriteRelabelConfigsNested<A> editWriteRelabelConfig(int index) {
    if (writeRelabelConfigs.size() <= index) throw new RuntimeException("Can't edit writeRelabelConfigs. Index exceeds size.");
    return setNewWriteRelabelConfigLike(index, buildWriteRelabelConfig(index));
  }
  
  public WriteRelabelConfigsNested<A> editFirstWriteRelabelConfig() {
    if (writeRelabelConfigs.size() == 0) throw new RuntimeException("Can't edit first writeRelabelConfigs. The list is empty.");
    return setNewWriteRelabelConfigLike(0, buildWriteRelabelConfig(0));
  }
  
  public WriteRelabelConfigsNested<A> editLastWriteRelabelConfig() {
    int index = writeRelabelConfigs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last writeRelabelConfigs. The list is empty.");
    return setNewWriteRelabelConfigLike(index, buildWriteRelabelConfig(index));
  }
  
  public WriteRelabelConfigsNested<A> editMatchingWriteRelabelConfig(Predicate<RelabelConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<writeRelabelConfigs.size();i++) { 
    if (predicate.test(writeRelabelConfigs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching writeRelabelConfigs. No match found.");
    return setNewWriteRelabelConfigLike(index, buildWriteRelabelConfig(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    RemoteWriteSpecFluent that = (RemoteWriteSpecFluent) o;
    if (!java.util.Objects.equals(authorization, that.authorization)) return false;
    if (!java.util.Objects.equals(basicAuth, that.basicAuth)) return false;
    if (!java.util.Objects.equals(bearerToken, that.bearerToken)) return false;
    if (!java.util.Objects.equals(bearerTokenFile, that.bearerTokenFile)) return false;
    if (!java.util.Objects.equals(headers, that.headers)) return false;
    if (!java.util.Objects.equals(metadataConfig, that.metadataConfig)) return false;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(oauth2, that.oauth2)) return false;
    if (!java.util.Objects.equals(proxyUrl, that.proxyUrl)) return false;
    if (!java.util.Objects.equals(queueConfig, that.queueConfig)) return false;
    if (!java.util.Objects.equals(remoteTimeout, that.remoteTimeout)) return false;
    if (!java.util.Objects.equals(sendExemplars, that.sendExemplars)) return false;
    if (!java.util.Objects.equals(sendNativeHistograms, that.sendNativeHistograms)) return false;
    if (!java.util.Objects.equals(sigv4, that.sigv4)) return false;
    if (!java.util.Objects.equals(tlsConfig, that.tlsConfig)) return false;
    if (!java.util.Objects.equals(url, that.url)) return false;
    if (!java.util.Objects.equals(writeRelabelConfigs, that.writeRelabelConfigs)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(authorization,  basicAuth,  bearerToken,  bearerTokenFile,  headers,  metadataConfig,  name,  oauth2,  proxyUrl,  queueConfig,  remoteTimeout,  sendExemplars,  sendNativeHistograms,  sigv4,  tlsConfig,  url,  writeRelabelConfigs,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (authorization != null) { sb.append("authorization:"); sb.append(authorization + ","); }
    if (basicAuth != null) { sb.append("basicAuth:"); sb.append(basicAuth + ","); }
    if (bearerToken != null) { sb.append("bearerToken:"); sb.append(bearerToken + ","); }
    if (bearerTokenFile != null) { sb.append("bearerTokenFile:"); sb.append(bearerTokenFile + ","); }
    if (headers != null && !headers.isEmpty()) { sb.append("headers:"); sb.append(headers + ","); }
    if (metadataConfig != null) { sb.append("metadataConfig:"); sb.append(metadataConfig + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (oauth2 != null) { sb.append("oauth2:"); sb.append(oauth2 + ","); }
    if (proxyUrl != null) { sb.append("proxyUrl:"); sb.append(proxyUrl + ","); }
    if (queueConfig != null) { sb.append("queueConfig:"); sb.append(queueConfig + ","); }
    if (remoteTimeout != null) { sb.append("remoteTimeout:"); sb.append(remoteTimeout + ","); }
    if (sendExemplars != null) { sb.append("sendExemplars:"); sb.append(sendExemplars + ","); }
    if (sendNativeHistograms != null) { sb.append("sendNativeHistograms:"); sb.append(sendNativeHistograms + ","); }
    if (sigv4 != null) { sb.append("sigv4:"); sb.append(sigv4 + ","); }
    if (tlsConfig != null) { sb.append("tlsConfig:"); sb.append(tlsConfig + ","); }
    if (url != null) { sb.append("url:"); sb.append(url + ","); }
    if (writeRelabelConfigs != null && !writeRelabelConfigs.isEmpty()) { sb.append("writeRelabelConfigs:"); sb.append(writeRelabelConfigs + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withSendExemplars() {
    return withSendExemplars(true);
  }
  
  public A withSendNativeHistograms() {
    return withSendNativeHistograms(true);
  }
  public class AuthorizationNested<N> extends AuthorizationFluent<AuthorizationNested<N>> implements Nested<N>{
    AuthorizationNested(Authorization item) {
      this.builder = new AuthorizationBuilder(this, item);
    }
    AuthorizationBuilder builder;
    
    public N and() {
      return (N) RemoteWriteSpecFluent.this.withAuthorization(builder.build());
    }
    
    public N endAuthorization() {
      return and();
    }
    
  
  }
  public class BasicAuthNested<N> extends BasicAuthFluent<BasicAuthNested<N>> implements Nested<N>{
    BasicAuthNested(BasicAuth item) {
      this.builder = new BasicAuthBuilder(this, item);
    }
    BasicAuthBuilder builder;
    
    public N and() {
      return (N) RemoteWriteSpecFluent.this.withBasicAuth(builder.build());
    }
    
    public N endBasicAuth() {
      return and();
    }
    
  
  }
  public class MetadataConfigNested<N> extends MetadataConfigFluent<MetadataConfigNested<N>> implements Nested<N>{
    MetadataConfigNested(MetadataConfig item) {
      this.builder = new MetadataConfigBuilder(this, item);
    }
    MetadataConfigBuilder builder;
    
    public N and() {
      return (N) RemoteWriteSpecFluent.this.withMetadataConfig(builder.build());
    }
    
    public N endMetadataConfig() {
      return and();
    }
    
  
  }
  public class Oauth2Nested<N> extends OAuth2Fluent<Oauth2Nested<N>> implements Nested<N>{
    Oauth2Nested(OAuth2 item) {
      this.builder = new OAuth2Builder(this, item);
    }
    OAuth2Builder builder;
    
    public N and() {
      return (N) RemoteWriteSpecFluent.this.withOauth2(builder.build());
    }
    
    public N endOauth2() {
      return and();
    }
    
  
  }
  public class QueueConfigNested<N> extends QueueConfigFluent<QueueConfigNested<N>> implements Nested<N>{
    QueueConfigNested(QueueConfig item) {
      this.builder = new QueueConfigBuilder(this, item);
    }
    QueueConfigBuilder builder;
    
    public N and() {
      return (N) RemoteWriteSpecFluent.this.withQueueConfig(builder.build());
    }
    
    public N endQueueConfig() {
      return and();
    }
    
  
  }
  public class Sigv4Nested<N> extends Sigv4Fluent<Sigv4Nested<N>> implements Nested<N>{
    Sigv4Nested(Sigv4 item) {
      this.builder = new Sigv4Builder(this, item);
    }
    Sigv4Builder builder;
    
    public N and() {
      return (N) RemoteWriteSpecFluent.this.withSigv4(builder.build());
    }
    
    public N endSigv4() {
      return and();
    }
    
  
  }
  public class TlsConfigNested<N> extends TLSConfigFluent<TlsConfigNested<N>> implements Nested<N>{
    TlsConfigNested(TLSConfig item) {
      this.builder = new TLSConfigBuilder(this, item);
    }
    TLSConfigBuilder builder;
    
    public N and() {
      return (N) RemoteWriteSpecFluent.this.withTlsConfig(builder.build());
    }
    
    public N endTlsConfig() {
      return and();
    }
    
  
  }
  public class WriteRelabelConfigsNested<N> extends RelabelConfigFluent<WriteRelabelConfigsNested<N>> implements Nested<N>{
    WriteRelabelConfigsNested(int index,RelabelConfig item) {
      this.index = index;
      this.builder = new RelabelConfigBuilder(this, item);
    }
    RelabelConfigBuilder builder;
    int index;
    
    public N and() {
      return (N) RemoteWriteSpecFluent.this.setToWriteRelabelConfigs(index,builder.build());
    }
    
    public N endWriteRelabelConfig() {
      return and();
    }
    
  
  }

}