package io.fabric8.openshift.api.model.monitoring.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class TLSConfigFluent<A extends TLSConfigFluent<A>> extends BaseFluent<A>{
  public TLSConfigFluent() {
  }
  
  public TLSConfigFluent(TLSConfig instance) {
    this.copyInstance(instance);
  }
  private SecretOrConfigMapBuilder ca;
  private String caFile;
  private SecretOrConfigMapBuilder cert;
  private String certFile;
  private Boolean insecureSkipVerify;
  private String keyFile;
  private SecretKeySelector keySecret;
  private String serverName;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(TLSConfig instance) {
    instance = (instance != null ? instance : new TLSConfig());
    if (instance != null) {
          this.withCa(instance.getCa());
          this.withCaFile(instance.getCaFile());
          this.withCert(instance.getCert());
          this.withCertFile(instance.getCertFile());
          this.withInsecureSkipVerify(instance.getInsecureSkipVerify());
          this.withKeyFile(instance.getKeyFile());
          this.withKeySecret(instance.getKeySecret());
          this.withServerName(instance.getServerName());
          this.withCa(instance.getCa());
          this.withCaFile(instance.getCaFile());
          this.withCert(instance.getCert());
          this.withCertFile(instance.getCertFile());
          this.withInsecureSkipVerify(instance.getInsecureSkipVerify());
          this.withKeyFile(instance.getKeyFile());
          this.withKeySecret(instance.getKeySecret());
          this.withServerName(instance.getServerName());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public SecretOrConfigMap buildCa() {
    return this.ca != null ? this.ca.build() : null;
  }
  
  public A withCa(SecretOrConfigMap ca) {
    this._visitables.remove(this.ca);
    if (ca != null) {
        this.ca = new SecretOrConfigMapBuilder(ca);
        this._visitables.get("ca").add(this.ca);
    } else {
        this.ca = null;
        this._visitables.get("ca").remove(this.ca);
    }
    return (A) this;
  }
  
  public boolean hasCa() {
    return this.ca != null;
  }
  
  public CaNested<A> withNewCa() {
    return new CaNested(null);
  }
  
  public CaNested<A> withNewCaLike(SecretOrConfigMap item) {
    return new CaNested(item);
  }
  
  public CaNested<A> editCa() {
    return withNewCaLike(java.util.Optional.ofNullable(buildCa()).orElse(null));
  }
  
  public CaNested<A> editOrNewCa() {
    return withNewCaLike(java.util.Optional.ofNullable(buildCa()).orElse(new SecretOrConfigMapBuilder().build()));
  }
  
  public CaNested<A> editOrNewCaLike(SecretOrConfigMap item) {
    return withNewCaLike(java.util.Optional.ofNullable(buildCa()).orElse(item));
  }
  
  public String getCaFile() {
    return this.caFile;
  }
  
  public A withCaFile(String caFile) {
    this.caFile = caFile;
    return (A) this;
  }
  
  public boolean hasCaFile() {
    return this.caFile != null;
  }
  
  public SecretOrConfigMap buildCert() {
    return this.cert != null ? this.cert.build() : null;
  }
  
  public A withCert(SecretOrConfigMap cert) {
    this._visitables.remove(this.cert);
    if (cert != null) {
        this.cert = new SecretOrConfigMapBuilder(cert);
        this._visitables.get("cert").add(this.cert);
    } else {
        this.cert = null;
        this._visitables.get("cert").remove(this.cert);
    }
    return (A) this;
  }
  
  public boolean hasCert() {
    return this.cert != null;
  }
  
  public CertNested<A> withNewCert() {
    return new CertNested(null);
  }
  
  public CertNested<A> withNewCertLike(SecretOrConfigMap item) {
    return new CertNested(item);
  }
  
  public CertNested<A> editCert() {
    return withNewCertLike(java.util.Optional.ofNullable(buildCert()).orElse(null));
  }
  
  public CertNested<A> editOrNewCert() {
    return withNewCertLike(java.util.Optional.ofNullable(buildCert()).orElse(new SecretOrConfigMapBuilder().build()));
  }
  
  public CertNested<A> editOrNewCertLike(SecretOrConfigMap item) {
    return withNewCertLike(java.util.Optional.ofNullable(buildCert()).orElse(item));
  }
  
  public String getCertFile() {
    return this.certFile;
  }
  
  public A withCertFile(String certFile) {
    this.certFile = certFile;
    return (A) this;
  }
  
  public boolean hasCertFile() {
    return this.certFile != null;
  }
  
  public Boolean getInsecureSkipVerify() {
    return this.insecureSkipVerify;
  }
  
  public A withInsecureSkipVerify(Boolean insecureSkipVerify) {
    this.insecureSkipVerify = insecureSkipVerify;
    return (A) this;
  }
  
  public boolean hasInsecureSkipVerify() {
    return this.insecureSkipVerify != null;
  }
  
  public String getKeyFile() {
    return this.keyFile;
  }
  
  public A withKeyFile(String keyFile) {
    this.keyFile = keyFile;
    return (A) this;
  }
  
  public boolean hasKeyFile() {
    return this.keyFile != null;
  }
  
  public SecretKeySelector getKeySecret() {
    return this.keySecret;
  }
  
  public A withKeySecret(SecretKeySelector keySecret) {
    this.keySecret = keySecret;
    return (A) this;
  }
  
  public boolean hasKeySecret() {
    return this.keySecret != null;
  }
  
  public A withNewKeySecret(String key,String name,Boolean optional) {
    return (A)withKeySecret(new SecretKeySelector(key, name, optional));
  }
  
  public String getServerName() {
    return this.serverName;
  }
  
  public A withServerName(String serverName) {
    this.serverName = serverName;
    return (A) this;
  }
  
  public boolean hasServerName() {
    return this.serverName != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TLSConfigFluent that = (TLSConfigFluent) o;
    if (!java.util.Objects.equals(ca, that.ca)) return false;
    if (!java.util.Objects.equals(caFile, that.caFile)) return false;
    if (!java.util.Objects.equals(cert, that.cert)) return false;
    if (!java.util.Objects.equals(certFile, that.certFile)) return false;
    if (!java.util.Objects.equals(insecureSkipVerify, that.insecureSkipVerify)) return false;
    if (!java.util.Objects.equals(keyFile, that.keyFile)) return false;
    if (!java.util.Objects.equals(keySecret, that.keySecret)) return false;
    if (!java.util.Objects.equals(serverName, that.serverName)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(ca,  caFile,  cert,  certFile,  insecureSkipVerify,  keyFile,  keySecret,  serverName,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (ca != null) { sb.append("ca:"); sb.append(ca + ","); }
    if (caFile != null) { sb.append("caFile:"); sb.append(caFile + ","); }
    if (cert != null) { sb.append("cert:"); sb.append(cert + ","); }
    if (certFile != null) { sb.append("certFile:"); sb.append(certFile + ","); }
    if (insecureSkipVerify != null) { sb.append("insecureSkipVerify:"); sb.append(insecureSkipVerify + ","); }
    if (keyFile != null) { sb.append("keyFile:"); sb.append(keyFile + ","); }
    if (keySecret != null) { sb.append("keySecret:"); sb.append(keySecret + ","); }
    if (serverName != null) { sb.append("serverName:"); sb.append(serverName + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withInsecureSkipVerify() {
    return withInsecureSkipVerify(true);
  }
  public class CaNested<N> extends SecretOrConfigMapFluent<CaNested<N>> implements Nested<N>{
    CaNested(SecretOrConfigMap item) {
      this.builder = new SecretOrConfigMapBuilder(this, item);
    }
    SecretOrConfigMapBuilder builder;
    
    public N and() {
      return (N) TLSConfigFluent.this.withCa(builder.build());
    }
    
    public N endCa() {
      return and();
    }
    
  
  }
  public class CertNested<N> extends SecretOrConfigMapFluent<CertNested<N>> implements Nested<N>{
    CertNested(SecretOrConfigMap item) {
      this.builder = new SecretOrConfigMapBuilder(this, item);
    }
    SecretOrConfigMapBuilder builder;
    
    public N and() {
      return (N) TLSConfigFluent.this.withCert(builder.build());
    }
    
    public N endCert() {
      return and();
    }
    
  
  }

}