package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class DiscordConfigFluent<A extends DiscordConfigFluent<A>> extends BaseFluent<A>{
  public DiscordConfigFluent() {
  }
  
  public DiscordConfigFluent(DiscordConfig instance) {
    this.copyInstance(instance);
  }
  private SecretKeySelector apiURL;
  private HTTPConfigBuilder httpConfig;
  private String message;
  private Boolean sendResolved;
  private String title;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(DiscordConfig instance) {
    instance = (instance != null ? instance : new DiscordConfig());
    if (instance != null) {
          this.withApiURL(instance.getApiURL());
          this.withHttpConfig(instance.getHttpConfig());
          this.withMessage(instance.getMessage());
          this.withSendResolved(instance.getSendResolved());
          this.withTitle(instance.getTitle());
          this.withApiURL(instance.getApiURL());
          this.withHttpConfig(instance.getHttpConfig());
          this.withMessage(instance.getMessage());
          this.withSendResolved(instance.getSendResolved());
          this.withTitle(instance.getTitle());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public SecretKeySelector getApiURL() {
    return this.apiURL;
  }
  
  public A withApiURL(SecretKeySelector apiURL) {
    this.apiURL = apiURL;
    return (A) this;
  }
  
  public boolean hasApiURL() {
    return this.apiURL != null;
  }
  
  public A withNewApiURL(String key,String name,Boolean optional) {
    return (A)withApiURL(new SecretKeySelector(key, name, optional));
  }
  
  public HTTPConfig buildHttpConfig() {
    return this.httpConfig != null ? this.httpConfig.build() : null;
  }
  
  public A withHttpConfig(HTTPConfig httpConfig) {
    this._visitables.remove(this.httpConfig);
    if (httpConfig != null) {
        this.httpConfig = new HTTPConfigBuilder(httpConfig);
        this._visitables.get("httpConfig").add(this.httpConfig);
    } else {
        this.httpConfig = null;
        this._visitables.get("httpConfig").remove(this.httpConfig);
    }
    return (A) this;
  }
  
  public boolean hasHttpConfig() {
    return this.httpConfig != null;
  }
  
  public HttpConfigNested<A> withNewHttpConfig() {
    return new HttpConfigNested(null);
  }
  
  public HttpConfigNested<A> withNewHttpConfigLike(HTTPConfig item) {
    return new HttpConfigNested(item);
  }
  
  public HttpConfigNested<A> editHttpConfig() {
    return withNewHttpConfigLike(java.util.Optional.ofNullable(buildHttpConfig()).orElse(null));
  }
  
  public HttpConfigNested<A> editOrNewHttpConfig() {
    return withNewHttpConfigLike(java.util.Optional.ofNullable(buildHttpConfig()).orElse(new HTTPConfigBuilder().build()));
  }
  
  public HttpConfigNested<A> editOrNewHttpConfigLike(HTTPConfig item) {
    return withNewHttpConfigLike(java.util.Optional.ofNullable(buildHttpConfig()).orElse(item));
  }
  
  public String getMessage() {
    return this.message;
  }
  
  public A withMessage(String message) {
    this.message = message;
    return (A) this;
  }
  
  public boolean hasMessage() {
    return this.message != null;
  }
  
  public Boolean getSendResolved() {
    return this.sendResolved;
  }
  
  public A withSendResolved(Boolean sendResolved) {
    this.sendResolved = sendResolved;
    return (A) this;
  }
  
  public boolean hasSendResolved() {
    return this.sendResolved != null;
  }
  
  public String getTitle() {
    return this.title;
  }
  
  public A withTitle(String title) {
    this.title = title;
    return (A) this;
  }
  
  public boolean hasTitle() {
    return this.title != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DiscordConfigFluent that = (DiscordConfigFluent) o;
    if (!java.util.Objects.equals(apiURL, that.apiURL)) return false;
    if (!java.util.Objects.equals(httpConfig, that.httpConfig)) return false;
    if (!java.util.Objects.equals(message, that.message)) return false;
    if (!java.util.Objects.equals(sendResolved, that.sendResolved)) return false;
    if (!java.util.Objects.equals(title, that.title)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(apiURL,  httpConfig,  message,  sendResolved,  title,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiURL != null) { sb.append("apiURL:"); sb.append(apiURL + ","); }
    if (httpConfig != null) { sb.append("httpConfig:"); sb.append(httpConfig + ","); }
    if (message != null) { sb.append("message:"); sb.append(message + ","); }
    if (sendResolved != null) { sb.append("sendResolved:"); sb.append(sendResolved + ","); }
    if (title != null) { sb.append("title:"); sb.append(title + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withSendResolved() {
    return withSendResolved(true);
  }
  public class HttpConfigNested<N> extends HTTPConfigFluent<HttpConfigNested<N>> implements Nested<N>{
    HttpConfigNested(HTTPConfig item) {
      this.builder = new HTTPConfigBuilder(this, item);
    }
    HTTPConfigBuilder builder;
    
    public N and() {
      return (N) DiscordConfigFluent.this.withHttpConfig(builder.build());
    }
    
    public N endHttpConfig() {
      return and();
    }
    
  
  }

}