package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorization;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfigFluent;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfig;
import java.lang.String;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import io.fabric8.openshift.api.model.monitoring.v1.BasicAuthBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.BasicAuthFluent;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.OAuth2;
import io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorizationFluent;
import io.fabric8.openshift.api.model.monitoring.v1.OAuth2Fluent;
import io.fabric8.openshift.api.model.monitoring.v1.BasicAuth;
import io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorizationBuilder;
import java.lang.Object;
import io.fabric8.openshift.api.model.monitoring.v1.OAuth2Builder;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class HTTPConfigFluent<A extends HTTPConfigFluent<A>> extends BaseFluent<A>{
  public HTTPConfigFluent() {
  }
  
  public HTTPConfigFluent(HTTPConfig instance) {
    this.copyInstance(instance);
  }
  private SafeAuthorizationBuilder authorization;
  private BasicAuthBuilder basicAuth;
  private SecretKeySelector bearerTokenSecret;
  private Boolean followRedirects;
  private OAuth2Builder oauth2;
  private String proxyURL;
  private SafeTLSConfigBuilder tlsConfig;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(HTTPConfig instance) {
    instance = (instance != null ? instance : new HTTPConfig());
    if (instance != null) {
          this.withAuthorization(instance.getAuthorization());
          this.withBasicAuth(instance.getBasicAuth());
          this.withBearerTokenSecret(instance.getBearerTokenSecret());
          this.withFollowRedirects(instance.getFollowRedirects());
          this.withOauth2(instance.getOauth2());
          this.withProxyURL(instance.getProxyURL());
          this.withTlsConfig(instance.getTlsConfig());
          this.withAuthorization(instance.getAuthorization());
          this.withBasicAuth(instance.getBasicAuth());
          this.withBearerTokenSecret(instance.getBearerTokenSecret());
          this.withFollowRedirects(instance.getFollowRedirects());
          this.withOauth2(instance.getOauth2());
          this.withProxyURL(instance.getProxyURL());
          this.withTlsConfig(instance.getTlsConfig());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public SafeAuthorization buildAuthorization() {
    return this.authorization != null ? this.authorization.build() : null;
  }
  
  public A withAuthorization(SafeAuthorization authorization) {
    this._visitables.remove(this.authorization);
    if (authorization != null) {
        this.authorization = new SafeAuthorizationBuilder(authorization);
        this._visitables.get("authorization").add(this.authorization);
    } else {
        this.authorization = null;
        this._visitables.get("authorization").remove(this.authorization);
    }
    return (A) this;
  }
  
  public boolean hasAuthorization() {
    return this.authorization != null;
  }
  
  public AuthorizationNested<A> withNewAuthorization() {
    return new AuthorizationNested(null);
  }
  
  public AuthorizationNested<A> withNewAuthorizationLike(SafeAuthorization item) {
    return new AuthorizationNested(item);
  }
  
  public AuthorizationNested<A> editAuthorization() {
    return withNewAuthorizationLike(java.util.Optional.ofNullable(buildAuthorization()).orElse(null));
  }
  
  public AuthorizationNested<A> editOrNewAuthorization() {
    return withNewAuthorizationLike(java.util.Optional.ofNullable(buildAuthorization()).orElse(new SafeAuthorizationBuilder().build()));
  }
  
  public AuthorizationNested<A> editOrNewAuthorizationLike(SafeAuthorization item) {
    return withNewAuthorizationLike(java.util.Optional.ofNullable(buildAuthorization()).orElse(item));
  }
  
  public BasicAuth buildBasicAuth() {
    return this.basicAuth != null ? this.basicAuth.build() : null;
  }
  
  public A withBasicAuth(BasicAuth basicAuth) {
    this._visitables.remove(this.basicAuth);
    if (basicAuth != null) {
        this.basicAuth = new BasicAuthBuilder(basicAuth);
        this._visitables.get("basicAuth").add(this.basicAuth);
    } else {
        this.basicAuth = null;
        this._visitables.get("basicAuth").remove(this.basicAuth);
    }
    return (A) this;
  }
  
  public boolean hasBasicAuth() {
    return this.basicAuth != null;
  }
  
  public BasicAuthNested<A> withNewBasicAuth() {
    return new BasicAuthNested(null);
  }
  
  public BasicAuthNested<A> withNewBasicAuthLike(BasicAuth item) {
    return new BasicAuthNested(item);
  }
  
  public BasicAuthNested<A> editBasicAuth() {
    return withNewBasicAuthLike(java.util.Optional.ofNullable(buildBasicAuth()).orElse(null));
  }
  
  public BasicAuthNested<A> editOrNewBasicAuth() {
    return withNewBasicAuthLike(java.util.Optional.ofNullable(buildBasicAuth()).orElse(new BasicAuthBuilder().build()));
  }
  
  public BasicAuthNested<A> editOrNewBasicAuthLike(BasicAuth item) {
    return withNewBasicAuthLike(java.util.Optional.ofNullable(buildBasicAuth()).orElse(item));
  }
  
  public SecretKeySelector getBearerTokenSecret() {
    return this.bearerTokenSecret;
  }
  
  public A withBearerTokenSecret(SecretKeySelector bearerTokenSecret) {
    this.bearerTokenSecret = bearerTokenSecret;
    return (A) this;
  }
  
  public boolean hasBearerTokenSecret() {
    return this.bearerTokenSecret != null;
  }
  
  public A withNewBearerTokenSecret(String key,String name,Boolean optional) {
    return (A)withBearerTokenSecret(new SecretKeySelector(key, name, optional));
  }
  
  public Boolean getFollowRedirects() {
    return this.followRedirects;
  }
  
  public A withFollowRedirects(Boolean followRedirects) {
    this.followRedirects = followRedirects;
    return (A) this;
  }
  
  public boolean hasFollowRedirects() {
    return this.followRedirects != null;
  }
  
  public OAuth2 buildOauth2() {
    return this.oauth2 != null ? this.oauth2.build() : null;
  }
  
  public A withOauth2(OAuth2 oauth2) {
    this._visitables.remove(this.oauth2);
    if (oauth2 != null) {
        this.oauth2 = new OAuth2Builder(oauth2);
        this._visitables.get("oauth2").add(this.oauth2);
    } else {
        this.oauth2 = null;
        this._visitables.get("oauth2").remove(this.oauth2);
    }
    return (A) this;
  }
  
  public boolean hasOauth2() {
    return this.oauth2 != null;
  }
  
  public Oauth2Nested<A> withNewOauth2() {
    return new Oauth2Nested(null);
  }
  
  public Oauth2Nested<A> withNewOauth2Like(OAuth2 item) {
    return new Oauth2Nested(item);
  }
  
  public Oauth2Nested<A> editOauth2() {
    return withNewOauth2Like(java.util.Optional.ofNullable(buildOauth2()).orElse(null));
  }
  
  public Oauth2Nested<A> editOrNewOauth2() {
    return withNewOauth2Like(java.util.Optional.ofNullable(buildOauth2()).orElse(new OAuth2Builder().build()));
  }
  
  public Oauth2Nested<A> editOrNewOauth2Like(OAuth2 item) {
    return withNewOauth2Like(java.util.Optional.ofNullable(buildOauth2()).orElse(item));
  }
  
  public String getProxyURL() {
    return this.proxyURL;
  }
  
  public A withProxyURL(String proxyURL) {
    this.proxyURL = proxyURL;
    return (A) this;
  }
  
  public boolean hasProxyURL() {
    return this.proxyURL != null;
  }
  
  public SafeTLSConfig buildTlsConfig() {
    return this.tlsConfig != null ? this.tlsConfig.build() : null;
  }
  
  public A withTlsConfig(SafeTLSConfig tlsConfig) {
    this._visitables.remove(this.tlsConfig);
    if (tlsConfig != null) {
        this.tlsConfig = new SafeTLSConfigBuilder(tlsConfig);
        this._visitables.get("tlsConfig").add(this.tlsConfig);
    } else {
        this.tlsConfig = null;
        this._visitables.get("tlsConfig").remove(this.tlsConfig);
    }
    return (A) this;
  }
  
  public boolean hasTlsConfig() {
    return this.tlsConfig != null;
  }
  
  public TlsConfigNested<A> withNewTlsConfig() {
    return new TlsConfigNested(null);
  }
  
  public TlsConfigNested<A> withNewTlsConfigLike(SafeTLSConfig item) {
    return new TlsConfigNested(item);
  }
  
  public TlsConfigNested<A> editTlsConfig() {
    return withNewTlsConfigLike(java.util.Optional.ofNullable(buildTlsConfig()).orElse(null));
  }
  
  public TlsConfigNested<A> editOrNewTlsConfig() {
    return withNewTlsConfigLike(java.util.Optional.ofNullable(buildTlsConfig()).orElse(new SafeTLSConfigBuilder().build()));
  }
  
  public TlsConfigNested<A> editOrNewTlsConfigLike(SafeTLSConfig item) {
    return withNewTlsConfigLike(java.util.Optional.ofNullable(buildTlsConfig()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HTTPConfigFluent that = (HTTPConfigFluent) o;
    if (!java.util.Objects.equals(authorization, that.authorization)) return false;
    if (!java.util.Objects.equals(basicAuth, that.basicAuth)) return false;
    if (!java.util.Objects.equals(bearerTokenSecret, that.bearerTokenSecret)) return false;
    if (!java.util.Objects.equals(followRedirects, that.followRedirects)) return false;
    if (!java.util.Objects.equals(oauth2, that.oauth2)) return false;
    if (!java.util.Objects.equals(proxyURL, that.proxyURL)) return false;
    if (!java.util.Objects.equals(tlsConfig, that.tlsConfig)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(authorization,  basicAuth,  bearerTokenSecret,  followRedirects,  oauth2,  proxyURL,  tlsConfig,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (authorization != null) { sb.append("authorization:"); sb.append(authorization + ","); }
    if (basicAuth != null) { sb.append("basicAuth:"); sb.append(basicAuth + ","); }
    if (bearerTokenSecret != null) { sb.append("bearerTokenSecret:"); sb.append(bearerTokenSecret + ","); }
    if (followRedirects != null) { sb.append("followRedirects:"); sb.append(followRedirects + ","); }
    if (oauth2 != null) { sb.append("oauth2:"); sb.append(oauth2 + ","); }
    if (proxyURL != null) { sb.append("proxyURL:"); sb.append(proxyURL + ","); }
    if (tlsConfig != null) { sb.append("tlsConfig:"); sb.append(tlsConfig + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withFollowRedirects() {
    return withFollowRedirects(true);
  }
  public class AuthorizationNested<N> extends SafeAuthorizationFluent<AuthorizationNested<N>> implements Nested<N>{
    AuthorizationNested(SafeAuthorization item) {
      this.builder = new SafeAuthorizationBuilder(this, item);
    }
    SafeAuthorizationBuilder builder;
    
    public N and() {
      return (N) HTTPConfigFluent.this.withAuthorization(builder.build());
    }
    
    public N endAuthorization() {
      return and();
    }
    
  
  }
  public class BasicAuthNested<N> extends BasicAuthFluent<BasicAuthNested<N>> implements Nested<N>{
    BasicAuthNested(BasicAuth item) {
      this.builder = new BasicAuthBuilder(this, item);
    }
    BasicAuthBuilder builder;
    
    public N and() {
      return (N) HTTPConfigFluent.this.withBasicAuth(builder.build());
    }
    
    public N endBasicAuth() {
      return and();
    }
    
  
  }
  public class Oauth2Nested<N> extends OAuth2Fluent<Oauth2Nested<N>> implements Nested<N>{
    Oauth2Nested(OAuth2 item) {
      this.builder = new OAuth2Builder(this, item);
    }
    OAuth2Builder builder;
    
    public N and() {
      return (N) HTTPConfigFluent.this.withOauth2(builder.build());
    }
    
    public N endOauth2() {
      return and();
    }
    
  
  }
  public class TlsConfigNested<N> extends SafeTLSConfigFluent<TlsConfigNested<N>> implements Nested<N>{
    TlsConfigNested(SafeTLSConfig item) {
      this.builder = new SafeTLSConfigBuilder(this, item);
    }
    SafeTLSConfigBuilder builder;
    
    public N and() {
      return (N) HTTPConfigFluent.this.withTlsConfig(builder.build());
    }
    
    public N endTlsConfig() {
      return and();
    }
    
  
  }

}