/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.MuteTimeInterval;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.TimeInterval;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.TimeIntervalBuilder;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.TimeIntervalFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class MuteTimeIntervalFluent<A extends MuteTimeIntervalFluent<A>>
extends BaseFluent<A> {
    private String name;
    private ArrayList<TimeIntervalBuilder> timeIntervals = new ArrayList();
    private Map<String, Object> additionalProperties;

    public MuteTimeIntervalFluent() {
    }

    public MuteTimeIntervalFluent(MuteTimeInterval instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(MuteTimeInterval instance) {
        MuteTimeInterval muteTimeInterval = instance = instance != null ? instance : new MuteTimeInterval();
        if (instance != null) {
            this.withName(instance.getName());
            this.withTimeIntervals(instance.getTimeIntervals());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public A addToTimeIntervals(int index, TimeInterval item) {
        if (this.timeIntervals == null) {
            this.timeIntervals = new ArrayList();
        }
        TimeIntervalBuilder builder = new TimeIntervalBuilder(item);
        if (index < 0 || index >= this.timeIntervals.size()) {
            this._visitables.get((Object)"timeIntervals").add(builder);
            this.timeIntervals.add(builder);
        } else {
            this._visitables.get((Object)"timeIntervals").add(index, builder);
            this.timeIntervals.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToTimeIntervals(int index, TimeInterval item) {
        if (this.timeIntervals == null) {
            this.timeIntervals = new ArrayList();
        }
        TimeIntervalBuilder builder = new TimeIntervalBuilder(item);
        if (index < 0 || index >= this.timeIntervals.size()) {
            this._visitables.get((Object)"timeIntervals").add(builder);
            this.timeIntervals.add(builder);
        } else {
            this._visitables.get((Object)"timeIntervals").set(index, builder);
            this.timeIntervals.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToTimeIntervals(TimeInterval ... items) {
        if (this.timeIntervals == null) {
            this.timeIntervals = new ArrayList();
        }
        for (TimeInterval item : items) {
            TimeIntervalBuilder builder = new TimeIntervalBuilder(item);
            this._visitables.get((Object)"timeIntervals").add(builder);
            this.timeIntervals.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToTimeIntervals(Collection<TimeInterval> items) {
        if (this.timeIntervals == null) {
            this.timeIntervals = new ArrayList();
        }
        for (TimeInterval item : items) {
            TimeIntervalBuilder builder = new TimeIntervalBuilder(item);
            this._visitables.get((Object)"timeIntervals").add(builder);
            this.timeIntervals.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromTimeIntervals(TimeInterval ... items) {
        if (this.timeIntervals == null) {
            return (A)((Object)this);
        }
        for (TimeInterval item : items) {
            TimeIntervalBuilder builder = new TimeIntervalBuilder(item);
            this._visitables.get((Object)"timeIntervals").remove((Object)builder);
            this.timeIntervals.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTimeIntervals(Collection<TimeInterval> items) {
        if (this.timeIntervals == null) {
            return (A)((Object)this);
        }
        for (TimeInterval item : items) {
            TimeIntervalBuilder builder = new TimeIntervalBuilder(item);
            this._visitables.get((Object)"timeIntervals").remove((Object)builder);
            this.timeIntervals.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromTimeIntervals(Predicate<TimeIntervalBuilder> predicate) {
        if (this.timeIntervals == null) {
            return (A)((Object)this);
        }
        Iterator<TimeIntervalBuilder> each = this.timeIntervals.iterator();
        List visitables = this._visitables.get((Object)"timeIntervals");
        while (each.hasNext()) {
            TimeIntervalBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<TimeInterval> buildTimeIntervals() {
        return this.timeIntervals != null ? MuteTimeIntervalFluent.build(this.timeIntervals) : null;
    }

    public TimeInterval buildTimeInterval(int index) {
        return this.timeIntervals.get(index).build();
    }

    public TimeInterval buildFirstTimeInterval() {
        return this.timeIntervals.get(0).build();
    }

    public TimeInterval buildLastTimeInterval() {
        return this.timeIntervals.get(this.timeIntervals.size() - 1).build();
    }

    public TimeInterval buildMatchingTimeInterval(Predicate<TimeIntervalBuilder> predicate) {
        for (TimeIntervalBuilder item : this.timeIntervals) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingTimeInterval(Predicate<TimeIntervalBuilder> predicate) {
        for (TimeIntervalBuilder item : this.timeIntervals) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTimeIntervals(List<TimeInterval> timeIntervals) {
        if (this.timeIntervals != null) {
            this._visitables.get((Object)"timeIntervals").clear();
        }
        if (timeIntervals != null) {
            this.timeIntervals = new ArrayList();
            for (TimeInterval item : timeIntervals) {
                this.addToTimeIntervals(item);
            }
        } else {
            this.timeIntervals = null;
        }
        return (A)((Object)this);
    }

    public A withTimeIntervals(TimeInterval ... timeIntervals) {
        if (this.timeIntervals != null) {
            this.timeIntervals.clear();
            this._visitables.remove((Object)"timeIntervals");
        }
        if (timeIntervals != null) {
            for (TimeInterval item : timeIntervals) {
                this.addToTimeIntervals(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTimeIntervals() {
        return this.timeIntervals != null && !this.timeIntervals.isEmpty();
    }

    public TimeIntervalsNested<A> addNewTimeInterval() {
        return new TimeIntervalsNested(-1, null);
    }

    public TimeIntervalsNested<A> addNewTimeIntervalLike(TimeInterval item) {
        return new TimeIntervalsNested(-1, item);
    }

    public TimeIntervalsNested<A> setNewTimeIntervalLike(int index, TimeInterval item) {
        return new TimeIntervalsNested(index, item);
    }

    public TimeIntervalsNested<A> editTimeInterval(int index) {
        if (this.timeIntervals.size() <= index) {
            throw new RuntimeException("Can't edit timeIntervals. Index exceeds size.");
        }
        return this.setNewTimeIntervalLike(index, this.buildTimeInterval(index));
    }

    public TimeIntervalsNested<A> editFirstTimeInterval() {
        if (this.timeIntervals.size() == 0) {
            throw new RuntimeException("Can't edit first timeIntervals. The list is empty.");
        }
        return this.setNewTimeIntervalLike(0, this.buildTimeInterval(0));
    }

    public TimeIntervalsNested<A> editLastTimeInterval() {
        int index = this.timeIntervals.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last timeIntervals. The list is empty.");
        }
        return this.setNewTimeIntervalLike(index, this.buildTimeInterval(index));
    }

    public TimeIntervalsNested<A> editMatchingTimeInterval(Predicate<TimeIntervalBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.timeIntervals.size(); ++i) {
            if (!predicate.test(this.timeIntervals.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching timeIntervals. No match found.");
        }
        return this.setNewTimeIntervalLike(index, this.buildTimeInterval(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MuteTimeIntervalFluent that = (MuteTimeIntervalFluent)((Object)o);
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.timeIntervals, that.timeIntervals)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.timeIntervals, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.timeIntervals != null && !this.timeIntervals.isEmpty()) {
            sb.append("timeIntervals:");
            sb.append(this.timeIntervals + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TimeIntervalsNested<N>
    extends TimeIntervalFluent<TimeIntervalsNested<N>>
    implements Nested<N> {
        TimeIntervalBuilder builder;
        int index;

        TimeIntervalsNested(int index, TimeInterval item) {
            this.index = index;
            this.builder = new TimeIntervalBuilder(this, item);
        }

        public N and() {
            return (N)MuteTimeIntervalFluent.this.setToTimeIntervals(this.index, this.builder.build());
        }

        public N endTimeInterval() {
            return this.and();
        }
    }
}

