package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class AlertmanagerSpecBuilder extends AlertmanagerSpecFluent<AlertmanagerSpecBuilder> implements VisitableBuilder<AlertmanagerSpec,AlertmanagerSpecBuilder>{
  public AlertmanagerSpecBuilder() {
    this(new AlertmanagerSpec());
  }
  
  public AlertmanagerSpecBuilder(AlertmanagerSpecFluent<?> fluent) {
    this(fluent, new AlertmanagerSpec());
  }
  
  public AlertmanagerSpecBuilder(AlertmanagerSpecFluent<?> fluent,AlertmanagerSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public AlertmanagerSpecBuilder(AlertmanagerSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  AlertmanagerSpecFluent<?> fluent;
  
  public AlertmanagerSpec build() {
    AlertmanagerSpec buildable = new AlertmanagerSpec(fluent.getAdditionalPeers(),fluent.getAffinity(),fluent.buildAlertmanagerConfigMatcherStrategy(),fluent.buildAlertmanagerConfigNamespaceSelector(),fluent.buildAlertmanagerConfigSelector(),fluent.buildAlertmanagerConfiguration(),fluent.getAutomountServiceAccountToken(),fluent.getBaseImage(),fluent.getClusterAdvertiseAddress(),fluent.getClusterGossipInterval(),fluent.getClusterLabel(),fluent.getClusterPeerTimeout(),fluent.getClusterPushpullInterval(),fluent.getConfigMaps(),fluent.getConfigSecret(),fluent.buildContainers(),fluent.buildDnsConfig(),fluent.getDnsPolicy(),fluent.getEnableFeatures(),fluent.getExternalUrl(),fluent.getForceEnableClusterMode(),fluent.buildHostAliases(),fluent.getImage(),fluent.getImagePullPolicy(),fluent.buildImagePullSecrets(),fluent.buildInitContainers(),fluent.getListenLocal(),fluent.getLogFormat(),fluent.getLogLevel(),fluent.getMinReadySeconds(),fluent.getNodeSelector(),fluent.getPaused(),fluent.buildPodMetadata(),fluent.getPortName(),fluent.getPriorityClassName(),fluent.getReplicas(),fluent.buildResources(),fluent.getRetention(),fluent.getRoutePrefix(),fluent.getSecrets(),fluent.getSecurityContext(),fluent.getServiceAccountName(),fluent.getSha(),fluent.buildStorage(),fluent.getTag(),fluent.getTolerations(),fluent.getTopologySpreadConstraints(),fluent.getVersion(),fluent.buildVolumeMounts(),fluent.buildVolumes(),fluent.buildWeb());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}