package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfigFluent;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfig;
import java.lang.String;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.LinkedHashMap;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfigBuilder;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class OpenStackSDConfigFluent<A extends OpenStackSDConfigFluent<A>> extends BaseFluent<A>{
  public OpenStackSDConfigFluent() {
  }
  
  public OpenStackSDConfigFluent(OpenStackSDConfig instance) {
    this.copyInstance(instance);
  }
  private Boolean allTenants;
  private String applicationCredentialId;
  private String applicationCredentialName;
  private SecretKeySelector applicationCredentialSecret;
  private String availability;
  private String domainID;
  private String domainName;
  private String identityEndpoint;
  private SecretKeySelector password;
  private Integer port;
  private String projectID;
  private String projectName;
  private String refreshInterval;
  private String region;
  private String role;
  private SafeTLSConfigBuilder tlsConfig;
  private String userid;
  private String username;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(OpenStackSDConfig instance) {
    instance = (instance != null ? instance : new OpenStackSDConfig());
    if (instance != null) {
          this.withAllTenants(instance.getAllTenants());
          this.withApplicationCredentialId(instance.getApplicationCredentialId());
          this.withApplicationCredentialName(instance.getApplicationCredentialName());
          this.withApplicationCredentialSecret(instance.getApplicationCredentialSecret());
          this.withAvailability(instance.getAvailability());
          this.withDomainID(instance.getDomainID());
          this.withDomainName(instance.getDomainName());
          this.withIdentityEndpoint(instance.getIdentityEndpoint());
          this.withPassword(instance.getPassword());
          this.withPort(instance.getPort());
          this.withProjectID(instance.getProjectID());
          this.withProjectName(instance.getProjectName());
          this.withRefreshInterval(instance.getRefreshInterval());
          this.withRegion(instance.getRegion());
          this.withRole(instance.getRole());
          this.withTlsConfig(instance.getTlsConfig());
          this.withUserid(instance.getUserid());
          this.withUsername(instance.getUsername());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Boolean getAllTenants() {
    return this.allTenants;
  }
  
  public A withAllTenants(Boolean allTenants) {
    this.allTenants = allTenants;
    return (A) this;
  }
  
  public boolean hasAllTenants() {
    return this.allTenants != null;
  }
  
  public String getApplicationCredentialId() {
    return this.applicationCredentialId;
  }
  
  public A withApplicationCredentialId(String applicationCredentialId) {
    this.applicationCredentialId = applicationCredentialId;
    return (A) this;
  }
  
  public boolean hasApplicationCredentialId() {
    return this.applicationCredentialId != null;
  }
  
  public String getApplicationCredentialName() {
    return this.applicationCredentialName;
  }
  
  public A withApplicationCredentialName(String applicationCredentialName) {
    this.applicationCredentialName = applicationCredentialName;
    return (A) this;
  }
  
  public boolean hasApplicationCredentialName() {
    return this.applicationCredentialName != null;
  }
  
  public SecretKeySelector getApplicationCredentialSecret() {
    return this.applicationCredentialSecret;
  }
  
  public A withApplicationCredentialSecret(SecretKeySelector applicationCredentialSecret) {
    this.applicationCredentialSecret = applicationCredentialSecret;
    return (A) this;
  }
  
  public boolean hasApplicationCredentialSecret() {
    return this.applicationCredentialSecret != null;
  }
  
  public A withNewApplicationCredentialSecret(String key,String name,Boolean optional) {
    return (A)withApplicationCredentialSecret(new SecretKeySelector(key, name, optional));
  }
  
  public String getAvailability() {
    return this.availability;
  }
  
  public A withAvailability(String availability) {
    this.availability = availability;
    return (A) this;
  }
  
  public boolean hasAvailability() {
    return this.availability != null;
  }
  
  public String getDomainID() {
    return this.domainID;
  }
  
  public A withDomainID(String domainID) {
    this.domainID = domainID;
    return (A) this;
  }
  
  public boolean hasDomainID() {
    return this.domainID != null;
  }
  
  public String getDomainName() {
    return this.domainName;
  }
  
  public A withDomainName(String domainName) {
    this.domainName = domainName;
    return (A) this;
  }
  
  public boolean hasDomainName() {
    return this.domainName != null;
  }
  
  public String getIdentityEndpoint() {
    return this.identityEndpoint;
  }
  
  public A withIdentityEndpoint(String identityEndpoint) {
    this.identityEndpoint = identityEndpoint;
    return (A) this;
  }
  
  public boolean hasIdentityEndpoint() {
    return this.identityEndpoint != null;
  }
  
  public SecretKeySelector getPassword() {
    return this.password;
  }
  
  public A withPassword(SecretKeySelector password) {
    this.password = password;
    return (A) this;
  }
  
  public boolean hasPassword() {
    return this.password != null;
  }
  
  public A withNewPassword(String key,String name,Boolean optional) {
    return (A)withPassword(new SecretKeySelector(key, name, optional));
  }
  
  public Integer getPort() {
    return this.port;
  }
  
  public A withPort(Integer port) {
    this.port = port;
    return (A) this;
  }
  
  public boolean hasPort() {
    return this.port != null;
  }
  
  public String getProjectID() {
    return this.projectID;
  }
  
  public A withProjectID(String projectID) {
    this.projectID = projectID;
    return (A) this;
  }
  
  public boolean hasProjectID() {
    return this.projectID != null;
  }
  
  public String getProjectName() {
    return this.projectName;
  }
  
  public A withProjectName(String projectName) {
    this.projectName = projectName;
    return (A) this;
  }
  
  public boolean hasProjectName() {
    return this.projectName != null;
  }
  
  public String getRefreshInterval() {
    return this.refreshInterval;
  }
  
  public A withRefreshInterval(String refreshInterval) {
    this.refreshInterval = refreshInterval;
    return (A) this;
  }
  
  public boolean hasRefreshInterval() {
    return this.refreshInterval != null;
  }
  
  public String getRegion() {
    return this.region;
  }
  
  public A withRegion(String region) {
    this.region = region;
    return (A) this;
  }
  
  public boolean hasRegion() {
    return this.region != null;
  }
  
  public String getRole() {
    return this.role;
  }
  
  public A withRole(String role) {
    this.role = role;
    return (A) this;
  }
  
  public boolean hasRole() {
    return this.role != null;
  }
  
  public SafeTLSConfig buildTlsConfig() {
    return this.tlsConfig != null ? this.tlsConfig.build() : null;
  }
  
  public A withTlsConfig(SafeTLSConfig tlsConfig) {
    this._visitables.remove("tlsConfig");
    if (tlsConfig != null) {
        this.tlsConfig = new SafeTLSConfigBuilder(tlsConfig);
        this._visitables.get("tlsConfig").add(this.tlsConfig);
    } else {
        this.tlsConfig = null;
        this._visitables.get("tlsConfig").remove(this.tlsConfig);
    }
    return (A) this;
  }
  
  public boolean hasTlsConfig() {
    return this.tlsConfig != null;
  }
  
  public TlsConfigNested<A> withNewTlsConfig() {
    return new TlsConfigNested(null);
  }
  
  public TlsConfigNested<A> withNewTlsConfigLike(SafeTLSConfig item) {
    return new TlsConfigNested(item);
  }
  
  public TlsConfigNested<A> editTlsConfig() {
    return withNewTlsConfigLike(java.util.Optional.ofNullable(buildTlsConfig()).orElse(null));
  }
  
  public TlsConfigNested<A> editOrNewTlsConfig() {
    return withNewTlsConfigLike(java.util.Optional.ofNullable(buildTlsConfig()).orElse(new SafeTLSConfigBuilder().build()));
  }
  
  public TlsConfigNested<A> editOrNewTlsConfigLike(SafeTLSConfig item) {
    return withNewTlsConfigLike(java.util.Optional.ofNullable(buildTlsConfig()).orElse(item));
  }
  
  public String getUserid() {
    return this.userid;
  }
  
  public A withUserid(String userid) {
    this.userid = userid;
    return (A) this;
  }
  
  public boolean hasUserid() {
    return this.userid != null;
  }
  
  public String getUsername() {
    return this.username;
  }
  
  public A withUsername(String username) {
    this.username = username;
    return (A) this;
  }
  
  public boolean hasUsername() {
    return this.username != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    OpenStackSDConfigFluent that = (OpenStackSDConfigFluent) o;
    if (!java.util.Objects.equals(allTenants, that.allTenants)) return false;
    if (!java.util.Objects.equals(applicationCredentialId, that.applicationCredentialId)) return false;
    if (!java.util.Objects.equals(applicationCredentialName, that.applicationCredentialName)) return false;
    if (!java.util.Objects.equals(applicationCredentialSecret, that.applicationCredentialSecret)) return false;
    if (!java.util.Objects.equals(availability, that.availability)) return false;
    if (!java.util.Objects.equals(domainID, that.domainID)) return false;
    if (!java.util.Objects.equals(domainName, that.domainName)) return false;
    if (!java.util.Objects.equals(identityEndpoint, that.identityEndpoint)) return false;
    if (!java.util.Objects.equals(password, that.password)) return false;
    if (!java.util.Objects.equals(port, that.port)) return false;
    if (!java.util.Objects.equals(projectID, that.projectID)) return false;
    if (!java.util.Objects.equals(projectName, that.projectName)) return false;
    if (!java.util.Objects.equals(refreshInterval, that.refreshInterval)) return false;
    if (!java.util.Objects.equals(region, that.region)) return false;
    if (!java.util.Objects.equals(role, that.role)) return false;
    if (!java.util.Objects.equals(tlsConfig, that.tlsConfig)) return false;
    if (!java.util.Objects.equals(userid, that.userid)) return false;
    if (!java.util.Objects.equals(username, that.username)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(allTenants,  applicationCredentialId,  applicationCredentialName,  applicationCredentialSecret,  availability,  domainID,  domainName,  identityEndpoint,  password,  port,  projectID,  projectName,  refreshInterval,  region,  role,  tlsConfig,  userid,  username,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (allTenants != null) { sb.append("allTenants:"); sb.append(allTenants + ","); }
    if (applicationCredentialId != null) { sb.append("applicationCredentialId:"); sb.append(applicationCredentialId + ","); }
    if (applicationCredentialName != null) { sb.append("applicationCredentialName:"); sb.append(applicationCredentialName + ","); }
    if (applicationCredentialSecret != null) { sb.append("applicationCredentialSecret:"); sb.append(applicationCredentialSecret + ","); }
    if (availability != null) { sb.append("availability:"); sb.append(availability + ","); }
    if (domainID != null) { sb.append("domainID:"); sb.append(domainID + ","); }
    if (domainName != null) { sb.append("domainName:"); sb.append(domainName + ","); }
    if (identityEndpoint != null) { sb.append("identityEndpoint:"); sb.append(identityEndpoint + ","); }
    if (password != null) { sb.append("password:"); sb.append(password + ","); }
    if (port != null) { sb.append("port:"); sb.append(port + ","); }
    if (projectID != null) { sb.append("projectID:"); sb.append(projectID + ","); }
    if (projectName != null) { sb.append("projectName:"); sb.append(projectName + ","); }
    if (refreshInterval != null) { sb.append("refreshInterval:"); sb.append(refreshInterval + ","); }
    if (region != null) { sb.append("region:"); sb.append(region + ","); }
    if (role != null) { sb.append("role:"); sb.append(role + ","); }
    if (tlsConfig != null) { sb.append("tlsConfig:"); sb.append(tlsConfig + ","); }
    if (userid != null) { sb.append("userid:"); sb.append(userid + ","); }
    if (username != null) { sb.append("username:"); sb.append(username + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withAllTenants() {
    return withAllTenants(true);
  }
  public class TlsConfigNested<N> extends SafeTLSConfigFluent<TlsConfigNested<N>> implements Nested<N>{
    TlsConfigNested(SafeTLSConfig item) {
      this.builder = new SafeTLSConfigBuilder(this, item);
    }
    SafeTLSConfigBuilder builder;
    
    public N and() {
      return (N) OpenStackSDConfigFluent.this.withTlsConfig(builder.build());
    }
    
    public N endTlsConfig() {
      return and();
    }
    
  
  }

}