package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Iterator;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ReceiverFluent<A extends ReceiverFluent<A>> extends BaseFluent<A>{
  public ReceiverFluent() {
  }
  
  public ReceiverFluent(Receiver instance) {
    this.copyInstance(instance);
  }
  private ArrayList<DiscordConfigBuilder> discordConfigs = new ArrayList<DiscordConfigBuilder>();
  private ArrayList<EmailConfigBuilder> emailConfigs = new ArrayList<EmailConfigBuilder>();
  private ArrayList<MSTeamsConfigBuilder> msteamsConfigs = new ArrayList<MSTeamsConfigBuilder>();
  private String name;
  private ArrayList<OpsGenieConfigBuilder> opsgenieConfigs = new ArrayList<OpsGenieConfigBuilder>();
  private ArrayList<PagerDutyConfigBuilder> pagerdutyConfigs = new ArrayList<PagerDutyConfigBuilder>();
  private ArrayList<PushoverConfigBuilder> pushoverConfigs = new ArrayList<PushoverConfigBuilder>();
  private ArrayList<SlackConfigBuilder> slackConfigs = new ArrayList<SlackConfigBuilder>();
  private ArrayList<SNSConfigBuilder> snsConfigs = new ArrayList<SNSConfigBuilder>();
  private ArrayList<TelegramConfigBuilder> telegramConfigs = new ArrayList<TelegramConfigBuilder>();
  private ArrayList<VictorOpsConfigBuilder> victoropsConfigs = new ArrayList<VictorOpsConfigBuilder>();
  private ArrayList<WebexConfigBuilder> webexConfigs = new ArrayList<WebexConfigBuilder>();
  private ArrayList<WebhookConfigBuilder> webhookConfigs = new ArrayList<WebhookConfigBuilder>();
  private ArrayList<WeChatConfigBuilder> wechatConfigs = new ArrayList<WeChatConfigBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(Receiver instance) {
    instance = (instance != null ? instance : new Receiver());
    if (instance != null) {
          this.withDiscordConfigs(instance.getDiscordConfigs());
          this.withEmailConfigs(instance.getEmailConfigs());
          this.withMsteamsConfigs(instance.getMsteamsConfigs());
          this.withName(instance.getName());
          this.withOpsgenieConfigs(instance.getOpsgenieConfigs());
          this.withPagerdutyConfigs(instance.getPagerdutyConfigs());
          this.withPushoverConfigs(instance.getPushoverConfigs());
          this.withSlackConfigs(instance.getSlackConfigs());
          this.withSnsConfigs(instance.getSnsConfigs());
          this.withTelegramConfigs(instance.getTelegramConfigs());
          this.withVictoropsConfigs(instance.getVictoropsConfigs());
          this.withWebexConfigs(instance.getWebexConfigs());
          this.withWebhookConfigs(instance.getWebhookConfigs());
          this.withWechatConfigs(instance.getWechatConfigs());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToDiscordConfigs(int index,DiscordConfig item) {
    if (this.discordConfigs == null) {this.discordConfigs = new ArrayList<DiscordConfigBuilder>();}
    DiscordConfigBuilder builder = new DiscordConfigBuilder(item);
    if (index < 0 || index >= discordConfigs.size()) { _visitables.get("discordConfigs").add(builder); discordConfigs.add(builder); } else { _visitables.get("discordConfigs").add(index, builder); discordConfigs.add(index, builder);}
    return (A)this;
  }
  
  public A setToDiscordConfigs(int index,DiscordConfig item) {
    if (this.discordConfigs == null) {this.discordConfigs = new ArrayList<DiscordConfigBuilder>();}
    DiscordConfigBuilder builder = new DiscordConfigBuilder(item);
    if (index < 0 || index >= discordConfigs.size()) { _visitables.get("discordConfigs").add(builder); discordConfigs.add(builder); } else { _visitables.get("discordConfigs").set(index, builder); discordConfigs.set(index, builder);}
    return (A)this;
  }
  
  public A addToDiscordConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.DiscordConfig... items) {
    if (this.discordConfigs == null) {this.discordConfigs = new ArrayList<DiscordConfigBuilder>();}
    for (DiscordConfig item : items) {DiscordConfigBuilder builder = new DiscordConfigBuilder(item);_visitables.get("discordConfigs").add(builder);this.discordConfigs.add(builder);} return (A)this;
  }
  
  public A addAllToDiscordConfigs(Collection<DiscordConfig> items) {
    if (this.discordConfigs == null) {this.discordConfigs = new ArrayList<DiscordConfigBuilder>();}
    for (DiscordConfig item : items) {DiscordConfigBuilder builder = new DiscordConfigBuilder(item);_visitables.get("discordConfigs").add(builder);this.discordConfigs.add(builder);} return (A)this;
  }
  
  public A removeFromDiscordConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.DiscordConfig... items) {
    if (this.discordConfigs == null) return (A)this;
    for (DiscordConfig item : items) {DiscordConfigBuilder builder = new DiscordConfigBuilder(item);_visitables.get("discordConfigs").remove(builder); this.discordConfigs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromDiscordConfigs(Collection<DiscordConfig> items) {
    if (this.discordConfigs == null) return (A)this;
    for (DiscordConfig item : items) {DiscordConfigBuilder builder = new DiscordConfigBuilder(item);_visitables.get("discordConfigs").remove(builder); this.discordConfigs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromDiscordConfigs(Predicate<DiscordConfigBuilder> predicate) {
    if (discordConfigs == null) return (A) this;
    final Iterator<DiscordConfigBuilder> each = discordConfigs.iterator();
    final List visitables = _visitables.get("discordConfigs");
    while (each.hasNext()) {
      DiscordConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<DiscordConfig> buildDiscordConfigs() {
    return this.discordConfigs != null ? build(discordConfigs) : null;
  }
  
  public DiscordConfig buildDiscordConfig(int index) {
    return this.discordConfigs.get(index).build();
  }
  
  public DiscordConfig buildFirstDiscordConfig() {
    return this.discordConfigs.get(0).build();
  }
  
  public DiscordConfig buildLastDiscordConfig() {
    return this.discordConfigs.get(discordConfigs.size() - 1).build();
  }
  
  public DiscordConfig buildMatchingDiscordConfig(Predicate<DiscordConfigBuilder> predicate) {
      for (DiscordConfigBuilder item : discordConfigs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingDiscordConfig(Predicate<DiscordConfigBuilder> predicate) {
      for (DiscordConfigBuilder item : discordConfigs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withDiscordConfigs(List<DiscordConfig> discordConfigs) {
    if (this.discordConfigs != null) {
      this._visitables.get("discordConfigs").clear();
    }
    if (discordConfigs != null) {
        this.discordConfigs = new ArrayList();
        for (DiscordConfig item : discordConfigs) {
          this.addToDiscordConfigs(item);
        }
    } else {
      this.discordConfigs = null;
    }
    return (A) this;
  }
  
  public A withDiscordConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.DiscordConfig... discordConfigs) {
    if (this.discordConfigs != null) {
        this.discordConfigs.clear();
        _visitables.remove("discordConfigs");
    }
    if (discordConfigs != null) {
      for (DiscordConfig item : discordConfigs) {
        this.addToDiscordConfigs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasDiscordConfigs() {
    return this.discordConfigs != null && !this.discordConfigs.isEmpty();
  }
  
  public DiscordConfigsNested<A> addNewDiscordConfig() {
    return new DiscordConfigsNested(-1, null);
  }
  
  public DiscordConfigsNested<A> addNewDiscordConfigLike(DiscordConfig item) {
    return new DiscordConfigsNested(-1, item);
  }
  
  public DiscordConfigsNested<A> setNewDiscordConfigLike(int index,DiscordConfig item) {
    return new DiscordConfigsNested(index, item);
  }
  
  public DiscordConfigsNested<A> editDiscordConfig(int index) {
    if (discordConfigs.size() <= index) throw new RuntimeException("Can't edit discordConfigs. Index exceeds size.");
    return setNewDiscordConfigLike(index, buildDiscordConfig(index));
  }
  
  public DiscordConfigsNested<A> editFirstDiscordConfig() {
    if (discordConfigs.size() == 0) throw new RuntimeException("Can't edit first discordConfigs. The list is empty.");
    return setNewDiscordConfigLike(0, buildDiscordConfig(0));
  }
  
  public DiscordConfigsNested<A> editLastDiscordConfig() {
    int index = discordConfigs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last discordConfigs. The list is empty.");
    return setNewDiscordConfigLike(index, buildDiscordConfig(index));
  }
  
  public DiscordConfigsNested<A> editMatchingDiscordConfig(Predicate<DiscordConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<discordConfigs.size();i++) { 
    if (predicate.test(discordConfigs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching discordConfigs. No match found.");
    return setNewDiscordConfigLike(index, buildDiscordConfig(index));
  }
  
  public A addToEmailConfigs(int index,EmailConfig item) {
    if (this.emailConfigs == null) {this.emailConfigs = new ArrayList<EmailConfigBuilder>();}
    EmailConfigBuilder builder = new EmailConfigBuilder(item);
    if (index < 0 || index >= emailConfigs.size()) { _visitables.get("emailConfigs").add(builder); emailConfigs.add(builder); } else { _visitables.get("emailConfigs").add(index, builder); emailConfigs.add(index, builder);}
    return (A)this;
  }
  
  public A setToEmailConfigs(int index,EmailConfig item) {
    if (this.emailConfigs == null) {this.emailConfigs = new ArrayList<EmailConfigBuilder>();}
    EmailConfigBuilder builder = new EmailConfigBuilder(item);
    if (index < 0 || index >= emailConfigs.size()) { _visitables.get("emailConfigs").add(builder); emailConfigs.add(builder); } else { _visitables.get("emailConfigs").set(index, builder); emailConfigs.set(index, builder);}
    return (A)this;
  }
  
  public A addToEmailConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.EmailConfig... items) {
    if (this.emailConfigs == null) {this.emailConfigs = new ArrayList<EmailConfigBuilder>();}
    for (EmailConfig item : items) {EmailConfigBuilder builder = new EmailConfigBuilder(item);_visitables.get("emailConfigs").add(builder);this.emailConfigs.add(builder);} return (A)this;
  }
  
  public A addAllToEmailConfigs(Collection<EmailConfig> items) {
    if (this.emailConfigs == null) {this.emailConfigs = new ArrayList<EmailConfigBuilder>();}
    for (EmailConfig item : items) {EmailConfigBuilder builder = new EmailConfigBuilder(item);_visitables.get("emailConfigs").add(builder);this.emailConfigs.add(builder);} return (A)this;
  }
  
  public A removeFromEmailConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.EmailConfig... items) {
    if (this.emailConfigs == null) return (A)this;
    for (EmailConfig item : items) {EmailConfigBuilder builder = new EmailConfigBuilder(item);_visitables.get("emailConfigs").remove(builder); this.emailConfigs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromEmailConfigs(Collection<EmailConfig> items) {
    if (this.emailConfigs == null) return (A)this;
    for (EmailConfig item : items) {EmailConfigBuilder builder = new EmailConfigBuilder(item);_visitables.get("emailConfigs").remove(builder); this.emailConfigs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromEmailConfigs(Predicate<EmailConfigBuilder> predicate) {
    if (emailConfigs == null) return (A) this;
    final Iterator<EmailConfigBuilder> each = emailConfigs.iterator();
    final List visitables = _visitables.get("emailConfigs");
    while (each.hasNext()) {
      EmailConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<EmailConfig> buildEmailConfigs() {
    return this.emailConfigs != null ? build(emailConfigs) : null;
  }
  
  public EmailConfig buildEmailConfig(int index) {
    return this.emailConfigs.get(index).build();
  }
  
  public EmailConfig buildFirstEmailConfig() {
    return this.emailConfigs.get(0).build();
  }
  
  public EmailConfig buildLastEmailConfig() {
    return this.emailConfigs.get(emailConfigs.size() - 1).build();
  }
  
  public EmailConfig buildMatchingEmailConfig(Predicate<EmailConfigBuilder> predicate) {
      for (EmailConfigBuilder item : emailConfigs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingEmailConfig(Predicate<EmailConfigBuilder> predicate) {
      for (EmailConfigBuilder item : emailConfigs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withEmailConfigs(List<EmailConfig> emailConfigs) {
    if (this.emailConfigs != null) {
      this._visitables.get("emailConfigs").clear();
    }
    if (emailConfigs != null) {
        this.emailConfigs = new ArrayList();
        for (EmailConfig item : emailConfigs) {
          this.addToEmailConfigs(item);
        }
    } else {
      this.emailConfigs = null;
    }
    return (A) this;
  }
  
  public A withEmailConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.EmailConfig... emailConfigs) {
    if (this.emailConfigs != null) {
        this.emailConfigs.clear();
        _visitables.remove("emailConfigs");
    }
    if (emailConfigs != null) {
      for (EmailConfig item : emailConfigs) {
        this.addToEmailConfigs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasEmailConfigs() {
    return this.emailConfigs != null && !this.emailConfigs.isEmpty();
  }
  
  public EmailConfigsNested<A> addNewEmailConfig() {
    return new EmailConfigsNested(-1, null);
  }
  
  public EmailConfigsNested<A> addNewEmailConfigLike(EmailConfig item) {
    return new EmailConfigsNested(-1, item);
  }
  
  public EmailConfigsNested<A> setNewEmailConfigLike(int index,EmailConfig item) {
    return new EmailConfigsNested(index, item);
  }
  
  public EmailConfigsNested<A> editEmailConfig(int index) {
    if (emailConfigs.size() <= index) throw new RuntimeException("Can't edit emailConfigs. Index exceeds size.");
    return setNewEmailConfigLike(index, buildEmailConfig(index));
  }
  
  public EmailConfigsNested<A> editFirstEmailConfig() {
    if (emailConfigs.size() == 0) throw new RuntimeException("Can't edit first emailConfigs. The list is empty.");
    return setNewEmailConfigLike(0, buildEmailConfig(0));
  }
  
  public EmailConfigsNested<A> editLastEmailConfig() {
    int index = emailConfigs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last emailConfigs. The list is empty.");
    return setNewEmailConfigLike(index, buildEmailConfig(index));
  }
  
  public EmailConfigsNested<A> editMatchingEmailConfig(Predicate<EmailConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<emailConfigs.size();i++) { 
    if (predicate.test(emailConfigs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching emailConfigs. No match found.");
    return setNewEmailConfigLike(index, buildEmailConfig(index));
  }
  
  public A addToMsteamsConfigs(int index,MSTeamsConfig item) {
    if (this.msteamsConfigs == null) {this.msteamsConfigs = new ArrayList<MSTeamsConfigBuilder>();}
    MSTeamsConfigBuilder builder = new MSTeamsConfigBuilder(item);
    if (index < 0 || index >= msteamsConfigs.size()) { _visitables.get("msteamsConfigs").add(builder); msteamsConfigs.add(builder); } else { _visitables.get("msteamsConfigs").add(index, builder); msteamsConfigs.add(index, builder);}
    return (A)this;
  }
  
  public A setToMsteamsConfigs(int index,MSTeamsConfig item) {
    if (this.msteamsConfigs == null) {this.msteamsConfigs = new ArrayList<MSTeamsConfigBuilder>();}
    MSTeamsConfigBuilder builder = new MSTeamsConfigBuilder(item);
    if (index < 0 || index >= msteamsConfigs.size()) { _visitables.get("msteamsConfigs").add(builder); msteamsConfigs.add(builder); } else { _visitables.get("msteamsConfigs").set(index, builder); msteamsConfigs.set(index, builder);}
    return (A)this;
  }
  
  public A addToMsteamsConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.MSTeamsConfig... items) {
    if (this.msteamsConfigs == null) {this.msteamsConfigs = new ArrayList<MSTeamsConfigBuilder>();}
    for (MSTeamsConfig item : items) {MSTeamsConfigBuilder builder = new MSTeamsConfigBuilder(item);_visitables.get("msteamsConfigs").add(builder);this.msteamsConfigs.add(builder);} return (A)this;
  }
  
  public A addAllToMsteamsConfigs(Collection<MSTeamsConfig> items) {
    if (this.msteamsConfigs == null) {this.msteamsConfigs = new ArrayList<MSTeamsConfigBuilder>();}
    for (MSTeamsConfig item : items) {MSTeamsConfigBuilder builder = new MSTeamsConfigBuilder(item);_visitables.get("msteamsConfigs").add(builder);this.msteamsConfigs.add(builder);} return (A)this;
  }
  
  public A removeFromMsteamsConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.MSTeamsConfig... items) {
    if (this.msteamsConfigs == null) return (A)this;
    for (MSTeamsConfig item : items) {MSTeamsConfigBuilder builder = new MSTeamsConfigBuilder(item);_visitables.get("msteamsConfigs").remove(builder); this.msteamsConfigs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromMsteamsConfigs(Collection<MSTeamsConfig> items) {
    if (this.msteamsConfigs == null) return (A)this;
    for (MSTeamsConfig item : items) {MSTeamsConfigBuilder builder = new MSTeamsConfigBuilder(item);_visitables.get("msteamsConfigs").remove(builder); this.msteamsConfigs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromMsteamsConfigs(Predicate<MSTeamsConfigBuilder> predicate) {
    if (msteamsConfigs == null) return (A) this;
    final Iterator<MSTeamsConfigBuilder> each = msteamsConfigs.iterator();
    final List visitables = _visitables.get("msteamsConfigs");
    while (each.hasNext()) {
      MSTeamsConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<MSTeamsConfig> buildMsteamsConfigs() {
    return this.msteamsConfigs != null ? build(msteamsConfigs) : null;
  }
  
  public MSTeamsConfig buildMsteamsConfig(int index) {
    return this.msteamsConfigs.get(index).build();
  }
  
  public MSTeamsConfig buildFirstMsteamsConfig() {
    return this.msteamsConfigs.get(0).build();
  }
  
  public MSTeamsConfig buildLastMsteamsConfig() {
    return this.msteamsConfigs.get(msteamsConfigs.size() - 1).build();
  }
  
  public MSTeamsConfig buildMatchingMsteamsConfig(Predicate<MSTeamsConfigBuilder> predicate) {
      for (MSTeamsConfigBuilder item : msteamsConfigs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingMsteamsConfig(Predicate<MSTeamsConfigBuilder> predicate) {
      for (MSTeamsConfigBuilder item : msteamsConfigs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withMsteamsConfigs(List<MSTeamsConfig> msteamsConfigs) {
    if (this.msteamsConfigs != null) {
      this._visitables.get("msteamsConfigs").clear();
    }
    if (msteamsConfigs != null) {
        this.msteamsConfigs = new ArrayList();
        for (MSTeamsConfig item : msteamsConfigs) {
          this.addToMsteamsConfigs(item);
        }
    } else {
      this.msteamsConfigs = null;
    }
    return (A) this;
  }
  
  public A withMsteamsConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.MSTeamsConfig... msteamsConfigs) {
    if (this.msteamsConfigs != null) {
        this.msteamsConfigs.clear();
        _visitables.remove("msteamsConfigs");
    }
    if (msteamsConfigs != null) {
      for (MSTeamsConfig item : msteamsConfigs) {
        this.addToMsteamsConfigs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasMsteamsConfigs() {
    return this.msteamsConfigs != null && !this.msteamsConfigs.isEmpty();
  }
  
  public MsteamsConfigsNested<A> addNewMsteamsConfig() {
    return new MsteamsConfigsNested(-1, null);
  }
  
  public MsteamsConfigsNested<A> addNewMsteamsConfigLike(MSTeamsConfig item) {
    return new MsteamsConfigsNested(-1, item);
  }
  
  public MsteamsConfigsNested<A> setNewMsteamsConfigLike(int index,MSTeamsConfig item) {
    return new MsteamsConfigsNested(index, item);
  }
  
  public MsteamsConfigsNested<A> editMsteamsConfig(int index) {
    if (msteamsConfigs.size() <= index) throw new RuntimeException("Can't edit msteamsConfigs. Index exceeds size.");
    return setNewMsteamsConfigLike(index, buildMsteamsConfig(index));
  }
  
  public MsteamsConfigsNested<A> editFirstMsteamsConfig() {
    if (msteamsConfigs.size() == 0) throw new RuntimeException("Can't edit first msteamsConfigs. The list is empty.");
    return setNewMsteamsConfigLike(0, buildMsteamsConfig(0));
  }
  
  public MsteamsConfigsNested<A> editLastMsteamsConfig() {
    int index = msteamsConfigs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last msteamsConfigs. The list is empty.");
    return setNewMsteamsConfigLike(index, buildMsteamsConfig(index));
  }
  
  public MsteamsConfigsNested<A> editMatchingMsteamsConfig(Predicate<MSTeamsConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<msteamsConfigs.size();i++) { 
    if (predicate.test(msteamsConfigs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching msteamsConfigs. No match found.");
    return setNewMsteamsConfigLike(index, buildMsteamsConfig(index));
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public A addToOpsgenieConfigs(int index,OpsGenieConfig item) {
    if (this.opsgenieConfigs == null) {this.opsgenieConfigs = new ArrayList<OpsGenieConfigBuilder>();}
    OpsGenieConfigBuilder builder = new OpsGenieConfigBuilder(item);
    if (index < 0 || index >= opsgenieConfigs.size()) { _visitables.get("opsgenieConfigs").add(builder); opsgenieConfigs.add(builder); } else { _visitables.get("opsgenieConfigs").add(index, builder); opsgenieConfigs.add(index, builder);}
    return (A)this;
  }
  
  public A setToOpsgenieConfigs(int index,OpsGenieConfig item) {
    if (this.opsgenieConfigs == null) {this.opsgenieConfigs = new ArrayList<OpsGenieConfigBuilder>();}
    OpsGenieConfigBuilder builder = new OpsGenieConfigBuilder(item);
    if (index < 0 || index >= opsgenieConfigs.size()) { _visitables.get("opsgenieConfigs").add(builder); opsgenieConfigs.add(builder); } else { _visitables.get("opsgenieConfigs").set(index, builder); opsgenieConfigs.set(index, builder);}
    return (A)this;
  }
  
  public A addToOpsgenieConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfig... items) {
    if (this.opsgenieConfigs == null) {this.opsgenieConfigs = new ArrayList<OpsGenieConfigBuilder>();}
    for (OpsGenieConfig item : items) {OpsGenieConfigBuilder builder = new OpsGenieConfigBuilder(item);_visitables.get("opsgenieConfigs").add(builder);this.opsgenieConfigs.add(builder);} return (A)this;
  }
  
  public A addAllToOpsgenieConfigs(Collection<OpsGenieConfig> items) {
    if (this.opsgenieConfigs == null) {this.opsgenieConfigs = new ArrayList<OpsGenieConfigBuilder>();}
    for (OpsGenieConfig item : items) {OpsGenieConfigBuilder builder = new OpsGenieConfigBuilder(item);_visitables.get("opsgenieConfigs").add(builder);this.opsgenieConfigs.add(builder);} return (A)this;
  }
  
  public A removeFromOpsgenieConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfig... items) {
    if (this.opsgenieConfigs == null) return (A)this;
    for (OpsGenieConfig item : items) {OpsGenieConfigBuilder builder = new OpsGenieConfigBuilder(item);_visitables.get("opsgenieConfigs").remove(builder); this.opsgenieConfigs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromOpsgenieConfigs(Collection<OpsGenieConfig> items) {
    if (this.opsgenieConfigs == null) return (A)this;
    for (OpsGenieConfig item : items) {OpsGenieConfigBuilder builder = new OpsGenieConfigBuilder(item);_visitables.get("opsgenieConfigs").remove(builder); this.opsgenieConfigs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromOpsgenieConfigs(Predicate<OpsGenieConfigBuilder> predicate) {
    if (opsgenieConfigs == null) return (A) this;
    final Iterator<OpsGenieConfigBuilder> each = opsgenieConfigs.iterator();
    final List visitables = _visitables.get("opsgenieConfigs");
    while (each.hasNext()) {
      OpsGenieConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<OpsGenieConfig> buildOpsgenieConfigs() {
    return this.opsgenieConfigs != null ? build(opsgenieConfigs) : null;
  }
  
  public OpsGenieConfig buildOpsgenieConfig(int index) {
    return this.opsgenieConfigs.get(index).build();
  }
  
  public OpsGenieConfig buildFirstOpsgenieConfig() {
    return this.opsgenieConfigs.get(0).build();
  }
  
  public OpsGenieConfig buildLastOpsgenieConfig() {
    return this.opsgenieConfigs.get(opsgenieConfigs.size() - 1).build();
  }
  
  public OpsGenieConfig buildMatchingOpsgenieConfig(Predicate<OpsGenieConfigBuilder> predicate) {
      for (OpsGenieConfigBuilder item : opsgenieConfigs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingOpsgenieConfig(Predicate<OpsGenieConfigBuilder> predicate) {
      for (OpsGenieConfigBuilder item : opsgenieConfigs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withOpsgenieConfigs(List<OpsGenieConfig> opsgenieConfigs) {
    if (this.opsgenieConfigs != null) {
      this._visitables.get("opsgenieConfigs").clear();
    }
    if (opsgenieConfigs != null) {
        this.opsgenieConfigs = new ArrayList();
        for (OpsGenieConfig item : opsgenieConfigs) {
          this.addToOpsgenieConfigs(item);
        }
    } else {
      this.opsgenieConfigs = null;
    }
    return (A) this;
  }
  
  public A withOpsgenieConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfig... opsgenieConfigs) {
    if (this.opsgenieConfigs != null) {
        this.opsgenieConfigs.clear();
        _visitables.remove("opsgenieConfigs");
    }
    if (opsgenieConfigs != null) {
      for (OpsGenieConfig item : opsgenieConfigs) {
        this.addToOpsgenieConfigs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasOpsgenieConfigs() {
    return this.opsgenieConfigs != null && !this.opsgenieConfigs.isEmpty();
  }
  
  public OpsgenieConfigsNested<A> addNewOpsgenieConfig() {
    return new OpsgenieConfigsNested(-1, null);
  }
  
  public OpsgenieConfigsNested<A> addNewOpsgenieConfigLike(OpsGenieConfig item) {
    return new OpsgenieConfigsNested(-1, item);
  }
  
  public OpsgenieConfigsNested<A> setNewOpsgenieConfigLike(int index,OpsGenieConfig item) {
    return new OpsgenieConfigsNested(index, item);
  }
  
  public OpsgenieConfigsNested<A> editOpsgenieConfig(int index) {
    if (opsgenieConfigs.size() <= index) throw new RuntimeException("Can't edit opsgenieConfigs. Index exceeds size.");
    return setNewOpsgenieConfigLike(index, buildOpsgenieConfig(index));
  }
  
  public OpsgenieConfigsNested<A> editFirstOpsgenieConfig() {
    if (opsgenieConfigs.size() == 0) throw new RuntimeException("Can't edit first opsgenieConfigs. The list is empty.");
    return setNewOpsgenieConfigLike(0, buildOpsgenieConfig(0));
  }
  
  public OpsgenieConfigsNested<A> editLastOpsgenieConfig() {
    int index = opsgenieConfigs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last opsgenieConfigs. The list is empty.");
    return setNewOpsgenieConfigLike(index, buildOpsgenieConfig(index));
  }
  
  public OpsgenieConfigsNested<A> editMatchingOpsgenieConfig(Predicate<OpsGenieConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<opsgenieConfigs.size();i++) { 
    if (predicate.test(opsgenieConfigs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching opsgenieConfigs. No match found.");
    return setNewOpsgenieConfigLike(index, buildOpsgenieConfig(index));
  }
  
  public A addToPagerdutyConfigs(int index,PagerDutyConfig item) {
    if (this.pagerdutyConfigs == null) {this.pagerdutyConfigs = new ArrayList<PagerDutyConfigBuilder>();}
    PagerDutyConfigBuilder builder = new PagerDutyConfigBuilder(item);
    if (index < 0 || index >= pagerdutyConfigs.size()) { _visitables.get("pagerdutyConfigs").add(builder); pagerdutyConfigs.add(builder); } else { _visitables.get("pagerdutyConfigs").add(index, builder); pagerdutyConfigs.add(index, builder);}
    return (A)this;
  }
  
  public A setToPagerdutyConfigs(int index,PagerDutyConfig item) {
    if (this.pagerdutyConfigs == null) {this.pagerdutyConfigs = new ArrayList<PagerDutyConfigBuilder>();}
    PagerDutyConfigBuilder builder = new PagerDutyConfigBuilder(item);
    if (index < 0 || index >= pagerdutyConfigs.size()) { _visitables.get("pagerdutyConfigs").add(builder); pagerdutyConfigs.add(builder); } else { _visitables.get("pagerdutyConfigs").set(index, builder); pagerdutyConfigs.set(index, builder);}
    return (A)this;
  }
  
  public A addToPagerdutyConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.PagerDutyConfig... items) {
    if (this.pagerdutyConfigs == null) {this.pagerdutyConfigs = new ArrayList<PagerDutyConfigBuilder>();}
    for (PagerDutyConfig item : items) {PagerDutyConfigBuilder builder = new PagerDutyConfigBuilder(item);_visitables.get("pagerdutyConfigs").add(builder);this.pagerdutyConfigs.add(builder);} return (A)this;
  }
  
  public A addAllToPagerdutyConfigs(Collection<PagerDutyConfig> items) {
    if (this.pagerdutyConfigs == null) {this.pagerdutyConfigs = new ArrayList<PagerDutyConfigBuilder>();}
    for (PagerDutyConfig item : items) {PagerDutyConfigBuilder builder = new PagerDutyConfigBuilder(item);_visitables.get("pagerdutyConfigs").add(builder);this.pagerdutyConfigs.add(builder);} return (A)this;
  }
  
  public A removeFromPagerdutyConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.PagerDutyConfig... items) {
    if (this.pagerdutyConfigs == null) return (A)this;
    for (PagerDutyConfig item : items) {PagerDutyConfigBuilder builder = new PagerDutyConfigBuilder(item);_visitables.get("pagerdutyConfigs").remove(builder); this.pagerdutyConfigs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromPagerdutyConfigs(Collection<PagerDutyConfig> items) {
    if (this.pagerdutyConfigs == null) return (A)this;
    for (PagerDutyConfig item : items) {PagerDutyConfigBuilder builder = new PagerDutyConfigBuilder(item);_visitables.get("pagerdutyConfigs").remove(builder); this.pagerdutyConfigs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromPagerdutyConfigs(Predicate<PagerDutyConfigBuilder> predicate) {
    if (pagerdutyConfigs == null) return (A) this;
    final Iterator<PagerDutyConfigBuilder> each = pagerdutyConfigs.iterator();
    final List visitables = _visitables.get("pagerdutyConfigs");
    while (each.hasNext()) {
      PagerDutyConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<PagerDutyConfig> buildPagerdutyConfigs() {
    return this.pagerdutyConfigs != null ? build(pagerdutyConfigs) : null;
  }
  
  public PagerDutyConfig buildPagerdutyConfig(int index) {
    return this.pagerdutyConfigs.get(index).build();
  }
  
  public PagerDutyConfig buildFirstPagerdutyConfig() {
    return this.pagerdutyConfigs.get(0).build();
  }
  
  public PagerDutyConfig buildLastPagerdutyConfig() {
    return this.pagerdutyConfigs.get(pagerdutyConfigs.size() - 1).build();
  }
  
  public PagerDutyConfig buildMatchingPagerdutyConfig(Predicate<PagerDutyConfigBuilder> predicate) {
      for (PagerDutyConfigBuilder item : pagerdutyConfigs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingPagerdutyConfig(Predicate<PagerDutyConfigBuilder> predicate) {
      for (PagerDutyConfigBuilder item : pagerdutyConfigs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withPagerdutyConfigs(List<PagerDutyConfig> pagerdutyConfigs) {
    if (this.pagerdutyConfigs != null) {
      this._visitables.get("pagerdutyConfigs").clear();
    }
    if (pagerdutyConfigs != null) {
        this.pagerdutyConfigs = new ArrayList();
        for (PagerDutyConfig item : pagerdutyConfigs) {
          this.addToPagerdutyConfigs(item);
        }
    } else {
      this.pagerdutyConfigs = null;
    }
    return (A) this;
  }
  
  public A withPagerdutyConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.PagerDutyConfig... pagerdutyConfigs) {
    if (this.pagerdutyConfigs != null) {
        this.pagerdutyConfigs.clear();
        _visitables.remove("pagerdutyConfigs");
    }
    if (pagerdutyConfigs != null) {
      for (PagerDutyConfig item : pagerdutyConfigs) {
        this.addToPagerdutyConfigs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasPagerdutyConfigs() {
    return this.pagerdutyConfigs != null && !this.pagerdutyConfigs.isEmpty();
  }
  
  public PagerdutyConfigsNested<A> addNewPagerdutyConfig() {
    return new PagerdutyConfigsNested(-1, null);
  }
  
  public PagerdutyConfigsNested<A> addNewPagerdutyConfigLike(PagerDutyConfig item) {
    return new PagerdutyConfigsNested(-1, item);
  }
  
  public PagerdutyConfigsNested<A> setNewPagerdutyConfigLike(int index,PagerDutyConfig item) {
    return new PagerdutyConfigsNested(index, item);
  }
  
  public PagerdutyConfigsNested<A> editPagerdutyConfig(int index) {
    if (pagerdutyConfigs.size() <= index) throw new RuntimeException("Can't edit pagerdutyConfigs. Index exceeds size.");
    return setNewPagerdutyConfigLike(index, buildPagerdutyConfig(index));
  }
  
  public PagerdutyConfigsNested<A> editFirstPagerdutyConfig() {
    if (pagerdutyConfigs.size() == 0) throw new RuntimeException("Can't edit first pagerdutyConfigs. The list is empty.");
    return setNewPagerdutyConfigLike(0, buildPagerdutyConfig(0));
  }
  
  public PagerdutyConfigsNested<A> editLastPagerdutyConfig() {
    int index = pagerdutyConfigs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last pagerdutyConfigs. The list is empty.");
    return setNewPagerdutyConfigLike(index, buildPagerdutyConfig(index));
  }
  
  public PagerdutyConfigsNested<A> editMatchingPagerdutyConfig(Predicate<PagerDutyConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<pagerdutyConfigs.size();i++) { 
    if (predicate.test(pagerdutyConfigs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching pagerdutyConfigs. No match found.");
    return setNewPagerdutyConfigLike(index, buildPagerdutyConfig(index));
  }
  
  public A addToPushoverConfigs(int index,PushoverConfig item) {
    if (this.pushoverConfigs == null) {this.pushoverConfigs = new ArrayList<PushoverConfigBuilder>();}
    PushoverConfigBuilder builder = new PushoverConfigBuilder(item);
    if (index < 0 || index >= pushoverConfigs.size()) { _visitables.get("pushoverConfigs").add(builder); pushoverConfigs.add(builder); } else { _visitables.get("pushoverConfigs").add(index, builder); pushoverConfigs.add(index, builder);}
    return (A)this;
  }
  
  public A setToPushoverConfigs(int index,PushoverConfig item) {
    if (this.pushoverConfigs == null) {this.pushoverConfigs = new ArrayList<PushoverConfigBuilder>();}
    PushoverConfigBuilder builder = new PushoverConfigBuilder(item);
    if (index < 0 || index >= pushoverConfigs.size()) { _visitables.get("pushoverConfigs").add(builder); pushoverConfigs.add(builder); } else { _visitables.get("pushoverConfigs").set(index, builder); pushoverConfigs.set(index, builder);}
    return (A)this;
  }
  
  public A addToPushoverConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.PushoverConfig... items) {
    if (this.pushoverConfigs == null) {this.pushoverConfigs = new ArrayList<PushoverConfigBuilder>();}
    for (PushoverConfig item : items) {PushoverConfigBuilder builder = new PushoverConfigBuilder(item);_visitables.get("pushoverConfigs").add(builder);this.pushoverConfigs.add(builder);} return (A)this;
  }
  
  public A addAllToPushoverConfigs(Collection<PushoverConfig> items) {
    if (this.pushoverConfigs == null) {this.pushoverConfigs = new ArrayList<PushoverConfigBuilder>();}
    for (PushoverConfig item : items) {PushoverConfigBuilder builder = new PushoverConfigBuilder(item);_visitables.get("pushoverConfigs").add(builder);this.pushoverConfigs.add(builder);} return (A)this;
  }
  
  public A removeFromPushoverConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.PushoverConfig... items) {
    if (this.pushoverConfigs == null) return (A)this;
    for (PushoverConfig item : items) {PushoverConfigBuilder builder = new PushoverConfigBuilder(item);_visitables.get("pushoverConfigs").remove(builder); this.pushoverConfigs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromPushoverConfigs(Collection<PushoverConfig> items) {
    if (this.pushoverConfigs == null) return (A)this;
    for (PushoverConfig item : items) {PushoverConfigBuilder builder = new PushoverConfigBuilder(item);_visitables.get("pushoverConfigs").remove(builder); this.pushoverConfigs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromPushoverConfigs(Predicate<PushoverConfigBuilder> predicate) {
    if (pushoverConfigs == null) return (A) this;
    final Iterator<PushoverConfigBuilder> each = pushoverConfigs.iterator();
    final List visitables = _visitables.get("pushoverConfigs");
    while (each.hasNext()) {
      PushoverConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<PushoverConfig> buildPushoverConfigs() {
    return this.pushoverConfigs != null ? build(pushoverConfigs) : null;
  }
  
  public PushoverConfig buildPushoverConfig(int index) {
    return this.pushoverConfigs.get(index).build();
  }
  
  public PushoverConfig buildFirstPushoverConfig() {
    return this.pushoverConfigs.get(0).build();
  }
  
  public PushoverConfig buildLastPushoverConfig() {
    return this.pushoverConfigs.get(pushoverConfigs.size() - 1).build();
  }
  
  public PushoverConfig buildMatchingPushoverConfig(Predicate<PushoverConfigBuilder> predicate) {
      for (PushoverConfigBuilder item : pushoverConfigs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingPushoverConfig(Predicate<PushoverConfigBuilder> predicate) {
      for (PushoverConfigBuilder item : pushoverConfigs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withPushoverConfigs(List<PushoverConfig> pushoverConfigs) {
    if (this.pushoverConfigs != null) {
      this._visitables.get("pushoverConfigs").clear();
    }
    if (pushoverConfigs != null) {
        this.pushoverConfigs = new ArrayList();
        for (PushoverConfig item : pushoverConfigs) {
          this.addToPushoverConfigs(item);
        }
    } else {
      this.pushoverConfigs = null;
    }
    return (A) this;
  }
  
  public A withPushoverConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.PushoverConfig... pushoverConfigs) {
    if (this.pushoverConfigs != null) {
        this.pushoverConfigs.clear();
        _visitables.remove("pushoverConfigs");
    }
    if (pushoverConfigs != null) {
      for (PushoverConfig item : pushoverConfigs) {
        this.addToPushoverConfigs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasPushoverConfigs() {
    return this.pushoverConfigs != null && !this.pushoverConfigs.isEmpty();
  }
  
  public PushoverConfigsNested<A> addNewPushoverConfig() {
    return new PushoverConfigsNested(-1, null);
  }
  
  public PushoverConfigsNested<A> addNewPushoverConfigLike(PushoverConfig item) {
    return new PushoverConfigsNested(-1, item);
  }
  
  public PushoverConfigsNested<A> setNewPushoverConfigLike(int index,PushoverConfig item) {
    return new PushoverConfigsNested(index, item);
  }
  
  public PushoverConfigsNested<A> editPushoverConfig(int index) {
    if (pushoverConfigs.size() <= index) throw new RuntimeException("Can't edit pushoverConfigs. Index exceeds size.");
    return setNewPushoverConfigLike(index, buildPushoverConfig(index));
  }
  
  public PushoverConfigsNested<A> editFirstPushoverConfig() {
    if (pushoverConfigs.size() == 0) throw new RuntimeException("Can't edit first pushoverConfigs. The list is empty.");
    return setNewPushoverConfigLike(0, buildPushoverConfig(0));
  }
  
  public PushoverConfigsNested<A> editLastPushoverConfig() {
    int index = pushoverConfigs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last pushoverConfigs. The list is empty.");
    return setNewPushoverConfigLike(index, buildPushoverConfig(index));
  }
  
  public PushoverConfigsNested<A> editMatchingPushoverConfig(Predicate<PushoverConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<pushoverConfigs.size();i++) { 
    if (predicate.test(pushoverConfigs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching pushoverConfigs. No match found.");
    return setNewPushoverConfigLike(index, buildPushoverConfig(index));
  }
  
  public A addToSlackConfigs(int index,SlackConfig item) {
    if (this.slackConfigs == null) {this.slackConfigs = new ArrayList<SlackConfigBuilder>();}
    SlackConfigBuilder builder = new SlackConfigBuilder(item);
    if (index < 0 || index >= slackConfigs.size()) { _visitables.get("slackConfigs").add(builder); slackConfigs.add(builder); } else { _visitables.get("slackConfigs").add(index, builder); slackConfigs.add(index, builder);}
    return (A)this;
  }
  
  public A setToSlackConfigs(int index,SlackConfig item) {
    if (this.slackConfigs == null) {this.slackConfigs = new ArrayList<SlackConfigBuilder>();}
    SlackConfigBuilder builder = new SlackConfigBuilder(item);
    if (index < 0 || index >= slackConfigs.size()) { _visitables.get("slackConfigs").add(builder); slackConfigs.add(builder); } else { _visitables.get("slackConfigs").set(index, builder); slackConfigs.set(index, builder);}
    return (A)this;
  }
  
  public A addToSlackConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.SlackConfig... items) {
    if (this.slackConfigs == null) {this.slackConfigs = new ArrayList<SlackConfigBuilder>();}
    for (SlackConfig item : items) {SlackConfigBuilder builder = new SlackConfigBuilder(item);_visitables.get("slackConfigs").add(builder);this.slackConfigs.add(builder);} return (A)this;
  }
  
  public A addAllToSlackConfigs(Collection<SlackConfig> items) {
    if (this.slackConfigs == null) {this.slackConfigs = new ArrayList<SlackConfigBuilder>();}
    for (SlackConfig item : items) {SlackConfigBuilder builder = new SlackConfigBuilder(item);_visitables.get("slackConfigs").add(builder);this.slackConfigs.add(builder);} return (A)this;
  }
  
  public A removeFromSlackConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.SlackConfig... items) {
    if (this.slackConfigs == null) return (A)this;
    for (SlackConfig item : items) {SlackConfigBuilder builder = new SlackConfigBuilder(item);_visitables.get("slackConfigs").remove(builder); this.slackConfigs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromSlackConfigs(Collection<SlackConfig> items) {
    if (this.slackConfigs == null) return (A)this;
    for (SlackConfig item : items) {SlackConfigBuilder builder = new SlackConfigBuilder(item);_visitables.get("slackConfigs").remove(builder); this.slackConfigs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromSlackConfigs(Predicate<SlackConfigBuilder> predicate) {
    if (slackConfigs == null) return (A) this;
    final Iterator<SlackConfigBuilder> each = slackConfigs.iterator();
    final List visitables = _visitables.get("slackConfigs");
    while (each.hasNext()) {
      SlackConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<SlackConfig> buildSlackConfigs() {
    return this.slackConfigs != null ? build(slackConfigs) : null;
  }
  
  public SlackConfig buildSlackConfig(int index) {
    return this.slackConfigs.get(index).build();
  }
  
  public SlackConfig buildFirstSlackConfig() {
    return this.slackConfigs.get(0).build();
  }
  
  public SlackConfig buildLastSlackConfig() {
    return this.slackConfigs.get(slackConfigs.size() - 1).build();
  }
  
  public SlackConfig buildMatchingSlackConfig(Predicate<SlackConfigBuilder> predicate) {
      for (SlackConfigBuilder item : slackConfigs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingSlackConfig(Predicate<SlackConfigBuilder> predicate) {
      for (SlackConfigBuilder item : slackConfigs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withSlackConfigs(List<SlackConfig> slackConfigs) {
    if (this.slackConfigs != null) {
      this._visitables.get("slackConfigs").clear();
    }
    if (slackConfigs != null) {
        this.slackConfigs = new ArrayList();
        for (SlackConfig item : slackConfigs) {
          this.addToSlackConfigs(item);
        }
    } else {
      this.slackConfigs = null;
    }
    return (A) this;
  }
  
  public A withSlackConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.SlackConfig... slackConfigs) {
    if (this.slackConfigs != null) {
        this.slackConfigs.clear();
        _visitables.remove("slackConfigs");
    }
    if (slackConfigs != null) {
      for (SlackConfig item : slackConfigs) {
        this.addToSlackConfigs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasSlackConfigs() {
    return this.slackConfigs != null && !this.slackConfigs.isEmpty();
  }
  
  public SlackConfigsNested<A> addNewSlackConfig() {
    return new SlackConfigsNested(-1, null);
  }
  
  public SlackConfigsNested<A> addNewSlackConfigLike(SlackConfig item) {
    return new SlackConfigsNested(-1, item);
  }
  
  public SlackConfigsNested<A> setNewSlackConfigLike(int index,SlackConfig item) {
    return new SlackConfigsNested(index, item);
  }
  
  public SlackConfigsNested<A> editSlackConfig(int index) {
    if (slackConfigs.size() <= index) throw new RuntimeException("Can't edit slackConfigs. Index exceeds size.");
    return setNewSlackConfigLike(index, buildSlackConfig(index));
  }
  
  public SlackConfigsNested<A> editFirstSlackConfig() {
    if (slackConfigs.size() == 0) throw new RuntimeException("Can't edit first slackConfigs. The list is empty.");
    return setNewSlackConfigLike(0, buildSlackConfig(0));
  }
  
  public SlackConfigsNested<A> editLastSlackConfig() {
    int index = slackConfigs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last slackConfigs. The list is empty.");
    return setNewSlackConfigLike(index, buildSlackConfig(index));
  }
  
  public SlackConfigsNested<A> editMatchingSlackConfig(Predicate<SlackConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<slackConfigs.size();i++) { 
    if (predicate.test(slackConfigs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching slackConfigs. No match found.");
    return setNewSlackConfigLike(index, buildSlackConfig(index));
  }
  
  public A addToSnsConfigs(int index,SNSConfig item) {
    if (this.snsConfigs == null) {this.snsConfigs = new ArrayList<SNSConfigBuilder>();}
    SNSConfigBuilder builder = new SNSConfigBuilder(item);
    if (index < 0 || index >= snsConfigs.size()) { _visitables.get("snsConfigs").add(builder); snsConfigs.add(builder); } else { _visitables.get("snsConfigs").add(index, builder); snsConfigs.add(index, builder);}
    return (A)this;
  }
  
  public A setToSnsConfigs(int index,SNSConfig item) {
    if (this.snsConfigs == null) {this.snsConfigs = new ArrayList<SNSConfigBuilder>();}
    SNSConfigBuilder builder = new SNSConfigBuilder(item);
    if (index < 0 || index >= snsConfigs.size()) { _visitables.get("snsConfigs").add(builder); snsConfigs.add(builder); } else { _visitables.get("snsConfigs").set(index, builder); snsConfigs.set(index, builder);}
    return (A)this;
  }
  
  public A addToSnsConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.SNSConfig... items) {
    if (this.snsConfigs == null) {this.snsConfigs = new ArrayList<SNSConfigBuilder>();}
    for (SNSConfig item : items) {SNSConfigBuilder builder = new SNSConfigBuilder(item);_visitables.get("snsConfigs").add(builder);this.snsConfigs.add(builder);} return (A)this;
  }
  
  public A addAllToSnsConfigs(Collection<SNSConfig> items) {
    if (this.snsConfigs == null) {this.snsConfigs = new ArrayList<SNSConfigBuilder>();}
    for (SNSConfig item : items) {SNSConfigBuilder builder = new SNSConfigBuilder(item);_visitables.get("snsConfigs").add(builder);this.snsConfigs.add(builder);} return (A)this;
  }
  
  public A removeFromSnsConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.SNSConfig... items) {
    if (this.snsConfigs == null) return (A)this;
    for (SNSConfig item : items) {SNSConfigBuilder builder = new SNSConfigBuilder(item);_visitables.get("snsConfigs").remove(builder); this.snsConfigs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromSnsConfigs(Collection<SNSConfig> items) {
    if (this.snsConfigs == null) return (A)this;
    for (SNSConfig item : items) {SNSConfigBuilder builder = new SNSConfigBuilder(item);_visitables.get("snsConfigs").remove(builder); this.snsConfigs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromSnsConfigs(Predicate<SNSConfigBuilder> predicate) {
    if (snsConfigs == null) return (A) this;
    final Iterator<SNSConfigBuilder> each = snsConfigs.iterator();
    final List visitables = _visitables.get("snsConfigs");
    while (each.hasNext()) {
      SNSConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<SNSConfig> buildSnsConfigs() {
    return this.snsConfigs != null ? build(snsConfigs) : null;
  }
  
  public SNSConfig buildSnsConfig(int index) {
    return this.snsConfigs.get(index).build();
  }
  
  public SNSConfig buildFirstSnsConfig() {
    return this.snsConfigs.get(0).build();
  }
  
  public SNSConfig buildLastSnsConfig() {
    return this.snsConfigs.get(snsConfigs.size() - 1).build();
  }
  
  public SNSConfig buildMatchingSnsConfig(Predicate<SNSConfigBuilder> predicate) {
      for (SNSConfigBuilder item : snsConfigs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingSnsConfig(Predicate<SNSConfigBuilder> predicate) {
      for (SNSConfigBuilder item : snsConfigs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withSnsConfigs(List<SNSConfig> snsConfigs) {
    if (this.snsConfigs != null) {
      this._visitables.get("snsConfigs").clear();
    }
    if (snsConfigs != null) {
        this.snsConfigs = new ArrayList();
        for (SNSConfig item : snsConfigs) {
          this.addToSnsConfigs(item);
        }
    } else {
      this.snsConfigs = null;
    }
    return (A) this;
  }
  
  public A withSnsConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.SNSConfig... snsConfigs) {
    if (this.snsConfigs != null) {
        this.snsConfigs.clear();
        _visitables.remove("snsConfigs");
    }
    if (snsConfigs != null) {
      for (SNSConfig item : snsConfigs) {
        this.addToSnsConfigs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasSnsConfigs() {
    return this.snsConfigs != null && !this.snsConfigs.isEmpty();
  }
  
  public SnsConfigsNested<A> addNewSnsConfig() {
    return new SnsConfigsNested(-1, null);
  }
  
  public SnsConfigsNested<A> addNewSnsConfigLike(SNSConfig item) {
    return new SnsConfigsNested(-1, item);
  }
  
  public SnsConfigsNested<A> setNewSnsConfigLike(int index,SNSConfig item) {
    return new SnsConfigsNested(index, item);
  }
  
  public SnsConfigsNested<A> editSnsConfig(int index) {
    if (snsConfigs.size() <= index) throw new RuntimeException("Can't edit snsConfigs. Index exceeds size.");
    return setNewSnsConfigLike(index, buildSnsConfig(index));
  }
  
  public SnsConfigsNested<A> editFirstSnsConfig() {
    if (snsConfigs.size() == 0) throw new RuntimeException("Can't edit first snsConfigs. The list is empty.");
    return setNewSnsConfigLike(0, buildSnsConfig(0));
  }
  
  public SnsConfigsNested<A> editLastSnsConfig() {
    int index = snsConfigs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last snsConfigs. The list is empty.");
    return setNewSnsConfigLike(index, buildSnsConfig(index));
  }
  
  public SnsConfigsNested<A> editMatchingSnsConfig(Predicate<SNSConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<snsConfigs.size();i++) { 
    if (predicate.test(snsConfigs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching snsConfigs. No match found.");
    return setNewSnsConfigLike(index, buildSnsConfig(index));
  }
  
  public A addToTelegramConfigs(int index,TelegramConfig item) {
    if (this.telegramConfigs == null) {this.telegramConfigs = new ArrayList<TelegramConfigBuilder>();}
    TelegramConfigBuilder builder = new TelegramConfigBuilder(item);
    if (index < 0 || index >= telegramConfigs.size()) { _visitables.get("telegramConfigs").add(builder); telegramConfigs.add(builder); } else { _visitables.get("telegramConfigs").add(index, builder); telegramConfigs.add(index, builder);}
    return (A)this;
  }
  
  public A setToTelegramConfigs(int index,TelegramConfig item) {
    if (this.telegramConfigs == null) {this.telegramConfigs = new ArrayList<TelegramConfigBuilder>();}
    TelegramConfigBuilder builder = new TelegramConfigBuilder(item);
    if (index < 0 || index >= telegramConfigs.size()) { _visitables.get("telegramConfigs").add(builder); telegramConfigs.add(builder); } else { _visitables.get("telegramConfigs").set(index, builder); telegramConfigs.set(index, builder);}
    return (A)this;
  }
  
  public A addToTelegramConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.TelegramConfig... items) {
    if (this.telegramConfigs == null) {this.telegramConfigs = new ArrayList<TelegramConfigBuilder>();}
    for (TelegramConfig item : items) {TelegramConfigBuilder builder = new TelegramConfigBuilder(item);_visitables.get("telegramConfigs").add(builder);this.telegramConfigs.add(builder);} return (A)this;
  }
  
  public A addAllToTelegramConfigs(Collection<TelegramConfig> items) {
    if (this.telegramConfigs == null) {this.telegramConfigs = new ArrayList<TelegramConfigBuilder>();}
    for (TelegramConfig item : items) {TelegramConfigBuilder builder = new TelegramConfigBuilder(item);_visitables.get("telegramConfigs").add(builder);this.telegramConfigs.add(builder);} return (A)this;
  }
  
  public A removeFromTelegramConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.TelegramConfig... items) {
    if (this.telegramConfigs == null) return (A)this;
    for (TelegramConfig item : items) {TelegramConfigBuilder builder = new TelegramConfigBuilder(item);_visitables.get("telegramConfigs").remove(builder); this.telegramConfigs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromTelegramConfigs(Collection<TelegramConfig> items) {
    if (this.telegramConfigs == null) return (A)this;
    for (TelegramConfig item : items) {TelegramConfigBuilder builder = new TelegramConfigBuilder(item);_visitables.get("telegramConfigs").remove(builder); this.telegramConfigs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromTelegramConfigs(Predicate<TelegramConfigBuilder> predicate) {
    if (telegramConfigs == null) return (A) this;
    final Iterator<TelegramConfigBuilder> each = telegramConfigs.iterator();
    final List visitables = _visitables.get("telegramConfigs");
    while (each.hasNext()) {
      TelegramConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<TelegramConfig> buildTelegramConfigs() {
    return this.telegramConfigs != null ? build(telegramConfigs) : null;
  }
  
  public TelegramConfig buildTelegramConfig(int index) {
    return this.telegramConfigs.get(index).build();
  }
  
  public TelegramConfig buildFirstTelegramConfig() {
    return this.telegramConfigs.get(0).build();
  }
  
  public TelegramConfig buildLastTelegramConfig() {
    return this.telegramConfigs.get(telegramConfigs.size() - 1).build();
  }
  
  public TelegramConfig buildMatchingTelegramConfig(Predicate<TelegramConfigBuilder> predicate) {
      for (TelegramConfigBuilder item : telegramConfigs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingTelegramConfig(Predicate<TelegramConfigBuilder> predicate) {
      for (TelegramConfigBuilder item : telegramConfigs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withTelegramConfigs(List<TelegramConfig> telegramConfigs) {
    if (this.telegramConfigs != null) {
      this._visitables.get("telegramConfigs").clear();
    }
    if (telegramConfigs != null) {
        this.telegramConfigs = new ArrayList();
        for (TelegramConfig item : telegramConfigs) {
          this.addToTelegramConfigs(item);
        }
    } else {
      this.telegramConfigs = null;
    }
    return (A) this;
  }
  
  public A withTelegramConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.TelegramConfig... telegramConfigs) {
    if (this.telegramConfigs != null) {
        this.telegramConfigs.clear();
        _visitables.remove("telegramConfigs");
    }
    if (telegramConfigs != null) {
      for (TelegramConfig item : telegramConfigs) {
        this.addToTelegramConfigs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasTelegramConfigs() {
    return this.telegramConfigs != null && !this.telegramConfigs.isEmpty();
  }
  
  public TelegramConfigsNested<A> addNewTelegramConfig() {
    return new TelegramConfigsNested(-1, null);
  }
  
  public TelegramConfigsNested<A> addNewTelegramConfigLike(TelegramConfig item) {
    return new TelegramConfigsNested(-1, item);
  }
  
  public TelegramConfigsNested<A> setNewTelegramConfigLike(int index,TelegramConfig item) {
    return new TelegramConfigsNested(index, item);
  }
  
  public TelegramConfigsNested<A> editTelegramConfig(int index) {
    if (telegramConfigs.size() <= index) throw new RuntimeException("Can't edit telegramConfigs. Index exceeds size.");
    return setNewTelegramConfigLike(index, buildTelegramConfig(index));
  }
  
  public TelegramConfigsNested<A> editFirstTelegramConfig() {
    if (telegramConfigs.size() == 0) throw new RuntimeException("Can't edit first telegramConfigs. The list is empty.");
    return setNewTelegramConfigLike(0, buildTelegramConfig(0));
  }
  
  public TelegramConfigsNested<A> editLastTelegramConfig() {
    int index = telegramConfigs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last telegramConfigs. The list is empty.");
    return setNewTelegramConfigLike(index, buildTelegramConfig(index));
  }
  
  public TelegramConfigsNested<A> editMatchingTelegramConfig(Predicate<TelegramConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<telegramConfigs.size();i++) { 
    if (predicate.test(telegramConfigs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching telegramConfigs. No match found.");
    return setNewTelegramConfigLike(index, buildTelegramConfig(index));
  }
  
  public A addToVictoropsConfigs(int index,VictorOpsConfig item) {
    if (this.victoropsConfigs == null) {this.victoropsConfigs = new ArrayList<VictorOpsConfigBuilder>();}
    VictorOpsConfigBuilder builder = new VictorOpsConfigBuilder(item);
    if (index < 0 || index >= victoropsConfigs.size()) { _visitables.get("victoropsConfigs").add(builder); victoropsConfigs.add(builder); } else { _visitables.get("victoropsConfigs").add(index, builder); victoropsConfigs.add(index, builder);}
    return (A)this;
  }
  
  public A setToVictoropsConfigs(int index,VictorOpsConfig item) {
    if (this.victoropsConfigs == null) {this.victoropsConfigs = new ArrayList<VictorOpsConfigBuilder>();}
    VictorOpsConfigBuilder builder = new VictorOpsConfigBuilder(item);
    if (index < 0 || index >= victoropsConfigs.size()) { _visitables.get("victoropsConfigs").add(builder); victoropsConfigs.add(builder); } else { _visitables.get("victoropsConfigs").set(index, builder); victoropsConfigs.set(index, builder);}
    return (A)this;
  }
  
  public A addToVictoropsConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.VictorOpsConfig... items) {
    if (this.victoropsConfigs == null) {this.victoropsConfigs = new ArrayList<VictorOpsConfigBuilder>();}
    for (VictorOpsConfig item : items) {VictorOpsConfigBuilder builder = new VictorOpsConfigBuilder(item);_visitables.get("victoropsConfigs").add(builder);this.victoropsConfigs.add(builder);} return (A)this;
  }
  
  public A addAllToVictoropsConfigs(Collection<VictorOpsConfig> items) {
    if (this.victoropsConfigs == null) {this.victoropsConfigs = new ArrayList<VictorOpsConfigBuilder>();}
    for (VictorOpsConfig item : items) {VictorOpsConfigBuilder builder = new VictorOpsConfigBuilder(item);_visitables.get("victoropsConfigs").add(builder);this.victoropsConfigs.add(builder);} return (A)this;
  }
  
  public A removeFromVictoropsConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.VictorOpsConfig... items) {
    if (this.victoropsConfigs == null) return (A)this;
    for (VictorOpsConfig item : items) {VictorOpsConfigBuilder builder = new VictorOpsConfigBuilder(item);_visitables.get("victoropsConfigs").remove(builder); this.victoropsConfigs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromVictoropsConfigs(Collection<VictorOpsConfig> items) {
    if (this.victoropsConfigs == null) return (A)this;
    for (VictorOpsConfig item : items) {VictorOpsConfigBuilder builder = new VictorOpsConfigBuilder(item);_visitables.get("victoropsConfigs").remove(builder); this.victoropsConfigs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromVictoropsConfigs(Predicate<VictorOpsConfigBuilder> predicate) {
    if (victoropsConfigs == null) return (A) this;
    final Iterator<VictorOpsConfigBuilder> each = victoropsConfigs.iterator();
    final List visitables = _visitables.get("victoropsConfigs");
    while (each.hasNext()) {
      VictorOpsConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<VictorOpsConfig> buildVictoropsConfigs() {
    return this.victoropsConfigs != null ? build(victoropsConfigs) : null;
  }
  
  public VictorOpsConfig buildVictoropsConfig(int index) {
    return this.victoropsConfigs.get(index).build();
  }
  
  public VictorOpsConfig buildFirstVictoropsConfig() {
    return this.victoropsConfigs.get(0).build();
  }
  
  public VictorOpsConfig buildLastVictoropsConfig() {
    return this.victoropsConfigs.get(victoropsConfigs.size() - 1).build();
  }
  
  public VictorOpsConfig buildMatchingVictoropsConfig(Predicate<VictorOpsConfigBuilder> predicate) {
      for (VictorOpsConfigBuilder item : victoropsConfigs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingVictoropsConfig(Predicate<VictorOpsConfigBuilder> predicate) {
      for (VictorOpsConfigBuilder item : victoropsConfigs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withVictoropsConfigs(List<VictorOpsConfig> victoropsConfigs) {
    if (this.victoropsConfigs != null) {
      this._visitables.get("victoropsConfigs").clear();
    }
    if (victoropsConfigs != null) {
        this.victoropsConfigs = new ArrayList();
        for (VictorOpsConfig item : victoropsConfigs) {
          this.addToVictoropsConfigs(item);
        }
    } else {
      this.victoropsConfigs = null;
    }
    return (A) this;
  }
  
  public A withVictoropsConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.VictorOpsConfig... victoropsConfigs) {
    if (this.victoropsConfigs != null) {
        this.victoropsConfigs.clear();
        _visitables.remove("victoropsConfigs");
    }
    if (victoropsConfigs != null) {
      for (VictorOpsConfig item : victoropsConfigs) {
        this.addToVictoropsConfigs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasVictoropsConfigs() {
    return this.victoropsConfigs != null && !this.victoropsConfigs.isEmpty();
  }
  
  public VictoropsConfigsNested<A> addNewVictoropsConfig() {
    return new VictoropsConfigsNested(-1, null);
  }
  
  public VictoropsConfigsNested<A> addNewVictoropsConfigLike(VictorOpsConfig item) {
    return new VictoropsConfigsNested(-1, item);
  }
  
  public VictoropsConfigsNested<A> setNewVictoropsConfigLike(int index,VictorOpsConfig item) {
    return new VictoropsConfigsNested(index, item);
  }
  
  public VictoropsConfigsNested<A> editVictoropsConfig(int index) {
    if (victoropsConfigs.size() <= index) throw new RuntimeException("Can't edit victoropsConfigs. Index exceeds size.");
    return setNewVictoropsConfigLike(index, buildVictoropsConfig(index));
  }
  
  public VictoropsConfigsNested<A> editFirstVictoropsConfig() {
    if (victoropsConfigs.size() == 0) throw new RuntimeException("Can't edit first victoropsConfigs. The list is empty.");
    return setNewVictoropsConfigLike(0, buildVictoropsConfig(0));
  }
  
  public VictoropsConfigsNested<A> editLastVictoropsConfig() {
    int index = victoropsConfigs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last victoropsConfigs. The list is empty.");
    return setNewVictoropsConfigLike(index, buildVictoropsConfig(index));
  }
  
  public VictoropsConfigsNested<A> editMatchingVictoropsConfig(Predicate<VictorOpsConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<victoropsConfigs.size();i++) { 
    if (predicate.test(victoropsConfigs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching victoropsConfigs. No match found.");
    return setNewVictoropsConfigLike(index, buildVictoropsConfig(index));
  }
  
  public A addToWebexConfigs(int index,WebexConfig item) {
    if (this.webexConfigs == null) {this.webexConfigs = new ArrayList<WebexConfigBuilder>();}
    WebexConfigBuilder builder = new WebexConfigBuilder(item);
    if (index < 0 || index >= webexConfigs.size()) { _visitables.get("webexConfigs").add(builder); webexConfigs.add(builder); } else { _visitables.get("webexConfigs").add(index, builder); webexConfigs.add(index, builder);}
    return (A)this;
  }
  
  public A setToWebexConfigs(int index,WebexConfig item) {
    if (this.webexConfigs == null) {this.webexConfigs = new ArrayList<WebexConfigBuilder>();}
    WebexConfigBuilder builder = new WebexConfigBuilder(item);
    if (index < 0 || index >= webexConfigs.size()) { _visitables.get("webexConfigs").add(builder); webexConfigs.add(builder); } else { _visitables.get("webexConfigs").set(index, builder); webexConfigs.set(index, builder);}
    return (A)this;
  }
  
  public A addToWebexConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.WebexConfig... items) {
    if (this.webexConfigs == null) {this.webexConfigs = new ArrayList<WebexConfigBuilder>();}
    for (WebexConfig item : items) {WebexConfigBuilder builder = new WebexConfigBuilder(item);_visitables.get("webexConfigs").add(builder);this.webexConfigs.add(builder);} return (A)this;
  }
  
  public A addAllToWebexConfigs(Collection<WebexConfig> items) {
    if (this.webexConfigs == null) {this.webexConfigs = new ArrayList<WebexConfigBuilder>();}
    for (WebexConfig item : items) {WebexConfigBuilder builder = new WebexConfigBuilder(item);_visitables.get("webexConfigs").add(builder);this.webexConfigs.add(builder);} return (A)this;
  }
  
  public A removeFromWebexConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.WebexConfig... items) {
    if (this.webexConfigs == null) return (A)this;
    for (WebexConfig item : items) {WebexConfigBuilder builder = new WebexConfigBuilder(item);_visitables.get("webexConfigs").remove(builder); this.webexConfigs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromWebexConfigs(Collection<WebexConfig> items) {
    if (this.webexConfigs == null) return (A)this;
    for (WebexConfig item : items) {WebexConfigBuilder builder = new WebexConfigBuilder(item);_visitables.get("webexConfigs").remove(builder); this.webexConfigs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromWebexConfigs(Predicate<WebexConfigBuilder> predicate) {
    if (webexConfigs == null) return (A) this;
    final Iterator<WebexConfigBuilder> each = webexConfigs.iterator();
    final List visitables = _visitables.get("webexConfigs");
    while (each.hasNext()) {
      WebexConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<WebexConfig> buildWebexConfigs() {
    return this.webexConfigs != null ? build(webexConfigs) : null;
  }
  
  public WebexConfig buildWebexConfig(int index) {
    return this.webexConfigs.get(index).build();
  }
  
  public WebexConfig buildFirstWebexConfig() {
    return this.webexConfigs.get(0).build();
  }
  
  public WebexConfig buildLastWebexConfig() {
    return this.webexConfigs.get(webexConfigs.size() - 1).build();
  }
  
  public WebexConfig buildMatchingWebexConfig(Predicate<WebexConfigBuilder> predicate) {
      for (WebexConfigBuilder item : webexConfigs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingWebexConfig(Predicate<WebexConfigBuilder> predicate) {
      for (WebexConfigBuilder item : webexConfigs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withWebexConfigs(List<WebexConfig> webexConfigs) {
    if (this.webexConfigs != null) {
      this._visitables.get("webexConfigs").clear();
    }
    if (webexConfigs != null) {
        this.webexConfigs = new ArrayList();
        for (WebexConfig item : webexConfigs) {
          this.addToWebexConfigs(item);
        }
    } else {
      this.webexConfigs = null;
    }
    return (A) this;
  }
  
  public A withWebexConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.WebexConfig... webexConfigs) {
    if (this.webexConfigs != null) {
        this.webexConfigs.clear();
        _visitables.remove("webexConfigs");
    }
    if (webexConfigs != null) {
      for (WebexConfig item : webexConfigs) {
        this.addToWebexConfigs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasWebexConfigs() {
    return this.webexConfigs != null && !this.webexConfigs.isEmpty();
  }
  
  public WebexConfigsNested<A> addNewWebexConfig() {
    return new WebexConfigsNested(-1, null);
  }
  
  public WebexConfigsNested<A> addNewWebexConfigLike(WebexConfig item) {
    return new WebexConfigsNested(-1, item);
  }
  
  public WebexConfigsNested<A> setNewWebexConfigLike(int index,WebexConfig item) {
    return new WebexConfigsNested(index, item);
  }
  
  public WebexConfigsNested<A> editWebexConfig(int index) {
    if (webexConfigs.size() <= index) throw new RuntimeException("Can't edit webexConfigs. Index exceeds size.");
    return setNewWebexConfigLike(index, buildWebexConfig(index));
  }
  
  public WebexConfigsNested<A> editFirstWebexConfig() {
    if (webexConfigs.size() == 0) throw new RuntimeException("Can't edit first webexConfigs. The list is empty.");
    return setNewWebexConfigLike(0, buildWebexConfig(0));
  }
  
  public WebexConfigsNested<A> editLastWebexConfig() {
    int index = webexConfigs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last webexConfigs. The list is empty.");
    return setNewWebexConfigLike(index, buildWebexConfig(index));
  }
  
  public WebexConfigsNested<A> editMatchingWebexConfig(Predicate<WebexConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<webexConfigs.size();i++) { 
    if (predicate.test(webexConfigs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching webexConfigs. No match found.");
    return setNewWebexConfigLike(index, buildWebexConfig(index));
  }
  
  public A addToWebhookConfigs(int index,WebhookConfig item) {
    if (this.webhookConfigs == null) {this.webhookConfigs = new ArrayList<WebhookConfigBuilder>();}
    WebhookConfigBuilder builder = new WebhookConfigBuilder(item);
    if (index < 0 || index >= webhookConfigs.size()) { _visitables.get("webhookConfigs").add(builder); webhookConfigs.add(builder); } else { _visitables.get("webhookConfigs").add(index, builder); webhookConfigs.add(index, builder);}
    return (A)this;
  }
  
  public A setToWebhookConfigs(int index,WebhookConfig item) {
    if (this.webhookConfigs == null) {this.webhookConfigs = new ArrayList<WebhookConfigBuilder>();}
    WebhookConfigBuilder builder = new WebhookConfigBuilder(item);
    if (index < 0 || index >= webhookConfigs.size()) { _visitables.get("webhookConfigs").add(builder); webhookConfigs.add(builder); } else { _visitables.get("webhookConfigs").set(index, builder); webhookConfigs.set(index, builder);}
    return (A)this;
  }
  
  public A addToWebhookConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.WebhookConfig... items) {
    if (this.webhookConfigs == null) {this.webhookConfigs = new ArrayList<WebhookConfigBuilder>();}
    for (WebhookConfig item : items) {WebhookConfigBuilder builder = new WebhookConfigBuilder(item);_visitables.get("webhookConfigs").add(builder);this.webhookConfigs.add(builder);} return (A)this;
  }
  
  public A addAllToWebhookConfigs(Collection<WebhookConfig> items) {
    if (this.webhookConfigs == null) {this.webhookConfigs = new ArrayList<WebhookConfigBuilder>();}
    for (WebhookConfig item : items) {WebhookConfigBuilder builder = new WebhookConfigBuilder(item);_visitables.get("webhookConfigs").add(builder);this.webhookConfigs.add(builder);} return (A)this;
  }
  
  public A removeFromWebhookConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.WebhookConfig... items) {
    if (this.webhookConfigs == null) return (A)this;
    for (WebhookConfig item : items) {WebhookConfigBuilder builder = new WebhookConfigBuilder(item);_visitables.get("webhookConfigs").remove(builder); this.webhookConfigs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromWebhookConfigs(Collection<WebhookConfig> items) {
    if (this.webhookConfigs == null) return (A)this;
    for (WebhookConfig item : items) {WebhookConfigBuilder builder = new WebhookConfigBuilder(item);_visitables.get("webhookConfigs").remove(builder); this.webhookConfigs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromWebhookConfigs(Predicate<WebhookConfigBuilder> predicate) {
    if (webhookConfigs == null) return (A) this;
    final Iterator<WebhookConfigBuilder> each = webhookConfigs.iterator();
    final List visitables = _visitables.get("webhookConfigs");
    while (each.hasNext()) {
      WebhookConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<WebhookConfig> buildWebhookConfigs() {
    return this.webhookConfigs != null ? build(webhookConfigs) : null;
  }
  
  public WebhookConfig buildWebhookConfig(int index) {
    return this.webhookConfigs.get(index).build();
  }
  
  public WebhookConfig buildFirstWebhookConfig() {
    return this.webhookConfigs.get(0).build();
  }
  
  public WebhookConfig buildLastWebhookConfig() {
    return this.webhookConfigs.get(webhookConfigs.size() - 1).build();
  }
  
  public WebhookConfig buildMatchingWebhookConfig(Predicate<WebhookConfigBuilder> predicate) {
      for (WebhookConfigBuilder item : webhookConfigs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingWebhookConfig(Predicate<WebhookConfigBuilder> predicate) {
      for (WebhookConfigBuilder item : webhookConfigs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withWebhookConfigs(List<WebhookConfig> webhookConfigs) {
    if (this.webhookConfigs != null) {
      this._visitables.get("webhookConfigs").clear();
    }
    if (webhookConfigs != null) {
        this.webhookConfigs = new ArrayList();
        for (WebhookConfig item : webhookConfigs) {
          this.addToWebhookConfigs(item);
        }
    } else {
      this.webhookConfigs = null;
    }
    return (A) this;
  }
  
  public A withWebhookConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.WebhookConfig... webhookConfigs) {
    if (this.webhookConfigs != null) {
        this.webhookConfigs.clear();
        _visitables.remove("webhookConfigs");
    }
    if (webhookConfigs != null) {
      for (WebhookConfig item : webhookConfigs) {
        this.addToWebhookConfigs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasWebhookConfigs() {
    return this.webhookConfigs != null && !this.webhookConfigs.isEmpty();
  }
  
  public WebhookConfigsNested<A> addNewWebhookConfig() {
    return new WebhookConfigsNested(-1, null);
  }
  
  public WebhookConfigsNested<A> addNewWebhookConfigLike(WebhookConfig item) {
    return new WebhookConfigsNested(-1, item);
  }
  
  public WebhookConfigsNested<A> setNewWebhookConfigLike(int index,WebhookConfig item) {
    return new WebhookConfigsNested(index, item);
  }
  
  public WebhookConfigsNested<A> editWebhookConfig(int index) {
    if (webhookConfigs.size() <= index) throw new RuntimeException("Can't edit webhookConfigs. Index exceeds size.");
    return setNewWebhookConfigLike(index, buildWebhookConfig(index));
  }
  
  public WebhookConfigsNested<A> editFirstWebhookConfig() {
    if (webhookConfigs.size() == 0) throw new RuntimeException("Can't edit first webhookConfigs. The list is empty.");
    return setNewWebhookConfigLike(0, buildWebhookConfig(0));
  }
  
  public WebhookConfigsNested<A> editLastWebhookConfig() {
    int index = webhookConfigs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last webhookConfigs. The list is empty.");
    return setNewWebhookConfigLike(index, buildWebhookConfig(index));
  }
  
  public WebhookConfigsNested<A> editMatchingWebhookConfig(Predicate<WebhookConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<webhookConfigs.size();i++) { 
    if (predicate.test(webhookConfigs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching webhookConfigs. No match found.");
    return setNewWebhookConfigLike(index, buildWebhookConfig(index));
  }
  
  public A addToWechatConfigs(int index,WeChatConfig item) {
    if (this.wechatConfigs == null) {this.wechatConfigs = new ArrayList<WeChatConfigBuilder>();}
    WeChatConfigBuilder builder = new WeChatConfigBuilder(item);
    if (index < 0 || index >= wechatConfigs.size()) { _visitables.get("wechatConfigs").add(builder); wechatConfigs.add(builder); } else { _visitables.get("wechatConfigs").add(index, builder); wechatConfigs.add(index, builder);}
    return (A)this;
  }
  
  public A setToWechatConfigs(int index,WeChatConfig item) {
    if (this.wechatConfigs == null) {this.wechatConfigs = new ArrayList<WeChatConfigBuilder>();}
    WeChatConfigBuilder builder = new WeChatConfigBuilder(item);
    if (index < 0 || index >= wechatConfigs.size()) { _visitables.get("wechatConfigs").add(builder); wechatConfigs.add(builder); } else { _visitables.get("wechatConfigs").set(index, builder); wechatConfigs.set(index, builder);}
    return (A)this;
  }
  
  public A addToWechatConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.WeChatConfig... items) {
    if (this.wechatConfigs == null) {this.wechatConfigs = new ArrayList<WeChatConfigBuilder>();}
    for (WeChatConfig item : items) {WeChatConfigBuilder builder = new WeChatConfigBuilder(item);_visitables.get("wechatConfigs").add(builder);this.wechatConfigs.add(builder);} return (A)this;
  }
  
  public A addAllToWechatConfigs(Collection<WeChatConfig> items) {
    if (this.wechatConfigs == null) {this.wechatConfigs = new ArrayList<WeChatConfigBuilder>();}
    for (WeChatConfig item : items) {WeChatConfigBuilder builder = new WeChatConfigBuilder(item);_visitables.get("wechatConfigs").add(builder);this.wechatConfigs.add(builder);} return (A)this;
  }
  
  public A removeFromWechatConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.WeChatConfig... items) {
    if (this.wechatConfigs == null) return (A)this;
    for (WeChatConfig item : items) {WeChatConfigBuilder builder = new WeChatConfigBuilder(item);_visitables.get("wechatConfigs").remove(builder); this.wechatConfigs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromWechatConfigs(Collection<WeChatConfig> items) {
    if (this.wechatConfigs == null) return (A)this;
    for (WeChatConfig item : items) {WeChatConfigBuilder builder = new WeChatConfigBuilder(item);_visitables.get("wechatConfigs").remove(builder); this.wechatConfigs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromWechatConfigs(Predicate<WeChatConfigBuilder> predicate) {
    if (wechatConfigs == null) return (A) this;
    final Iterator<WeChatConfigBuilder> each = wechatConfigs.iterator();
    final List visitables = _visitables.get("wechatConfigs");
    while (each.hasNext()) {
      WeChatConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<WeChatConfig> buildWechatConfigs() {
    return this.wechatConfigs != null ? build(wechatConfigs) : null;
  }
  
  public WeChatConfig buildWechatConfig(int index) {
    return this.wechatConfigs.get(index).build();
  }
  
  public WeChatConfig buildFirstWechatConfig() {
    return this.wechatConfigs.get(0).build();
  }
  
  public WeChatConfig buildLastWechatConfig() {
    return this.wechatConfigs.get(wechatConfigs.size() - 1).build();
  }
  
  public WeChatConfig buildMatchingWechatConfig(Predicate<WeChatConfigBuilder> predicate) {
      for (WeChatConfigBuilder item : wechatConfigs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingWechatConfig(Predicate<WeChatConfigBuilder> predicate) {
      for (WeChatConfigBuilder item : wechatConfigs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withWechatConfigs(List<WeChatConfig> wechatConfigs) {
    if (this.wechatConfigs != null) {
      this._visitables.get("wechatConfigs").clear();
    }
    if (wechatConfigs != null) {
        this.wechatConfigs = new ArrayList();
        for (WeChatConfig item : wechatConfigs) {
          this.addToWechatConfigs(item);
        }
    } else {
      this.wechatConfigs = null;
    }
    return (A) this;
  }
  
  public A withWechatConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.WeChatConfig... wechatConfigs) {
    if (this.wechatConfigs != null) {
        this.wechatConfigs.clear();
        _visitables.remove("wechatConfigs");
    }
    if (wechatConfigs != null) {
      for (WeChatConfig item : wechatConfigs) {
        this.addToWechatConfigs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasWechatConfigs() {
    return this.wechatConfigs != null && !this.wechatConfigs.isEmpty();
  }
  
  public WechatConfigsNested<A> addNewWechatConfig() {
    return new WechatConfigsNested(-1, null);
  }
  
  public WechatConfigsNested<A> addNewWechatConfigLike(WeChatConfig item) {
    return new WechatConfigsNested(-1, item);
  }
  
  public WechatConfigsNested<A> setNewWechatConfigLike(int index,WeChatConfig item) {
    return new WechatConfigsNested(index, item);
  }
  
  public WechatConfigsNested<A> editWechatConfig(int index) {
    if (wechatConfigs.size() <= index) throw new RuntimeException("Can't edit wechatConfigs. Index exceeds size.");
    return setNewWechatConfigLike(index, buildWechatConfig(index));
  }
  
  public WechatConfigsNested<A> editFirstWechatConfig() {
    if (wechatConfigs.size() == 0) throw new RuntimeException("Can't edit first wechatConfigs. The list is empty.");
    return setNewWechatConfigLike(0, buildWechatConfig(0));
  }
  
  public WechatConfigsNested<A> editLastWechatConfig() {
    int index = wechatConfigs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last wechatConfigs. The list is empty.");
    return setNewWechatConfigLike(index, buildWechatConfig(index));
  }
  
  public WechatConfigsNested<A> editMatchingWechatConfig(Predicate<WeChatConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<wechatConfigs.size();i++) { 
    if (predicate.test(wechatConfigs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching wechatConfigs. No match found.");
    return setNewWechatConfigLike(index, buildWechatConfig(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ReceiverFluent that = (ReceiverFluent) o;
    if (!java.util.Objects.equals(discordConfigs, that.discordConfigs)) return false;
    if (!java.util.Objects.equals(emailConfigs, that.emailConfigs)) return false;
    if (!java.util.Objects.equals(msteamsConfigs, that.msteamsConfigs)) return false;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(opsgenieConfigs, that.opsgenieConfigs)) return false;
    if (!java.util.Objects.equals(pagerdutyConfigs, that.pagerdutyConfigs)) return false;
    if (!java.util.Objects.equals(pushoverConfigs, that.pushoverConfigs)) return false;
    if (!java.util.Objects.equals(slackConfigs, that.slackConfigs)) return false;
    if (!java.util.Objects.equals(snsConfigs, that.snsConfigs)) return false;
    if (!java.util.Objects.equals(telegramConfigs, that.telegramConfigs)) return false;
    if (!java.util.Objects.equals(victoropsConfigs, that.victoropsConfigs)) return false;
    if (!java.util.Objects.equals(webexConfigs, that.webexConfigs)) return false;
    if (!java.util.Objects.equals(webhookConfigs, that.webhookConfigs)) return false;
    if (!java.util.Objects.equals(wechatConfigs, that.wechatConfigs)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(discordConfigs,  emailConfigs,  msteamsConfigs,  name,  opsgenieConfigs,  pagerdutyConfigs,  pushoverConfigs,  slackConfigs,  snsConfigs,  telegramConfigs,  victoropsConfigs,  webexConfigs,  webhookConfigs,  wechatConfigs,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (discordConfigs != null && !discordConfigs.isEmpty()) { sb.append("discordConfigs:"); sb.append(discordConfigs + ","); }
    if (emailConfigs != null && !emailConfigs.isEmpty()) { sb.append("emailConfigs:"); sb.append(emailConfigs + ","); }
    if (msteamsConfigs != null && !msteamsConfigs.isEmpty()) { sb.append("msteamsConfigs:"); sb.append(msteamsConfigs + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (opsgenieConfigs != null && !opsgenieConfigs.isEmpty()) { sb.append("opsgenieConfigs:"); sb.append(opsgenieConfigs + ","); }
    if (pagerdutyConfigs != null && !pagerdutyConfigs.isEmpty()) { sb.append("pagerdutyConfigs:"); sb.append(pagerdutyConfigs + ","); }
    if (pushoverConfigs != null && !pushoverConfigs.isEmpty()) { sb.append("pushoverConfigs:"); sb.append(pushoverConfigs + ","); }
    if (slackConfigs != null && !slackConfigs.isEmpty()) { sb.append("slackConfigs:"); sb.append(slackConfigs + ","); }
    if (snsConfigs != null && !snsConfigs.isEmpty()) { sb.append("snsConfigs:"); sb.append(snsConfigs + ","); }
    if (telegramConfigs != null && !telegramConfigs.isEmpty()) { sb.append("telegramConfigs:"); sb.append(telegramConfigs + ","); }
    if (victoropsConfigs != null && !victoropsConfigs.isEmpty()) { sb.append("victoropsConfigs:"); sb.append(victoropsConfigs + ","); }
    if (webexConfigs != null && !webexConfigs.isEmpty()) { sb.append("webexConfigs:"); sb.append(webexConfigs + ","); }
    if (webhookConfigs != null && !webhookConfigs.isEmpty()) { sb.append("webhookConfigs:"); sb.append(webhookConfigs + ","); }
    if (wechatConfigs != null && !wechatConfigs.isEmpty()) { sb.append("wechatConfigs:"); sb.append(wechatConfigs + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class DiscordConfigsNested<N> extends DiscordConfigFluent<DiscordConfigsNested<N>> implements Nested<N>{
    DiscordConfigsNested(int index,DiscordConfig item) {
      this.index = index;
      this.builder = new DiscordConfigBuilder(this, item);
    }
    DiscordConfigBuilder builder;
    int index;
    
    public N and() {
      return (N) ReceiverFluent.this.setToDiscordConfigs(index,builder.build());
    }
    
    public N endDiscordConfig() {
      return and();
    }
    
  
  }
  public class EmailConfigsNested<N> extends EmailConfigFluent<EmailConfigsNested<N>> implements Nested<N>{
    EmailConfigsNested(int index,EmailConfig item) {
      this.index = index;
      this.builder = new EmailConfigBuilder(this, item);
    }
    EmailConfigBuilder builder;
    int index;
    
    public N and() {
      return (N) ReceiverFluent.this.setToEmailConfigs(index,builder.build());
    }
    
    public N endEmailConfig() {
      return and();
    }
    
  
  }
  public class MsteamsConfigsNested<N> extends MSTeamsConfigFluent<MsteamsConfigsNested<N>> implements Nested<N>{
    MsteamsConfigsNested(int index,MSTeamsConfig item) {
      this.index = index;
      this.builder = new MSTeamsConfigBuilder(this, item);
    }
    MSTeamsConfigBuilder builder;
    int index;
    
    public N and() {
      return (N) ReceiverFluent.this.setToMsteamsConfigs(index,builder.build());
    }
    
    public N endMsteamsConfig() {
      return and();
    }
    
  
  }
  public class OpsgenieConfigsNested<N> extends OpsGenieConfigFluent<OpsgenieConfigsNested<N>> implements Nested<N>{
    OpsgenieConfigsNested(int index,OpsGenieConfig item) {
      this.index = index;
      this.builder = new OpsGenieConfigBuilder(this, item);
    }
    OpsGenieConfigBuilder builder;
    int index;
    
    public N and() {
      return (N) ReceiverFluent.this.setToOpsgenieConfigs(index,builder.build());
    }
    
    public N endOpsgenieConfig() {
      return and();
    }
    
  
  }
  public class PagerdutyConfigsNested<N> extends PagerDutyConfigFluent<PagerdutyConfigsNested<N>> implements Nested<N>{
    PagerdutyConfigsNested(int index,PagerDutyConfig item) {
      this.index = index;
      this.builder = new PagerDutyConfigBuilder(this, item);
    }
    PagerDutyConfigBuilder builder;
    int index;
    
    public N and() {
      return (N) ReceiverFluent.this.setToPagerdutyConfigs(index,builder.build());
    }
    
    public N endPagerdutyConfig() {
      return and();
    }
    
  
  }
  public class PushoverConfigsNested<N> extends PushoverConfigFluent<PushoverConfigsNested<N>> implements Nested<N>{
    PushoverConfigsNested(int index,PushoverConfig item) {
      this.index = index;
      this.builder = new PushoverConfigBuilder(this, item);
    }
    PushoverConfigBuilder builder;
    int index;
    
    public N and() {
      return (N) ReceiverFluent.this.setToPushoverConfigs(index,builder.build());
    }
    
    public N endPushoverConfig() {
      return and();
    }
    
  
  }
  public class SlackConfigsNested<N> extends SlackConfigFluent<SlackConfigsNested<N>> implements Nested<N>{
    SlackConfigsNested(int index,SlackConfig item) {
      this.index = index;
      this.builder = new SlackConfigBuilder(this, item);
    }
    SlackConfigBuilder builder;
    int index;
    
    public N and() {
      return (N) ReceiverFluent.this.setToSlackConfigs(index,builder.build());
    }
    
    public N endSlackConfig() {
      return and();
    }
    
  
  }
  public class SnsConfigsNested<N> extends SNSConfigFluent<SnsConfigsNested<N>> implements Nested<N>{
    SnsConfigsNested(int index,SNSConfig item) {
      this.index = index;
      this.builder = new SNSConfigBuilder(this, item);
    }
    SNSConfigBuilder builder;
    int index;
    
    public N and() {
      return (N) ReceiverFluent.this.setToSnsConfigs(index,builder.build());
    }
    
    public N endSnsConfig() {
      return and();
    }
    
  
  }
  public class TelegramConfigsNested<N> extends TelegramConfigFluent<TelegramConfigsNested<N>> implements Nested<N>{
    TelegramConfigsNested(int index,TelegramConfig item) {
      this.index = index;
      this.builder = new TelegramConfigBuilder(this, item);
    }
    TelegramConfigBuilder builder;
    int index;
    
    public N and() {
      return (N) ReceiverFluent.this.setToTelegramConfigs(index,builder.build());
    }
    
    public N endTelegramConfig() {
      return and();
    }
    
  
  }
  public class VictoropsConfigsNested<N> extends VictorOpsConfigFluent<VictoropsConfigsNested<N>> implements Nested<N>{
    VictoropsConfigsNested(int index,VictorOpsConfig item) {
      this.index = index;
      this.builder = new VictorOpsConfigBuilder(this, item);
    }
    VictorOpsConfigBuilder builder;
    int index;
    
    public N and() {
      return (N) ReceiverFluent.this.setToVictoropsConfigs(index,builder.build());
    }
    
    public N endVictoropsConfig() {
      return and();
    }
    
  
  }
  public class WebexConfigsNested<N> extends WebexConfigFluent<WebexConfigsNested<N>> implements Nested<N>{
    WebexConfigsNested(int index,WebexConfig item) {
      this.index = index;
      this.builder = new WebexConfigBuilder(this, item);
    }
    WebexConfigBuilder builder;
    int index;
    
    public N and() {
      return (N) ReceiverFluent.this.setToWebexConfigs(index,builder.build());
    }
    
    public N endWebexConfig() {
      return and();
    }
    
  
  }
  public class WebhookConfigsNested<N> extends WebhookConfigFluent<WebhookConfigsNested<N>> implements Nested<N>{
    WebhookConfigsNested(int index,WebhookConfig item) {
      this.index = index;
      this.builder = new WebhookConfigBuilder(this, item);
    }
    WebhookConfigBuilder builder;
    int index;
    
    public N and() {
      return (N) ReceiverFluent.this.setToWebhookConfigs(index,builder.build());
    }
    
    public N endWebhookConfig() {
      return and();
    }
    
  
  }
  public class WechatConfigsNested<N> extends WeChatConfigFluent<WechatConfigsNested<N>> implements Nested<N>{
    WechatConfigsNested(int index,WeChatConfig item) {
      this.index = index;
      this.builder = new WeChatConfigBuilder(this, item);
    }
    WeChatConfigBuilder builder;
    int index;
    
    public N and() {
      return (N) ReceiverFluent.this.setToWechatConfigs(index,builder.build());
    }
    
    public N endWechatConfig() {
      return and();
    }
    
  
  }

}